/******************************************************************************
  SCI0_UART.h
UARTģʽSCI0ͷļ
    ߣ
    V1.0
    ڣ2016.11.17
******************************************************************************/

#ifndef _SCI0_UART_H_
#define _SCI0_UART_H_

#include "GPIO.h"
#include "CRG.h"
#include "comdef.h"

/******************************************************************************
UART 
******************************************************************************/
#define   SCI0_BAUD_RATE                    19200
#define   SCI0_FORMAT                       SCI0_8BIT_1STOP
#define   SCI0_PARITY_FUNC                  SCI0_PARITY_FUNC_ENABLE
#define   SCI0_PARITY_TYPE                  SCI0_EVEN_PARITY

#define   SCI0_Tx_BUFFER_SIZE               32

/******************************************************************************
UART ѡ
******************************************************************************/
/*** UARTʽ ***/
#define   SCI0_8BIT_1STOP                   0x00
#define   SCI0_9BIT_1STOP                   0x10

/*** żУʹ ***/
#define   SCI0_PARITY_FUNC_DISABLE          0x00
#define   SCI0_PARITY_FUNC_ENABLE           0x02

/*** żУѡ ***/
#define   SCI0_EVEN_PARITY                  0x00
#define   SCI0_ODD_PARITY                   0x01

/******************************************************************************
ĴֵԤ
******************************************************************************/
#define   SCI0_BAUD_RATE_REG                ((uint16_t)(BUSCLK / 16 / SCI0_BAUD_RATE) & 0x1FFF)
#define   SCI0_CFG_REG                      (SCI0_FORMAT | SCI0_PARITY_FUNC | SCI0_PARITY_TYPE)

/******************************************************************************
ͻṹ
******************************************************************************/
typedef struct
{
  uint8_t Data[SCI0_Tx_BUFFER_SIZE];
  uint8_t Len;
} SCI0TxBufferStruct;

/******************************************************************************

******************************************************************************/
void SCI0_UART_Byte_Rx(uint8_t Data);
void SCI0_UART_Byte_Tx(uint8_t Data);
void SCI0_UART_Block_Tx(uint8_t *Data, uint8_t Len);
uint8_t SCI0_UART_Get_Tx_Buffer_Status(void);
void SCI0_UART_Init(void);

#endif