/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.tools.conversion.eot.BitIOWriter;
import com.google.typography.font.tools.conversion.eot.HuffmanEncoder;
import junit.framework.TestCase;

public class HuffmanEncoderTest
extends TestCase {
    public void testBitsUsed() {
        HuffmanEncoderTest.assertEquals(1, HuffmanEncoder.bitsUsed(0));
        HuffmanEncoderTest.assertEquals(1, HuffmanEncoder.bitsUsed(1));
        HuffmanEncoderTest.assertEquals(8, HuffmanEncoder.bitsUsed(255));
        HuffmanEncoderTest.assertEquals(9, HuffmanEncoder.bitsUsed(256));
        HuffmanEncoderTest.assertEquals(32, HuffmanEncoder.bitsUsed(-1));
    }

    public void testInitConsistency() {
        BitIOWriter bits = new BitIOWriter();
        HuffmanEncoder h = new HuffmanEncoder(bits, 512);
        HuffmanEncoderTest.assertNull(h.checkTree());
    }

    public void testRetainConsistency() {
        BitIOWriter bits = new BitIOWriter();
        HuffmanEncoder h = new HuffmanEncoder(bits, 8);
        int i = 0;
        while (i < 1024) {
            HuffmanEncoderTest.assertNull("Iteration " + i, h.checkTree());
            h.writeSymbol((i & 1) != 0 ? 0 : i & 7);
            ++i;
        }
    }
}

