
#include "SEG_LCD.h"
#include "LED.h"
#include "Flash_synchronizer.h"
SEGLCDBackupStruct   SEGLCDBackup;

uint8_t   SEGLCDIconLeftStatus;
uint8_t   SEGLCDIconParkStatus;
uint8_t   SEGLCDIconAirbagStatus;
uint8_t   SEGLCDIconMILStatus;
uint8_t   SEGLCDIconLoOilPressureStatus;
uint8_t   SEGLCDIconRightStatus;
uint8_t   SEGLCDIconFOGFStatus;
uint8_t   SEGLCDIconFOGRStatus;
uint8_t   SEGLCDIconPositionStatus;
uint8_t   SEGLCDIconHiBeamStatus;
   
#include "SEG_LCD.h"

SEGLCDBackupStruct   SEGLCDBackup;

uint8_t   SEGLCDIconLeftStatus;
uint8_t   SEGLCDIconParkStatus;
uint8_t   SEGLCDIconAirbagStatus;
uint8_t   SEGLCDIconMILStatus;
uint8_t   SEGLCDIconLoOilPressureStatus;
uint8_t   SEGLCDIconRightStatus;
uint8_t   SEGLCDIconFOGFStatus;
uint8_t   SEGLCDIconFOGRStatus;
uint8_t   SEGLCDIconPositionStatus;
uint8_t   SEGLCDIconHiBeamStatus;


uint8_t   LED_ODO_TRIP_FLAG_OLD;   //TRIPA = 1  TRIPB = 2 ODO = 3

void SEG_LCD_Init(void)
{
  SEGLCDBackup.Brightness = 0x00;
  SEGLCDBackup.Window     = 0x00;
  SEGLCDBackup.VSpeedSeg  = 0xFF;
  SEGLCDBackup.ESpeedSeg  = 0xFF;
  SEGLCDBackup.VSpeed     = 0xFFFF;
  SEGLCDBackup.ESpeed     = 0xFFFF;
  SEGLCDBackup.ODONum    = 0xFFFFFFFF;
  SEGLCDBackup.Power     = 0xFFFF;
  SEGLCDBackup.Voltage     = 0xFFFF;
  SEGLCDBackup.Current     = 0xFFFF;
  SEGLCDBackup.Mileage     = 0xFFFF;
  SEGLCDBackup.SOCSeg     = 0xFF;
  SEGLCDBackup.InitPowerSeg     = 0xFF;
  SEGLCDBackup.RePowerSeg     = 0xFF;
  SEGLCDBackup.TotalPowerSeg     = 0xFF;
  SEGLCDIconLeftStatus          = 0x00;
  SEGLCDIconParkStatus          = 0x00;
  SEGLCDIconAirbagStatus        = 0x00;
  SEGLCDIconMILStatus           = 0x00;
  SEGLCDIconLoOilPressureStatus = 0x00;
  SEGLCDIconRightStatus         = 0x00;
  SEGLCDIconFOGFStatus          = 0x00;
  SEGLCDIconFOGRStatus          = 0x00;
  SEGLCDIconPositionStatus      = 0x00;
  SEGLCDIconHiBeamStatus        = 0x00;
  
  /*
  SEG_LCD_WINDOW_P = 0;
  SEG_LCD_WINDOW_M = 0;
  
  LED_LEFT_G             = 0;
 // LED_PARK_R             = 0;
  LED_AIRBAG_R           = 0;
 // LED_MIL_Y              = 0;
 // LED_LOW_OIL_PRESSURE_R = 0;
  LED_RIGHT_G            = 0;
  LED_FOG_F_G            = 0;
  LED_FOG_R_Y            = 0;
 // LED_POSITION_G         = 0;
  LED_HI_BEAM_B          = 0;
  */
  
  //----hyq--20180913
  LED_ODO_TRIP_FLAG_OLD = 0;      //TRIPA = 1 TRIPB = 2 ODO = 3
  
  
  PWM_Channel_Init(7, PWM_CLOCK_SB, PWM_POL_POS, PWM_LEFT_ALIGN, PWM7_PM3);
  PWM_Channel_Set_Freq(7, 769);
  PWM_Channel_Set_Duty_Cycle(7, 0);   //ʼΪر,ɺӦó
  PWM_Channel_Start(7);
  
  BU98R10_Init();
}

void SEG_LCD_Shutdown(void)
{
  BU98R10_Shutdown();
/*  
  SEG_LCD_WINDOW_P = 0;
  SEG_LCD_WINDOW_M = 0;
  
  SEGLCDBackup.Brightness = 0x00;
  SEGLCDBackup.Window     = 0x00;
  
  PWM_Channel_Stop(2);
  PWM_BL = 0;
  
  LED_LEFT_G             = 0;
 // LED_PARK_R             = 0;
  LED_AIRBAG_R           = 0;
 // LED_MIL_Y              = 0;
  //LED_LOW_OIL_PRESSURE_R = 0;
  LED_RIGHT_G            = 0;
  LED_FOG_F_G            = 0;
  LED_FOG_R_Y            = 0;
 //LED_POSITION_G         = 0;
  LED_HI_BEAM_B          = 0;
*/  
}

void SEG_LCD_Set_Brightness(uint8_t Br)
{
  if (Br > 100)
    Br = 100;
  
  if (Br != SEGLCDBackup.Brightness)
  {
    SEGLCDBackup.Brightness = Br;
    PWM_Channel_Set_Duty_Cycle(2, Br);
  }
}

void SEG_LCD_Window_Switch(uint8_t Sw)
{
#if 0
  if (Sw == SEGLCDBackup.Window)
    return;
  
  SEGLCDBackup.Window = Sw;
  
  if (Sw)
  {
    SEG_LCD_WINDOW_P = 1;
    SEG_LCD_WINDOW_M = 0;
  }
  else
  {
    SEG_LCD_WINDOW_P = 0;
    SEG_LCD_WINDOW_M = 0;
  }
#endif   
}

//10ms
void SEG_LCD_Window_Control_Service(void)
{
#if 0
  if (SEGLCDBackup.Window)
  {
    SEG_LCD_WINDOW_P = ~SEG_LCD_WINDOW_P;
    SEG_LCD_WINDOW_M = ~SEG_LCD_WINDOW_M;
  }
#endif  
}

/******************************************************************************
SEG_LCD_ODO_Speed_Num_Display
  : ܼʾ
  : DOD_TRIP_FLAGGСGֵ 0.1   ODONum 
ֵ
˵                              
******************************************************************************/
void SEG_LCD_ODO_Speed_Num_Display(uint8_t DOD_TRIP_FLAG, uint32_t ODONum)
{ 
  uint8_t Dig[6];
  
  if (SEGLCDBackup.ODONum != ODONum || LED_ODO_TRIP_FLAG_OLD != DOD_TRIP_FLAG)
  {
    SEGLCDBackup.ODONum = ODONum;
    LED_ODO_TRIP_FLAG_OLD = DOD_TRIP_FLAG;
   
    //----hyq--ּ
    if (DOD_TRIP_FLAG != 3)       //СG A  B
    {
      if (ODONum > 9999999)
          ODONum = 9999999; 
      
      Dig[0] = ODONum % 10;
      ODONum /= 10;
      Dig[1] = ODONum % 10; 
      ODONum /= 10;
      Dig[2] = ODONum % 10;
      ODONum /= 10;
      Dig[3] = ODONum % 10;
      ODONum /= 10;
      Dig[4] = ODONum % 10;
      ODONum /= 10;
      Dig[5] = ODONum % 10;
      Dig[6] = ODONum / 10; 
    }
    else                          //ܼODO
    {   
      if (ODONum > 1999999)
          ODONum = 1999999;
      
      ODONum /= 10;  
      Dig[0] = ODONum % 10;
      ODONum /= 10;
      Dig[1] = ODONum % 10; 
      ODONum /= 10;
      Dig[2] = ODONum % 10;
      ODONum /= 10;
      Dig[3] = ODONum % 10;
      ODONum /= 10;
      Dig[4] = ODONum % 10;
      ODONum /= 10;
      Dig[5] = ODONum % 10;
      Dig[6] = ODONum / 10; 
    }
    if (Dig[6] == 0)
    {
      Dig[6] = 0x0F;
      if (Dig[5] == 0)
      {
        Dig[5] = 0x0F;
        if (Dig[4] == 0)
        {
          Dig[4] = 0x0F;
          if (Dig[3] == 0)
          {
            Dig[3] = 0x0F;
            if (Dig[2] == 0)
              Dig[2] = 0x0F;
              if(DOD_TRIP_FLAG == 3)     //ܼ ODO
              {
                if (Dig[1] == 0)
                  Dig[1] = 0x0F;
              }    
          }
        }
      }
    }
    
    //----hyq--ʾ                   //СG A
    if (DOD_TRIP_FLAG == 1)
    {
      SEG_TRIP  = SEG_LCD_LIGHT;
      SEG_AA    = SEG_LCD_LIGHT;
      SEG_BB    = SEG_LCD_GRAY_light;
      SEG_DP    = SEG_LCD_LIGHT;
      SEG_ODO   = SEG_LCD_GRAY_light;
    }
    else if (DOD_TRIP_FLAG == 2)          //СG B
    {
      SEG_TRIP  = SEG_LCD_LIGHT;
      SEG_AA    = SEG_LCD_GRAY_light;
      SEG_BB    = SEG_LCD_LIGHT;
      SEG_DP    = SEG_LCD_LIGHT;
      SEG_ODO   = SEG_LCD_GRAY_light;
    }
    else if (DOD_TRIP_FLAG == 3)          //G ODO
    {
      SEG_TRIP  = SEG_LCD_GRAY_light;
      SEG_AA    = SEG_LCD_GRAY_light;
      SEG_BB    = SEG_LCD_GRAY_light;
      SEG_DP    = SEG_LCD_GRAY_light;
      SEG_ODO   = SEG_LCD_LIGHT;
    }
    else                                  //쳣
    {
      SEG_TRIP  = SEG_LCD_GRAY_light;
      SEG_AA    = SEG_LCD_GRAY_light;
      SEG_BB    = SEG_LCD_GRAY_light;
      SEG_DP    = SEG_LCD_GRAY_light;
      SEG_ODO   = SEG_LCD_GRAY_light;  
    }
    
    SEG_KM = SEG_LCD_LIGHT;
    
    //----hyq--ʾ
    switch (Dig[6])
    {
      case 0  : SEG_1A  = SEG_LCD_LIGHT;
                SEG_1B  = SEG_LCD_LIGHT;
                SEG_1C  = SEG_LCD_LIGHT;
                SEG_1D  = SEG_LCD_LIGHT;
                SEG_1E  = SEG_LCD_LIGHT;
                SEG_1F  = SEG_LCD_LIGHT;
                SEG_1G  = SEG_LCD_GRAY_light;
                break;
                
      case 1  : SEG_1A  = SEG_LCD_GRAY_light;
                SEG_1B  = SEG_LCD_LIGHT;
                SEG_1C  = SEG_LCD_LIGHT;
                SEG_1D  = SEG_LCD_GRAY_light;
                SEG_1E  = SEG_LCD_GRAY_light;
                SEG_1F  = SEG_LCD_GRAY_light;
                SEG_1G  = SEG_LCD_GRAY_light;
                break;
                
      case 2  : SEG_1A  = SEG_LCD_LIGHT;
                SEG_1B  = SEG_LCD_LIGHT;
                SEG_1C  = SEG_LCD_GRAY_light;
                SEG_1D  = SEG_LCD_LIGHT;
                SEG_1E  = SEG_LCD_LIGHT;
                SEG_1F  = SEG_LCD_GRAY_light;
                SEG_1G  = SEG_LCD_LIGHT;
                break;
                
      case 3  : SEG_1A  = SEG_LCD_LIGHT;
                SEG_1B  = SEG_LCD_LIGHT;
                SEG_1C  = SEG_LCD_LIGHT;
                SEG_1D  = SEG_LCD_LIGHT;
                SEG_1E  = SEG_LCD_GRAY_light;
                SEG_1F  = SEG_LCD_GRAY_light;
                SEG_1G  = SEG_LCD_LIGHT;
                break;         
                
      case 4  : SEG_1A  = SEG_LCD_GRAY_light;
                SEG_1B  = SEG_LCD_LIGHT;
                SEG_1C  = SEG_LCD_LIGHT;
                SEG_1D  = SEG_LCD_GRAY_light;
                SEG_1E  = SEG_LCD_GRAY_light;
                SEG_1F  = SEG_LCD_LIGHT;
                SEG_1G  = SEG_LCD_LIGHT;
                break;  
                       
      case 5  : SEG_1A  = SEG_LCD_LIGHT;
                SEG_1B  = SEG_LCD_GRAY_light;
                SEG_1C  = SEG_LCD_LIGHT;
                SEG_1D  = SEG_LCD_LIGHT;
                SEG_1E  = SEG_LCD_GRAY_light;
                SEG_1F  = SEG_LCD_LIGHT;
                SEG_1G  = SEG_LCD_LIGHT;
                break;    
                     
      case 6  : SEG_1A  = SEG_LCD_LIGHT;
                SEG_1B  = SEG_LCD_GRAY_light;
                SEG_1C  = SEG_LCD_LIGHT;
                SEG_1D  = SEG_LCD_LIGHT;
                SEG_1E  = SEG_LCD_LIGHT;
                SEG_1F  = SEG_LCD_LIGHT;
                SEG_1G  = SEG_LCD_LIGHT;
                break; 
                  
      case 7  : SEG_1A  = SEG_LCD_LIGHT;
                SEG_1B  = SEG_LCD_LIGHT;
                SEG_1C  = SEG_LCD_LIGHT;
                SEG_1D  = SEG_LCD_GRAY_light;
                SEG_1E  = SEG_LCD_GRAY_light;
                SEG_1F  = SEG_LCD_GRAY_light;
                SEG_1G  = SEG_LCD_GRAY_light;
                break;              
                      
      case 8  : SEG_1A  = SEG_LCD_LIGHT;
                SEG_1B  = SEG_LCD_LIGHT;
                SEG_1C  = SEG_LCD_LIGHT;
                SEG_1D  = SEG_LCD_LIGHT;
                SEG_1E  = SEG_LCD_LIGHT;
                SEG_1F  = SEG_LCD_LIGHT;
                SEG_1G  = SEG_LCD_LIGHT;
                break;  
                
      case 9  : SEG_1A  = SEG_LCD_LIGHT;;
                SEG_1B  = SEG_LCD_LIGHT;
                SEG_1C  = SEG_LCD_LIGHT;
                SEG_1D  = SEG_LCD_LIGHT;
                SEG_1E  = SEG_LCD_GRAY_light;
                SEG_1F  = SEG_LCD_LIGHT;
                SEG_1G  = SEG_LCD_LIGHT;
                break;                 
                
      default : SEG_1A  = SEG_LCD_GRAY_light;;
                SEG_1B  = SEG_LCD_GRAY_light;
                SEG_1C  = SEG_LCD_GRAY_light;
                SEG_1D  = SEG_LCD_GRAY_light;
                SEG_1E  = SEG_LCD_GRAY_light;
                SEG_1F  = SEG_LCD_GRAY_light;
                SEG_1G  = SEG_LCD_GRAY_light;        
                break;
    }
    switch (Dig[5])
    {
      case 0  : SEG_2A  = SEG_LCD_LIGHT;
                SEG_2B  = SEG_LCD_LIGHT;
                SEG_2C  = SEG_LCD_LIGHT;
                SEG_2D  = SEG_LCD_LIGHT;
                SEG_2E  = SEG_LCD_LIGHT;
                SEG_2F  = SEG_LCD_LIGHT;
                SEG_2G  = SEG_LCD_GRAY_light;
                break;
                
      case 1  : SEG_2A  = SEG_LCD_GRAY_light;
                SEG_2B  = SEG_LCD_LIGHT;
                SEG_2C  = SEG_LCD_LIGHT;
                SEG_2D  = SEG_LCD_GRAY_light;
                SEG_2E  = SEG_LCD_GRAY_light;
                SEG_2F  = SEG_LCD_GRAY_light;
                SEG_2G  = SEG_LCD_GRAY_light;
                break;
                
      case 2  : SEG_2A  = SEG_LCD_LIGHT;
                SEG_2B  = SEG_LCD_LIGHT;
                SEG_2C  = SEG_LCD_GRAY_light;
                SEG_2D  = SEG_LCD_LIGHT;
                SEG_2E  = SEG_LCD_LIGHT;
                SEG_2F  = SEG_LCD_GRAY_light;
                SEG_2G  = SEG_LCD_LIGHT;
                break;
                
      case 3  : SEG_2A  = SEG_LCD_LIGHT;
                SEG_2B  = SEG_LCD_LIGHT;
                SEG_2C  = SEG_LCD_LIGHT;
                SEG_2D  = SEG_LCD_LIGHT;
                SEG_2E  = SEG_LCD_GRAY_light;
                SEG_2F  = SEG_LCD_GRAY_light;
                SEG_2G  = SEG_LCD_LIGHT;
                break;         
                
      case 4  : SEG_2A  = SEG_LCD_GRAY_light;
                SEG_2B  = SEG_LCD_LIGHT;
                SEG_2C  = SEG_LCD_LIGHT;
                SEG_2D  = SEG_LCD_GRAY_light;
                SEG_2E  = SEG_LCD_GRAY_light;
                SEG_2F  = SEG_LCD_LIGHT;
                SEG_2G  = SEG_LCD_LIGHT;
                break;  
                       
      case 5  : SEG_2A  = SEG_LCD_LIGHT;
                SEG_2B  = SEG_LCD_GRAY_light;
                SEG_2C  = SEG_LCD_LIGHT;
                SEG_2D  = SEG_LCD_LIGHT;
                SEG_2E  = SEG_LCD_GRAY_light;
                SEG_2F  = SEG_LCD_LIGHT;
                SEG_2G  = SEG_LCD_LIGHT;
                break;    
                     
      case 6  : SEG_2A  = SEG_LCD_LIGHT;
                SEG_2B  = SEG_LCD_GRAY_light;
                SEG_2C  = SEG_LCD_LIGHT;
                SEG_2D  = SEG_LCD_LIGHT;
                SEG_2E  = SEG_LCD_LIGHT;
                SEG_2F  = SEG_LCD_LIGHT;
                SEG_2G  = SEG_LCD_LIGHT;
                break; 
                  
      case 7  : SEG_2A  = SEG_LCD_LIGHT;
                SEG_2B  = SEG_LCD_LIGHT;
                SEG_2C  = SEG_LCD_LIGHT;
                SEG_2D  = SEG_LCD_GRAY_light;
                SEG_2E  = SEG_LCD_GRAY_light;
                SEG_2F  = SEG_LCD_GRAY_light;
                SEG_2G  = SEG_LCD_GRAY_light;
                break;              
                      
      case 8  : SEG_2A  = SEG_LCD_LIGHT;
                SEG_2B  = SEG_LCD_LIGHT;
                SEG_2C  = SEG_LCD_LIGHT;
                SEG_2D  = SEG_LCD_LIGHT;
                SEG_2E  = SEG_LCD_LIGHT;
                SEG_2F  = SEG_LCD_LIGHT;
                SEG_2G  = SEG_LCD_LIGHT;
                break;  
                
      case 9  : SEG_2A  = SEG_LCD_LIGHT;;
                SEG_2B  = SEG_LCD_LIGHT;
                SEG_2C  = SEG_LCD_LIGHT;
                SEG_2D  = SEG_LCD_LIGHT;
                SEG_2E  = SEG_LCD_GRAY_light;
                SEG_2F  = SEG_LCD_LIGHT;
                SEG_2G  = SEG_LCD_LIGHT;
                break;                 
                
      default : SEG_2A  = SEG_LCD_GRAY_light;;
                SEG_2B  = SEG_LCD_GRAY_light;
                SEG_2C  = SEG_LCD_GRAY_light;
                SEG_2D  = SEG_LCD_GRAY_light;
                SEG_2E  = SEG_LCD_GRAY_light;
                SEG_2F  = SEG_LCD_GRAY_light;
                SEG_2G  = SEG_LCD_GRAY_light;        
                break;
    }
    switch (Dig[4])
    {
      case 0  : SEG_3A  = SEG_LCD_LIGHT;
                SEG_3B  = SEG_LCD_LIGHT;
                SEG_3C  = SEG_LCD_LIGHT;
                SEG_3D  = SEG_LCD_LIGHT;
                SEG_3E  = SEG_LCD_LIGHT;
                SEG_3F  = SEG_LCD_LIGHT;
                SEG_3G  = SEG_LCD_GRAY_light;
                break;
                
      case 1  : SEG_3A  = SEG_LCD_GRAY_light;
                SEG_3B  = SEG_LCD_LIGHT;
                SEG_3C  = SEG_LCD_LIGHT;
                SEG_3D  = SEG_LCD_GRAY_light;
                SEG_3E  = SEG_LCD_GRAY_light;
                SEG_3F  = SEG_LCD_GRAY_light;
                SEG_3G  = SEG_LCD_GRAY_light;
                break;
                
      case 2  : SEG_3A  = SEG_LCD_LIGHT;
                SEG_3B  = SEG_LCD_LIGHT;
                SEG_3C  = SEG_LCD_GRAY_light;
                SEG_3D  = SEG_LCD_LIGHT;
                SEG_3E  = SEG_LCD_LIGHT;
                SEG_3F  = SEG_LCD_GRAY_light;
                SEG_3G  = SEG_LCD_LIGHT;
                break;
                
      case 3  : SEG_3A  = SEG_LCD_LIGHT;
                SEG_3B  = SEG_LCD_LIGHT;
                SEG_3C  = SEG_LCD_LIGHT;
                SEG_3D  = SEG_LCD_LIGHT;
                SEG_3E  = SEG_LCD_GRAY_light;
                SEG_3F  = SEG_LCD_GRAY_light;
                SEG_3G  = SEG_LCD_LIGHT;
                break;         
                
      case 4  : SEG_3A  = SEG_LCD_GRAY_light;
                SEG_3B  = SEG_LCD_LIGHT;
                SEG_3C  = SEG_LCD_LIGHT;
                SEG_3D  = SEG_LCD_GRAY_light;
                SEG_3E  = SEG_LCD_GRAY_light;
                SEG_3F  = SEG_LCD_LIGHT;
                SEG_3G  = SEG_LCD_LIGHT;
                break;  
                       
      case 5  : SEG_3A  = SEG_LCD_LIGHT;
                SEG_3B  = SEG_LCD_GRAY_light;
                SEG_3C  = SEG_LCD_LIGHT;
                SEG_3D  = SEG_LCD_LIGHT;
                SEG_3E  = SEG_LCD_GRAY_light;
                SEG_3F  = SEG_LCD_LIGHT;
                SEG_3G  = SEG_LCD_LIGHT;
                break;    
                     
      case 6  : SEG_3A  = SEG_LCD_LIGHT;
                SEG_3B  = SEG_LCD_GRAY_light;
                SEG_3C  = SEG_LCD_LIGHT;
                SEG_3D  = SEG_LCD_LIGHT;
                SEG_3E  = SEG_LCD_LIGHT;
                SEG_3F  = SEG_LCD_LIGHT;
                SEG_3G  = SEG_LCD_LIGHT;
                break; 
                  
      case 7  : SEG_3A  = SEG_LCD_LIGHT;
                SEG_3B  = SEG_LCD_LIGHT;
                SEG_3C  = SEG_LCD_LIGHT;
                SEG_3D  = SEG_LCD_GRAY_light;
                SEG_3E  = SEG_LCD_GRAY_light;
                SEG_3F  = SEG_LCD_GRAY_light;
                SEG_3G  = SEG_LCD_GRAY_light;
                break;              
                      
      case 8  : SEG_3A  = SEG_LCD_LIGHT;
                SEG_3B  = SEG_LCD_LIGHT;
                SEG_3C  = SEG_LCD_LIGHT;
                SEG_3D  = SEG_LCD_LIGHT;
                SEG_3E  = SEG_LCD_LIGHT;
                SEG_3F  = SEG_LCD_LIGHT;
                SEG_3G  = SEG_LCD_LIGHT;
                break;  
                
      case 9  : SEG_3A  = SEG_LCD_LIGHT;;
                SEG_3B  = SEG_LCD_LIGHT;
                SEG_3C  = SEG_LCD_LIGHT;
                SEG_3D  = SEG_LCD_LIGHT;
                SEG_3E  = SEG_LCD_GRAY_light;
                SEG_3F  = SEG_LCD_LIGHT;
                SEG_3G  = SEG_LCD_LIGHT;
                break;                 
                
      default : SEG_3A  = SEG_LCD_GRAY_light;;
                SEG_3B  = SEG_LCD_GRAY_light;
                SEG_3C  = SEG_LCD_GRAY_light;
                SEG_3D  = SEG_LCD_GRAY_light;
                SEG_3E  = SEG_LCD_GRAY_light;
                SEG_3F  = SEG_LCD_GRAY_light;
                SEG_3G  = SEG_LCD_GRAY_light;        
                break;
    }
    
    switch (Dig[3])
    {
    	case 0  : SEG_4A  = SEG_LCD_LIGHT;
                SEG_4B  = SEG_LCD_LIGHT;
                SEG_4C  = SEG_LCD_LIGHT;
                SEG_4D  = SEG_LCD_LIGHT;
                SEG_4E  = SEG_LCD_LIGHT;
                SEG_4F  = SEG_LCD_LIGHT;
                SEG_4G  = SEG_LCD_GRAY_light;
      			    break;
      			    
      case 1  : SEG_4A  = SEG_LCD_GRAY_light;
      		      SEG_4B  = SEG_LCD_LIGHT;
      		      SEG_4C  = SEG_LCD_LIGHT;
      		      SEG_4D  = SEG_LCD_GRAY_light;
                SEG_4E  = SEG_LCD_GRAY_light;
                SEG_4F  = SEG_LCD_GRAY_light;
                SEG_4G  = SEG_LCD_GRAY_light;
      		    	break;
      		    	
      case 2  : SEG_4A = SEG_LCD_LIGHT;
                SEG_4B = SEG_LCD_LIGHT;
                SEG_4C = SEG_LCD_GRAY_light;
                SEG_4D = SEG_LCD_LIGHT;
                SEG_4E = SEG_LCD_LIGHT;
                SEG_4F = SEG_LCD_GRAY_light;
                SEG_4G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_4A  = SEG_LCD_LIGHT;
                SEG_4B  = SEG_LCD_LIGHT;
                SEG_4C  = SEG_LCD_LIGHT;
                SEG_4D  = SEG_LCD_LIGHT;
                SEG_4E  = SEG_LCD_GRAY_light;  
                SEG_4F  = SEG_LCD_GRAY_light;   
                SEG_4G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_4A  = SEG_LCD_GRAY_light;
                SEG_4B  = SEG_LCD_LIGHT;
                SEG_4C  = SEG_LCD_LIGHT;
                SEG_4D  = SEG_LCD_GRAY_light;   
                SEG_4E  = SEG_LCD_GRAY_light;
                SEG_4F  = SEG_LCD_LIGHT;
                SEG_4G  = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_4A = SEG_LCD_LIGHT;
                SEG_4B = SEG_LCD_GRAY_light; 
                SEG_4C = SEG_LCD_LIGHT;
                SEG_4D = SEG_LCD_LIGHT;
                SEG_4E = SEG_LCD_GRAY_light;
                SEG_4F = SEG_LCD_LIGHT;
                SEG_4G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_4A = SEG_LCD_LIGHT;
                SEG_4B = SEG_LCD_GRAY_light;
                SEG_4C = SEG_LCD_LIGHT;
                SEG_4D = SEG_LCD_LIGHT;
                SEG_4E = SEG_LCD_LIGHT;
                SEG_4F = SEG_LCD_LIGHT;
                SEG_4G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_4A = SEG_LCD_LIGHT;
                SEG_4B = SEG_LCD_LIGHT;
                SEG_4C = SEG_LCD_LIGHT;
                SEG_4D = SEG_LCD_GRAY_light;  
                SEG_4E = SEG_LCD_GRAY_light;  
                SEG_4F = SEG_LCD_GRAY_light;  
                SEG_4G = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_4A  = SEG_LCD_LIGHT;
                SEG_4B  = SEG_LCD_LIGHT;
                SEG_4C  = SEG_LCD_LIGHT;
                SEG_4D  = SEG_LCD_LIGHT;
                SEG_4E  = SEG_LCD_LIGHT;
                SEG_4F  = SEG_LCD_LIGHT;
                SEG_4G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_4A  = SEG_LCD_LIGHT;
                SEG_4B  = SEG_LCD_LIGHT;
                SEG_4C  = SEG_LCD_LIGHT;
                SEG_4D  = SEG_LCD_LIGHT;
                SEG_4E  = SEG_LCD_GRAY_light;
                SEG_4F  = SEG_LCD_LIGHT;
                SEG_4G  = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_4A = SEG_LCD_GRAY_light;  
                SEG_4B = SEG_LCD_GRAY_light;  
                SEG_4C = SEG_LCD_GRAY_light;  
                SEG_4D = SEG_LCD_GRAY_light;  
                SEG_4E = SEG_LCD_GRAY_light;  
                SEG_4F = SEG_LCD_GRAY_light;  
                SEG_4G = SEG_LCD_GRAY_light;   
      		    	break;
    }
    
    switch (Dig[2])
    {
    	case 0  : SEG_5A  = SEG_LCD_LIGHT;
                SEG_5B  = SEG_LCD_LIGHT;
                SEG_5C  = SEG_LCD_LIGHT;
                SEG_5D  = SEG_LCD_LIGHT;
                SEG_5E  = SEG_LCD_LIGHT;
                SEG_5F  = SEG_LCD_LIGHT;
                SEG_5G  = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_5A  = SEG_LCD_GRAY_light;
      		      SEG_5B  = SEG_LCD_LIGHT;
      		      SEG_5C  = SEG_LCD_LIGHT;
      		      SEG_5D  = SEG_LCD_GRAY_light;
                SEG_5E  = SEG_LCD_GRAY_light;
                SEG_5F  = SEG_LCD_GRAY_light;
                SEG_5G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 2  : SEG_5A = SEG_LCD_LIGHT;
                SEG_5B = SEG_LCD_LIGHT;
                SEG_5C = SEG_LCD_GRAY_light;
                SEG_5D = SEG_LCD_LIGHT;
                SEG_5E = SEG_LCD_LIGHT;
                SEG_5F = SEG_LCD_GRAY_light;
                SEG_5G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_5A = SEG_LCD_LIGHT;
                SEG_5B = SEG_LCD_LIGHT;
                SEG_5C = SEG_LCD_LIGHT;
                SEG_5D = SEG_LCD_LIGHT;
                SEG_5E = SEG_LCD_GRAY_light;
                SEG_5F = SEG_LCD_GRAY_light;
                SEG_5G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_5A = SEG_LCD_GRAY_light;
                SEG_5B = SEG_LCD_LIGHT;
                SEG_5C = SEG_LCD_LIGHT;
                SEG_5D = SEG_LCD_GRAY_light;
                SEG_5E = SEG_LCD_GRAY_light;
                SEG_5F = SEG_LCD_LIGHT;
                SEG_5G = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_5A = SEG_LCD_LIGHT;
                SEG_5B = SEG_LCD_GRAY_light;
                SEG_5C = SEG_LCD_LIGHT;
                SEG_5D = SEG_LCD_LIGHT;
                SEG_5E = SEG_LCD_GRAY_light;
                SEG_5F = SEG_LCD_LIGHT;
                SEG_5G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_5A  = SEG_LCD_LIGHT;
                SEG_5B  = SEG_LCD_GRAY_light;
                SEG_5C  = SEG_LCD_LIGHT;
                SEG_5D  = SEG_LCD_LIGHT;
                SEG_5E  = SEG_LCD_LIGHT;
                SEG_5F  = SEG_LCD_LIGHT;
                SEG_5G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_5A  = SEG_LCD_LIGHT;
                SEG_5B  = SEG_LCD_LIGHT;
                SEG_5C  = SEG_LCD_LIGHT;
                SEG_5D  = SEG_LCD_GRAY_light;
                SEG_5E  = SEG_LCD_GRAY_light;
                SEG_5F  = SEG_LCD_GRAY_light;
                SEG_5G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_5A  = SEG_LCD_LIGHT;
                SEG_5B  = SEG_LCD_LIGHT;
                SEG_5C  = SEG_LCD_LIGHT;
                SEG_5D  = SEG_LCD_LIGHT;
                SEG_5E  = SEG_LCD_LIGHT;
                SEG_5F  = SEG_LCD_LIGHT;
                SEG_5G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_5A = SEG_LCD_LIGHT;
                SEG_5B = SEG_LCD_LIGHT;
                SEG_5C = SEG_LCD_LIGHT;
                SEG_5D = SEG_LCD_LIGHT;
                SEG_5E = SEG_LCD_GRAY_light;
                SEG_5F = SEG_LCD_LIGHT;
                SEG_5G = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_5A = SEG_LCD_GRAY_light;
                SEG_5B = SEG_LCD_GRAY_light;
                SEG_5C = SEG_LCD_GRAY_light;
                SEG_5D = SEG_LCD_GRAY_light;
                SEG_5E = SEG_LCD_GRAY_light;
                SEG_5F = SEG_LCD_GRAY_light;
                SEG_5G = SEG_LCD_GRAY_light; 
      		    	break;
    }
    switch (Dig[1])
    {
    	case 0  : SEG_6A  = SEG_LCD_LIGHT;
                SEG_6B  = SEG_LCD_LIGHT;
                SEG_6C  = SEG_LCD_LIGHT;
                SEG_6D  = SEG_LCD_LIGHT;
                SEG_6E  = SEG_LCD_LIGHT;
                SEG_6F  = SEG_LCD_LIGHT;
                SEG_6G  = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_6A  = SEG_LCD_GRAY_light;
      		      SEG_6B  = SEG_LCD_LIGHT;
      		      SEG_6C  = SEG_LCD_LIGHT;
      		      SEG_6D  = SEG_LCD_GRAY_light;
                SEG_6E  = SEG_LCD_GRAY_light;
                SEG_6F  = SEG_LCD_GRAY_light;
                SEG_6G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 2  : SEG_6A = SEG_LCD_LIGHT;
                SEG_6B = SEG_LCD_LIGHT;
                SEG_6C = SEG_LCD_GRAY_light;
                SEG_6D = SEG_LCD_LIGHT;
                SEG_6E = SEG_LCD_LIGHT;
                SEG_6F = SEG_LCD_GRAY_light;
                SEG_6G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_6A = SEG_LCD_LIGHT;
                SEG_6B = SEG_LCD_LIGHT;
                SEG_6C = SEG_LCD_LIGHT;
                SEG_6D = SEG_LCD_LIGHT;
                SEG_6E = SEG_LCD_GRAY_light;
                SEG_6F = SEG_LCD_GRAY_light;
                SEG_6G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_6A = SEG_LCD_GRAY_light;
                SEG_6B = SEG_LCD_LIGHT;
                SEG_6C = SEG_LCD_LIGHT;
                SEG_6D = SEG_LCD_GRAY_light;
                SEG_6E = SEG_LCD_GRAY_light;
                SEG_6F = SEG_LCD_LIGHT;
                SEG_6G = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_6A = SEG_LCD_LIGHT;
                SEG_6B = SEG_LCD_GRAY_light;
                SEG_6C = SEG_LCD_LIGHT;
                SEG_6D = SEG_LCD_LIGHT;
                SEG_6E = SEG_LCD_GRAY_light;
                SEG_6F = SEG_LCD_LIGHT;
                SEG_6G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_6A  = SEG_LCD_LIGHT;
                SEG_6B  = SEG_LCD_GRAY_light;
                SEG_6C  = SEG_LCD_LIGHT;
                SEG_6D  = SEG_LCD_LIGHT;
                SEG_6E  = SEG_LCD_LIGHT;
                SEG_6F  = SEG_LCD_LIGHT;
                SEG_6G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_6A  = SEG_LCD_LIGHT;
                SEG_6B  = SEG_LCD_LIGHT;
                SEG_6C  = SEG_LCD_LIGHT;
                SEG_6D  = SEG_LCD_GRAY_light;
                SEG_6E  = SEG_LCD_GRAY_light;
                SEG_6F  = SEG_LCD_GRAY_light;
                SEG_6G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_6A  = SEG_LCD_LIGHT;
                SEG_6B  = SEG_LCD_LIGHT;
                SEG_6C  = SEG_LCD_LIGHT;
                SEG_6D  = SEG_LCD_LIGHT;
                SEG_6E  = SEG_LCD_LIGHT;
                SEG_6F  = SEG_LCD_LIGHT;
                SEG_6G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_6A = SEG_LCD_LIGHT;
                SEG_6B = SEG_LCD_LIGHT;
                SEG_6C = SEG_LCD_LIGHT;
                SEG_6D = SEG_LCD_LIGHT;
                SEG_6E = SEG_LCD_GRAY_light;
                SEG_6F = SEG_LCD_LIGHT;
                SEG_6G = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_6A = SEG_LCD_GRAY_light;
                SEG_6B = SEG_LCD_GRAY_light;
                SEG_6C = SEG_LCD_GRAY_light;
                SEG_6D = SEG_LCD_GRAY_light;
                SEG_6E = SEG_LCD_GRAY_light;
                SEG_6F = SEG_LCD_GRAY_light;
                SEG_6G = SEG_LCD_GRAY_light; 
      		    	break;
    }
    switch (Dig[0])
    {
    	case 0  : SEG_7A  = SEG_LCD_LIGHT;
                SEG_7B  = SEG_LCD_LIGHT;
                SEG_7C  = SEG_LCD_LIGHT;
                SEG_7D  = SEG_LCD_LIGHT;
                SEG_7E  = SEG_LCD_LIGHT;
                SEG_7F  = SEG_LCD_LIGHT;
                SEG_7G  = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_7A  = SEG_LCD_GRAY_light;
      		      SEG_7B  = SEG_LCD_LIGHT;
      		      SEG_7C  = SEG_LCD_LIGHT;
      		      SEG_7D  = SEG_LCD_GRAY_light;
                SEG_7E  = SEG_LCD_GRAY_light;
                SEG_7F  = SEG_LCD_GRAY_light;
                SEG_7G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 2  : SEG_7A = SEG_LCD_LIGHT;
                SEG_7B = SEG_LCD_LIGHT;
                SEG_7C = SEG_LCD_GRAY_light;
                SEG_7D = SEG_LCD_LIGHT;
                SEG_7E = SEG_LCD_LIGHT;
                SEG_7F = SEG_LCD_GRAY_light;
                SEG_7G = SEG_LCD_LIGHT; 
                break;
      			
      case 3  : SEG_7A = SEG_LCD_LIGHT;
                SEG_7B = SEG_LCD_LIGHT;
                SEG_7C = SEG_LCD_LIGHT;
                SEG_7D = SEG_LCD_LIGHT;
                SEG_7E = SEG_LCD_GRAY_light;
                SEG_7F = SEG_LCD_GRAY_light;
                SEG_7G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_7A = SEG_LCD_GRAY_light;
                SEG_7B = SEG_LCD_LIGHT;
                SEG_7C = SEG_LCD_LIGHT;
                SEG_7D = SEG_LCD_GRAY_light;
                SEG_7E = SEG_LCD_GRAY_light;
                SEG_7F = SEG_LCD_LIGHT;
                SEG_7G = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_7A = SEG_LCD_LIGHT;
                SEG_7B = SEG_LCD_GRAY_light;
                SEG_7C = SEG_LCD_LIGHT;
                SEG_7D = SEG_LCD_LIGHT;
                SEG_7E = SEG_LCD_GRAY_light;
                SEG_7F = SEG_LCD_LIGHT;
                SEG_7G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_7A  = SEG_LCD_LIGHT;
                SEG_7B  = SEG_LCD_GRAY_light;
                SEG_7C  = SEG_LCD_LIGHT;
                SEG_7D  = SEG_LCD_LIGHT;
                SEG_7E  = SEG_LCD_LIGHT;
                SEG_7F  = SEG_LCD_LIGHT;
                SEG_7G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_7A  = SEG_LCD_LIGHT;
                SEG_7B  = SEG_LCD_LIGHT;
                SEG_7C  = SEG_LCD_LIGHT;
                SEG_7D  = SEG_LCD_GRAY_light;
                SEG_7E  = SEG_LCD_GRAY_light;
                SEG_7F  = SEG_LCD_GRAY_light;
                SEG_7G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_7A  = SEG_LCD_LIGHT;
                SEG_7B  = SEG_LCD_LIGHT;
                SEG_7C  = SEG_LCD_LIGHT;
                SEG_7D  = SEG_LCD_LIGHT;
                SEG_7E  = SEG_LCD_LIGHT;
                SEG_7F  = SEG_LCD_LIGHT;
                SEG_7G  = SEG_LCD_LIGHT;
      		    	break;
      		    	
      case 9  : SEG_7A  = SEG_LCD_LIGHT;
                SEG_7B  = SEG_LCD_LIGHT;
                SEG_7C  = SEG_LCD_LIGHT;
                SEG_7D  = SEG_LCD_LIGHT;
                SEG_7E  = SEG_LCD_GRAY_light;
                SEG_7F  = SEG_LCD_LIGHT;
                SEG_7G  = SEG_LCD_LIGHT;
                break;
                
      default : SEG_7A = SEG_LCD_GRAY_light;
                SEG_7B = SEG_LCD_GRAY_light;
                SEG_7C = SEG_LCD_GRAY_light;
                SEG_7D = SEG_LCD_GRAY_light;
                SEG_7E = SEG_LCD_GRAY_light;
                SEG_7F = SEG_LCD_GRAY_light;
                SEG_7G = SEG_LCD_GRAY_light; 
      		    	break;
    }
  }
}

/******************************************************************************
SEG_LCD_ODO_Speed_Num_Off
  : ֹܼر
  : 
ֵ
˵                              
******************************************************************************/
void SEG_LCD_ODO_Speed_Num_Off(void)
{ 
  SEG_7A   =  SEG_LCD_OFF  ;
  SEG_7B   =  SEG_LCD_OFF  ;
  SEG_7C   =  SEG_LCD_OFF  ;
  SEG_7D   =  SEG_LCD_OFF  ;
  SEG_7E   =  SEG_LCD_OFF  ;
  SEG_7F   =  SEG_LCD_OFF  ;
  SEG_7G   =  SEG_LCD_OFF  ;

  SEG_6A   =  SEG_LCD_OFF  ;
  SEG_6B   =  SEG_LCD_OFF  ;
  SEG_6C   =  SEG_LCD_OFF  ;
  SEG_6D   =  SEG_LCD_OFF  ;
  SEG_6E   =  SEG_LCD_OFF  ;
  SEG_6F   =  SEG_LCD_OFF  ;
  SEG_6G   =  SEG_LCD_OFF  ;

  SEG_5A   =  SEG_LCD_OFF  ;
  SEG_5B   =  SEG_LCD_OFF  ;
  SEG_5C   =  SEG_LCD_OFF  ;
  SEG_5D   =  SEG_LCD_OFF  ;
  SEG_5E   =  SEG_LCD_OFF  ;
  SEG_5F   =  SEG_LCD_OFF  ;
  SEG_5G   =  SEG_LCD_OFF  ;

  SEG_4A   =  SEG_LCD_OFF  ;
  SEG_4B   =  SEG_LCD_OFF  ;
  SEG_4C   =  SEG_LCD_OFF  ;
  SEG_4D   =  SEG_LCD_OFF  ;
  SEG_4E   =  SEG_LCD_OFF  ;
  SEG_4F   =  SEG_LCD_OFF  ;
  SEG_4G   =  SEG_LCD_OFF  ;

  SEG_3A   =  SEG_LCD_OFF  ;
  SEG_3B   =  SEG_LCD_OFF  ;
  SEG_3C   =  SEG_LCD_OFF  ;
  SEG_3D   =  SEG_LCD_OFF  ;
  SEG_3E   =  SEG_LCD_OFF  ;
  SEG_3F   =  SEG_LCD_OFF  ;
  SEG_3G   =  SEG_LCD_OFF  ;

  SEG_2A   =  SEG_LCD_OFF  ;
  SEG_2B   =  SEG_LCD_OFF  ;
  SEG_2C   =  SEG_LCD_OFF  ;
  SEG_2D   =  SEG_LCD_OFF  ;
  SEG_2E   =  SEG_LCD_OFF  ;
  SEG_2F   =  SEG_LCD_OFF  ;
  SEG_2G   =  SEG_LCD_OFF  ;
  
  SEG_1A   =  SEG_LCD_OFF  ;
  SEG_1B   =  SEG_LCD_OFF  ;
  SEG_1C   =  SEG_LCD_OFF  ;
  SEG_1D   =  SEG_LCD_OFF  ;
  SEG_1E   =  SEG_LCD_OFF  ;
  SEG_1F   =  SEG_LCD_OFF  ;
  SEG_1G   =  SEG_LCD_OFF  ;
   
  SEG_TRIP =  SEG_LCD_OFF  ; 
  SEG_AA   =  SEG_LCD_OFF  ;  
  SEG_BB   =  SEG_LCD_OFF  ; 
  SEG_DP   =  SEG_LCD_OFF  ;
  SEG_ODO  =  SEG_LCD_OFF  ; 
  SEG_KM   =  SEG_LCD_OFF  ; 
  
  SEGLCDBackup.ODONum = 0xFFFF; 
}
/******************************************************************************
SEG_LCD_FUEL_Seg_Display
  : ȼʾ    
  : SegNumȼͱĶ
ֵ                               
******************************************************************************/
void SEG_LCD_FUEL_Seg_Display(uint8_t SegNum)
{
  if (SegNum > 12)
    SegNum =12;

  if (SEGLCDBackup.VSpeedSeg != SegNum)
  {
    SEGLCDBackup.VSpeedSeg = SegNum;
    
    //----hyq--ȼ
    SEG_YX1  =  SEG_LCD_LIGHT ; 
    SEG_CX   =  SEG_LCD_LIGHT ; 
    
    SEG_T1   =  SEG_LCD_LIGHT ; 
    SEG_T2   =  SEG_LCD_LIGHT ; 
    SEG_T3   =  SEG_LCD_LIGHT ;  
    SEG_T4   =  SEG_LCD_LIGHT ;
    SEG_T5   =  SEG_LCD_LIGHT ; 
    SEG_T6   =  SEG_LCD_LIGHT ;
    SEG_T7   =  SEG_LCD_LIGHT ;
    SEG_T8   =  SEG_LCD_LIGHT ;
    SEG_T9   =  SEG_LCD_LIGHT ;
    SEG_T10  =  SEG_LCD_LIGHT ; 
    SEG_T11  =  SEG_LCD_LIGHT ;
    SEG_T12  =  SEG_LCD_LIGHT ; 
    
    switch (SegNum)
    {     
      case 0  : SEG_T1  = SEG_LCD_OFF;     
      case 1  : SEG_T2  = SEG_LCD_OFF;     
      case 2  : SEG_T3  = SEG_LCD_OFF;     
      case 3  : SEG_T4  = SEG_LCD_OFF;
                     
      case 4  : SEG_T5  = SEG_LCD_OFF;     
      case 5  : SEG_T6  = SEG_LCD_OFF;     
      case 6  : SEG_T7  = SEG_LCD_OFF;     
      case 7  : SEG_T8  = SEG_LCD_OFF;
                 
      case 8  : SEG_T9  = SEG_LCD_OFF;       
      case 9  : SEG_T10 = SEG_LCD_OFF;        
      case 10 : SEG_T11 = SEG_LCD_OFF;        
      case 11 : SEG_T12 = SEG_LCD_OFF;
            
      default : break;
    }
  }
}

/******************************************************************************
SEG_LCD_FUEL_Seg_Off    
  : ȼȫر 
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_FUEL_Seg_Off(void)
{
  SEG_YX1 = SEG_LCD_OFF;                           
  SEG_CX  = SEG_LCD_OFF;                           
  SEG_T1  = SEG_LCD_OFF;                           
  SEG_T2  = SEG_LCD_OFF;                           
  SEG_T3  = SEG_LCD_OFF;                           
  SEG_T4  = SEG_LCD_OFF;                           
  SEG_T5  = SEG_LCD_OFF;                           
  SEG_T6  = SEG_LCD_OFF;                           
  SEG_T7  = SEG_LCD_OFF;                            
  SEG_T8  = SEG_LCD_OFF;                           
  SEG_T9  = SEG_LCD_OFF;                           
  SEG_T10 = SEG_LCD_OFF;                           
  SEG_T11 = SEG_LCD_OFF;                           
  SEG_T12 = SEG_LCD_OFF;                           
  
  SEGLCDBackup.VSpeedSeg = 0xFF; 
}
/******************************************************************************
SEG_LCD_ADBLUE_Seg_Display
  : ADBLUEʾ    
  : SegNumADBLUEĶ
ֵ                               
******************************************************************************/
void SEG_LCD_ADBLUE_Seg_Display(uint8_t SegNum)
{
  if (SegNum > 5)
    SegNum = 5;

  if (SEGLCDBackup.VSpeedSeg != SegNum)
  {
    SEGLCDBackup.VSpeedSeg = SegNum;
    
    //----hyq--ADBLUE
    SEG_YX2  =  SEG_LCD_LIGHT ; 
    SEG_CX2  =  SEG_LCD_LIGHT ;  
    SEG_AE   =  SEG_LCD_LIGHT ; 
    
    SEG_K1   =  SEG_LCD_LIGHT ; 
    SEG_K2   =  SEG_LCD_LIGHT ;  
    SEG_K3   =  SEG_LCD_LIGHT ;
    SEG_K4   =  SEG_LCD_LIGHT ; 
    SEG_K5   =  SEG_LCD_LIGHT ;
    
    switch (SegNum)
    {     
      case 0  : SEG_K1  = SEG_LCD_OFF;     
      case 1  : SEG_K2  = SEG_LCD_OFF;     
      case 2  : SEG_K3  = SEG_LCD_OFF;     
      case 3  : SEG_K4  = SEG_LCD_OFF;               
      case 4  : SEG_K5  = SEG_LCD_OFF;     
            
      default : break;
    }
  }
}

/******************************************************************************
SEG_LCD_ADBLUE_Seg_Off    
  : ADBLUEȫر 
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_ADBLUE_Seg_Off(void)
{
  SEG_YX2 = SEG_LCD_OFF;                           
  SEG_CX2 = SEG_LCD_OFF;                           
  SEG_AE  = SEG_LCD_OFF;                           
  SEG_K1  = SEG_LCD_OFF;                           
  SEG_K2  = SEG_LCD_OFF;                           
  SEG_K3  = SEG_LCD_OFF;                           
  SEG_K4  = SEG_LCD_OFF;                           
  SEG_K5  = SEG_LCD_OFF;                                                    
                         
  SEGLCDBackup.VSpeedSeg = 0xFF; 
}

