/*****************************************************************************************************************************************************************************
  文 件 名：CAN_Communication_Matrix.h
  功能描述：BZ3组合仪表CAN通信矩阵
  作    者：张暄
  版    本：V1.0
  日    期：2016.11.8
*****************************************************************************************************************************************************************************/

#ifndef CAN_COMMUNICATION_MATRIX_H_
#define CAN_COMMUNICATION_MATRIX_H_

#include "stdint.h"

#define Test             1
#define Normal           2

//#define  CODEMODE        Test
#define CODEMODE         Normal

#pragma MESSAGE DISABLE C1106

/*****************************************************************************************************************************************************************************/
/*报文及信号定义 Intel
 *****************************************************************************************************************************************************************************/ 
/*****************************************10FF1021*****************************************************************************************************************************
ID  : 0x10FF1021           
报文： BCM_ExternalLight
信号：

|-Rx 
|- 
 ******************************************10FF1021***************************************************************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
    uint8_t         :  1;       //0 
    uint8_t   S09   :  1;       //1 
    uint8_t   S01   :  2;       //2-3 
    uint8_t   S02   :  2;       //4-5 
    uint8_t         :  2;       //6-7 

    uint8_t         :  8;       //8-15

    uint8_t         :  8;       //16-23

    uint8_t         :  2;	      //24-25 
    uint8_t   S03   :  2;	      //26-27 
    uint8_t   S04   :  2;	      //28-29 
    uint8_t   S05   :  2;	      //30-31

    uint8_t         :  8;       //32-39

    uint8_t         :  7;       //40-46 
    uint8_t   S06   :  1;       //47-47 
    
    uint8_t         :  4;       //48-51
    uint8_t   S07   :  1;       //52-52 
    uint8_t         :  3;       //53-55 
    
    uint8_t         :  8;       //56-63
	} Sig;

} CANMsg10FF1021Union;

extern volatile CANMsg10FF1021Union CANMsg10FF1021;
extern volatile uint8_t             CANMsg10FF1021Status;

#define BCM_ExternalLight          	0x10FF1021
#define BCM_ExternalLight_STATUS    CANMsg10FF1021Status
//-------------------10FF1021---------------------
#define BCM_ICM_Alarm              CANMsg10FF1021.Sig.S09
#define RearFogSts                 CANMsg10FF1021.Sig.S01
#define FrontFogSts                CANMsg10FF1021.Sig.S02
#define RHTurnSignalSts            CANMsg10FF1021.Sig.S03
#define LHTurnSignalSts            CANMsg10FF1021.Sig.S04
#define HazardLightSts		       	 CANMsg10FF1021.Sig.S05
#define BreakLightWarning		       CANMsg10FF1021.Sig.S06
#define Auxiliary_sign_LaneChange	 CANMsg10FF1021.Sig.S07

static const uint8_t  CANMsg10FF1021Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg10FF1021Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg10FF1021Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};    

/******************************************************************************
ID名称：BCM_StatusNBC
ID:0x10FF7521
报文：BCM_StatusNBC
信号：

|- PsngrDoorSts   	  	副驾驶侧车门状态   
|- DriveDoorSts		    	驾驶侧车门状态

|- RearviewMirrorDefSts 后视镜除霜状态

******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
    uint8_t          	:  8;   // b00_07            
    uint8_t           :  8;   // b08_15 
    
    uint8_t           :  4;   // b16_19
    uint8_t   S01   	:  2;   // DriveDoorSts
    uint8_t   S02   	:  2;   // PsngrDoorSts
    
    uint8_t          	:  8;   // b24_31
    
    uint8_t         	:  6;   // b32_37               
    uint8_t   S03     :  2;   // RearviewMirrorDefSts
    
    uint8_t           :  8;   // b40_47 
    uint8_t         	:  8;   // b48_55 
    uint8_t          	:  8;   // b56_63
	} Sig; 
} CANMsg10FF7521Union;

extern volatile CANMsg10FF7521Union CANMsg10FF7521;
extern volatile uint8_t             CANMsg10FF7521Status;

#define BCM_StatusNBC          		  0x10FF7521
#define BCM_StatusNBC_STATUS       	CANMsg10FF7521Status

#define DriveDoorSts_can		    	  CANMsg10FF7521.Sig.S01        // 副驾驶侧车门状态                                                               
#define PsngrDoorSts_can		    	  CANMsg10FF7521.Sig.S02        // 驾驶侧车门状态

#define RearviewMirrorDefSts	      CANMsg10FF7521.Sig.S03        // 后视镜除霜状态                                                              

static const uint8_t  CANMsg10FF7521Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg10FF7521Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg10FF7521Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/***********************************10FF1017*******************************************
  ID名称：BCM_Msg2
ID:0x10FF1017
报文：BCM_Msg2
信号：

|- PositionLightSts   	位置灯   
|- HighBeamSts			    远光灯

|- LowBeamSts           近光灯
 
***********************************10FF1017*******************************************/
typedef union
{
  uint8_t Msg[8];
  struct
  {		
    uint8_t   S04   	:  2;   // b00_01   
    uint8_t         	:  6;   // b02_07              
    
    uint8_t   S01     :  2;   // LowBeamSts
    uint8_t   S02     :  2;   // HighBeamSts
    uint8_t   S03   	:  2;   // PositionLightSts
    uint8_t         	:  2;   // b14_15 
    
    uint8_t          	:  8;   // b16_23 
    uint8_t          	:  8;   // b24_31               
    uint8_t           :  8;   // b32_39   
    uint8_t           :  8;   // b40_47
    uint8_t          	:  8;   // b48_55
    uint8_t         	:  8;   // b56_63  
	} Sig; 
} CANMsg10FF1017Union;

extern volatile CANMsg10FF1017Union CANMsg10FF1017;
extern volatile uint8_t             CANMsg10FF1017Status;

#define BCM_Msg2          		   	  0x10FF1017
#define BCM_Msg2_STATUS       		  CANMsg10FF1017Status

#define Brake_Switch			  	      CANMsg10FF1017.Sig.S04         //  刹车制动 
#define LowBeamSts			  	        CANMsg10FF1017.Sig.S01         //  近光灯                                                             
#define HighBeamSts			  	        CANMsg10FF1017.Sig.S02         //  远光灯

#define PositionLightSts_can		    CANMsg10FF1017.Sig.S03         //  位置灯                                                           

static const uint8_t  CANMsg10FF1017Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg10FF1017Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg10FF1017Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：BCM_TPMS
ID:0x18FEF433
报文：BCM_TPMS
信号：

|- TireLocation   	        	Tire Location   
|- TirePressure		           	Tire Pressure
|- TireTemp                   Tire Temperature
|- CTIWheelSensSts          	CTI Wheel Sensor Status  
|- TireLeakSts		            Tire Leakage Status
|- TireHighTempWarning        Tire High Temperature Warning
|- TirePressureState         	The State of Tire Pressure  
|- TirePressureThresholdDet		The Pressure Threshold Detection
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
    uint8_t   S01 	  :  2;   // TireLocation   
    uint8_t   S10   	:  2;   // TireIDStudy	
    uint8_t         	:  4;   // 
    
    uint8_t   S02     :  8;   // TirePressure
    uint8_t   S03L    :  8;   // TireTempL
    uint8_t   S03H  	:  8;   // TireTempH

    uint8_t   S04   	:  2;   // CTIWheelSensSts
    uint8_t   S05   	:  2;   // TireLeakSts
    uint8_t   S06   	:  2;   // TireHighTempWarning              
    uint8_t   S07     :  2;   // TirePressureState 
    
    uint8_t           :  8;   // 
    uint8_t         	:  8;   // 
    
    uint8_t         	:  4;   // 
    uint8_t   S09   	:  3;   // TirePressureThresholdDet
    uint8_t         	:  1;   // 
	} Sig; 
} CANMsg18FEF433Union;

extern volatile CANMsg18FEF433Union CANMsg18FEF433 ;
extern volatile uint8_t             CANMsg18FEF433Status;

#define BCM_TPMS          		   	  0x18FEF433
#define BCM_TPMS_STATUS       		  CANMsg18FEF433Status

#define TireLocation			          CANMsg18FEF433.Sig.S01            //  Tire Location                                                          
#define TirePressure			          CANMsg18FEF433.Sig.S02            //  Tire Pressure
#define TireTempL				            CANMsg18FEF433.Sig.S03L           //  Tire Temperature
#define TireTempH				            CANMsg18FEF433.Sig.S03H           //  Tire Temperature
#define CTIWheelSensSts			        CANMsg18FEF433.Sig.S04            //  CTI Wheel Sensor Status                                             
#define TireLeakSts				          CANMsg18FEF433.Sig.S05            //  Tire Leakage Status              
#define TireHighTempWarning		      CANMsg18FEF433.Sig.S06            //  Tire High Temperature Warning
#define TirePressureState		        CANMsg18FEF433.Sig.S07            //   The State of Tire Pressure                                                          
#define TirePressureThresholdDet	  CANMsg18FEF433.Sig.S09            //   The Pressure Threshold Detection  
#define TireIDStudy             	  CANMsg18FEF433.Sig.S10            //   TireIDStudy                                                              

static const uint8_t  CANMsg18FEF433Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEF433Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEF433Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：BCM_PEPS_MSG1
ID:0x08FF00DD
报文：BCM_PEPS_MSG1
信号：

|- PepslcuAlarm   		PEPS仪表报警提示   
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
    uint8_t          	:  8;   //    
    uint8_t         	:  4;   // 	
    uint8_t   S01     :  4;   // PepslcuAlarm
    uint8_t           :  8;   // 
    uint8_t          	:  8;   // 
    uint8_t          	:  8;   // 
    uint8_t          	:  8;   // 
    uint8_t          	:  8;   //               
    uint8_t           :  8;   //    
	} Sig; 
} CANMsg08FF00DDUnion;

extern volatile CANMsg08FF00DDUnion CANMsg08FF00DD;
extern volatile uint8_t             CANMsg08FF00DDStatus;

#define BCM_PEPS_MSG1          		  0x08FF00DD
#define BCM_PEPS_MSG1_STATUS       	CANMsg08FF00DDStatus

#define PepslcuAlarm			          CANMsg08FF00DD.Sig.S01           //	PEPS仪表报警提示                                                              

static const uint8_t  CANMsg08FF00DDInit[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg08FF00DDTimeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg08FF00DDMask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：NWM_BCM
ID:0x18FFA021
报文：NWM_BCM
信号：

|- BCM_Sleep_Indicator   	BCM网络管理报文
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   S01   	:  3;   // BCM_Sleep_Indicator  
    uint8_t         	:  5;   // 	
    uint8_t           :  8;   // 
    uint8_t           :  8;   // 
    uint8_t          	:  8;   // 
    uint8_t         	:  8;   // 
    uint8_t          	:  8;   // 
    uint8_t          	:  8;   //               
    uint8_t           :  8;   //    
	} Sig; 
} CANMsg18FFA021Union;

extern volatile CANMsg18FFA021Union CANMsg18FFA021;
extern volatile uint8_t             CANMsg18FFA021Status;

#define NWM_BCM          		   	    0x18FFA021
#define NWM_BCM_STATUS       		    CANMsg18FFA021Status

#define BCM_Sleep_Indicator			    CANMsg18FFA021.Sig.S01              //	BCM网络管理报文                                                         

static const uint8_t  CANMsg18FFA021Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FFA021Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FFA021Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：TCO1
ID:0x18FE6CEE
报文：TCO1
信号：

|- Tachograph_Vehicle_Speed   	车速

******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
    uint8_t           	:  8;   // 	 
    uint8_t             :  8;   // 
    uint8_t             :  8;   // 
    uint8_t           	:  8;   // 
    uint8_t           	:  8;   // 
    uint8_t           	:  8;   // 
    uint8_t   S01L    	:  8;   // Tachograph_Vehicle_SpeedL              
    uint8_t   S01H      :  8;   // Tachograph_Vehicle_SpeedH  
	} Sig; 
} CANMsg18FE6CEEUnion;

extern volatile CANMsg18FE6CEEUnion CANMsg18FE6CEE;
extern volatile uint8_t             CANMsg18FE6CEEStatus;

#define TCO1          		   	      0x18FE6CEE
#define TCO1_STATUS       		      CANMsg18FE6CEEStatus

#define Tachograph_Vehicle_SpeedL		CANMsg18FE6CEE.Sig.S01L     //车速                                                                  
#define Tachograph_Vehicle_SpeedH		CANMsg18FE6CEE.Sig.S01H     //车速 

static const uint8_t  CANMsg18FE6CEEInit[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FE6CEETimeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FE6CEEMask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：VDHR
ID:0x18FEC117
报文：VDHR
信号：

|- High_Resolution_Total_Vehicle_Distance   	总里程

******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
    uint8_t    S01   	:  8;   // High_Resolution_Total_Vehicle_Distance_LL 
    uint8_t    S02    :  8;   // High_Resolution_Total_Vehicle_Distance_LH
    uint8_t    S03    :  8;   // High_Resolution_Total_Vehicle_Distance_HL
    uint8_t    S04   	:  8;   // High_Resolution_Total_Vehicle_Distance_HH
    uint8_t          	:  8;   // 
    uint8_t          	:  8;   // 
    uint8_t          	:  8;   //               
    uint8_t           :  8;   //  
	} Sig; 
} CANMsg18FEC117Union;

extern volatile CANMsg18FEC117Union CANMsg18FEC117;
extern volatile uint8_t             CANMsg18FEC117Status;

#define VDHR          		   	      0x18FEC117
#define VDHR_STATUS       		      CANMsg18FEC117Status

#define High_Resolution_Total_Vehicle_Distance_LL			CANMsg18FEC117.Sig.S01       // 总里程                                                               
#define High_Resolution_Total_Vehicle_Distance_LH			CANMsg18FEC117.Sig.S02       // 总里程 
#define High_Resolution_Total_Vehicle_Distance_HL			CANMsg18FEC117.Sig.S03       // 总里程 
#define High_Resolution_Total_Vehicle_Distance_HH			CANMsg18FEC117.Sig.S04       // 总里程 

static const uint8_t  CANMsg18FEC117Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEC117Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEC117Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：AIR1
ID:0x18FEAE17
报文：AIR1
信号：

|- FrontBarometricPress   	前桥气压
|- RearBarometricPress    	后桥气压
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
    uint8_t         	:  8;   //  
    uint8_t           :  8;   // 
    uint8_t   S01     :  8;   // FrontBarometricPress
    uint8_t   S02    	:  8;   // RearBarometricPress
    uint8_t          	:  8;   // 
    uint8_t          	:  8;   // 
    uint8_t          	:  8;   //               
    uint8_t           :  8;   //  
	} Sig; 
} CANMsg18FEAE17Union;

extern volatile CANMsg18FEAE17Union CANMsg18FEAE17;
extern volatile uint8_t             CANMsg18FEAE17Status;

#define AIR1          		   	      0x18FEAE17
#define AIR1_STATUS       		      CANMsg18FEAE17Status

#define FrontBarometricPress			  CANMsg18FEAE17.Sig.S01     // 前桥气压                                                                  
#define RearBarometricPress				  CANMsg18FEAE17.Sig.S02     // 后桥气压

static const uint8_t  CANMsg18FEAE17Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEAE17Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEAE17Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：PGNRQ
ID:0x18EA0021
报文：PGNRQ
信号：

|- LeastSignificantBytePGN   	PNG低字节

|- MidbytePGN   			      	PNG中字节

|- MostSignificantBytePGN    	PNG高字节 
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // LeastSignificantBytePGN
		uint8_t   b10_17  :  8;   // MidbytePGN
		uint8_t   b20_27  :  8;   // MostSignificantBytePGN
		uint8_t   b30_37 	:  8;   // 
		uint8_t   b40_47 	:  8;   // 
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18EA0021Union;

extern volatile CANMsg18EA0021Union CANMsg18EA0021;
extern volatile uint8_t             CANMsg18EA0021Status;

#define PGNRQ          		   	      0x18EA0021
#define PGNRQ_STATUS       		      CANMsg18EA0021Status

#define LeastSignificantBytePGN			CANMsg18EA0021.Sig.b00_07    //  PNG低字节                                                                 
#define MidbytePGN					      	CANMsg18EA0021.Sig.b10_17    //  PNG中字节

#define MostSignificantBytePGN			CANMsg18EA0021.Sig.b20_27    //  PNG高字节 

static const uint8_t  CANMsg18EA0021Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18EA0021Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18EA0021Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：NWM_ICM
ID:0x18FEF717
报文：NWM_ICM
信号：

|- ICM_Sleep_Indicator   	ICM网络管理报文
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_02 	:  3;   // ICM_Sleep_Indicator
		uint8_t   b03_07 	:  5;   // 
		
		uint8_t   b10_17  :  8;   // 
		uint8_t   b20_27  :  8;   // 
		uint8_t   b30_37 	:  8;   // 
		uint8_t   b40_47 	:  8;   // 
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FEF717Union;

extern volatile CANMsg18FEF717Union CANMsg18FEF717;
extern volatile uint8_t             CANMsg18FEF717Status;

#define NWM_ICM          		   	    0x18FEF717
#define NWM_ICM_STATUS       		    CANMsg18FEF717Status

#define ICM_Sleep_Indicator				  CANMsg18FEF717.Sig.b00_02    // ICM网络管理报文                                                                  

static const uint8_t  CANMsg18FEF717Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEF717Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEF717Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：ETCS
ID:0x18FEC317
报文：ETCS
信号：

|- ReverseGear   	倒挡信号(康明斯接收)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // 
		
		uint8_t   b10_10 	:  1;   // ReverseGear
		uint8_t   b11_17  :  7;   // 
		
		uint8_t   b20_27  :  8;   // 
		uint8_t   b30_37 	:  8;   // 
		uint8_t   b40_47 	:  8;   // 
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FEC317Union;

extern volatile CANMsg18FEC317Union CANMsg18FEC317;
extern volatile uint8_t             CANMsg18FEC317Status;

#define ETCS          		   	      0x18FEC317
#define ETCS_STATUS       		      CANMsg18FEC317Status

#define ReverseGear				          CANMsg18FEC317.Sig.b10_10    //	倒挡信号(康明斯接收)                                                            

static const uint8_t  CANMsg18FEC317Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEC317Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEC317Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：ICM_1
ID:0x18FE8E17
报文：ICM_1
信号：

|- LowBrakeLuidLevel	   	制动液位低

|- SafetyBeltSt			    	主驾安全带状态

|- TankLevel				      油箱液位
|- MaintainSignal			    保养信号
|- AverageFuelConsumption	平均油耗

 ******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_00 	:  1;   // LowBrakeLuidLevel
		uint8_t   b01_01 	:  1;   // SafetyBeltSt
		uint8_t   b02_04  :  3;   //
		uint8_t   b05_05  :  1;   // MaintainSignal
		uint8_t   b06_07 	:  2;   // 
		
		uint8_t   b10_17 	:  8;   //
		uint8_t   b20_27 	:  8;   //
		uint8_t   b30_37 	:  8;   //
		uint8_t   b40_47 	:  8;   //
		uint8_t   b50_57 	:  8;   // TankLevel
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FE8E17Union;

extern volatile CANMsg18FE8E17Union CANMsg18FE8E17;
extern volatile uint8_t             CANMsg18FE8E17Status;

#define ICM_1          		   	      0x18FE8E17
#define ICM_1_STATUS       		      CANMsg18FE8E17Status

#define LowBrakeLuidLevel		    	  CANMsg18FE8E17.Sig.b00_00    //  制动液位低

#define SafetyBeltSt			        	CANMsg18FE8E17.Sig.b01_01    //  主驾安全带状态

#define TankLevel				          	CANMsg18FE8E17.Sig.b50_57    //  油箱液位
#define MaintainSignal			    	  CANMsg18FE8E17.Sig.b05_05    //  保养信号

static const uint8_t  CANMsg18FE8E17Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FE8E17Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FE8E17Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：ICM_2
ID:0x18FEF117
报文：ICM_2
信号：

|- ParkingBrakeSwitch		驻车制动开关(康明斯接收)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_01 	:  2;   // 
		uint8_t   b02_03 	:  2;   // ParkingBrakeSwitch
		uint8_t   b04_07  :  4;   //   
		
		uint8_t   b10_17 	:  8;   //
		uint8_t   b20_27 	:  8;   //
		uint8_t   b30_37 	:  8;   //
		uint8_t   b40_47 	:  8;   //
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FEF117Union;

extern volatile CANMsg18FEF117Union CANMsg18FEF117;
extern volatile uint8_t             CANMsg18FEF117Status;

#define ICM_2          		   	      0x18FEF117
#define ICM_2_STATUS       		      CANMsg18FEF117Status

#define ParkingBrakeSwitch		    	CANMsg18FEF117.Sig.b02_03    // 驻车制动开关(康明斯接收)

static const uint8_t  CANMsg18FEF117Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEF117Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEF117Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
/******************************************************************************
ID名称：ICM_4
ID:0x18FEFC17
报文：ICM_4
信号：

|- ICM_FuelLevel		驻车制动开关(康明斯接收)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
  	uint8_t   b00_07  :  8;   //   
		uint8_t   b08_15 	:  8;   // ICM_FuelLevel 
		uint8_t   b16_23 	:  8;   // 
		uint8_t   b24_31 	:  8;   //
		uint8_t   b32_39 	:  8;   //  
		uint8_t   b40_47 	:  8;   // 
		uint8_t   b48_55 	:  8;   // 
		uint8_t   b56_63 	:  8;   //         
	} Sig; 
} CANMsg18FEFC17Union;

extern volatile CANMsg18FEFC17Union CANMsg18FEFC17;
extern volatile uint8_t             CANMsg18FEFC17Status;

#define ICM_4          		   	      0x18FEFC17
#define ICM_4_STATUS       		      CANMsg18FEFC17Status

#define ICM_FuelLevel		    	      CANMsg18FEFC17.Sig.b08_15    // 驻车制动开关(康明斯接收)

static const uint8_t  CANMsg18FEFC17Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEFC17Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEFC17Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：ICM_3
ID:0x18FF0A17
报文：ICM_3
信号：

|- CabLockSt		驾驶室锁止(康明斯接收)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_05 	:  6;   // 
		uint8_t   b06_07 	:  2;   // CabLockSt  
		
		uint8_t   b10_17 	:  8;   //
		uint8_t   b20_27 	:  8;   //
		uint8_t   b30_37 	:  8;   //
		uint8_t   b40_47 	:  8;   //
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FF0A17Union;

extern volatile CANMsg18FF0A17Union CANMsg18FF0A17;
extern volatile uint8_t             CANMsg18FF0A17Status;

#define ICM_3          		   	      0x18FF0A17
#define ICM_3_STATUS       		      CANMsg18FF0A17Status

#define CabLockSt	                	CANMsg18FF0A17.Sig.b06_07    //驾驶室锁止(康明斯接收)

static const uint8_t  CANMsg18FF0A17Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FF0A17Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FF0A17Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：NWM_TBOX
ID:0x18EFCD27
报文：NWM_TBOX
信号：

|- TBOX_Sleep_Indicator		TBOX网络管理报文
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_02 	:  3;   // TBOX_Sleep_Indicator
		uint8_t   b03_07 	:  5;   //  
		
		uint8_t   b10_17 	:  8;   //
		uint8_t   b20_27 	:  8;   //
		uint8_t   b30_37 	:  8;   //
		uint8_t   b40_47 	:  8;   //
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18EFCD27Union;

extern volatile CANMsg18EFCD27Union CANMsg18EFCD27;
extern volatile uint8_t             CANMsg18EFCD27Status;

#define NWM_TBOX          		   	  0x18EFCD27
#define NWM_TBOX_STATUS       		  CANMsg18EFCD27Status

#define TBOX_Sleep_Indicator		    CANMsg18EFCD27.Sig.b00_02    //	TBOX网络管理报文

static const uint8_t  CANMsg18EFCD27Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18EFCD27Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18EFCD27Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：ADAS_1
ID:0x10F007E8
报文：ADAS_1
信号：

|- Right_LDW		右侧车道偏离
|- Left_LDW			左侧车道偏离
|- FCW				  前碰预警
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_03 	:  4;   // 
		uint8_t   b04_04 	:  1;   // Right_LDW 
		uint8_t   b05_05 	:  1;   // 
		uint8_t   b06_06 	:  1;   // Left_LDW
		uint8_t   b07_07 	:  1;   // 
		
		uint8_t   b10_10 	:  1;   // FCW
		uint8_t   b11_17 	:  7;   // 
		
		uint8_t   b20_27 	:  8;   //
		uint8_t   b30_37 	:  8;   //
		uint8_t   b40_47 	:  8;   //
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg10F007E8Union;

extern volatile CANMsg10F007E8Union CANMsg10F007E8;
extern volatile uint8_t             CANMsg10F007E8Status;

#define ADAS_1          		   	    0x10F007E8
#define ADAS_1_STATUS       		    CANMsg10F007E8Status

#define Right_LDW			              CANMsg10F007E8.Sig.b04_04    //  右侧车道偏离
#define Left_LDW			              CANMsg10F007E8.Sig.b06_06    //  左侧车道偏离
#define FCW				  	              CANMsg10F007E8.Sig.b10_10    //  前碰预警

static const uint8_t  CANMsg10F007E8Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg10F007E8Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg10F007E8Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：ADAS_2
ID:0x18FE5BE8
报文：ADAS_2
信号：

|- Right_Lane_Tracking		右车道跟踪

|- Leftt_Lane_Tracking		左车道跟踪

|- LDW_Disable			    	车道偏离预警未启用

|- Headway_Warning		  	车距监测报警
|- PCW					        	行人碰撞
|- Headway_Measurement		车距监测时间数值

|- ADAS_Error_Active	   	Error Active
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_01 	:  2;   // 
		uint8_t   b02_03 	:  2;   // Right_Lane_Tracking
		uint8_t   b04_05 	:  2;   // Leftt_Lane_Tracking
		uint8_t   b06_06 	:  1;   // LDW_Disable
		uint8_t   b07_07 	:  1;   // 
		
		uint8_t   b10_14 	:  5;   // 
		uint8_t   b15_16 	:  2;   // Headway_Warning
		uint8_t   b17_17 	:  1;   // 
		
		uint8_t   b20_20 	:  1;   // PCW
		uint8_t   b21_21 	:  1;   // Ped_In_Zone
		uint8_t   b21_25 	:  4;   // 
		uint8_t   b26_26 	:  1;   // ADAS_Maintenance
		uint8_t   b27_27 	:  1;   //  ADAS_Failsafe
		
		uint8_t   b30_30 	:  1;   // 
		uint8_t   b31_37 	:  7;   // Headway_Measurement
		
		uint8_t   b40_40 	:  1;   // ADAS_Error_Active
		uint8_t   b41_47 	:  7;   // ADAS_Error_Code
		
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FE5BE8Union;

extern volatile CANMsg18FE5BE8Union CANMsg18FE5BE8;
extern volatile uint8_t             CANMsg18FE5BE8Status;

#define ADAS_2          		   	    0x18FE5BE8
#define ADAS_2_STATUS       		    CANMsg18FE5BE8Status

#define Right_Lane_Tracking			    CANMsg18FE5BE8.Sig.b02_03    // 右车道跟踪

#define Leftt_Lane_Tracking	    		CANMsg18FE5BE8.Sig.b04_05    // 左车道跟踪

#define LDW_Disable					        CANMsg18FE5BE8.Sig.b06_06    // 车道偏离预警未启用 
#define Headway_Warning				      CANMsg18FE5BE8.Sig.b15_16    // 车距监测报警
#define PCW							            CANMsg18FE5BE8.Sig.b20_20    // 行人碰撞
#define Ped_In_Zone							    CANMsg18FE5BE8.Sig.b21_21    // Ped in zone
#define ADAS_Maintenance				    CANMsg18FE5BE8.Sig.b26_26    // 维修信息
#define ADAS_Failsafe						    CANMsg18FE5BE8.Sig.b27_27    // Failsafe
#define Headway_Measurement			    CANMsg18FE5BE8.Sig.b31_37    // 车距监测时间数值

#define ADAS_Error_Active	    		  CANMsg18FE5BE8.Sig.b40_40    // Error Active
#define ADAS_Error_Code			        CANMsg18FE5BE8.Sig.b41_47    // ADAS_Error_Code

static const uint8_t  CANMsg18FE5BE8Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FE5BE8Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FE5BE8Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：EEC1
ID:0x0CF00400
报文：EEC1
信号：

|- Engine_Speed				发送机转速 (玉柴、潍柴、大柴、锡柴、云内)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // 
		uint8_t   b10_17 	:  8;   // 
		uint8_t   b20_27 	:  8;   // 
		uint8_t   b30_37 	:  8;   // Engine_SpeedL
		uint8_t   b40_47 	:  8;   // Engine_SpeedH	
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg0CF00400Union;

extern volatile CANMsg0CF00400Union CANMsg0CF00400;
extern volatile uint8_t             CANMsg0CF00400Status;

#define EEC1          		   	      0x0CF00400
#define EEC1_STATUS       		      CANMsg0CF00400Status

#define Engine_SpeedL			          CANMsg0CF00400.Sig.b30_37    // 发送机转速

#define Engine_SpeedH			          CANMsg0CF00400.Sig.b40_47    // 发送机转速   (玉柴、潍柴、大柴、锡柴、云内)

static const uint8_t  CANMsg0CF00400Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg0CF00400Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg0CF00400Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：ET1
ID:0x18FEEE00
报文：ET1
信号：

|- Engine_Coolant_Temp			冷却液温度

******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // Engine_Coolant_Temp
		uint8_t   b10_17 	:  8;   // 
		uint8_t   b20_27 	:  8;   // 
		uint8_t   b30_37 	:  8;   // 
		uint8_t   b40_47 	:  8;   // 	
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FEEE00Union;

extern volatile CANMsg18FEEE00Union CANMsg18FEEE00;
extern volatile uint8_t             CANMsg18FEEE00Status; 

#define ET1          		   	        0x18FEEE00
#define ET1_STATUS       		        CANMsg18FEEE00Status

#define Engine_Coolant_Temp			    CANMsg18FEEE00.Sig.b00_07    //冷却液温度


static const uint8_t  CANMsg18FEEE00Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEEE00Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEEE00Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：EFLP1
ID:0x18FEEF00
报文：EFLP1
信号：

|- EngOilPress			机油压力(玉柴、潍柴、大柴、锡柴、云内)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // 
		uint8_t   b10_17 	:  8;   // 
		uint8_t   b20_27 	:  8;   // 
		uint8_t   b30_37 	:  8;   // EngOilPress
		uint8_t   b40_47 	:  8;   // 	
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FEEF00Union;

extern volatile CANMsg18FEEF00Union CANMsg18FEEF00;
extern volatile uint8_t             CANMsg18FEEF00Status;

#define EFLP1          		   	      0x18FEEF00
#define EFLP1_STATUS       		      CANMsg18FEEF00Status

#define EngOilPress		              CANMsg18FEEF00.Sig.b30_37    //机油压力(玉柴/潍柴/大柴/锡柴/云内)

static const uint8_t  CANMsg18FEEF00Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEEF00Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEEF00Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：AT1T1L
ID:0x18FE5600
报文：AT1T1L
信号：

|- Aftrtrtmnt1SCRCatalystTankLevel		尿素液位值/反应剂余量

|- Urealevelalarm_Kang				      	尿素液位报警(康明斯)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // Aftrtrtmnt1SCRCatalystTankLevel
		uint8_t   b10_17 	:  8;   // 
		uint8_t   b20_27 	:  8;   // 
		uint8_t   b30_37 	:  8;   // 
		uint8_t   b40_44 	:  5;   // 
		uint8_t   b45_47 	:  3;   // Urealevelalarm_Kang	
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	}Sig; 
} CANMsg18FE5600Union;

extern volatile CANMsg18FE5600Union CANMsg18FE5600;
extern volatile uint8_t             CANMsg18FE5600Status;

#define AT1T1L          		   	    0x18FE5600
#define AT1T1L_STATUS       		    CANMsg18FE5600Status

#define Aftrtrtmnt1SCRCatalystTankLevel		CANMsg18FE5600.Sig.b00_07  // 尿素液位值/反应剂余量

#define Urealevelalarm_KANG					      CANMsg18FE5600.Sig.b45_47  // 尿素液位报警(康明斯)

static const uint8_t  CANMsg18FE5600Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FE5600Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FE5600Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：SHUTDN
ID:0x18FEE400
报文：SHUTDN
信号：

|- EngWaitToStartLamp		发动机预热指示灯
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // 
		uint8_t   b10_17 	:  8;   // 
		uint8_t   b20_27 	:  8;   // 
		uint8_t   b30_31 	:  2;   // EngWaitToStartLamp
		uint8_t   b32_37 	:  6;   // 
		uint8_t   b40_44 	:  5;   // 
		uint8_t   b45_47 	:  3;   // 	
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FEE400Union;

extern volatile CANMsg18FEE400Union CANMsg18FEE400;
extern volatile uint8_t             CANMsg18FEE400Status;

#define SHUTDN          		   	    0x18FEE400
#define SHUTDN_STATUS       		    CANMsg18FEE400Status

#define EngWaitToStartLamp		      CANMsg18FEE400.Sig.b30_31    //发动机预热指示灯

static const uint8_t  CANMsg18FEE400Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEE400Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEE400Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：WFI_DA    
ID:0x18FF7400
报文：
信号：

|- DriverAlarmSystem  		驾驶员报警系统(大柴、锡柴)
******************************************************************************/
typedef union
{
  uint8_t Msg[8];
  struct
  {		
    uint8_t   b00_02 	:  3;   // DriverAlarmSystem
    uint8_t   b03_07 	:  5;   // 
    uint8_t   b10_17 	:  8;   // 
    uint8_t   b20_27 	:  8;   // 
    uint8_t   b30_37 	:  8;   // 	
    uint8_t   b40_47 	:  8;   // 	
    uint8_t   b50_57 	:  8;   // 
    uint8_t   b60_67 	:  8;   //               
    uint8_t   b70_77  :  8;   //  
  } Sig; 
} CANMsg18FF7400Union;

extern volatile CANMsg18FF7400Union CANMsg18FF7400;
extern volatile uint8_t             CANMsg18FF7400Status;

#define WFI_DA          		   	    0x18FF7400
#define WFI_DA_STATUS       		    CANMsg18FF7400Status

#define DriverAlarmSystem_DA			  CANMsg18FF7400.Sig.b00_02    // 驾驶员报警系统(大柴、锡柴)

static const uint8_t  CANMsg18FF7400Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FF7400Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FF7400Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}; 
/******************************************************************************
ID名称：WFI    此ID与前面的OI的ID相同，需要修改

ID:0x18FEFF00
报文：
信号：

|- WaterInFuelIndicator		燃料中有水指示 (康明斯、玉柴、潍柴、云内)
|- DriverAlarmSystem  		驾驶员报警系统(康明斯)
******************************************************************************/
typedef union
{
  uint8_t Msg[8];
  struct
  {		
    uint8_t   b00_01 	:  2;   // WaterInFuelIndicator
    uint8_t   b02_07 	:  6;   // 
    uint8_t   b10_12 	:  3;   // DriverAlarmSystem
    uint8_t   b13_15 	:  3;   // 
    uint8_t   b16_17 	:  2;   // 
    uint8_t   b20_27 	:  8;   // 
    uint8_t   b30_37 	:  8;   // 	
    uint8_t   b40_47 	:  5;   // 	
    uint8_t   b50_57 	:  8;   // 
    uint8_t   b60_67 	:  8;   //               
    uint8_t   b70_77  :  8;   //  
  } Sig; 
} CANMsg18FEFF00Union;

extern volatile CANMsg18FEFF00Union CANMsg18FEFF00;
extern volatile uint8_t             CANMsg18FEFF00Status;

#define WFI          		   	        0x18FEFF00
#define WFI_STATUS       		        CANMsg18FEFF00Status

#define WaterInFuelIndicator	       	CANMsg18FEFF00.Sig.b00_01  // 燃料中有水指示(康明斯、玉柴、潍柴、云内)
#define DriverAlarmSystem_KANGWEI			CANMsg18FEFF00.Sig.b10_12  // 驾驶员报警系统(康明斯、潍柴)
#define Urealevelalarm_YU		          CANMsg18FEFF00.Sig.b10_12  //  尿素液位报警(玉柴)
#define DrivabilityRestrictionsystem	CANMsg18FEFF00.Sig.b13_15  //  驾驶性能限制系统(潍柴)
#define DriverAlarmSystem_YUN	        CANMsg18FEFF00.Sig.b13_15  //  驾驶员报警系统（云内）


static const uint8_t  CANMsg18FEFF00Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEFF00Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEFF00Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};  

/******************************************************************************
ID名称：MFD1   
ID:0x18FF0800
报文：MFD1
信号：

|- OBDMalfunctionindLamp	   	OBD灯状态(MIL灯)(潍柴)
|- EngineMalfunctionLamp  		发动机系统一般故障(潍柴)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // 
		uint8_t   b10_17 	:  8;   // 
		uint8_t   b20_27 	:  8;   // 
		uint8_t   b30_31 	:  2;   // OBDMalfunctionindLamp
		uint8_t   b32_33 	:  2;   // EngineMalfunctionLamp
		uint8_t   b34_37 	:  4;   // 	
		uint8_t   b40_47 	:  8;   // 	
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //               
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FF0800Union;

extern volatile CANMsg18FF0800Union CANMsg18FF0800;
extern volatile uint8_t             CANMsg18FF0800Status;

#define MFD1          		   	      0x18FF0800
#define MFD1_STATUS       		      CANMsg18FF0800Status

#define EngineMalfunctionLamp_WEI		CANMsg18FF0800.Sig.b32_33    //  发动机系统一般故障(潍柴)
#define OBDMalfunctionindLamp_WEI		CANMsg18FF0800.Sig.b30_31    //  OBD灯状态(MIL灯)(潍柴)

static const uint8_t  CANMsg18FF0800Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FF0800Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FF0800Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：DPFC1   
ID:0x18FD7C00
报文：DPFC1
信号：

|- DPF_Lamp_Status				DPF再生指示灯状态(康明斯/玉柴、锡柴)
//|- DPF_Lamp_Status			DPF再生指示灯状态(潍柴) 
|- DPF_Forbidden_Lamp			DPF禁止主动再生(玉柴/潍柴)
|- ExhaustHighTempLamp		高排气温度报警灯(康明斯)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_02 	:  3;   // DPF_Lamp_Status
		uint8_t   b03_07 	:  5;   // 
		
		uint8_t   b10_13 	:  4;   // 
		uint8_t   b14_17 	:  4;   // DPF_Need_Status

		uint8_t   b20_21 	:  2;   // DPF_Forbidden_Lamp
		uint8_t   b22_23 	:  2;   // 
		uint8_t   b24_27 	:  4;   // 
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_61 	:  2;   //  
		uint8_t   b62_64 	:  3;   // ExhaustHighTempLamp 
		uint8_t   b65_67 	:  3;   // 
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FD7C00Union;

extern volatile CANMsg18FD7C00Union CANMsg18FD7C00;
extern volatile uint8_t             CANMsg18FD7C00Status;

#define DPFC1          		   	      0x18FD7C00
#define DPFC1_STATUS       		      CANMsg18FD7C00Status

#define DPF_Lamp_Status				      CANMsg18FD7C00.Sig.b00_02    //  DPF再生指示灯状态 
#define DPF_Need_Status				      CANMsg18FD7C00.Sig.b14_17    //  DPF需要再生状态（大柴/锡柴） 
#define DPF_Forbidden_Lamp_YUWEI	  CANMsg18FD7C00.Sig.b20_21    //  DPF禁止主动再生(玉柴/潍柴)
#define DPF_Forbidden_Lamp_YUN		  CANMsg18FD7C00.Sig.b22_23    //  DPF禁止主动再生(云内)
#define ExhaustHighTempLamp			    CANMsg18FD7C00.Sig.b62_64    //  高排气温度报警灯(康明斯、云内)

static const uint8_t  CANMsg18FD7C00Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FD7C00Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FD7C00Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：DPFC1_DA   
ID:0x18E0FF00
信号：

|- DPF_Forbidden_Lamp			DPF禁止主动再生(大柴、锡柴)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // 
		uint8_t   b10_17 	:  8;   // 
		uint8_t   b20_27 	:  8;   // 
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	
		uint8_t   b50_51 	:  2;   // DPF_Forbidden_Lamp
  	uint8_t   b52_57 	:  6;   // 
		uint8_t   b60_67 	:  8;   //  
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18E0FF00Union;

extern volatile CANMsg18E0FF00Union CANMsg18E0FF00;
extern volatile uint8_t             CANMsg18E0FF00Status;

#define DPFC1_DA          		   	  0x18E0FF00
#define DPFC1_DA_STATUS       		  CANMsg18E0FF00Status

#define DPF_Forbidden_Lamp_DA			  CANMsg18E0FF00.Sig.b50_51    //  DPF禁止主动再生(大柴、锡柴)

static const uint8_t  CANMsg18E0FF00Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18E0FF00Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18E0FF00Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
/******************************************************************************
ID名称：ERC1_WEI   
ID:0x18F0000F
报文：ERC1_WEI
信号：

|- Retarder_Request_BreakLight_WEI		排气制动灯(潍柴)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // 
		uint8_t   b10_17 	:  8;   // 
		uint8_t   b20_27 	:  8;   // 
		uint8_t   b30_31 	:  2;   // 	
		uint8_t   b32_33 	:  2;   // Retarder_Request_BreakLight_WEI
		uint8_t   b34_37 	:  4;   // 
		uint8_t   b40_47 	:  8;   // 	
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18F0000FUnion;

extern volatile CANMsg18F0000FUnion CANMsg18F0000F;
extern volatile uint8_t             CANMsg18F0000FStatus;

#define ERC1_WEI          		   	  0x18F0000F
#define ERC1_WEI_STATUS       		  CANMsg18F0000FStatus

#define Retarder_Request_BreakLight_WEI	CANMsg18F0000F.Sig.b32_33  //排气制动灯(潍柴)

static const uint8_t  CANMsg18F0000FInit[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18F0000FTimeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18F0000FMask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：ERC1_YU   
ID:0x18FD070F
报文：ERC1_YU
信号：

|- Retarder_Request_BreakLight_YU		排气制动灯(玉柴)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // 
		uint8_t   b10_11 	:  2;   // Retarder_Request_BreakLight_YU
		uint8_t   b12_17 	:  6;   // 
		uint8_t   b20_27 	:  8;   // 
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FD070FUnion;

extern volatile CANMsg18FD070FUnion CANMsg18FD070F;
extern volatile uint8_t             CANMsg18FD070FStatus;

#define ERC1_YU          		   	    0x18FD070F
#define ERC1_YU_STATUS       		    CANMsg18FD070FStatus

#define Retarder_Request_BreakLight_YU	CANMsg18FD070F.Sig.b10_11 //排气制动灯(玉柴)

static const uint8_t  CANMsg18FD070FInit[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FD070FTimeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FD070FMask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：ERC1_EXR   
ID:0x18F00029
报文：ERC1_YU
信号：

|- Retarder_Request_BreakLight_YU		排气制动灯(大柴、云内、锡柴)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // 
		uint8_t   b10_17 	:  8;   // Retarder_Request_BreakLight_YU
		uint8_t   b20_27 	:  8;   // 
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18F00029Union;

extern volatile CANMsg18F00029Union CANMsg18F00029;
extern volatile uint8_t             CANMsg18F00029Status;

#define ERC1_EXR          		   	  0x18F00029
#define ERC1_EXR_STATUS       		  CANMsg18F00029Status

#define Retarder_Request_BrakeLight	CANMsg18F00029.Sig.b10_17    //排气制动灯(大柴、云内、锡柴)

static const uint8_t  CANMsg18F00029Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18F00029Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18F00029Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：DLCC1               ID冲突
ID:0x18FD0700
报文：DLCC1
信号：

|- EngineMalfunctionLamp		发动机系统一般故障(康明斯，大柴)    
|- DriverAlarmSystem		  	驾驶员报警系统(玉柴)
|- EngineSeriousFailure			发动机系统严重故障(康明斯)
|- OBDMalfunctionindLamp		OBD灯状态(MIL灯)(康明斯/玉柴/大柴)
|- EngOilPressWaringLamp		机油压力低报警灯(玉柴)
|- EngCoolantTempWarningLamp    发动机水温报警灯
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_01 	:  2;   // EngineMalfunctionLamp  发动机系统一般故障（云内）
		
		uint8_t   b02_03 	:  2;   // EngineMalfunctionLamp/DriverAlarmSystem
		uint8_t   b04_05 	:  2;	  // EngineSeriousFailure	
		uint8_t   b06_07 	:  2; 	// OBDMalfunctionindLamp
		
		uint8_t   b10_11 	:  2;   // 
		uint8_t   b12_13 	:  2;   // 
		uint8_t   b14_15 	:  2;   // EngOilPressWaringLamp
		uint8_t   b16_17 	:  2;   // EngCoolantTempWarningLamp
		
		uint8_t   b20_27 	:  8;   // 
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FD0700Union;

extern volatile CANMsg18FD0700Union CANMsg18FD0700;
extern volatile uint8_t             CANMsg18FD0700Status;

#define DLCC1          		   	      0x18FD0700
#define DLCC1_STATUS       		      CANMsg18FD0700Status

#define EngineMalfunctionLamp_YUN		     CANMsg18FD0700.Sig.b00_01 //  发动机系统一般故障（云内/潍柴)
#define EngineMalfunctionLamp_DAKANG		 CANMsg18FD0700.Sig.b02_03 //  发动机系统一般故障(大柴、锡柴、康明斯)
#define DriverAlarmSystem_YU				     CANMsg18FD0700.Sig.b02_03 //  驾驶员报警系统(玉柴)
#define EngineSeriousFailure			       CANMsg18FD0700.Sig.b04_05 //  发动机系统严重故障(康明斯)
#define OBDMalfunctionindLamp_KANGYU		 CANMsg18FD0700.Sig.b06_07 //  OBD灯状态(MIL灯)(康明斯、玉柴、大柴、锡柴、云内)
#define Retarder_Request_BreakLight_KANG CANMsg18FD0700.Sig.b10_11 //  排气制动灯(康明斯)
#define EngOilPressWaringLamp			       CANMsg18FD0700.Sig.b14_15 //  机油压力低报警灯(玉柴、锡柴) 
#define EngCoolantTempWarningLamp	       CANMsg18FD0700.Sig.b16_17 //  发动机水温报警灯（康明斯/玉柴/潍柴）


static const uint8_t  CANMsg18FD0700Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FD0700Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FD0700Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：EIMI   
ID:0x18FB8500
报文?
信号：

|- Stop_Start_System_Public		起停系统状态指示灯命令(康明斯)
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_03 	:  4;   // Stop_Start_System_Public
		uint8_t   b04_07 	:  4;   // 
		uint8_t   b10_11 	:  2;   // 
		uint8_t   b12_17 	:  6;   // 
		uint8_t   b20_27 	:  8;   // 
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	
		uint8_t   b50_57 	:  8;   // 
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FB8500Union;

extern volatile CANMsg18FB8500Union CANMsg18FB8500;
extern volatile uint8_t             CANMsg18FB8500Status;

#define EIMI          		   	      0x18FB8500
#define EIMI_STATUS       		      CANMsg18FB8500Status

#define Stop_Start_System_Public		CANMsg18FB8500.Sig.b00_03 //起停系统状态指示灯命令(康明斯)

static const uint8_t  CANMsg18FB8500Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FB8500Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FB8500Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：LFC   
ID:0x18FEE900
报文?
信号：

|- CumulativeOilConsumOneway
|- CumulativeOilConsumption
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   //CumulativeOilConsumOneway 
		uint8_t   b10_17 	:  8;   //CumulativeOilConsumOneway
		uint8_t   b20_27 	:  8;   //CumulativeOilConsumOneway
		uint8_t   b30_37 	:  8;   //CumulativeOilConsumOneway	
		uint8_t   b40_47 	:  8;   //CumulativeOilConsumption	
		uint8_t   b50_57 	:  8;   //CumulativeOilConsumption
		uint8_t   b60_67 	:  8;   //CumulativeOilConsumption 	
		uint8_t   b70_77  :  8;   //CumulativeOilConsumption  
	} Sig; 
} CANMsg18FEE900Union;

extern volatile CANMsg18FEE900Union CANMsg18FEE900;
extern volatile uint8_t             CANMsg18FEE900Status;

#define LFC          		   	        0x18FEE900
#define LFC_STATUS       		        CANMsg18FEE900Status

#define CumulativeOilConsumOnewayLL	CANMsg18FEE900.Sig.b00_07    //CumulativeOilConsumOneway 累计油耗单程 （康明斯） （玉柴/潍柴）

#define CumulativeOilConsumOnewayLH	CANMsg18FEE900.Sig.b10_17    //CumulativeOilConsumOneway
#define CumulativeOilConsumOnewayHL	CANMsg18FEE900.Sig.b20_27    //CumulativeOilConsumOneway
#define CumulativeOilConsumOnewayHH	CANMsg18FEE900.Sig.b30_37    //CumulativeOilConsumOneway	
#define CumulativeOilConsumptionLL	CANMsg18FEE900.Sig.b40_47    //CumulativeOilConsumption	累计油耗 （康明斯） （玉柴/潍柴/大柴）

#define CumulativeOilConsumptionLH	CANMsg18FEE900.Sig.b50_57    //CumulativeOilConsumption
#define CumulativeOilConsumptionHL	CANMsg18FEE900.Sig.b60_67    //CumulativeOilConsumption 	
#define CumulativeOilConsumptionHH	CANMsg18FEE900.Sig.b70_77    //CumulativeOilConsumption  

static const uint8_t  CANMsg18FEE900Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEE900Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEE900Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：LFE  
ID:0x18FEF200
报文?
信号：

|- FuelConsumptionRate    瞬时油耗-燃油消耗率
|- FuelEconomy            瞬时油耗-燃油经济性

******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   //  FuelConsumptionRate
		uint8_t   b10_17 	:  8;   //  FuelConsumptionRate
		uint8_t   b20_27 	:  8;   //  FuelEconomy
		uint8_t   b30_37 	:  8;   // 	FuelEconomy
		uint8_t   b40_47 	:  8;   // 	 
		uint8_t   b50_57 	:  8;   //   
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FEF200Union;

extern volatile CANMsg18FEF200Union CANMsg18FEF200;
extern volatile uint8_t             CANMsg18FEF200Status;

#define LFE          		   	        0x18FEF200
#define LFE_STATUS       		        CANMsg18FEF200Status

#define FuelConsumptionRateL			  CANMsg18FEF200.Sig.b00_07    //瞬时油耗-燃油消耗率
#define FuelConsumptionRateH			  CANMsg18FEF200.Sig.b10_17    
#define FuelEconomyL			          CANMsg18FEF200.Sig.b20_27    // 瞬时油耗-燃油经济性   //20200229
#define FuelEconomyH			          CANMsg18FEF200.Sig.b30_37 

static const uint8_t  CANMsg18FEF200Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEF200Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEF200Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
/******************************************************************************
ID名称：DM1  
ID:0x18FECA00
报文?
信号：

|-EngineMalfunctionLamp1 
|-EngineMalfunctionLamp2      发动机系统故障灯
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_03 	:  4;   // 
		uint8_t   b04_05 	:  2;   // EngineMalfunctionLamp1
		uint8_t   b06_07 	:  2;   // 
		uint8_t   b10_13 	:  4;   // 
		uint8_t   b14_15 	:  2;   // EngineMalfunctionLamp2
		uint8_t   b16_17 	:  2;   // 
		uint8_t   b20_27 	:  8;   //  
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	 
		uint8_t   b50_57 	:  8;   //   
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FECA00Union;

extern volatile CANMsg18FECA00Union CANMsg18FECA00;
extern volatile uint8_t             CANMsg18FECA00Status;

#define DM1          		   	        0x18FECA00
#define DM1_STATUS       		        CANMsg18FECA00Status

#define EngineMalfunctionLamp1			CANMsg18FECA00.Sig.b04_05      //发动机系统故障灯1
#define EngineMalfunctionLamp2			CANMsg18FECA00.Sig.b14_15      //发动机系统故障灯2

static const uint8_t  CANMsg18FECA00Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FECA00Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FECA00Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：TCU_ICM_Display1  
ID:0x1801D003
报文?
信号：

|-Gear_Display 档位显示
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // Gear_Display
		uint8_t   b10_11 	:  2;   // AMT_Warning_Lamp 
		uint8_t   b12_13 	:  2;   // 
		uint8_t   b14_15 	:  2;   // 
		uint8_t   b16_17 	:  2;   // 
		uint8_t   b20_27 	:  8;   //  
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	 
		uint8_t   b50_57 	:  8;   //   
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg1801D003Union;

extern volatile CANMsg1801D003Union CANMsg1801D003;
extern volatile uint8_t             CANMsg1801D003Status;

#define TCU_ICM_Display1          	0x1801D003
#define TCU_ICM_Display1_STATUS     CANMsg1801D003Status

#define Gear_Display			          CANMsg1801D003.Sig.b00_07    //档位显示
#define AMT_Warning_Lamp			      CANMsg1801D003.Sig.b10_11    //AMT故障灯


static const uint8_t  CANMsg1801D003Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg1801D003Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg1801D003Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：CCVS 
ID:0x18FEF100
报文?
信号：

|- CruiseCtrlActive  巡航工作指示灯
 
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   //  
		uint8_t   b08_15 	:  8;   //    
		uint8_t   b16_23 	:  8;   //  
		uint8_t   b24_25 	:  2;   // CruiseCtrlActive 	
		uint8_t   b26_31 	:  6;   // 
		uint8_t   b32_39 	:  8;   // 	 
		uint8_t   b40_47 	:  8;   //   
		uint8_t   b48_52 	:  5;   //  
		uint8_t   b53_55 	:  3;   // CruiseCtrlActive	
		uint8_t   b56_63  :  8;   // 56
	} Sig; 
} CANMsg18FEF100Union;

extern volatile CANMsg18FEF100Union CANMsg18FEF100;
extern volatile uint8_t             CANMsg18FEF100Status;

#define CCVS          		   	      0x18FEF100
#define CCVS_STATUS       		      CANMsg18FEF100Status

#define CruiseCtrlActive_DA			    CANMsg18FEF100.Sig.b24_25    //巡航工作指示灯(大柴/锡柴/云内)
#define CruiseCtrlActive_FEIDA	    CANMsg18FEF100.Sig.b53_55    //巡航工作指示灯(康明斯/潍柴/玉柴)

static const uint8_t  CANMsg18FEF100Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEF100Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEF100Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：EBC1 
ID:0x18F0010B
报文?
信号：

|- ASR_OffRoad_Switch          ASR开关

|- ABS_FullyOperation          ABS完全工作模式
|- EBSRedWarningSignal         EBS红灯警告
|- ABS_EBS_AmberWarningSignal  ABS/EBS黄灯警告
|- ASR_Driver_Info_Signal       发给驾驶员的信号，发到仪表盘驱动灯

******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_01 	:  2;   // ASR_Engine_Control_Active 
		uint8_t   b02_03 	:  2;   // ASR_BrakeControl_Active
		uint8_t   b04_05 	:  2;   // ABS_Active
		uint8_t   b06_07 	:  2;   // 
		uint8_t   b10_17 	:  8;   //    
		uint8_t   b20_21 	:  2;   //  
		uint8_t   b22_23 	:  2;   // ASR_OffRoad_Switch
		uint8_t   b24_27 	:  4;   // 
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	 
		uint8_t   b50_51 	:  2;   // ABS_FullyOperation
		uint8_t   b52_53 	:  2;   // EBSRedWarningSignal
		uint8_t   b54_55 	:  2;   // ABS_EBS_AmberWarningSignal
		uint8_t   b56_57 	:  2;   // ASR_Driver_Info_Signal
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18F0010BUnion;

extern volatile CANMsg18F0010BUnion CANMsg18F0010B;
extern volatile uint8_t             CANMsg18F0010BStatus;

#define EBC1          		   	      0x18F0010B
#define EBC1_STATUS       		      CANMsg18F0010BStatus

#define ASR_Engine_Control_Active 	CANMsg18F0010B.Sig.b00_01    // ASR 发动机控制激活

#define ASR_BrakeControl_Active			CANMsg18F0010B.Sig.b02_03    // ASR工作状态

#define ABS_Active			            CANMsg18F0010B.Sig.b04_05    // ABS激活

#define ASR_OffRoad_Switch			    CANMsg18F0010B.Sig.b22_23    // ASR开关

#define ABS_FullyOperation			    CANMsg18F0010B.Sig.b50_51    // ABS完全工作模式
#define EBSRedWarningSignal			    CANMsg18F0010B.Sig.b52_53    // EBS红灯警告
#define ABS_EBS_AmberWarningSignal	CANMsg18F0010B.Sig.b54_55    // ABS/EBS黄灯警告
#define ASR_Driver_Info_Signal			CANMsg18F0010B.Sig.b56_57    // ATC/ASR指示灯状态


static const uint8_t  CANMsg18F0010BInit[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18F0010BTimeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18F0010BMask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
/******************************************************************************
ID名称：EBC2  
ID:0x18FEBF0B
报文?
信号：

|- FA_Speed         车速
 
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   // FA_Speed
		uint8_t   b10_17 	:  8;   // FA_Speed
		uint8_t   b20_27 	:  8;   //  
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	 
		uint8_t   b50_57 	:  8;   //   
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FEBF0BUnion;

extern volatile CANMsg18FEBF0BUnion CANMsg18FEBF0B;
extern volatile uint8_t             CANMsg18FEBF0BStatus;

#define EBC2          		   	      0x18FEBF0B
#define EBC2_STATUS       		      CANMsg18FEBF0BStatus

#define FA_SpeedL			              CANMsg18FEBF0B.Sig.b00_07    //车速

#define FA_SpeedH			              CANMsg18FEBF0B.Sig.b10_17    //车速


static const uint8_t  CANMsg18FEBF0BInit[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEBF0BTimeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEBF0BMask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：EBC3  
ID:0x18FE4F0B
报文?
信号：

|- VDC_Information_Signal     VDC信息
|- VDC_Fully_Operational      VDC全部工作
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_01 	:  2;   // VDC_Information_Signal
		uint8_t   b02_03 	:  2;   // VDC_Fully_Operational
		uint8_t   b04_07 	:  4;   //  
		uint8_t   b10_17 	:  8;   //    
		uint8_t   b20_27 	:  8;   //  
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	 
		uint8_t   b50_57 	:  8;   //   
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FE4F0BUnion;

extern volatile CANMsg18FE4F0BUnion CANMsg18FE4F0B;
extern volatile uint8_t             CANMsg18FE4F0BStatus;

#define EBC3          		   	      0x18FE4F0B
#define EBC3_STATUS       		      CANMsg18FE4F0BStatus

#define VDC_Information_Signal		  CANMsg18FE4F0B.Sig.b00_01    // VDC信息
#define VDC_Fully_Operational			  CANMsg18FE4F0B.Sig.b02_03    // VDC全部工作

static const uint8_t  CANMsg18FE4F0BInit[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FE4F0BTimeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FE4F0BMask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：AEBS1 
ID:0x0CF02F2A
报文?
信号：

|- AEB_State           AEB状态

******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_03 	:  4;   // AEB_State
		uint8_t   b04_07 	:  4;   // 
		uint8_t   b10_17 	:  8;   //    
		uint8_t   b20_27 	:  8;   //  
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	 
		uint8_t   b50_57 	:  8;   //   
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg0CF02F2AUnion;

extern volatile CANMsg0CF02F2AUnion CANMsg0CF02F2A;
extern volatile uint8_t             CANMsg0CF02F2AStatus;

#define AEBS1          		   	      0x0CF02F2A
#define AEBS1_STATUS       		      CANMsg0CF02F2AStatus

#define AEB_State			              CANMsg0CF02F2A.Sig.b00_03    // AEB状态


static const uint8_t  CANMsg0CF02F2AInit[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg0CF02F2ATimeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg0CF02F2AMask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称?EEPBS1 
ID:0x18FE1264
报文?
信号：

|- EPB_State 电子驻车状态

|- AutoHold  临时停车工作状态指示灯
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_01 	:  2;   // EPB_State
		uint8_t   b02_05 	:  4;   // AutoHold
		uint8_t   b06_07 	:  2;   // 
		uint8_t   b10_17 	:  8;   // 
		   
		uint8_t   b20_21 	:  2;   // 
		uint8_t   b22_23 	:  2;   // 
		uint8_t   b24_27 	:  4;   // 
		 
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	 
		uint8_t   b50_57 	:  8;   //   
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FE1264Union;

extern volatile CANMsg18FE1264Union CANMsg18FE1264;
extern volatile uint8_t             CANMsg18FE1264Status;

#define EEPBS1          		   	    0x18FE1264
#define EEPBS1_STATUS       		    CANMsg18FE1264Status

#define EPB_State			              CANMsg18FE1264.Sig.b00_01    //电子驻车状态

#define AutoHold			              CANMsg18FE1264.Sig.b02_05    //临时停车工作状态指示灯
#define EPB_Lamp_State	            CANMsg18FE1264.Sig.b10_17    //EPB故障指示灯

#define Child_Loca_State	          CANMsg18FE1264.Sig.b20_21    //童锁状态

#define LowPress_ReleaseLimit	      CANMsg18FE1264.Sig.b22_23    //低压释放限制状态


static const uint8_t  CANMsg18FE1264Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FE1264Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FE1264Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称?EEPB_DM1  
ID:0x18FECA64
报文?
信号：

|- Amber_Warning_Lamp_St        EPB故障灯
 
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
    uint8_t   b00_01 	:  2;   //                             
    uint8_t   b02_03 	:  2;   //  Amber_Warning_Lamp_St      
    uint8_t   b04_07 	:  4;   //                             
    uint8_t   b10_17 	:  8;   //                             
    uint8_t   b20_27 	:  8;   //                             
    uint8_t   b30_37 	:  8;   // 	                           
    uint8_t   b40_47 	:  8;   // 	                           
    uint8_t   b50_57 	:  8;   //                             
    uint8_t   b60_67 	:  8;   //  	                         
    uint8_t   b70_77  :  8;   //                             
	} Sig; 
} CANMsg18FECA64Union;

extern volatile CANMsg18FECA64Union CANMsg18FECA64;
extern volatile uint8_t             CANMsg18FECA64Status;

#define EEPB_DM1          		   	  0x18FECA64
#define EEPB_DM1_STATUS       		  CANMsg18FECA64Status

#define Amber_Warning_Lamp_St			  CANMsg18FECA64.Sig.b02_03    // EPB故障灯


static const uint8_t  CANMsg18FECA64Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FECA64Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FECA64Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称?EEPS_Status 
ID:0x18FF0113
报文?
信号：

|-   EPS_Status         EEPS状态
 
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_00 	:  1;   // 
		uint8_t   b01_02 	:  2;   //   
		uint8_t   b03_07 	:  5;   //  
		uint8_t   b10_17 	:  8;   //    
		uint8_t   b20_20 	:  1;   //  
		uint8_t   b21_22 	:  2;   // EPS_Status
		uint8_t   b23_27 	:  5;   // 
		uint8_t   b30_37 	:  8;   // 	
		uint8_t   b40_47 	:  8;   // 	 
		uint8_t   b50_57 	:  8;   //   
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FF0113Union;

extern volatile CANMsg18FF0113Union CANMsg18FF0113;
extern volatile uint8_t             CANMsg18FF0113Status;

#define EPS_Status          		   	0x18FF0113
#define EPS_Status_STATUS       		CANMsg18FF0113Status

#define EPS_Status_signal			      CANMsg18FF0113.Sig.b01_02    //EEPS状态


static const uint8_t  CANMsg18FF0113Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FF0113Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FF0113Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称：EGSM_1  
ID:0x1802BFD0
报文?
信号：

|- ActualGearPosition        实际档位
|- EGSMFaultSt               EGSM错误状态
 
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_03 	:  4;   // ActualGearPosition
		uint8_t   b04_04 	:  1;   //   
		uint8_t   b05_05 	:  1;   // EGSMFaultSt
		uint8_t   b06_07 	:  2;   // 
		
		uint8_t   b10_17 	:  8;   //    
		uint8_t   b20_27 	:  8;   //  
		uint8_t   b30_37 	:  8;   // 		
		uint8_t   b40_47 	:  8;   // 
			 
		uint8_t   b50_51 	:  2;   // EGSM_ShiftGearTip
		uint8_t   b52_53 	:  2;   //
		uint8_t   b54_57 	:  4;   // EGSM_NearShiftGearTip
		  
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg1802BFD0Union;

extern volatile CANMsg1802BFD0Union CANMsg1802BFD0;
extern volatile uint8_t             CANMsg1802BFD0Status;

#define EGSM_1          		   	    0x1802BFD0
#define EGSM_1_STATUS       		    CANMsg1802BFD0Status

#define ActualGearPosition	        CANMsg1802BFD0.Sig.b00_03    // 实际档位
#define EGSMFaultSt			            CANMsg1802BFD0.Sig.b05_05    // EGSM错误状态

#define EGSM_ShiftGearTip			      CANMsg1802BFD0.Sig.b50_51    // 换挡提示
#define EGSM_NearShiftGearTip			  CANMsg1802BFD0.Sig.b54_57    // 邻近档位提示

static const uint8_t  CANMsg1802BFD0Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg1802BFD0Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg1802BFD0Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/******************************************************************************
ID名称?AAMB  
ID:0x18FEF500
报文
信号：

|- 
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   //   
		uint8_t   b10_17 	:  8;   //    
		uint8_t   b20_27 	:  8;   //  
		uint8_t   b30_37 	:  8;   // Ambient_Air_TemperatureL 	
		uint8_t   b40_47 	:  8;   // Ambient_Air_TemperatureH 	 
		uint8_t   b50_57 	:  8;   //   
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FEF500Union;

extern volatile CANMsg18FEF500Union CANMsg18FEF500;
extern volatile uint8_t             CANMsg18FEF500Status;

#define AMB          		   	        0x18FEF500
#define AMB_STATUS       		        CANMsg18FEF500Status

#define Ambient_Air_TemperatureL 	  CANMsg18FEF500.Sig.b30_37    //
#define Ambient_Air_TemperatureH 	  CANMsg18FEF500.Sig.b40_47    //

static const uint8_t  CANMsg18FEF500Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEF500Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEF500Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
/******************************************************************************
ID名称?AGPS_SYSTime  
ID:0x18FEE6EE
报文
信号：

|- 
 ******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   //   
		uint8_t   b10_17 	:  8;   // GPS_SYSTime_Min    
		uint8_t   b20_27 	:  8;   // GPS_SYSTime_Hour  
		uint8_t   b30_37 	:  8;   //	
		uint8_t   b40_47 	:  8;   //	 
		uint8_t   b50_57 	:  8;   //   
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg18FEE6EEUnion;

extern volatile CANMsg18FEE6EEUnion CANMsg18FEE6EE;
extern volatile uint8_t             CANMsg18FEE6EEStatus;

#define GPS_SYSTime          		   	0x18FEE6EE
#define GPS_SYSTime_STATUS       		CANMsg18FEE6EEStatus

#define GPS_SYSTime_Min 	          CANMsg18FEE6EE.Sig.b10_17    //
#define GPS_SYSTime_Hour 	          CANMsg18FEE6EE.Sig.b20_27    //

static const uint8_t  CANMsg18FEE6EEInit[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEE6EETimeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEE6EEMask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
/******************************************************************************
ID名称：T-BOX  
ID:0x1CFFBE18
报文
信号：

|- 
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   //   
		uint8_t   b10_17 	:  8;   //   
		uint8_t   b20_23 	:  4;   // RMS_Fault 
		uint8_t   b24_27 	:  4;   //

		uint8_t   b30_37 	:  8;   //	
		uint8_t   b40_47 	:  8;   //	 
		uint8_t   b50_57 	:  8;   //   
		uint8_t   b60_67 	:  8;   //  	
		uint8_t   b70_77  :  8;   //  
	} Sig; 
} CANMsg1CFFBE18Union;

extern volatile CANMsg1CFFBE18Union CANMsg1CFFBE18;
extern volatile uint8_t             CANMsg1CFFBE18Status;

#define T_BOX_RVM          		   	  0x1CFFBE18
#define T_BOX_RVM_STATUS       		  CANMsg1CFFBE18Status

#define RMS_Fault 	                CANMsg1CFFBE18.Sig.b20_23    //

static const uint8_t  CANMsg1CFFBE18Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg1CFFBE18Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg1CFFBE18Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
/******************************************************************************
EMS_55E  
ID:0x18FED800
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_01 	:  2;   // EMS_CNGLampStatus 
		uint8_t   b02_07 	:  6;   // 
		uint8_t   b08_15 	:  8;   //   
		uint8_t   b16_23 	:  8;   // 
		uint8_t   b24_31 	:  8;   // 

		uint8_t   b32_39 	:  8;   //	
		uint8_t   b40_47 	:  8;   //	 
		uint8_t   b48_55 	:  8;   //   
		uint8_t   b56_63 	:  8;   //  	
	} Sig; 
} CANMsg18FED800Union;

extern volatile CANMsg18FED800Union CANMsg18FED800;
extern volatile uint8_t             CANMsg18FED800Status;

#define EMS_55E          		   	    0x18FED800
#define EMS_55E_STATUS       		    CANMsg18FED800Status

#define EMS_CNGLampStatus 	        (CANMsg18FED800.Sig.b00_01)

static const uint8_t  CANMsg18FED800Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FED800Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FED800Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
/******************************************************************************
EMS_35D  
ID:0x18FFC800
 ******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_05 	:  6;   // EMS_GasLeakIndicator
		uint8_t   b06_07 	:  2;   // 
		uint8_t   b08_15 	:  8;   //   
		uint8_t   b16_23 	:  8;   // 
		uint8_t   b24_31 	:  8;   // 

		uint8_t   b32_39 	:  8;   //	
		uint8_t   b40_47 	:  8;   //	 
		uint8_t   b48_55 	:  8;   //   
		uint8_t   b56_63 	:  8;   //  	
	} Sig; 
} CANMsg18FFC800Union;

extern volatile CANMsg18FFC800Union CANMsg18FFC800;
extern volatile uint8_t             CANMsg18FFC800Status;

#define EMS_35D          		   	    0x18FFC800
#define EMS_35D_STATUS       		    CANMsg18FFC800Status

#define EMS_GasLeakIndicator      	(CANMsg18FFC800.Sig.b00_05)

static const uint8_t  CANMsg18FFC800Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FFC800Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FFC800Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
/******************************************************************************
EMS_51C  
ID:0x18FEC600
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   //   
		uint8_t   b08_15 	:  8;   //   
		uint8_t   b16_23 	:  8;   // EMS_CylinderPressure_L
		uint8_t   b24_31 	:  8;   // EMS_CylinderPressure_H

		uint8_t   b32_39 	:  8;   //	
		uint8_t   b40_47 	:  8;   //	 
		uint8_t   b48_55 	:  8;   //   
		uint8_t   b56_63 	:  8;   //  	
	} Sig; 
} CANMsg18FEC600Union;

extern volatile CANMsg18FEC600Union CANMsg18FEC600;
extern volatile uint8_t             CANMsg18FEC600Status;

#define EMS_51C          		   	    0x18FEC600
#define EMS_51C_STATUS       		    CANMsg18FEC600Status

#define EMS_CylinderPressure 	      ((uint16_t)CANMsg18FEC600.Sig.b24_31 << 8 | CANMsg18FEC600.Sig.b16_23)

static const uint8_t  CANMsg18FEC600Init[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEC600Timeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FEC600Mask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
/******************************************************************************
LLM_EB4E  
ID:0x18FFEB4E
******************************************************************************/
typedef union
{
	uint8_t Msg[8];
	struct
	{		
		uint8_t   b00_07 	:  8;   //   
		uint8_t   b08_15 	:  8;   //   
		uint8_t   b16_23 	:  8;   // 
		uint8_t   b24_31 	:  8;   // 

		uint8_t   b32_39 	:  8;   //	
		uint8_t   b40_47 	:  8;   //LLM_LiquidLever_PCT	 
		uint8_t   b48_55 	:  8;   //   
		uint8_t   b56_63 	:  8;   //  	
	} Sig; 
} CANMsg18FFEB4EUnion;

extern volatile CANMsg18FFEB4EUnion CANMsg18FFEB4E;
extern volatile uint8_t             CANMsg18FFEB4EStatus;

#define LLM_EB4E          		      0x18FFEB4E
#define LLM_EB4E_STATUS       	    CANMsg18FFEB4EStatus

#define LLM_LiquidLever_PCT 	      CANMsg18FFEB4E.Sig.b40_47

static const uint8_t  CANMsg18FFEB4EInit[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FFEB4ETimeout[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const uint8_t  CANMsg18FFEB4EMask[8]    = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
/*****************************************************************************************************************************************************************************
报文属性预定义
*****************************************************************************************************************************************************************************/ 

/***  属性表结构  ***/ 
typedef struct
{
	uint32_t  ID;                 //报文ID
	volatile uint8_t   *pMsg;     //报文名称(报文存储地址)
	uint8_t   DLCMax;             //报文最大允许报文长度
	
	uint8_t   DLCMin;             //报文最小允许报文长度
	
	uint8_t   Dir;                //报文方向(收/发)
	uint8_t   Type;               //报文类型(周期/事件)
	uint32_t  Cycle;              //报文超时周期(收),报文发送周期(发)
	uint16_t  Offset;             //报文时间偏移量
	
	volatile uint8_t   *pStatus;  //报文状态
	
	const    uint8_t   *pInit;    //报文初始化值
	
	const    uint8_t   *pTimeOut; //报文掉线值
	
	const    uint8_t   *pMask;    //报文屏蔽位(决定某一位在掉线时是否更新为掉线值)
} CANMsgAttrStruct;

/***  报文方向预定义  ***/ 
#define   CAN_MSG_Rx                        0x00
#define   CAN_MSG_Tx                        (!CAN_MSG_Rx)

/***  报文类型预定义  ***/ 
#define   CAN_MSG_CYCLE                     0x00
#define   CAN_MSG_EVENT                     0x01

/***  报文状态预定义  ***/
/*  ====================================================================================
	Bit 7       |    Bit 6 ~ Bit 2   |        Bit 1       |        Bit 0       
	-----------------------------------------------------------------------------------
	CAN_TX_EN     |        Rsvd        |     CAN_UPDATE     |    CAN_MSG_LOST
	|                    |                    |      报文丢失
	发送使能      |        保留        |    报文更新标志    |   (报文接收超时)
	===================================================================================  */
#define   CAN_TX_EN                         0x80
#define   CAN_UPDATE                        0x02
#define   CAN_MSG_LOST                      0x01

/***  其他 ***/
#ifndef   NULL
#define   NULL                              0x00
#endif

/*****************************************************************************************************************************************************************************
  报文属性列表
 
*****************************************************************************************************************************************************************************/ 
static const CANMsgAttrStruct CANMsgAttrTable[] = 
{
	/*============================================================================================================================================================================
	报文名称           |              | 最大 | 最小 |            |              | 周期 | 偏移 |                  |                |                  |  报文掉线默
	  (ID)             |   报文缓存   | 长度 | 长度 |    方向    |     类型     | (ms) | (ms) |     报文状态     |  报文初始化值  |  报文掉线默认值  |  认值屏蔽位
	----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
  //网络管理报文必须放在这个位置，与诊断的28服务关联
  { NWM_BCM,	  	     CANMsg18FFA021.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FFA021Status,	  CANMsg18FFA021Init,    CANMsg18FFA021Timeout,   CANMsg18FFA021Mask,},
  
  { BCM_ExternalLight, CANMsg10FF1021.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 500,	    0,   &CANMsg10FF1021Status,	  CANMsg10FF1021Init,    CANMsg10FF1021Timeout,   CANMsg10FF1021Mask,},
  { BCM_StatusNBC,	   CANMsg10FF7521.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg10FF7521Status,	  CANMsg10FF7521Init,    CANMsg10FF7521Timeout,   CANMsg10FF7521Mask,},
  { BCM_Msg2,	  	     CANMsg10FF1017.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg10FF1017Status,	  CANMsg10FF1017Init,    CANMsg10FF1017Timeout,   CANMsg10FF1017Mask,},
  { BCM_TPMS,	  	     CANMsg18FEF433.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FEF433Status,	  CANMsg18FEF433Init,    CANMsg18FEF433Timeout,   CANMsg18FEF433Mask,},
  { BCM_PEPS_MSG1,	   CANMsg08FF00DD.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg08FF00DDStatus,	  CANMsg08FF00DDInit,    CANMsg08FF00DDTimeout,   CANMsg08FF00DDMask,},
  
   //网络管理报文必须放在这个位置，与诊断的28服务关联
  { NWM_ICM,	     	   CANMsg18FEF717.Msg,  8,	  8,  CAN_MSG_Tx,  CAN_MSG_CYCLE,	 1000,	  1,   &CANMsg18FEF717Status,	  CANMsg18FEF717Init,    CANMsg18FEF717Timeout,   CANMsg18FEF717Mask,},
  { TCO1,	  	 	       CANMsg18FE6CEE.Msg,  8,	  8,  CAN_MSG_Tx,  CAN_MSG_CYCLE,	 50,	    3,   &CANMsg18FE6CEEStatus,	  CANMsg18FE6CEEInit,    CANMsg18FE6CEETimeout,   CANMsg18FE6CEEMask,},
  { VDHR,	  	 	       CANMsg18FEC117.Msg,  8,	  8,  CAN_MSG_Tx,  CAN_MSG_CYCLE,	 1000,   11,   &CANMsg18FEC117Status,	  CANMsg18FEC117Init,    CANMsg18FEC117Timeout,   CANMsg18FEC117Mask,},
  { AIR1,	  		       CANMsg18FEAE17.Msg,  8,	  8,  CAN_MSG_Tx,  CAN_MSG_CYCLE,	 1000,   13,   &CANMsg18FEAE17Status,	  CANMsg18FEAE17Init,    CANMsg18FEAE17Timeout,   CANMsg18FEAE17Mask,},
  { ETCS,	  	     	   CANMsg18FEC317.Msg,  8,	  8,  CAN_MSG_Tx,  CAN_MSG_CYCLE,	 100,	    7,   &CANMsg18FEC317Status,	  CANMsg18FEC317Init,    CANMsg18FEC317Timeout,   CANMsg18FEC317Mask,},
  { ICM_1,	  	   	   CANMsg18FE8E17.Msg,  8,	  8,  CAN_MSG_Tx,  CAN_MSG_CYCLE,	 1000,   17,   &CANMsg18FE8E17Status,	  CANMsg18FE8E17Init,    CANMsg18FE8E17Timeout,   CANMsg18FE8E17Mask,},
  { ICM_2,	  	   	   CANMsg18FEF117.Msg,  8,	  8,  CAN_MSG_Tx,  CAN_MSG_CYCLE,	 100,	    3,   &CANMsg18FEF117Status,	  CANMsg18FEF117Init,    CANMsg18FEF117Timeout,   CANMsg18FEF117Mask,},
  //{ ICM_3,	  	   	   CANMsg18FF0A17.Msg,  8,	  8,  CAN_MSG_Tx,  CAN_MSG_CYCLE,	 100,	   11,   &CANMsg18FF0A17Status,	  CANMsg18FF0A17Init,    CANMsg18FF0A17Timeout,   CANMsg18FF0A17Mask,},
  { ICM_4,	  	   	   CANMsg18FEFC17.Msg,  8,	  8,  CAN_MSG_Tx,  CAN_MSG_CYCLE,	 1000,    9,   &CANMsg18FEFC17Status,	  CANMsg18FEFC17Init,    CANMsg18FEFC17Timeout,   CANMsg18FEFC17Mask,},

  { NWM_TBOX,	  	     CANMsg18EFCD27.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18EFCD27Status,	  CANMsg18EFCD27Init,    CANMsg18EFCD27Timeout,   CANMsg18EFCD27Mask,},
  { ADAS_1,	  	       CANMsg10F007E8.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg10F007E8Status,	  CANMsg10F007E8Init,    CANMsg10F007E8Timeout,   CANMsg10F007E8Mask,},
  { ADAS_2,	  	       CANMsg18FE5BE8.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg18FE5BE8Status,	  CANMsg18FE5BE8Init,    CANMsg18FE5BE8Timeout,   CANMsg18FE5BE8Mask,},
  { EEC1,	  	         CANMsg0CF00400.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 100,	    0,   &CANMsg0CF00400Status,	  CANMsg0CF00400Init,    CANMsg0CF00400Timeout,   CANMsg0CF00400Mask,},
  { ET1,	  	         CANMsg18FEEE00.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FEEE00Status,	  CANMsg18FEEE00Init,    CANMsg18FEEE00Timeout,   CANMsg18FEEE00Mask,},
  { EFLP1,	  	       CANMsg18FEEF00.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 5000,	  0,   &CANMsg18FEEF00Status,	  CANMsg18FEEF00Init,    CANMsg18FEEF00Timeout,   CANMsg18FEEF00Mask,},
  { AT1T1L,	  	       CANMsg18FE5600.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FE5600Status,	  CANMsg18FE5600Init,    CANMsg18FE5600Timeout,   CANMsg18FE5600Mask,},
  { SHUTDN,	  	       CANMsg18FEE400.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FEE400Status,	  CANMsg18FEE400Init,    CANMsg18FEE400Timeout,   CANMsg18FEE400Mask,},
  { WFI_DA,	  	       CANMsg18FF7400.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FF7400Status,	  CANMsg18FF7400Init,    CANMsg18FF7400Timeout,   CANMsg18FF7400Mask,},
  { WFI,	  	         CANMsg18FEFF00.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 30000,	  0,   &CANMsg18FEFF00Status,	  CANMsg18FEFF00Init,    CANMsg18FEFF00Timeout,   CANMsg18FEFF00Mask,},

  { MFD1,	  	         CANMsg18FF0800.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg18FF0800Status,	  CANMsg18FF0800Init,    CANMsg18FF0800Timeout,   CANMsg18FF0800Mask,},
  { DPFC1,	  	       CANMsg18FD7C00.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FD7C00Status,	  CANMsg18FD7C00Init,    CANMsg18FD7C00Timeout,   CANMsg18FD7C00Mask,},
  { DPFC1_DA,	  	     CANMsg18E0FF00.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18E0FF00Status,	  CANMsg18E0FF00Init,    CANMsg18E0FF00Timeout,   CANMsg18E0FF00Mask,},
  { ERC1_WEI,	  	     CANMsg18F0000F.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg18F0000FStatus,	  CANMsg18F0000FInit,    CANMsg18F0000FTimeout,   CANMsg18F0000FMask,},
  { ERC1_YU,	  	     CANMsg18FD070F.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FD070FStatus,	  CANMsg18FD070FInit,    CANMsg18FD070FTimeout,   CANMsg18FD070FMask,},
  { ERC1_EXR,	  	     CANMsg18F00029.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg18F00029Status,	  CANMsg18F00029Init,    CANMsg18F00029Timeout,   CANMsg18F00029Mask,},
  { DLCC1,	  	 	     CANMsg18FD0700.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FD0700Status,	  CANMsg18FD0700Init,    CANMsg18FD0700Timeout,   CANMsg18FD0700Mask,},
  { EIMI,	  	  	     CANMsg18FB8500.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FB8500Status,	  CANMsg18FB8500Init,    CANMsg18FB8500Timeout,   CANMsg18FB8500Mask,},
  { LFC,	  	  	     CANMsg18FEE900.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg18FEE900Status,	  CANMsg18FEE900Init,    CANMsg18FEE900Timeout,   CANMsg18FEE900Mask,},
  { LFE,	  	 	       CANMsg18FEF200.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg18FEF200Status,	  CANMsg18FEF200Init,    CANMsg18FEF200Timeout,   CANMsg18FEF200Mask,},
  { DM1,	  	 	       CANMsg18FECA00.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FECA00Status,	  CANMsg18FECA00Init,    CANMsg18FECA00Timeout,   CANMsg18FECA00Mask,},
  { TCU_ICM_Display1,	 CANMsg1801D003.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 1000,	  0,   &CANMsg1801D003Status,	  CANMsg1801D003Init,    CANMsg1801D003Timeout,   CANMsg1801D003Mask,},

  { CCVS,	  	 	       CANMsg18FEF100.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg18FEF100Status,	  CANMsg18FEF100Init,    CANMsg18FEF100Timeout,   CANMsg18FEF100Mask,},
  { EBC1,	  	  	     CANMsg18F0010B.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg18F0010BStatus,	  CANMsg18F0010BInit,    CANMsg18F0010BTimeout,   CANMsg18F0010BMask,},
  { EBC2,	  	  	     CANMsg18FEBF0B.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg18FEBF0BStatus,	  CANMsg18FEBF0BInit,    CANMsg18FEBF0BTimeout,   CANMsg18FEBF0BMask,},
  { EBC3,	  	  	     CANMsg18FE4F0B.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg18FE4F0BStatus,	  CANMsg18FE4F0BInit,    CANMsg18FE4F0BTimeout,   CANMsg18FE4F0BMask,},
  { AEBS1,	  	  	   CANMsg0CF02F2A.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 500,     0,   &CANMsg0CF02F2AStatus,	  CANMsg0CF02F2AInit,    CANMsg0CF02F2ATimeout,   CANMsg0CF02F2AMask,},
  { EEPBS1,	  	  	   CANMsg18FE1264.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 1000,	  0,   &CANMsg18FE1264Status,	  CANMsg18FE1264Init,    CANMsg18FE1264Timeout,   CANMsg18FE1264Mask,},
  { EPS_Status,	  	   CANMsg18FF0113.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 1000,	  0,   &CANMsg18FF0113Status,	  CANMsg18FF0113Init,    CANMsg18FF0113Timeout,   CANMsg18FF0113Mask,},
  { EGSM_1,	  	  	   CANMsg1802BFD0.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 2000,	  0,   &CANMsg1802BFD0Status,	  CANMsg1802BFD0Init,    CANMsg1802BFD0Timeout,   CANMsg1802BFD0Mask,},
  { AMB,	  	  	     CANMsg18FEF500.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FEF500Status,	  CANMsg18FEF500Init,    CANMsg18FEF500Timeout,   CANMsg18FEF500Mask,},
  { GPS_SYSTime,	  	 CANMsg18FEE6EE.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 3000,	  0,   &CANMsg18FEE6EEStatus,	  CANMsg18FEE6EEInit,    CANMsg18FEE6EETimeout,   CANMsg18FEE6EEMask,},
  { T_BOX_RVM,	  	   CANMsg1CFFBE18.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg1CFFBE18Status,	  CANMsg1CFFBE18Init,    CANMsg1CFFBE18Timeout,   CANMsg1CFFBE18Mask,},
  { EMS_55E,	  	  	 CANMsg18FED800.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 10000,	  0,   &CANMsg18FED800Status,	  CANMsg18FED800Init,    CANMsg18FED800Timeout,   CANMsg18FED800Mask,},
  { EMS_35D,	  	  	 CANMsg18FFC800.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 1000,	  0,   &CANMsg18FFC800Status,	  CANMsg18FFC800Init,    CANMsg18FFC800Timeout,   CANMsg18FFC800Mask,},
  { EMS_51C,	  	  	 CANMsg18FEC600.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 5000,	  0,   &CANMsg18FEC600Status,	  CANMsg18FEC600Init,    CANMsg18FEC600Timeout,   CANMsg18FEC600Mask,},
  { LLM_EB4E,	  	  	 CANMsg18FFEB4E.Msg,  8,	  8,  CAN_MSG_Rx,  CAN_MSG_CYCLE,	 5000,	  0,   &CANMsg18FFEB4EStatus,	  CANMsg18FFEB4EInit,    CANMsg18FFEB4ETimeout,   CANMsg18FFEB4EMask,},
	/*==========================================================================================================================================================================*/
};
#define   CAN_TX_MSG_NUM                    8
#define   CAN_RX_MSG_NUM                    43

#endif
