/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.opentype;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.core.PostScriptTable;
import com.google.typography.font.sfntly.table.opentype.component.GlyphGroup;
import com.google.typography.font.sfntly.table.opentype.component.Rule;
import com.google.typography.font.sfntly.table.opentype.testing.FontLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.junit.Test;

public class RuleTests {
    private static final String FONTS_DIR = "/usr/local/google/home/cibu/sfntly/fonts";
    private static final String WORDS_DIR = "/usr/local/google/home/cibu/sfntly/adv_layout/data/testdata/wiki_words";
    private static final String HB_CLOSURE_DIR = "/usr/local/google/home/cibu/sfntly/adv_layout/data/testdata/wiki_words_hb_closure";
    private static final int TEST_COUNT = 4000;
    private static final String DEBUG_SPECIFIC_FONT = "";
    private static final Map<String, List<String>> LANG_WORDS_MAP = RuleTests.langWordsMap();

    @Test
    public void allFonts() throws IOException {
        List<File> fontFiles = FontLoader.getFontFiles(FONTS_DIR);
        for (File fontFile : fontFiles) {
            Font font = FontLoader.getFont(fontFile);
            String name = fontFile.getAbsolutePath();
            if (DEBUG_SPECIFIC_FONT.length() > 0) {
                if (!name.contains(DEBUG_SPECIFIC_FONT)) continue;
                Rule.dumpLookups(font);
            }
            System.out.println(name);
            Map<Integer, Set<Rule>> glyphRulesMap = Rule.glyphRulesMap(font);
            if (glyphRulesMap == null) {
                System.err.println("No GSUB");
                continue;
            }
            CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
            String osFontPath = name.substring(name.lastIndexOf(47, name.lastIndexOf(47) - 1) + 1);
            File[] hbOutFiles = new File("/usr/local/google/home/cibu/sfntly/adv_layout/data/testdata/wiki_words_hb_closure/" + osFontPath).listFiles();
            if (hbOutFiles == null) {
                System.err.println("No test data");
                continue;
            }
            File[] fileArray = hbOutFiles;
            int n = hbOutFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File hbOutFile = fileArray[n2];
                String lang = hbOutFile.getName();
                if (!lang.startsWith(".")) {
                    List<GlyphGroup> hbClosure = RuleTests.hbClosure(hbOutFile);
                    RuleTests.assertClosure(cmapTable, glyphRulesMap, LANG_WORDS_MAP.get(lang), hbClosure);
                }
                ++n2;
            }
        }
    }

    @Test
    public void aFont() throws IOException {
        Font font = FontLoader.getFont(new File("/usr/local/google/home/cibu/sfntly/fonts/noto/NotoSansBengali-Regular.ttf"));
        CMapTable cmap = (CMapTable)font.getTable(Tag.cmap);
        PostScriptTable post = (PostScriptTable)font.getTable(Tag.post);
        Map<Integer, Set<Rule>> glyphRulesMap = Rule.glyphRulesMap(font);
        GlyphGroup glyphGroup = Rule.glyphGroupForText("\u5533\ue215\ue752\u5533\u73ed\ue745", cmap);
        GlyphGroup closure = Rule.closure(glyphRulesMap, glyphGroup);
        Rule.dumpLookups(font);
        System.err.println(closure);
    }

    private static void assertClosure(CMapTable cmap, Map<Integer, Set<Rule>> glyphRulesMap, List<String> words, List<GlyphGroup> expecteds) {
        int i = 0;
        while (i < expecteds.size() && i < 4000) {
            String word = words.get(i);
            GlyphGroup expected = expecteds.get(i);
            GlyphGroup glyphGroup = Rule.glyphGroupForText(word, cmap);
            GlyphGroup closure = Rule.closure(glyphRulesMap, glyphGroup);
            if (expected.size() == 0 && closure.size() > 0) {
                System.err.println("Skipped: " + word);
            } else if (!expected.equals(closure)) {
                System.err.printf("'%s' failed:\n  %s HB\n  %s Snftly\n\n", word, expected, closure);
            }
            ++i;
        }
    }

    private static Map<String, List<String>> langWordsMap() {
        HashMap<String, List<String>> langWordsMap = new HashMap<String, List<String>>();
        File[] fileArray = new File(WORDS_DIR).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File wordsFile = fileArray[n2];
            String lang = wordsFile.getName();
            if (!lang.startsWith(".")) {
                langWordsMap.put(lang, RuleTests.linesFromFile(wordsFile));
            }
            ++n2;
        }
        return langWordsMap;
    }

    private static List<GlyphGroup> hbClosure(File file) {
        ArrayList<GlyphGroup> glyphGroups = new ArrayList<GlyphGroup>();
        for (String line : RuleTests.linesFromFile(file)) {
            GlyphGroup glyphGroup = new GlyphGroup();
            if (line.length() > 0) {
                String[] stringArray = line.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String intStr = stringArray[n2];
                    glyphGroup.add(Integer.parseInt(intStr));
                    ++n2;
                }
            }
            glyphGroups.add(glyphGroup);
        }
        return glyphGroups;
    }

    /*
     * Unable to fully structure code
     */
    private static List<String> linesFromFile(File file) {
        lines = new ArrayList<String>();
        try {
            scanner = new Scanner(file);
            if (true) ** GOTO lbl11
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found: " + file);
            return lines;
        }
        do {
            lines.add(scanner.nextLine());
lbl11:
            // 2 sources

        } while (scanner.hasNextLine() && lines.size() < 4000);
        scanner.close();
        return lines;
    }
}

