/******************************************************************************
  Key.h
⺯ͷļ
    ߣ
    V1.0
    ڣ2016.11.21
******************************************************************************/

#ifndef _KEY_H_
#define _KEY_H_

#include "Line_In.h"
/******************************************************************************
б
******************************************************************************/

/*** Խṹ ***/
typedef struct
{
  volatile  uint8_t   *pInputSignal;    //ź
  uint8_t   HoldDetMode;      //ģʽ
  uint8_t   DoubleDetEn;      //(˫)ʹ
} KeyAttrStruct;

/*** ģʽ ***/
#define   KEY_HOLD_DISABLE                  0x00      //ֳ֧
#define   KEY_HOLD_ONLY                     0x01      //ְ֧ס
#define   KEY_STUCK_ONLY                    0x02      //ֿ֧ס
#define   KEY_HOLD_STUCK                    0x03      //ְ֧ס/ס
#define   KEY_HOLD_LONG                     0x04      //ְ֧ס/
#define   KEY_HOLD_LONG_STUCK               0x05      //ְ֧ס//ס

/*** IDб ***/
#define   KEY_LEFT          0x00
#define   KEY_RIGHT         0x01
#define   KEY_ENTER         0x02

/*** б ***/
static const KeyAttrStruct KeyAttrTable[] =
{
  /*=====================================================================
  ע⣺1.Ӧ尴IDΪðλڱбе
        2.ֻһֳ״̬,ӦʹHoldDetEnLongDetEn
  -----------------------------------------------------------------------
      ID  |       ź       |    ģʽ    | ʹ
  ---------------------------------------------------------------------*/
  {/* 00 */  &KEY_LEFT_SIGNAL,       KEY_HOLD_LONG,             0, },
  {/* 01 */  &KEY_RIGHT_SIGNAL,       KEY_HOLD_LONG,             0, },
  {/* 02 */  &KEY_ENTER_SIGNAL,       KEY_HOLD_LONG,             0, },
  {/* 03 */  NULL,       KEY_HOLD_ONLY,             0, },
  /*===================================================================*/
};

/******************************************************************************

******************************************************************************/
#define   KEY_DOUBLE_INTERVAL               500       //(˫)
#define   KEY_HOLD_THRESHOLD                800       //סжʱֵ
#define   KEY_LONG_THRESHOLD                2000      //жʱֵ
#define   KEY_STUCK_THRESHOLD               15000     //סжʱֵ
#define   KEY_TOTAL_NUMBER                  (sizeof(KeyAttrTable) / sizeof(KeyAttrStruct))

/******************************************************************************
״̬ö
******************************************************************************/
typedef enum
{
  KEY_IDLE = 0,   //,δ
  KEY_PRESS,      //̰
  KEY_HOLD,       //ס(KEY_LONGʱ)
  KEY_LONG,       //
  KEY_STUCK,      //ס
  KEY_DOUBLE,     //(˫)
} KeyStatusEnum;

/******************************************************************************
״̬ṹ
******************************************************************************/
typedef struct
{
  uint8_t         UpdateEnable;
  uint16_t        Timer;
  uint16_t        IdleTimer;
  KeyStatusEnum   FinalStatus;
  KeyStatusEnum   CurrentStatus;
} KeyDetectStruct;

/******************************************************************************
תṹ
******************************************************************************/
typedef struct
{
    INT8U     Rotary1Old;
    INT8U     RotateState;
     INT8U    Rotary1Old1;
     INT8U     Rotary2Old;
    INT8U    RotateValid ; 

} RotateKeyAttrStruct ;

#define               clockwise                1
#define               widdershins              0
#define               OldDir                   2
#define               keep_local               255

extern RotateKeyAttrStruct KeyMenu ;

/******************************************************************************
Ť״̬ṹ
******************************************************************************/
/*typedef union
{
  uint8_t Byte;
  struct
  {

    uint8_t KEY_LINE_L  : 1;
    uint8_t KEY_LINE_R  : 1;
    uint8_t KEY_NEWKEY  : 2;
    uint8_t KEY_MIDKEY  : 2;
    uint8_t KEY_OLDKEY  : 2;
    uint8_t KEY_LINE_D;
  } KnobSwitch;
} KEY_Union;
*/
/******************************************************************************

******************************************************************************/
void Key_Status_Init(void);
void Key_Status_Detect_Service(void);
void Reset_Key_Status(uint8_t Key);
//void Key_Knob(void);
KeyStatusEnum Key_Get_Status(uint8_t Key);
KeyStatusEnum Key_Get_Current_Status(uint8_t Key);

void RotaryKey_Status_Detect_Service(RotateKeyAttrStruct *KeyMenu) ; 

#endif