/*******************************************************************************
  Motor_Controller.h
ͷļ
    ߣ
    V1.0
    ڣ2017.4.13
******************************************************************************/
#ifndef _MOTOR_CONTROLLER_H_
#define _MOTOR_CONTROLLER_H_

#include "CRG.h"

/******************************************************************************

******************************************************************************/
//#define   MOTOR_CONTROLLER_PERIOD         768       //ΰ
#define   MOTOR_CONTROLLER_PERIOD         1120      //
#define   MOTOR_CONTROLLER_CLOCK          (BUSCLK / MOTOR_CONTROLLER_PERIOD)

/******************************************************************************
ʹ

MOTOR_0: ͨ: Motor Controller Channel 0 & 1
         ˿: M0C0M / M0C0P / M0C1M / M0C1P

MOTOR_1: ͨ: Motor Controller Channel 2 & 3
         ˿: M1C0M / M1C0P / M1C1M / M1C1P

MOTOR_2: ͨ: Motor Controller Channel 4 & 5
         ˿: M2C0M / M2C0P / M2C1M / M2C1P

MOTOR_3: ͨ: Motor Controller Channel 6 & 7
         ˿: M3C0M / M3C0P / M3C1M / M3C1P
******************************************************************************/         
#define   MOTOR_0_ENABLE                    1
#define   MOTOR_1_ENABLE                    1
#define   MOTOR_2_ENABLE                    1
#define   MOTOR_3_ENABLE                    1

/******************************************************************************
Ԥ
******************************************************************************/
#if ((MOTOR_CONTROLLER_PERIOD == 0) || (MOTOR_CONTROLLER_PERIOD > BUSCLK))
  #error  Invalid motor controller period setting
#endif

/******************************************************************************

******************************************************************************/
void Motor_Controller_Init(void);
void Motor_Controller_Shutdown(void);

/******************************************************************************
궨
******************************************************************************/
#define   Motor_Controller_Set_CH0_Duty_Cycle(d)      MCDC0 = d
#define   Motor_Controller_Set_CH1_Duty_Cycle(d)      MCDC1 = d
#define   Motor_Controller_Set_CH2_Duty_Cycle(d)      MCDC2 = d
#define   Motor_Controller_Set_CH3_Duty_Cycle(d)      MCDC3 = d
#define   Motor_Controller_Set_CH4_Duty_Cycle(d)      MCDC4 = d
#define   Motor_Controller_Set_CH5_Duty_Cycle(d)      MCDC5 = d
#define   Motor_Controller_Set_CH6_Duty_Cycle(d)      MCDC6 = d
#define   Motor_Controller_Set_CH7_Duty_Cycle(d)      MCDC7 = d

#endif
