/******************************************************************************
  ADC.c
ADCļ
    ߣ
    V1.0
    ڣ2017.03.25
******************************************************************************/

#include "ADC.h"

/******************************************************************************
ADC_Init
  ܣADCʼ
        ҪԤADC.hжֱʡADCʱƵ
  
ֵ
******************************************************************************/
void ADC_Init(void)
{
  ATDDIEN = 0x0FFF;             //ȫA/D˿ڲΪADCʹ,ҪADC_Channel_Enable

  //ATDCTL0 = 0x0F;               //ʹת,Ҫô˼Ĵ
  ATDCTL1 = ADC_ATDCTL1_VALUE;  //÷ֱ,ʹⲿ
  ATDCTL2 = 0x40;			          //ĳԶCCFn־,ʹڲʱ,ʹⲿ,ʹж
  ATDCTL3 = 0x88;               //Ҷ,ÿֻת1ͨ,ʹFIFOģʽ
  ATDCTL4 = ADC_SMP_VALUE | ADC_PRS_VALUE;
}

/******************************************************************************
ADC_Channel_Enable
  ܣӦADCͨ
        ʼϺ,ͨڹر״̬,Ҫô˺
  Ch ҪADCͨ
ֵ
******************************************************************************/
void ADC_Channel_Enable(uint8_t Ch)
{
  uint16_t ChBit;

  if(Ch >= ADC_MAX_CHANNEL_CNT)
    return;

  ChBit = 1 << Ch;
  ATDDIEN &= ~ChBit;
}

/******************************************************************************
ADC_Start_Conversion
  ܣӦADCͨת
  Ch ҪתADCͨ
ֵ
******************************************************************************/
void ADC_Start_Conversion(uint8_t Ch)
{
  if(Ch < ADC_MAX_CHANNEL_CNT)
    ATDCTL5 = Ch;
}

/******************************************************************************
ADC_Get_Conversion_Status
  ܣȡǰһADCת״̬
  
ֵADC_CONV_COMPLETE      ת
        ADC_CONV_NOT_COMPLETE  תδ
******************************************************************************/
uint8_t ADC_Get_Conversion_Status(void)
{
  if (ATDSTAT0_SCF)
    return ADC_CONV_COMPLETE;
  else
    return ADC_CONV_NOT_COMPLETE;
}

/******************************************************************************
ADC_Get_Conversion_Result
  ܣȡǰһADCתת
  
ֵתֵ
******************************************************************************/
uint16_t ADC_Get_Conversion_Result(void)
{
  return ATDDR0;
}
