/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.opentype;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.opentype.FeatureListTable;
import com.google.typography.font.sfntly.table.opentype.GsubCommonTable;
import com.google.typography.font.sfntly.table.opentype.LookupListTable;
import com.google.typography.font.sfntly.table.opentype.ScriptListTable;
import java.util.concurrent.atomic.AtomicReference;

public class GSubTable
extends Table {
    private final GsubCommonTable gsub;
    private final AtomicReference<ScriptListTable> scriptListTable = new AtomicReference();
    private final AtomicReference<FeatureListTable> featureListTable = new AtomicReference();
    private final AtomicReference<LookupListTable> lookupListTable = new AtomicReference();

    private GSubTable(Header header, ReadableFontData data, boolean dataIsCanonical) {
        super(header, data);
        this.gsub = new GsubCommonTable(data, dataIsCanonical);
    }

    public ScriptListTable scriptList() {
        if (this.scriptListTable.get() == null) {
            this.scriptListTable.compareAndSet(null, this.gsub.createScriptList());
        }
        return this.scriptListTable.get();
    }

    public FeatureListTable featureList() {
        if (this.featureListTable.get() == null) {
            this.featureListTable.compareAndSet(null, this.gsub.createFeatureList());
        }
        return this.featureListTable.get();
    }

    public LookupListTable lookupList() {
        if (this.lookupListTable.get() == null) {
            this.lookupListTable.compareAndSet(null, this.gsub.createLookupList());
        }
        return this.lookupListTable.get();
    }

    /* synthetic */ GSubTable(Header header, ReadableFontData readableFontData, boolean bl, GSubTable gSubTable) {
        this(header, readableFontData, bl);
    }

    public static class Builder
    extends Table.Builder<GSubTable> {
        private final GsubCommonTable.Builder gsub;

        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, (ReadableFontData)data);
        }

        private Builder(Header header, ReadableFontData data) {
            super(header, data);
            this.gsub = new GsubCommonTable.Builder(data, false);
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            return this.gsub.subSerialize(newData);
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.gsub.subReadyToSerialize();
        }

        @Override
        protected int subDataSizeToSerialize() {
            return 0;
        }

        @Override
        protected void subDataSet() {
        }

        @Override
        protected GSubTable subBuildTable(ReadableFontData data) {
            return new GSubTable(this.header(), data, false, null);
        }
    }
}

