/*************************************/
#include "TSzhen.h"

uint16_t     CSB_JDMHLBUF_LS;
uint16_t     zs_JDMHLBUF_LS;
uint16_t     YOUB_FBJD_MHL;
uint16_t		 SUIB_FBJD_MHL;

uint16_t     CSB_SPDJ;	  					      
uint16_t     ZSB_SPDJ;					        	
uint16_t	   KP_CS_N;		                  
KPULSTRUCT   KPuls_cs;   

uint16_t     b_CSB_JD[cnCSB_KJDTBLen];    
uint16_t   	 b_ZSB_JD[cnZSB_KJDTBLen];  
uint16_t     b_RYB_JD[cnRYB_KJDTBLen];    
uint16_t   	 b_SWB_JD[cnSWB_KJDTBLen];   
       			    
KDVJDSTRUCT  SUIBVJDTB[cnSUIBVJDTBLen];   
KDVJDSTRUCT  YOUBVJDTB[cnYOUBVJDTBLen];   
KDVJDSTRUCT  ZSBFrJDTB[cnZSBFrJDTBLen];  	
KDVJDSTRUCT  CSBFrJDTB[cnCSBFrJDTBLen];  	

//KDVJDSTRUCT  QYB1JDTB[cnCSBFrJDTBLen];
//KDVJDSTRUCT  QYB2JDTB[cnCSBFrJDTBLen];


#pragma INTO_ROM  //ˮ̻    
const uint16_t SBB_X_Y_TB[][2] =
{
  //X,  			Y
  580,		  	0,
  650,   			1 * 100,
  700,   			2 * 100,
  750,   			3 * 100,
  1050,   		4 * 100,
  1100,   		5 * 100,
  1150,   		6 * 100,
  1200,   		7 * 100,
  1300,   		8 * 100,
};

#pragma INTO_ROM //ͱ̻ 

const uint16_t YBB_X_Y_TB[][2] =
{
  //10  20()
  //X,  			Y
  2830,			1 * 20,
  1890,			2 * 20,
  1628,			3 * 20,
  1502,			4 * 20,
  1366,			6 * 20,
  1130,			9 * 20,
  971,			11 * 20,
  863,			14 * 20,
  803,			17 * 20,
  742,			205 * 2,

  713,			22 * 20,
  653,			255 * 2,
  622,			28 * 20,
  567,			325 * 2,
  540,			345 * 2,
  512,			37 * 20,
  484,			385 * 2,
  426,			43 * 20,
  414,			52 * 20,
};

/*****************ģʽ*********************************
д,ת,ˮ,ͱ,KPuls_csFALSH
***********************************************************/
void Write_CZSYBKPILSTO_FLASH(void)
{
  uint16_t m16;
  MYeturnCode = DFLASH_Erase_Sector(DFLASH_FirstAddress);	//1(256ֽ)
  if (MYeturnCode != OK)
    return;
  DFLASHeep_adr = DFLASH_FirstAddress + 2;
  WriteNbyteToDFalsh((INT16U *)CSBFrJDTB, sizeof(CSBFrJDTB));
  WriteNbyteToDFalsh((INT16U *)ZSBFrJDTB, sizeof(ZSBFrJDTB));
  WriteNbyteToDFalsh((INT16U *)SUIBVJDTB, sizeof(SUIBVJDTB));
  WriteNbyteToDFalsh((INT16U *)YOUBVJDTB, sizeof(YOUBVJDTB));
  m16 = 0xA77A;
  MYeturnCode = DFLASH_N_Program(DFLASH_FirstAddress, &m16, 1);   
}
/***********************************************************
ó,תٱĿ̶ֵ(ʼ)
***********************************************************/

void JSCZSBMAXFRPRG(void)
{
  uint8_t i;

  for (i = 2; i < cnCSBFrJDTBLen; i++)
  {
    if (CSBFrJDTB[i].Kdu == 0)
      break;
  }
  for (i = 2; i < cnZSBFrJDTBLen; i++)
  {
    if (ZSBFrJDTB[i].Kdu == 0)
      break;
  }
  for (i = 2; i < cnSUIBVJDTBLen; i++) 
  {
    if (SUIBVJDTB[i].Kdu == 0)
      break;
  }
  for (i = 2; i < cnYOUBVJDTBLen; i++)  
  {
    if (YOUBVJDTB[i].Kdu == 0)
      break;
  }
}
/**********************ģʽ**************************/
void SetModeProc(void)
{
  uint8_t mStatus;
  uint8_t mTYPE;

  CSB_SPDJ = 33 * cnCZSB_BJDJ_WBD;
  ZSB_SPDJ = 33 * cnCZSB_BJDJ_WBD;
  for (;;)
  {
    wdt_reset();                                                 //λŹʱ
    Stepper_Motor_Speed_Control_Service();
    mStatus = RSSRecivJudge();                                   //жϴڽܻǷյȷ
    if (mStatus == 2)
      continue;
    if (mStatus == 1)
    {
      SendRomStrToUART((INT8U *)CommandNCK, sizeof(CommandNCK)); //NCK
      continue;
    }
    /****************ȷݴ************************/
    mTYPE = TX_BUF[3] & 0xF0;
    if ( mTYPE == 0x10 )
    {
      //
      if (TX_BUF[3] == 0x1E)
      {
        //FLASHж,ת,ˮ,ͱ,KPuls_csRAM
        Read_CZSYBKPILSFR_FLASH();
        SendACKToSBEI();        //ACK
      }

      if (TX_BUF[3] == 0x1F)
      {
        //д,ת,ˮ,ͱ,KPuls_csFALSH
        Write_CZSYBKPILSTO_FLASH();
        JSCZSBMAXFRPRG();			  //ó,תٱĿ̶ֵ(ʼ)
        KP_CS_N = KPuls_cs.CS_N;
        SendACKToSBEI();        //ACK
      }
      if (TX_BUF[3] == 0x14)
        SendACKToSBEI();        //ACK
      if (TX_BUF[3] == 0x15)
        SendACKToSBEI();        //ACK
    }
    if ( mTYPE == 0x60 )
      //ݴ
      ReadDataCOMPRG();         //Ķ
    if ( mTYPE == 0x80 )
    {
      //дݵRAM
      WriteDataCOMPRG();        //д
      SendACKToSBEI();          //ACK
    }
  }
}
/******************************************************
 ݵѹˮ,ͱĿǶֵ
 ::
 :
*******************************************************/
uint16_t GJ_KDV_JSSYBMBJD(KDVJDSTRUCT *mSTUCT, INT16U mV, uint8_t mLEN)
{
  uint16_t mV1, mV2;
  uint16_t mD1, mD2;

  uint8_t i = 0;
  uint8_t mBB;	                //=1ʾѹͽǶȳ˷,=0
  uint8_t mOK;

  //----------------------------------------------------------
  //0ѹֵ͵1ѹֵ򷵻ؽǶ0
  if ( (mSTUCT->Kdu) == ((mSTUCT + 1)->Kdu) )
    return  0;

  if ( (mSTUCT->Kdu) > ((mSTUCT + 1)->Kdu) )
    mBB = 1;		                //ʾѹͽǶȳ˷
  else
    mBB = 0;		                //ʾѹͽǶȳ
  //------------------------------------------------------------
  for (;;)
  {
    if ((*(mSTUCT + i)).Kdu == 0) //ǽ
    {
      if (i)
        return  (*(mSTUCT + i - 1)).WBJD;
    }
    mOK = 0;
    if (mBB)
    {
      if(mV >= (*(mSTUCT + i)).Kdu)
        mOK = 1;
    }
    else
    {
      if(mV <= (*(mSTUCT + i)).Kdu)
        mOK = 1;
    }
    //------------------------------------------------------------
    if (mOK)
    {
      if (i)
      {
        mV2 = (*(mSTUCT + i)).Kdu;
        mD2 = (*(mSTUCT + i)).WBJD;
        mV1 = (*(mSTUCT + i - 1)).Kdu;
        mD1 = (*(mSTUCT + i - 1)).WBJD;
        break;
      }
      else
      {
        return  (*(mSTUCT)).WBJD;
      }
    }
    else
    {
      i++;
      if (i == mLEN)                        
        return  (*(mSTUCT + i - 1)).WBJD;  
    }
  }
  
  if (mBB)
  {
    return  mD1 + ((INT32U)(mD2 - mD1) * (mV1 - mV)) / (mV1 - mV2);
  }
  else
  {
    return  mD1 + ((INT32U)(mD2 - mD1) * (mV - mV1)) / (mV2 - mV1);
  }
}

//========================================================
//FLASHж,ת,ˮ,ͱ,KPuls_csRAM
//========================================================
void Read_CZSYBKPILSFR_FLASH(void)
{
  //uint8_t i;
  //uint16_t m16;
  //---------------------------------------------------------------------

  if (DFLASH_Read_Word(DFLASH_FirstAddress) != 0xA77A)
  {
    //----hyq--20180404
    KPuls_cs.CSBIX = 595;
    KPuls_cs.CS_N = 4;                    
	  //Һ                      5
    CSBFrJDTB[0].WBJD = 30;                   
    CSBFrJDTB[0 + 1].WBJD = 248;      //16   1     ʻ    ΢ֵ 11.5
    CSBFrJDTB[1 + 1].WBJD = 1240;     //68   5
    CSBFrJDTB[2 + 1].WBJD = 2232;     //120  9 
    CSBFrJDTB[3 + 1].WBJD = 2480;     //135 10

    //                      5
    ZSBFrJDTB[0].WBJD = 30;
    ZSBFrJDTB[0 + 1].WBJD = 262;      //352;    	//16   1     ʻ    ΢ֵ 11.5
    ZSBFrJDTB[1 + 1].WBJD = 1270;     //1382;     //68   5
    ZSBFrJDTB[2 + 1].WBJD = 2307;     //2316;     //120  9 
    ZSBFrJDTB[3 + 1].WBJD = 2599;     //2633;     //135 10
    
    //ˮ                      8
    SUIBVJDTB[0].WBJD = 146; 
    SUIBVJDTB[0 + 1].WBJD = 385;      //16   1       
    SUIBVJDTB[1 + 1].WBJD = 796;      //39   3      
    SUIBVJDTB[2 + 1].WBJD = 1245;     //62   5      
    SUIBVJDTB[3 + 1].WBJD = 1648;     //86   7    
    SUIBVJDTB[4 + 1].WBJD = 1922;     //102  8      
    
    //ȼ                       8
    YOUBVJDTB[0 ].WBJD = 146;         //   
		YOUBVJDTB[0 + 1].WBJD = 347;      //16   1      20
		YOUBVJDTB[1 + 1].WBJD = 813;      //39   3      40
		YOUBVJDTB[2 + 1].WBJD = 1270;     //62   5      60
		YOUBVJDTB[3 + 1].WBJD = 1711;     //86   7      80
		YOUBVJDTB[4 + 1].WBJD = 1956;     //102  8      90
  }
  else
  {
    DFLASHeep_adr = DFLASH_FirstAddress + 2;
    wdt_reset();
    ReadNbyteFrDFalsh((INT16U *)CSBFrJDTB, sizeof(CSBFrJDTB));
    ReadNbyteFrDFalsh((INT16U *)ZSBFrJDTB, sizeof(ZSBFrJDTB));
    ReadNbyteFrDFalsh((INT16U *)SUIBVJDTB, sizeof(SUIBVJDTB));
    ReadNbyteFrDFalsh((INT16U *)YOUBVJDTB, sizeof(YOUBVJDTB));
    ReadNbyteFrDFalsh((INT16U *)(&KPuls_cs), sizeof(KPuls_cs));
  }
  //-----------------------------------
  KPuls_cs.YBala_N = 2;          //ͱ(ֲǶֵ)(1/8ȵλ)
  KPuls_cs.SBala_N = 5;          //ˮ(ֲǶֵ)(1/8ȵλ)
  KPuls_cs.SB_KT = 30;           //ˮʱ䵱ǰֵȥƽĿֵ(λ3.6MS)
  KPuls_cs.CSBIX = 595;          //ٱ
  KPuls_cs.CS_N = 4;             //ٴÿתһȦ(4,8)
  KPuls_cs.ZS_G100 = 400;        //תٱĸ
  //-------------------------    ʵӦõĲ
  CSBFrJDTB[0].Kdu = 0;
  CSBFrJDTB[0].WBJD = 0;

  CSBFrJDTB[1].Kdu =  10;
  CSBFrJDTB[2].Kdu =  50;
  CSBFrJDTB[3].Kdu =  90;
  CSBFrJDTB[4].Kdu = 100;
  
  b_CSB_JD[0] = 304;  
	b_CSB_JD[1] = 1238;  
	b_CSB_JD[2] = 2256; 
	b_CSB_JD[3] = 2537; 
  //--------------------------

  ZSBFrJDTB[0].Kdu = 0;
  ZSBFrJDTB[0].WBJD = 0;
  
  ZSBFrJDTB[1].Kdu =  100;
  ZSBFrJDTB[2].Kdu =  500;
  ZSBFrJDTB[3].Kdu =  900;
  ZSBFrJDTB[4].Kdu = 1000;

	b_ZSB_JD[0] = 352;   
	b_ZSB_JD[1] = 1382;   
	b_ZSB_JD[2] = 2316;  
	b_ZSB_JD[3] = 2633;  
  //--------------------------
	/*********************ȼͱ*********************/
	YOUBVJDTB[0].Kdu  = 0;   
	YOUBVJDTB[0].WBJD = 0;

	YOUBVJDTB[1].Kdu = 20;  
	YOUBVJDTB[2].Kdu = 40;	  
	YOUBVJDTB[3].Kdu = 60;	
	YOUBVJDTB[4].Kdu = 80;
	YOUBVJDTB[5].Kdu = 90;

	YOUBVJDTB[6].Kdu  = 0;
	YOUBVJDTB[6].WBJD = 0;

	b_RYB_JD[0] = 268; 
	b_RYB_JD[1] = 689; 
  b_RYB_JD[2] = 1133; 
  b_RYB_JD[3] = 1541; 
  b_RYB_JD[4] = 1785;
  
	/*********************ˮ*********************/
	SUIBVJDTB[0].Kdu  = 50;   
	SUIBVJDTB[0].WBJD = 0;

	SUIBVJDTB[1].Kdu = 59;  //16   1	
	SUIBVJDTB[2].Kdu = 75;  //39   3	
	SUIBVJDTB[3].Kdu = 98;	//62   5
	SUIBVJDTB[4].Kdu = 110; //86   7
	SUIBVJDTB[5].Kdu = 120; //102  8
	
	SUIBVJDTB[6].Kdu = 0;	
	SUIBVJDTB[6].WBJD= 0;
					
  b_SWB_JD[0] = 316; 
	b_SWB_JD[1] = 797; 
	b_SWB_JD[2] = 1217; 
  b_SWB_JD[3] = 1613; 
  b_SWB_JD[4] = 1905;
  	
  JSCZSBMAXFRPRG();		     //ó,תٱĿ̶ֵ(ʼ)
  KP_CS_N = KPuls_cs.CS_N;
}

void TSzhen_mode(void)
{
  if (!RSSRecivJudge())    //յȷ
  {
    if (TX_BUF[2] == 6)    //Ϊ6 ,YES
    {
      if((TX_BUF[3] == 0x11) && (TX_BUF[4] == 0x22) && (TX_BUF[5] == 0x33) && (TX_BUF[6] == 0x44) && (TX_BUF[7] == 0x55) )
      {
        SendACKToSBEI(); 	//ACK
        SetModeProc();    //ģʽ
      }
    }
  }
}



