/******************************************************************************

*****************************************************************************/
#include "BackLight.h"

BlPWMCaptureStruct  BlPWMCapture;
BlPWMFilterStruct   BlPWMFilter;
BlOFFCtrlStruct     BlOFFCtrl;
uint8_t             BlTurnOnDelay;
uint8_t             BlTurnOffDelay;
/******************************************************************************
 BL_Init
  ܣ ϵʼ
   dutyCycleڵڱ
ֵ 
*******************************************************************************/
void BL_Init(void)
{
  BlOFFCtrl.DoorStatusBackup = 0;
  BlOFFCtrl.Timer            = 0;
  BlTurnOnDelay              = 10;
  BlTurnOffDelay             = 10;
}
/******************************************************************************
 Backlight_Plate_Needle_Set
  ܣ ̼뱳趨
   dutyڵڵıռձ
ֵ 
*******************************************************************************/
void BackLight_Plate_Needle_Set(uint8_t duty)
{
  if(duty < 7)
    duty = 7;
  if(duty > 95)
    duty = 95;
  PWM_Channel_Set_Duty_Cycle(2, duty);
}
/******************************************************************************
 BackLight_Plate_Needle_Close
  ܣ ̼뱳ر
   
ֵ 
*******************************************************************************/
void BackLight_Plate_Needle_Close(void)
{
  PWM_Channel_Set_Duty_Cycle(2, 0);
}
/******************************************************************************
 Backlight_Init
  ܣ TFTı
   dutyõռձ
ֵ 
*******************************************************************************/
void BackLight_TFT_Set(uint8_t duty)
{
  if((duty < 7))
    duty = 7;
  if(duty > 95)
    duty = 95;
  PWM_Channel_Set_Duty_Cycle(7, duty);
}
/******************************************************************************
 Backlight_Init
  ܣ TFTر
   
ֵ 
*******************************************************************************/
void BackLight_TFT_Close(void)
{
  PWM_Channel_Set_Duty_Cycle(7, 0);
}
/*******************************************************************************

  ڲKEY_Step
********************************************************************************/
void BL_Management_Service(void)
{
  //uint8_t  Msg;
  //uint8_t  DutyCycle;

  //DutyCycle = BL_KEY_Step;
  //if(SYS_OPR_STAT_IGN_ON)
  //  {}
  if (SYS_IGN_OFF_DISP_MODE)
  {
    BlOFFCtrl.Timer = 0;
    if (BlTurnOffDelay)
      BlTurnOffDelay--;
    else
    {
      if ((DriveDoorSts == 1) || (PsngrDoorSts == 1) || (PositionLightSts == 1) || (HazardLightSts == 1) || ((PepslcuAlarm > 0) && (PepslcuAlarm < 13)) || (PepslcuAlarm == 14) || ((RHTurnSignalSts == 1) && (LHTurnSignalSts == 1)))    //20200501 fhl
      {
			  if (PositionLightSts == 1) 
        { 
          BackLight_TFT_Set((BcakLightPOS + 1) * 15);             
          if ((DriveDoorSts == 1) || (PsngrDoorSts == 1) || (HazardLightSts == 1) || ((RHTurnSignalSts == 1) && (LHTurnSignalSts == 1))) 
          {  
            // BackLight_Plate_Needle_Set((BcakLightPOS+1)*15);
            PWM_Channel_Set_Duty_Cycle(5, ((BcakLightPOS + 1) * 15));
          }                     
          else
          {
            //BackLight_Plate_Needle_Close(); //20200306
            PWM_Channel_Set_Duty_Cycle(5, 0); 
          }    
        }
        else   
        {                   
          if ((DriveDoorSts == 1) || (PsngrDoorSts == 1) || (HazardLightSts == 1) || ((RHTurnSignalSts == 1) && (LHTurnSignalSts == 1))) 
          {  
            //BackLight_Plate_Needle_Set((BcakLightPOS + 1) * 25);
            PWM_Channel_Set_Duty_Cycle(5, ((BcakLightPOS + 1) * 25));
          }                    
          if ((DriveDoorSts == 1) || (PsngrDoorSts == 1))/* || ((PepslcuAlarm > 0) && (PepslcuAlarm < 13)) || (PepslcuAlarm == 14)) */
          {
            BackLight_TFT_Set((BcakLightPOS + 1) * 25);
          } 
          else if (((PepslcuAlarm > 0) && (PepslcuAlarm < 13)) || (PepslcuAlarm == 14)) 
          {
            BackLight_TFT_Set((BcakLightPOS + 1) * 25);
            PWM_Channel_Set_Duty_Cycle(5, 0); //2020 01 06 WH ޸off±C
          }    
          else
            BackLight_TFT_Close(); //    
        }       
      }
      else
      {
        BackLight_TFT_Close();     //
        PWM_Channel_Set_Duty_Cycle(5, 0);
      }
      
      BackLight_Plate_Needle_Close(); //20200306 
    }
  } 
  else 
  {
    BlOFFCtrl.Timer = 0;
    if(BlTurnOnDelay)
      BlTurnOnDelay--;
    else
    {
      if (PositionLightSts == 1)
      { 	 			
        BackLight_TFT_Set((BcakLightPOS + 1) * 15);
        BackLight_Plate_Needle_Set((BcakLightPOS + 1) * 15);
        PWM_Channel_Set_Duty_Cycle(5, ((BcakLightPOS + 1) * 15));
      }
      else
      {
        BackLight_TFT_Set((BcakLightPOS + 1) * 25);
        BackLight_Plate_Needle_Set((BcakLightPOS + 1) * 25);
        PWM_Channel_Set_Duty_Cycle(5, ((BcakLightPOS + 1) * 25));
      }
    }
  }
}

void PWM_INIT(void)
{
  PWM_Channel_Init(7, PWM_CLOCK_SB, PWM_POL_POS, PWM_LEFT_ALIGN, PWM7_PM3); //ʼ
  PWM_Channel_Set_Freq(7, 20000);
  PWM_Channel_Set_Duty_Cycle(7, 0); //ʼΪر,ɺӦó
  PWM_Channel_Start(7);        

  PWM_Channel_Init(2, PWM_CLOCK_SB, PWM_POL_POS, PWM_LEFT_ALIGN, PWM2_PP2); //ָʾƱ
  PWM_Channel_Set_Freq(2, 20000);
  PWM_Channel_Set_Duty_Cycle(2, 0); //ʼΪر,ɺӦó
  PWM_Channel_Start(2);
  
  PWM_Channel_Init(5, PWM_CLOCK_SA, PWM_POL_POS, PWM_LEFT_ALIGN, PWM5_PP5); //C
  PWM_Channel_Set_Freq(5, 100);
  PWM_Channel_Set_Duty_Cycle(5, 0); //ʼΪر,ɺӦó
  PWM_Channel_Start(5);
}
