#ifndef	_FUELCONFIG_H                            	
#define _FUELCONFIG_H	

typedef unsigned int INT16U;
typedef unsigned char INT8U; 
typedef unsigned long INT32U;

//Fuel Config
typedef struct _FuelStruct {
  INT16U FuelShortCircuitR;
  INT16U FuelOpenCircuitR;
  INT16U DisplayZoneBoundary[11];
	INT16U FuelCapacityBoundary[11];
} FuelStruct;

extern void InitFuelParamter(FuelStruct *para);

extern void SaveSampleVal(INT16U FuelResistance); //unit:ohm,accuracy:0.1
extern void FuelFSM(void);

extern void SetRPM(INT16U n);   //Call only when the fuel is used,unit:RPM,accuracy:1
extern void SetSpeed(INT8U n);  //Call only when the fuel is used,unit:km/h,accuracy:1

extern void SetFuelSensorRecoverGroupCnt(INT16U n);       //1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600)
extern void SetFuelSensorOpenCircuitGroupCnt(INT16U n);   //1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600) 
extern void SetFuelSensorShortCircuitGroupCnt(INT16U n);  //1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600)

extern void SetPowerSt(INT8U n);
extern INT8U GetFuelSeg(void);  //Segment, range:0~8
extern INT8U GetFuelStep(void); //Pointer or Mono TFT stepless,range:0,10~90,   0,10:E,   90:F
extern INT16U GetFuelCapacityVal(void); //unit:L,accuracy:0.1
extern void SetDisplayStepMinVal(INT8U n); //Set GetFuelStep() min val,range:0~80,default 10
extern void SetCalcResistanceRange(INT8U min, INT8U max); //Call this function after calling InitFuelParamter();
                                                          //Set the range of calculated resistance value, default:40-120, max number:240;
                                                          //ResistanceRange[0]:Sample resistance minimum,fuel high; 
                                                          //ResistanceRange[239]:Sample resistance maximum, fuel low. 

enum {
	FuelSensorNormal,
	FuelSensorShortCircuit,
	FuelSensorOpenCircuit,
	FuelSensorPreFault,
};
extern INT8U GetFuelSensorState(void); 

enum {
	FUEL_ST_FIRST_POWER_UP,		 //0
	FUEL_ST_IGN_ON_PROCESS,		 //1
	FUEL_ST_POWER_ON_ADD_FUEL, //2
	FUEL_ST_VEHICLE_RUN,		   //3
	FUEL_ST_IGN_OFF_PROCESS,	 //4
	FUEL_ST_IGN_OFF,  			   //5
}; 
extern INT8U GetFuelFSM_St(void);
extern INT16U GetFuelResistance(void); //unit:ohm,accuracy:0.1
extern INT8U GetPowerDn(void);
extern INT16U GetPowerDownTimeCnt(void);  

// AFC & DrivingRange
typedef struct _AFC_INIT {
	INT8U CalcAFCMaxNum;	//max 100km,default 50
	INT16U AFCMin;	      //unit:L,accuracy:0.1
	INT16U AFCMax;      	//unit:L,accuracy:0.1
	INT16U AFCPreinstall;	//unit:L,accuracy:0.1
	INT32U CurODO;	    	//unit:m,accuracy:1
	INT32U MaxDRMileage;	//unit:km,accuracy:0.01
} AFC_INIT;
extern void InitAFC(AFC_INIT *data);
extern void ResetAFC(AFC_INIT *data);

typedef struct _AFC_PARA {
	INT32U CurODO;		  // unit:m,accuracy:1
	INT16U FuleConsume;	// unit:ul,accuracy:1
	INT16U RPM;		    	// unit:RPM,accuracy:1
	INT8U Speed;		    // unit:km/h,accuracy:1
} AFC_PARA;
extern void SetAFCPara(AFC_PARA *data);

extern void AFCTimerCall(void);   //must per 10ms interrupt
extern INT16U GetDRMileage(void); //unit:km,accuracy:1
extern INT16U GetCurAFC(void);    //unit:L,accuracy:0.1 
extern INT16U GetAFCSumH(void);
extern INT16U GetAFCSumL(void); 
  
  
#endif






