/******************************************************************************
  MSCAN0.h
MSCAN0շƺļ
    ߣ
    V1.0
    ڣ2016.5.5
******************************************************************************/

#include "MSCAN0.h"
uint8_t    WakeUpFlag;
uint8_t    WakeUpID;
uint16_t                      MSCAN0TxID[3];
MSCAN0BusoffMonitorStruct     MSCAN0Busoff;
extern uint8_t NM_RECEIVE;

extern void CoCAN_L_Data_Indication(uint16_t Identifier, uint8_t DLC, uint8_t *Data);
extern void CoCAN_L_Data_Confirm(uint16_t Identifier, uint8_t TransferStatus);

extern void DoCAN_L_Data_Indication(uint16_t Identifier, uint8_t dlc, uint8_t *pData);
extern void DoCAN_L_Data_Confirm(uint16_t Identifier, uint8_t TransferStatus);

extern FUNC(void, CANNM_CODE) CanNm_RxIndication
(
  PduIdType RxPudId,
  const uint16 RxId,
  P2CONST(PduInfoType, AUTOMATIC, CANNM_APPL_DATA)PduInfoPtr
);

extern FUNC(void, CANNM_CODE) CanNm_TxConfirmation
(
  PduIdType TxPudId
);

/******************************************************************************
MSCAN0_L_Data_Request
  ܣúϲ,Ϸһ鱨
  IdentifierID
        DLC       ĳ
        Data      
ֵ
******************************************************************************/
void MSCAN0_L_Data_Request(uint16_t Identifier, uint8_t DLC, uint8_t *Data)
{
  uint8_t  i;
  uint8_t  BufDetect;
  uint8_t  BufSel;

  //ݳȴ8MSCANCAN BUSͬ3ͻûпʱIDЧ,ϱʧܲ˳
  if ((DLC > 8) ||	(CAN0CTL0_SYNCH == 0) || (CAN0TFLG & 0x07 == 0) || (Identifier > 0x07FF))
  {
    MSCAN0_L_Data_Confirm(Identifier, NOT_COMPLETE);
    return;
  }

  CAN0TBSEL = CAN0TFLG;   		              //ѡָеķͻ(ѡ͵)
  BufSel    = CAN0TBSEL;

  BufDetect = 0x01;
  for (i = 0; i < 3; i++)
  {
    if (BufDetect == BufSel)
    {
      if (MSCAN0TxID[i] != 0xFFFF)           //ǰһαķδõBuffer
      {
        MSCAN0_L_Data_Confirm(MSCAN0TxID[i], NOT_COMPLETE);
        MSCAN0TxID[i] = 0xFFFF;
      }

      MSCAN0TxID[i] = Identifier;            //ID
    }

    BufDetect <<= 1;
  }

  CAN0TXIDR0 = (uint8_t)(Identifier >> 3);  //дʶID
  CAN0TXIDR1 = (uint8_t)(Identifier << 5);
  CAN0TXIDR1_SRR = 0;
  CAN0TXIDR1_IDE = 0;

  for (i = 0; i < DLC; i++)                 //д
    *((&CAN0TXDSR0) + i) = Data[i];

  CAN0TXDLR = DLC;

  //CAN0TXTBPR = 0;                         //ȼ,Bufferȼͬ,BufferIDԽС,ȼԽ
  CAN0TFLG  = BufSel;                       //
  CAN0TIER |= BufSel;                       //ӦCANж
}

/******************************************************************************
MSCAN0_L_Data_Indication
  ܣúϲָʾһ֡ĵĵ,ͬʱݴϲ
        ע⣺1.ʹʱӦϲıĴݺڱ֮,ĵʱ
                Ӧĺݱ
              2.ж,õϲıĴݺӦܼ
  IdentifierID
        DLC       ĳ
        Data      
ֵ
******************************************************************************/
void MSCAN0_L_Data_Indication(uint16_t Identifier, uint8_t DLC, uint8_t *Data)
{
  PduInfoType NW_MessageBuffer;

  if( ( Identifier >= 0x400 ) && ( Identifier <= 0x47F ) )  //
  {
    NW_MessageBuffer.SduDataPtr = Data;
    NW_MessageBuffer.SduLength = DLC;
    CanNm_RxIndication(0, 0, &NW_MessageBuffer);
    NM_RECEIVE = 1;

  }
  else    if ((Identifier == 0x7E3) || (Identifier == 0x7EB))
  {
    DoCAN_L_Data_Indication(Identifier, DLC, Data);
  }
  else
  {
    //Ӧñ
    if( sleepFlg == NET_WORK_STATE )
    {
      CoCAN_L_Data_Indication(Identifier, DLC, Data);

    }
    else if( sleepFlg == PREPARE_BUS_SLEEP_STATE )
    {


    }
    else if( sleepFlg == BUS_SLEEP_STATE )
    {

    }
    else if( sleepFlg == START_INDICATION_STATE )
    {
      CoCAN_L_Data_Indication(Identifier, DLC, Data);
    }
  }

  //  if ((Identifier == 0x7E3) || (Identifier == 0x7EB))
  //    DoCAN_L_Data_Indication(Identifier, DLC, Data);
  //  else
  //   CoCAN_L_Data_Indication(Identifier, DLC, Data);
}

/******************************************************************************
MSCAN0_L_Data_Confirm
  ܣúϲָʾ͵ıĵķͽ
        ע⣺1.ʹʱӦϲıķͽݺڱ֮,ķ
                ʱӦĺݱķͽ
              2.ж,õϲıķͽݺӦܼ
  Identifier    ID
        TransferStatusķͽCOMPLETE     
                                      NOT_COMPLETE δܷ
ֵ
******************************************************************************/
void MSCAN0_L_Data_Confirm(uint16_t Identifier, uint8_t TransferStatus)
{
  if( ( Identifier >= 0x400 ) && ( Identifier <= 0x47F ) )  //
  {
    CanNm_TxConfirmation(0);
  }
  else if (Identifier == 0x7E3)
    DoCAN_L_Data_Confirm(Identifier, TransferStatus);
  else
  {
    CoCAN_L_Data_Confirm(Identifier, TransferStatus);
  }

  //if (Identifier == 0x7E3)
  //   DoCAN_L_Data_Confirm(Identifier, TransferStatus);
  // else
  //   CoCAN_L_Data_Confirm(Identifier, TransferStatus);
}

/******************************************************************************
MSCAN0_Bus_Off_Monitoring_Service
  ܣMSCAN0 Bus-off״̬ط,Bus-off״̬Իָ
  
ֵ
*******************************************************************************
ע  ⣺÷ÿ20msһ
******************************************************************************/
void MSCAN0_Bus_Off_Monitoring_Service(void)
{
#if !MSCAN0_BUS_OFF_AUTO_RECOVERY

#if MSCAN0_BUS_LIMP_MODE_ENABLE
  if (MSCAN0Busoff.Status == MSCAN0_BUS_LIMP)
    return;	                                  //CANѾģʽ(λָʧ),ٻָ
#endif

  if (CAN0MISC_BOHOLD)                          //Bus-off
  {



    MSCAN0Busoff.Timer++;
    if (MSCAN0Busoff.Timer >= MSCAN0_BUS_OFF_RECOVERY_TIME / 20)
    {
      MSCAN0Busoff.Timer = 0;

      MSCAN0Busoff.Status = MSCAN0_BUS_OFF;     //¼Bus-off״̬

      CAN0MISC_BOHOLD = 1;                      //д1,ָBus-off

#if MSCAN0_BUS_LIMP_MODE_ENABLE
      MSCAN0Busoff.Cnt++;
      if (MSCAN0Busoff.Cnt > MSCAN0_BUS_LIMP_MODE_THRESHOLD)
      {
        MSCAN0Busoff.Cnt = 0;
        CAN0MISC_BOHOLD = 1;                      //д1,ָBus-off
        MSCAN0Busoff.Status = MSCAN0_BUS_LIMP;  //CANģʽ
        CAN0_STB = 1;                       //ʡģʽ
        MSCAN0_Init();				                  //ͨʼֹCANշ
        CAN0RIER_RXFIE = 0;   		              //ֹCANж
        CAN0RIER_WUPIE = 0;                     //رջж
        CAN0CTL0_WUPE  = 0;                     //ֹʹ
        if (CAN0RFLG_WUPIF)
          CAN0RFLG_WUPIF = 1;                   //лж־Ҳһ(д1)
      }
#endif
    }
  }
  else                                          //,ûBus-off
  {
    MSCAN0Busoff.Status = MSCAN0_BUS_STABLE;
    MSCAN0Busoff.Timer = 0;

#if MSCAN0_BUS_LIMP_MODE_ENABLE
    MSCAN0Busoff.Cnt   = 0;
#endif
  }
#endif
}

/******************************************************************************
MSCAN0_Get_Bus_Status
  ܣȡMSCAN0״̬
  
ֵMSCAN0_BUS_STABLE,ȶ
        MSCAN0_BUS_OFF   ߴBus-off״̬
        MSCAN0_BUS_LIMP  ߴ״̬(Bus-offλָʧܶر)
******************************************************************************/
uint8_t MSCAN0_Get_Bus_Status(void)
{
  return MSCAN0Busoff.Status;
}

/******************************************************************************
MSCAN0_Init
  ܣMSCAN0ʼ
  
ֵ
******************************************************************************/
void MSCAN0_Init(void)
{
  uint8_t i;

  CAN0CTL0 = 0x01;            // MSCANʼģʽ
  while(!(CAN0CTL1_INITAK));  //ȴʼģʽ

  CAN0IDAC = 0;   		        //ռĴĹʽ  two 32-bit filter

  CAN0IDAR0 = 0x00;     	    //ռĴ
  CAN0IDAR1 = 0x00;
  CAN0IDAR2 = 0x00;
  CAN0IDAR3 = 0x00;

  CAN0IDMR0 = 0xFF;           //μĴ (ΪбID)
  CAN0IDMR1 = 0xFF;
  CAN0IDMR2 = 0xFF;
  CAN0IDMR3 = 0xFF;

  CAN0IDAR4 = 0x00;      	    //ռĴ
  CAN0IDAR5 = 0x00;
  CAN0IDAR6 = 0x00;
  CAN0IDAR7 = 0x00;

  CAN0IDMR4 = 0xFF;           //μĴ (ΪбID)
  CAN0IDMR5 = 0xFF;
  CAN0IDMR6 = 0xFF;
  CAN0IDMR7 = 0xFF;

  CAN0CTL1_CANE   = 1;        //ʹMSCANģ
  CAN0CTL1_CLKSRC = 0;        //ѡOSCCLK(8MHz)ΪMSCANʱԴ
  CAN0CTL1_LISTEN = 0;        //ģʽ(Ǽģʽ)

#if MSCAN0_BUS_OFF_AUTO_RECOVERY
  CAN0CTL1_BORM = 0;	      //ԶBUS_OFFָ
#else
  CAN0CTL1_BORM = 1;	      //BUS_OFFûƻָ
#endif

  CAN0CTL1_WUPM = 1;		      //Ѽ˲

  CAN0BTR0 = MSCAN0_BTR0_VALUE;   //
  CAN0BTR1 = MSCAN0_BTR1_VALUE;

  CAN0CTL0 = 0x00;            //˳ʼģʽ
  while (CAN0CTL1_INITAK);    //ȴ˳ʼģʽ
  while (!CAN0CTL0_SYNCH);    //ȴMSCANCANͬ


  CAN0TIER = 0x00;            //ֹCANж
  CAN0RIER_RXFIE = 1;   		  //ʹCANж
  CAN0RIER_WUPIE = 1;

  CAN0_STB = 0;   	          //ʹCANշ

  MSCAN0Busoff.Status = MSCAN0_BUS_STABLE;
  MSCAN0Busoff.Timer = 0;

#if MSCAN0_BUS_LIMP_MODE_ENABLE
  MSCAN0Busoff.Cnt   = 0;
#endif

  for(i = 0; i < 3; i++)
    MSCAN0TxID[i] = 0xFFFF;   //0xFFFFʾЧID
}

/******************************************************************************
MSCAN0_Low_Power_Mode
  ܣMSCAN0͹ģʽ
  
ֵ
******************************************************************************/
void MSCAN0_Low_Power_Mode(void)
{
  //MSCAN͹ģʽ
  MSCAN0_Init();               //͸ʼֹCANշ
  //	CAN0_STB = 1;   	          //ʹCANշ
  CAN0RIER_RXFIE = 0;   			//ֹCANж
  if(CAN0RFLG_WUPIF)          //ж־ = 1 д10
    CAN0RFLG_WUPIF = 1;
  CAN0CTL0_WUPE = 1;			    //ʹ

  //1,MSCANз(Ͷп),Ҳ(CAN߿),
  //MSCAN SLEEPģʽ, CAN0CTL1_SLPAK=1ʾȷ
  //ôλǰ CAN0RFLG_WUPIF 

  //CAN0CTL0_SLPRQ=1,CAN0CTL1_SLPAK=1 ,ʾMSCANѾ˯ģʽ
  CAN0CTL0_SLPRQ = 1;			    //MSCAN˯ģʽ

  //MSCAN˯ģʽ, CAN0CTL0_WUPE = 1 յCANĺ,MSCAN˳˯,CAN0RFLG_WUPIF1
  //ͬʱ CAN0CTL0_SLPRQ,CAN0CTL1_SLPAK ҲԶ0.

  //MSCAN˯ģʽ,ҲCAN0CTL0_SLPRQ = 0,ʹMSCAN˳˯,CAN0CTL1_SLPAK ҲԶ0.
  // CAN0CTL0_SLPRQ = 1,MSCANûн˯ģʽ,ôCAN0CTL0_SLPRQ = 0.

  CAN0TARQ = 0x07;            //ֹбķ.
}

#pragma CODE_SEG __NEAR_SEG NON_BANKED   	//жϺFLASHķǷҳ

/******************************************************************************
MSCAN0_TX_ISR
  ܣMSCAN0жϷ
        CANķϻֹʱִд˺
  
ֵ
******************************************************************************/
void interrupt MSCAN0_TX_ISR(void)
{
  uint8_t i;
  uint8_t TxFlag;
  uint8_t TxBuf;
  uint8_t BufDetect;

  do
  {
    TxFlag = CAN0TFLG;

    TxBuf = CAN0TIER & TxFlag;              //ȡϻֹ͵ıBuffer
    CAN0TIER &= ~TxBuf;                     //رշϻֹ͵ıBufferӦж

    BufDetect = 1;
    for (i = 0; i < 3; i++)
    {
      if (BufDetect & TxBuf)
      {
        if (BufDetect & CAN0TAAK)           //ıɹֹ
          MSCAN0_L_Data_Confirm(MSCAN0TxID[i], NOT_COMPLETE);
        else                                //ķͳɹ
          MSCAN0_L_Data_Confirm(MSCAN0TxID[i], COMPLETE);

        MSCAN0TxID[i] = 0xFFFF;             //ļ¼
      }

      BufDetect <<= 1;
    }
  }
  while (TxFlag != CAN0TFLG);               //жϴڼµıķ
}

/******************************************************************************
MSCAN0_RX_ISR
  ܣMSCAN0жϷ
        CANʹʱCAN
  
ֵ
******************************************************************************/
void interrupt MSCAN0_RX_ISR(void)
{
  uint16_t CANMsgID;

  CAN0RIER_RXFIE = 0;                      //ȽֹMSCANж

  if (CAN0RXIDR1_IDE || CAN0RXIDR1_SRR)    //յΪչ֡,ΪԶ֡
  {
    CAN0RFLG_RXF = 1;                      //жϱ־
    CAN0RIER_RXFIE = 1;                    //MSCANж

    return;
  }

  CANMsgID = ((uint16_t)(CAN0RXIDR0 << 3)) | ((uint16_t)(CAN0RXIDR1 >> 5));

  MSCAN0_L_Data_Indication(CANMsgID, CAN0RXDLR & 0x0F, &CAN0RXDSR0);

  CAN0RFLG_RXF = 1;                        //жϱ־
  CAN0RIER_RXFIE = 1;                      //MSCANж
}

/******************************************************************************
MSCAN0_WAKEUP_ISR
  ܣMSCAN0ж
  
ֵ
******************************************************************************/
void interrupt MSCAN0_WAKEUP_ISR(void)
{
  CAN0RFLG_WUPIF = 1;
  WakeUpFlag = 1;
}

uint8_t GetWakeUPFLAG(void)
{
  return    WakeUpFlag;
}

#pragma CODE_SEG DEFAULT

Std_ReturnType CanIf_Transmit(PduIdType CanTxPduId, PduInfoType *PduInfoPtr)
{
  MSCAN0_L_Data_Request( 0x402, (uint8_t)PduInfoPtr->SduLength, (uint8_t *)PduInfoPtr->SduDataPtr );
  return E_OK;
}
