/****************************************************************************************************************************************************
    GPIO.h
  GPIOӳ估GPIOʼͷļ
      ߣ
      V1.0
      ڣ2016.11.1
 ****************************************************************************************************************************************************/
#ifndef _GPIO_H_
#define _GPIO_H_

#include "stdint.h"
#include "mc9s12xhy256.h"

/****************************************************************************************************************************************************
  GPIOӳ
 ****************************************************************************************************************************************************/

/*===================================================================================================================================================
  PORTA ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      |         ˿       |    |    |  ֵ    |  ˵
  ===================================================================================================================================================*/
#define     LINE_IN_GEAR                PORTA_PA0    // 87       IN 	    0           --ź
#define     PWR_3V3EN                   PORTA_PA1    // 88       OUT 	    0           --
#define     PWR_nVIOEN                  PORTA_PA2    // 89       OUT 	    0           --_CTL
#define     LINE_IN_CHARGEn             PORTA_PA3    // 90       IN 	    0           --
#define     LINE_RIGHT_GREEN            PORTA_PA4    // 91       OUT	    1           --ת
#define     LED_RIGHT_RED               PORTA_PA5    // 92       OUT	    1           --ת
#define     LED_RIGHT_WHITE             PORTA_PA6    // 93       OUT	    1           --ת
#define     LED_OUT_KEY_CTRL            PORTA_PA7    // 94       OUT 	    1           --ֵ⹩Դ
/*===================================================================================================================================================
  PORTB ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ    |  ˵
  ===================================================================================================================================================*/
#define     LINE_IN_PTO                 PORTB_PB0  	 // 86      IN 	      0          -- PTO
#define     DB8379_CLK_P                PORTB_PB1  	 // 95      OUT 	    0          -- 8379CLK             
#define     EEPROM_SCL		              PORTB_PB2    // 96      OUT	      1          --EEPROM SCLź  ()
#define     EEPROM_SDA					        PORTB_PB3    // 97      OUT       1          --EEPROM SDAź  ()
#define     STB_LCD_MCU                 PORTB_PB4  	 // 100     OUT 	    0          --TFT STB              
//#define     N.C.                      PORTB_PB5  	 // 101     OUT 	    0          --              
//#define     N.C.                      PORTB_PB6  	 // 102     OUT  	    0          --              
//#define     N.C.                      PORTB_PB7  	 // 103     OUT 	    0          --              

/*===================================================================================================================================================
  PTT ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
#define    LINE_IN_SEATBELTn         PTT_PTT0        // 52       IN       0	  	   0             0      --ȫ 
#define    LINE_IN_BREAK_FLUIDn      PTT_PTT1        // 53       IN       0	  	   0             0      --ƶҺλ
#define    LINE_IN_BREAKn            PTT_PTT2        // 54       IN       0	  	   0             0      --פƶ  
#define    LED_LEFT_WHITE            PTT_PTT3        // 55       OUT      1	  	   0             0      --תɫ
#define    LED_LEFT_GREEN            PTT_PTT4        // 57       OUT      1	  	   0             0      --תɫ
#define    TFT_nRST                  PTT_PTT5        // 58       OUT      0	  	   0             0      --
#define    LINE_IN_RF_HOOVES         PTT_PTT6        // 59       IN       0	  	   0             0      --ǰƬĥ 
#define    LINE_IN_RR_HOOVES         PTT_PTT7        // 60       IN       0	  	   0             0      --Ƭĥ 

/*===================================================================================================================================================
  PTS ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
#define    LINE_LINK_UART_RX       PTS_PTS0        // 39       IN       0	  	   0             0         LINK_RX
#define    LINE_LINK_UART_TX       PTS_PTS1        // 40       OUT      0	  	   0             0         LINK_TX
#define    CAN0_RXD                PTS_PTS2        // 43       IN       0	  	   1             0         --RXCAN
#define    CAN0_TXD                PTS_PTS3        // 44       OUT      0	  	   0             0            
#define    TFT_MISO                PTS_PTS4        // 47       IN       0	  	   0             0         --_MISO  
#define    TFT_MOSI                PTS_PTS5        // 48       OUT      0	  	   0             0         --_MOSI
#define    TFT_SCLK                PTS_PTS6        // 49       OUT      0	  	   0             0         --_SCLK 
#define    TFT_nCS                 PTS_PTS7        // 50       OUT      0	  	   0             0         --_nCS

/*===================================================================================================================================================
  PTP ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/   
#define     STEPPER_MOTOR_2_ZERO_SW PTP_PTP0       // 29       IN       0	  	   0             0           --ȼ͹
#define     STEPPER_MOTOR_3_ZERO_SW PTP_PTP1       // 30       IN       0	  	   0             0           --ѹ
#define     BL                     PTP_PTP2        // 31       OUT      0	  	   0             0           --Ǳ
#define     LINE_BUZZER            PTP_PTP3        // 32       OUT      0	  	   0             0           --+
#define     BUZZER_PWM_EN          PTP_PTP4        // 33       OUT      0	  	   0             0           ---
#define     BIGC_OUT               PTP_PTP5        // 34       OUT      0	  	   0             0           -- 
#define     DB8379_LE_P            PTP_PTP6        // 35       OUT      0	  	   0             0           --
#define     DB8379_OE_P            PTP_PTP7        // 36       OUT      0	  	   0             0           --

/*===================================================================================================================================================
  PTH ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
#define     LINE_IN_AEBSn          PTH_PTH0        // 63       IN      0	  	   0             0           --AEBSź
//#define     N.C.                   PTH_PTH1        // 64       OUT      0	  	   0             0           --
//#define     N.C.                   PTH_PTH2        // 65       OUT      0	  	   0             0           -- 
//#define     N.C.                   PTH_PTH3        // 66       OUT      0	  	   0             0           -- 
#define     LINE_IN_CAB_LOCKn      PTH_PTH4        // 75       IN       0	  	   0             0           --ʻ
#define     LINE_IN_FILT_BLOCKn    PTH_PTH5        // 76       IN       0	  	   0             0           --ĳLDWSź    
#define     LCD_1530EN             PTH_PTH6        // 83       OUT      0	  	   0             0           --TFTԴ
//#define     N.C.                   PTH_PTH7        // 84       OUT      0	  	   0             0           --
/*===================================================================================================================================================
  PT1AD ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  ˵
  ==================================================================================================================================================*/
//#define  N.C. 					           PT1AD_PT1AD0	   // 108      OUT	    0        0                         --
//#define  N.C.      				         PT1AD_PT1AD1	   // 109      OUT      0        0	                       --
#define  LINE_IN_KEY0n      			 PT1AD_PT1AD2    // 110      IN       0        0                         --Ͽ
#define  STEPPER_MOTOR_1_ZERO_SW   PT1AD_PT1AD3    // 111      IN       0        0                         --ˮ¹
#define  STEPPER_MOTOR_0_ZERO_SW   PT1AD_PT1AD4	   // 112      IN       0        0                         --ع 
#define	 LINE_OUT_FUEL_CTRL  			 PT1AD_PT1AD5	   // 1        OUT      0        0                         --ȼͼԴ
#define	 ADC_FUEL              	   PT1AD_PT1AD6    // 2        IN       0        0                         --ȼ 
#define	 LINE_OUT_GAS_CTRL			   PT1AD_PT1AD7    // 3        OUT      0        0                         --ѹԴ                 
/*===================================================================================================================================================
  PTR ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
#define	CAN0_STB               	 	 PTR_PTR0        // 45       OUT      0	  	   0             0         --CANշSTB
#define	TFT_nINT                 	 PTR_PTR1        // 46       OUT      0	  	   0             0			   --_INT 
#define DB8379_RST_P               PTR_PTR2        // 37       OUT      0	  	   0             0         --
#define DB8379_SIN_P 		           PTR_PTR3        // 38       OUT      0	  	   0             0         --
#define	LED_LEFT_RED               PTR_PTR4        // 56       OUT      1	  	   0             0         --
//#define	N.C.                       PTR_PTR5        // 61       OUT      0	  	   0             0     	   --
//#define N.C.       			           PTR_PTR6        // 62       OUT      0	  	   1             0			   --
//#define N.C.  					           PTR_PTR7        // 85       OUT      0	  	   0             0         --

/*===================================================================================================================================================
  PTU ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
//#define    N.C.                    PTU_PTU0         // 9        OUT      0	  	 0             0         LC_COS-       M0COSM
//#define    N.C.                    PTU_PTU1         // 10       OUT      0	  	 0             0         LC_COS+    
//#define    N.C.                    PTU_PTU2         // 11       OUT      0	  	 0             0         LC_SIN-    
//#define    N.C.                    PTU_PTU3         // 12       OUT      0       0             0         LC_SIN+    
//#define    N.C.                    PTU_PTU4         // 15       OUT      0       0             0         OIL_COS- ѹ2    M1COSM
//#define    N.C.                    PTU_PTU5         // 16       OUT      0       0             0         OIL_COS+    
//#define    N.C.                    PTU_PTU6         // 17       OUT      0       0             0         OIL_SIN-    
//#define    N.C.                    PTU_PTU7         // 18       OUT      0       0             0         OIL_SIN+   

/*===================================================================================================================================================
  PTV ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
//#define    N.C.                    PTV_PTV0         // 19       OUT      0	  	 0             0         TEM-COS- ѹ1    M2COSM   
//#define    N.C.                    PTV_PTV1         // 20       OUT      0	  	 0             0         TEM_COS+       
//#define    N.C.                    PTV_PTV2         // 21       OUT      0	  	 0             0         TEM_SIN-       
//#define    N.C.                    PTV_PTV3         // 22       OUT      0	  	 0             0         TEM_SIN+        
//#define    N.C.                    PTV_PTV4         // 25       OUT      0	  	 0             0         Z_COS+  Z_SIN-    M3COSM
//#define    N.C.                    PTV_PTV5         // 26       OUT      0	  	 0             0         Z_COS-  Z_COS+
//#define    N.C.                    PTV_PTV6         // 27       OUT      0	  	 0             0         Z_SIN+  Z_COS-
//#define    N.C.                    PTV_PTV7         // 28       OUT      0	  	 0             0         Z_SIN-  Z_SIN_

/*===================================================================================================================================================
  PTM ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
  ===================================================================================================================================================*/
//#define    N.C.                    PTM_PTM0         // 69       OUT      0	  	 0             0         --
//#define    N.C.                    PTM_PTM1         // 70       OUT      0	  	 0             0         --
#define    LCD_BL_EN               PTM_PTM2         // 71       OUT      0	  	 0             0         --ʹ  
#define    LCD_BL                  PTM_PTM3         // 72       OUT      0	  	 0             0         --
         
/*===================================================================================================================================================
  PT0AD ˿
  -----------------------------------------------------------------------------------------------------------------------------------------------------
  |                      | ˿                |    |    |  ֵ  |  ʹ  |  ˵
  ===================================================================================================================================================*/
#define	   ADC_GAS1		    			   PT0AD_PT0AD0     // 4        IN       0	  	 0                       --ѹ
#define	   ADC_GAS2			           PT0AD_PT0AD1     // 5        IN       0       0                       --ǰѹ
#define    ADC_KL15		             PT0AD_PT0AD2     // 6        IN       0       0                       --15-Դ  
#define	   ADC_KL30    				     PT0AD_PT0AD3     // 7        IN       0       0                       --30-    

/****************************************************************************************************************************************************
  
 ****************************************************************************************************************************************************/
void GPIO_Init(void);

#endif
