
#ifndef _SOUND_TRACKS_H_
#define _SOUND_TRACKS_H_

/******************************************************************************
һ
******************************************************************************/
#define   SND_TRACK_MAX_NOTE_NUM            4

/******************************************************************************
Խṹ
******************************************************************************/
typedef struct
{
  uint16_t   Freq;            //Ƶ(Hz),0ʾ(ֹ)
  uint8_t    Duty;            //ռձ(%)
  uint16_t   Interval;        //(ms)
  uint16_t   Fade;            //ʱ(ms)
}SndTrackNoteStruct;

/******************************************************************************
Խṹ
******************************************************************************/
typedef struct
{
  uint8_t             NoteNum;         //
  uint8_t             PreCharge;       //Ԥʱ(ms),ӰһĲ
  SndTrackNoteStruct  Note[SND_TRACK_MAX_NOTE_NUM];
}SndTrackStruct;

/******************************************************************************
Ա
******************************************************************************/
static const SndTrackStruct SndTracks[] = 
{
  {
    /*==============================================================
      | ܳ |                  
    ----------+--------+--------------------------------------------
          000 |  500ms |                                   2kHz  
    ----------------------------------------------------------------
      | Ԥʱ(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
      | Ƶ(Hz) | ռձ(%) | ʱ(ms) | ʱ(ms)
    --------------------------------------------------------------*/
     /*  1  */           2000,         50,       450,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/  
  },

  {
    /*==============================================================
      | ܳ |                  
    ----------+--------+--------------------------------------------
          001 |  980ms |                                   2kHz  
    ----------------------------------------------------------------
      | Ԥʱ(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
      | Ƶ(Hz) | ռձ(%) | ʱ(ms) | ʱ(ms)
    --------------------------------------------------------------*/
     /*  1  */           2000,         50,       930,         850,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/  
  },
  
  {
    /*==============================================================
      | ܳ |                  
    ----------+--------+--------------------------------------------
          002 |  550ms |                     ״ʾ,800Hz  
    ----------------------------------------------------------------
      | Ԥʱ(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
      | Ƶ(Hz) | ռձ(%) | ʱ(ms) | ʱ(ms)
    --------------------------------------------------------------*/
     /*  1  */            800,         50,       500,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/  
  },  
  
  {
    /*==============================================================
      | ܳ |                  
    ----------+--------+--------------------------------------------
          003 |  300ms |                     ״ʾ,800Hz
    ----------------------------------------------------------------
      | Ԥʱ(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
      | Ƶ(Hz) | ռձ(%) | ʱ(ms) | ʱ(ms)
    --------------------------------------------------------------*/
     /*  1  */            800,         50,       250,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },  
  
  {
    /*==============================================================
      | ܳ |                  
    ----------+--------+--------------------------------------------
          004 |  175ms |                     ״ʾ,800Hz
    ----------------------------------------------------------------
      | Ԥʱ(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
      | Ƶ(Hz) | ռձ(%) | ʱ(ms) | ʱ(ms)
    --------------------------------------------------------------*/
     /*  1  */            800,         50,       125,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },
  
  {
    /*==============================================================
      | ܳ |                  
    ----------+--------+--------------------------------------------
          005 |   53ms |                             תʾTick
    ----------------------------------------------------------------
      | Ԥʱ(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
      | Ƶ(Hz) | ռձ(%) | ʱ(ms) | ʱ(ms)
    --------------------------------------------------------------*/
    // /*  1  */           2800,         50,         3,           0,
     /*  1  */            425,         50,         9,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },
  
  {
    /*==============================================================
      | ܳ |                  
    ----------+--------+--------------------------------------------
          006 |   52ms |                             תʾTock
    ----------------------------------------------------------------
      | Ԥʱ(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
      | Ƶ(Hz) | ռձ(%) | ʱ(ms) | ʱ(ms)
    --------------------------------------------------------------*/
     /*  1  */           3750,         50,         2,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  }, 
  
  {
    /*==============================================================
      | ܳ |                  
    ----------+--------+--------------------------------------------
          007 |  980ms |                       ͨʾ,660Hz
    ----------------------------------------------------------------
      | Ԥʱ(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
      | Ƶ(Hz) | ռձ(%) | ʱ(ms) | ʱ(ms)
    --------------------------------------------------------------*/
     /*  1  */            660,         50,       930,         850,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  }, 
  
  {
    /*==============================================================
      | ܳ |                  
    ----------+--------+--------------------------------------------
          008 |  980ms |                       ͨʾ,784Hz
    ----------------------------------------------------------------
      | Ԥʱ(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
      | Ƶ(Hz) | ռձ(%) | ʱ(ms) | ʱ(ms)
    --------------------------------------------------------------*/
     /*  1  */            784,         50,       930,         850,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  }, 
  
  {
    /*==============================================================
      | ܳ |                  
    ----------+--------+--------------------------------------------
          009 |  980ms |                      ͨʾ,1000Hz
    ----------------------------------------------------------------
      | Ԥʱ(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
      | Ƶ(Hz) | ռձ(%) | ʱ(ms) | ʱ(ms)
    --------------------------------------------------------------*/
     /*  1  */           1000,         50,       930,         850,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  }, 
  
  {
    /*==============================================================
      | ܳ |                  
    ----------+--------+--------------------------------------------
          010 |  980ms |              ˫ʾ,1000Hz + 784Hz
    ----------------------------------------------------------------
      | Ԥʱ(ms) |
    --------------------------------------------------------------*/
             3,              50,
    /*--------------------------------------------------------------
      | Ƶ(Hz) | ռձ(%) | ʱ(ms) | ʱ(ms)
    --------------------------------------------------------------*/
     /*  1  */           1000,         50,       200,         150,
     /*  2  */              0,          0,        20,           0,
     /*  3  */            784,         50,       710,         620,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },   
  
  {
    /*==============================================================
      | ܳ |                  
    ----------+--------+--------------------------------------------
          011 |  500ms |                                  850Hz
    ----------------------------------------------------------------
      | Ԥʱ(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
      | Ƶ(Hz) | ռձ(%) | ʱ(ms) | ʱ(ms)
    --------------------------------------------------------------*/
     /*  1  */            850,         50,       450,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },  
};

/******************************************************************************

******************************************************************************/
#define   SND_TRACK_TOTAL_NUM               (sizeof(SndTracks) / sizeof(SndTrackStruct)) 

#endif