/****************************************************************/
#include "Common.h"

uint8_t   RSB_P;
uint8_t   RX_BUF[cnRSBufLen];    //ڽջ
uint8_t   TX_BUF[cnRSBufLen];    //ڷͻ
//ACK
#pragma INTO_ROM
const uint8_t CommandACK[5] =
{
  cnUASTHandH,	  // ڽϢͷλ
  cnUASTHandL,  	// ڽϢͷλ
  2,
  comACK,   	// ACK
  (uint8_t)(2 + comACK),
};
//NCK
#pragma INTO_ROM
const uint8_t CommandNCK[5] =
{
  cnUASTHandH,	 // ڽϢͷλ
  cnUASTHandL,   // ڽϢͷλ
  2,
  comNCK,   // NACK
  (uint8_t)(2 + comNCK),
};
//---------------------------------------------------------------------------
//дӦRAM׵ַ
#pragma INTO_ROM

const uint8_t *CommandRAMIF[16] 	=
{
  (uint8_t *)0,
  (uint8_t *)0,
  (uint8_t *) &CSBFrJDTB[1],	  //Ųܶ ٱ
  (uint8_t *) &ZSBFrJDTB[1],    //Ųܶ תٱ
  (uint8_t *)0,//&KPuls_cs,     //Ųܶ
  (uint8_t *)0,			            //Ųܶ
  (uint8_t *) &SUIBVJDTB[0],    //Ųܶ ˮ±
  (uint8_t *) &YOUBVJDTB[0],    //Ųܶ ȼͱ
  (uint8_t *)0,        		      //
  (uint8_t *)0,                 //
  (uint8_t *)0,      		        //
  (uint8_t *)0,//&CSB_SS_FrHL,  //Ųܶ
  (uint8_t *)0,//&ZSB_SS_FrHL,  //Ųܶ
  (uint8_t *)0,//&SBInputV,     //Ųܶ
  (uint8_t *)0,//&YBInputV,	  	//Ųܶ
  (uint8_t *)0,//&CJINF[0]      //Ųܶ
};
/**************************************************
򴮿ڷ1ֽ
***************************************************/
void SendByteToUART(uint8_t myByte)
{
  wdt_reset();                  //λŹʱ
  while (SCI0SR1_TDRE == 0);	  //ȴͻ
  SCI0DRL = myByte;
}
/**************************************************
򴮿ڷ1ֽ(ڵ)
***************************************************/
void SendWordToUART(uint16_t myWord)
{
  uint8_t *mP;
  mP = (uint8_t *)&myWord;
  SendByteToUART(mP[0]);
  SendByteToUART(mP[1]);
}
/**************************************************
ROMеһݴӴڷͳȥ
***************************************************/
void SendRomStrToUART(uint8_t *myROMADR, uint8_t mDataLen)
{
  uint8_t i;
  for (i = 0; i < mDataLen; i++)
  {
    SendByteToUART(myROMADR[i]); //򴮿ڷ1ֽ
  }
}
/**************************************************
ACK
***************************************************/
void SendACKToSBEI(void)
{
  SendRomStrToUART((uint8_t *)CommandACK, sizeof(CommandACK)); //ACK
}
/**************************************************
//ʼڽճ
***************************************************/
void InitUARTRecvP(void)
{
  cli();                        //ֹȫж
  RSB_P = 0;
  sei();                        //ȫж
}
/**************************************************
ڽճ(19200.ò)
:=1ʾյһ֡
***************************************************/
INT8U UARTRecvieP(void)
{
  if ((RSB_P >= 1) && (RX_BUF[0] != cnUASTHandH))
    goto UARTRciP1;

  if ((RSB_P >= 2) && (RX_BUF[1] != cnUASTHandL))
    goto UARTRciP1;

  if ((RSB_P >= 3) && (RX_BUF[2] > cnRSDatLen))
    goto UARTRciP1;

  if (RSB_P >= (RX_BUF[2] + 3))
    return 1;
  else
    return 0;
  
UARTRciP1:
  InitUARTRecvP();              //ʼڽճ
  return 0;
}
/*****************************************************************************
 жϴڽܻǷյȷ
 :=0ʾȷ,COPYݵͻ,ҺԶջ,¿ʼ
      =1ʾݲȷ,ҺԶջ,¿ʼ
      =2ʾûյ
*****************************************************************************/
INT8U RSSRecivJudge(void)
{
  INT8U i;
  INT8U mCC = 0;

  if (!UARTRecvieP())                    //յһ֡
    return 2;                            //no

  for (i = 0; i < RX_BUF[2]; i++)
    mCC = mCC + RX_BUF[2 + i];

  if (mCC == RX_BUF[RX_BUF[2] + 2])
  {
    for (i = 0; i < cnRSBufLen; i++)     //COPYڽջݵڷͻ
      TX_BUF[i] = RX_BUF[i];

    InitUARTRecvP();                     //ʼ򿪴ڽճ
    return 0;
  }
  else
  {
    InitUARTRecvP();                    //ʼ򿪴ڽճ
    return 1;
  }
}
/***************************************************
ݷͻ,,ֽRAM׵ַ
:ͻ
***************************************************/
INT8U *JSRAMADRGJLXN(void)
{
  return  TX_BUF[4] * TX_BUF[5] + (INT8U *)CommandRAMIF[TX_BUF[3] & 0x0F];
}
/***************************************************
Ķ
:ڷͻ
***************************************************/
void ReadDataCOMPRG(void)
{
  INT8U i;
  INT8U *pRAMAdr;
  
  TX_BUF[2] = TX_BUF[2] + TX_BUF[5];
  pRAMAdr = JSRAMADRGJLXN();                //ݷͻ,,ֽRAM׵ַ
  
  for (i = 0; i < TX_BUF[5]; i++)
    TX_BUF[6 + i] = *(pRAMAdr + i);
  JSCCSendDataToYQ();                       //㷢ͻCCݵ
}
/***************************************************
㷢ͻCCݵ
***************************************************/
void JSCCSendDataToYQ(void)
{
  INT8U i;
  INT8U mCC = 0;

  for (i = 0; i < TX_BUF[2]; i++)
    mCC = mCC + TX_BUF[2 + i];

  TX_BUF[TX_BUF[2] + 2] = mCC;

  for (i = 0; i < (TX_BUF[2] + 3); i++)
    SendByteToUART(TX_BUF[i]);
}
/***************************************************
д
:ڷͻ
(ע:,д,תٱ,,ˮ,Ҫ±ĿǶ
***************************************************/
void WriteDataCOMPRG(void)
{
  INT8U i;
  INT8U *pRAMAdr;
  INT8U mTPE;

  pRAMAdr = JSRAMADRGJLXN();                //ݷͻ,,ֽRAM׵ַ

  for (i = 0; i < TX_BUF[5]; i++)
    *(pRAMAdr + i) = TX_BUF[6 + i];

  mTPE = TX_BUF[3] & 0x0F;

  if (mTPE == 2)          //
    STEPPER_MOTOR_0_DST_STEP = *((INT16U *)(pRAMAdr + 2)); 
  if (mTPE == 3)          //
    STEPPER_MOTOR_3_DST_STEP = *((INT16U *)(pRAMAdr + 2)); 
  if (mTPE == 6)          //                         
    STEPPER_MOTOR_1_DST_STEP = *((INT16U *)(pRAMAdr + 2));   
  if (mTPE == 7)          //                           
    STEPPER_MOTOR_2_DST_STEP = *((INT16U *)(pRAMAdr + 2));   
}

