/********************************************************************************/
/*  CONFIDENTIAL                                                                */
/*  Copyright (C) 2011 Yamaha Corporation. All rights reserved.                 */
/*  Module          : $Workfile: LCD_AUOC035QAN01.h $                             */
/*  Description     : Clock, DisplayScan Prameter Include header                */
/*  Version         : $Rev: 89 $                                                */
/*  Last UpDate Time: $Date:: 2012-05-31 17:57:20#$                             */
/*  FOOT NOTE       : adjust 4tab                                               */
/*  AUTHOR          : H.Katayama                                                */
/********************************************************************************/

#ifndef _LCD_AUOC035QAN01_
#define _LCD_AUOC035QAN01_

/*------------------------------------------------------------------------------*/
/*                      D E F I N E                                             */
/*------------------------------------------------------------------------------*/
/********************************************************************************/
/* WQVGA LCD HannStar HSD043I9W1                                                */
/* DotClock: 9.529MHz                                                           */
/* 480~272 Digital interface TFT                                               */
/********************************************************************************/
/************************************************************************/
/*                      Clock Setting                                   */
/************************************************************************/
/*----------------------------------------------------------------------*/
/* DotClock , System Clock <Common>                                     */
/* PLLCTL[2:0]      = 'LLL'                                             */
/* XIN              = 10MHz  DTCKIN x  ----------->* Dot Clock  32MHZ   */
/* DTCKIN           = ---                 |   -----                     */
/* Dot Clock        = XIN                 *->| PLL |->* System Clock    */
/* System Clock     = 100MHz                  -----                     */
/* DTCKS_N Pin    = 'H'                                               */
/* TCON Pin       = 'L'                                               */
/*----------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*/
/*                      S T R U C T                                             */
/*------------------------------------------------------------------------------*/
typedef struct 
{
	uint8_t Clk[3];			/* Clock data				*/
	uint8_t Disp[23];		/* Display scan data		*/
	uint8_t VideoOut;		/* Video Output Control		*/
	uint8_t TCON[23];		/* Timing controller data	*/
} T_YVC1_DATA;

const T_YVC1_DATA tYvc1Data = 
{
	/*----------------------------------*/
	/* Clock : Clk[3]					*/
	/*----------------------------------*/
	{				/*           |  D7   |  D6   |  D5   |  D4   |  D3   |  D2   |  D1   |  D0   |  */
		0x00,	/*  0: R#01h | PLLR[4:0]                             |  "0"  |  "0"  | PLL[8]|  */
		0x4E,	/*  1: R#02h | PLLF[7:0]                                                     |  */
		0x97,	/*  2: R#03h | DTDEL | REVCK |              DTDV[5:0]                        |  */	/* DTDV=4(fDOCLK=40MHz) -> 6(fDOCLK=28.57MHz) (2013.07.29) */
	},
	/*----------------------------------*/
	/* Display scan : Disp[23]			*/
	/*----------------------------------*/
	{				/*           |  D7   |  D6   |  D5   |  D4   |  D3   |  D2   |  D1   |  D0   |  */

		0x11,	/*  0: R#06h |  "0"  |  "0"  | CSYOE | VSTM  | REVSY | REVBL | VTL[9:8]      |  */
		0x4E,	/*  1: R#07h | VTL[7:0]                                                      |  */	/* VTL=996(0x3E4) -> 833(0x341) (2013.07.29) */
		0x01,	/*  2: R#08h |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  | HTL[10:8]             |  */
		0x3F,	/*  3: R#09h | HTL[7:0]                                                      |  */	/* HTL=559(0x22F) -> 567(0x237) (2013.07.29) */
		0x01,	/*  4: R#0Ah |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  | VBLS[9:8]     |  */
		0x4B,	/*  5: R#0Bh | VBLS[7:0]                                                     |  */	/* VBLS=803(0x323) -> 805(0x325) (2013.07.29) */
		0x01,	/*  6: R#0Ch |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  | HBLS[10:8]            |  */
		0x2F,	/*  7: R#0Dh | HBLS[7:0]                                                     |  */	/* HBLS=498(0x1F2) -> 500(0x1F4) (2013.07.29) */
		0x00,	/*  8: R#0Eh |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  | VBLE[9:8]     |  */
		0x0B,	/*  9: R#0Fh | VBLE[7:0]                                                     |  */	/* VBLE=3(0x003) -> 5(0x005) (2013.07.29) */
		0x00,	/* 10: R#10h |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  | HBLE[10:8]            |  */
		0x3F,	/* 11: R#11h | HBLE[7:0]                                                     |  */	/* HBLE=18(0x012) -> 20(0x014) (2013.07.29) */
		0x08,	/* 12: R#12h | PDDS[4:0]                             | NMCMD | VDS[9:8]      |  */	/* PDDS=1(0x01), NMCMD=0 */
		0x0C,	/* 13: R#13h | VDS[7:0]                                                      |  */	/* VDS=5(0x005) */
		0x00,	/* 14: R#14h |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  | HDS[10:8]             |  */
		0x40,	/* 15: R#15h | HDS[7:0]                                                      |  */	/* HDS=20(0x014) */
		0x01,	/* 16: R#16h |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  | VDE[9:8]      |  */
		0x4A,	/* 17: R#17h | VDE[7:0]                                                      |  */	/* VDE=801(0x321) -> 805(0x325) (2013.07.29) */
    0x01,	/* 18: R#18h |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  | HDE[10:8]             |  */
		0x2E,	/* 19: R#19h | HDE[7:0]                                                      |  */	/* HDE=496(0x1F0) -> 500(0x1F4) (2013.07.29) */
    0x05,	/* 20: R#1Ah |  "0"  |  "0"  |   HSW[9:8]    |            VSW[3:0]           |  */	/* VSW=1(0x1) */
		0x0F,	/* 21: R#1Bh | HSW[7:0]                                                      |  */	/* HSW=4(0x004) */
		0x03,	/* 22: R#1Ch |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  | SYEN  | DTEN  |  */
	},
	/*----------------------------------*/
	/* Video Output Control : VideoOut	*/
	/*----------------------------------*/
	{				/*           |  D7   |  D6   |  D5   |  D4   |  D3   |  D2   |  D1   |  D0   |  */
		0x00,	/*  0: R#31h |  "0"  |  "0"  |  "0"  |  "0"  |  "0"  | FRCE  | FRCM  | VOBSEL|  */
	},
	/*----------------------------------*/
	/* T-CON : TCON[23]					*/
	/*----------------------------------*/
	/* gp */
	{				/*           |  D7   |  D6   |  D5   |  D4   |  D3   |  D2   |  D1   |  D0   |  */
		0x00,	/*  0: R#67h | REVSH |  "0"  | STHE[10:8]                                    |  */
		0x00,	/*  1: R#68h | STHE[7:0]                                                     |  */
		0x00,	/*  2: R#69h | STHS[7:0]                                                     |  */
		0x00,	/*  3: R#6Ah | REVLH |  "0"  | LDHE[10:8]            | LDHS[10:8]            |  */
		0x00,	/*  4: R#6Bh | LDHE[7:0]                                                     |  */
		0x00,	/*  5: R#6Ch | LDHS[7:0]                                                     |  */
		0x00,	/*  6: R#6Dh | REVCV |  "0"  | CKVE[10:8]            | CKVS[10:8]            |  */
		0x00,	/*  7: R#6Eh | CKVE[7:0]                                                     |  */
		0x00,	/*  8: R#6Fh | CKVS[7:0]                                                     |  */
		0x00,	/*  9: R#70h | REVSV | REVSVV|  "0"  |  "0"  | STVEV[9:8]   | STVSV[9:8]     |  */
		0x00,	/* 10: R#71h | STVEV[7:0]                                                    |  */
		0x00,	/* 11: R#72h | STVSV[7:0]                                                    |  */
		0x00,	/* 12: R#73h | REVSVH|  "0"  | STVEH[10:8]           | STVSH[10:8]           |  */
		0x00,	/* 13: R#74h | STVEH[7:0]                                                    |  */
		0x00,	/* 14: R#75h | STVSH[7:0]                                                    |  */
		0x00,	/* 15: R#76h | REVOE | REVOEV|  "0"  |  "0"  | OEEV[9:8]     | OESV[9:8]     |  */
		0x00,	/* 16: R#77h | OEEV[7:0]                                                     |  */
		0x00,	/* 17: R#78h | OESV[7:0]                                                     |  */
		0x00,	/* 18: R#79h | REVOEH|  "0"  | OEEH[10:8]            | OESH[10:8]            |  */
		0x00,	/* 19: R#7Ah | OEEH[7:0]                                                     |  */
		0x00,	/* 20: R#7Bh | OESH[7:0]                                                     |  */
		0x00,	/* 21: R#7Ch | POLEN |  "0"  | POLM[2:0]             | POLP[10:8]            |  */
		0x00	/* 22: R#7Dh | POLP[7:0]                                                     |  */
	},
};

#endif /* _LCD_AUOC035QAN01_	*/

/* ----------------------------- E O F ----------------------------------------*/

