/******************************************************************************
  SCI1_UART.h
UARTģʽSCI1ͷļ
    ߣ
    V1.0
    ڣ2016.11.17
******************************************************************************/

#ifndef _SCI1_UART_H_
#define _SCI1_UART_H_

#include "GPIO.h"
#include "CRG.h"
#include "comdef.h"

/******************************************************************************
UART 
******************************************************************************/
#define   SCI1_GPIO_SELECT                  SCI1_PH1_PH0
#define   SCI1_BAUD_RATE                    19200
#define   SCI1_FORMAT                       SCI1_8BIT_1STOP
#define   SCI1_PARITY_FUNC                  SCI1_PARITY_FUNC_DISABLE
#define   SCI1_PARITY_TYPE                  SCI1_EVEN_PARITY

#define   SCI1_Tx_BUFFER_SIZE               32

/******************************************************************************
UART ѡ
******************************************************************************/
/*** SCI1õGPIO ***/
#define   SCI1_PH1_PH0                      0x00
#define   SCI1_PM1_PM0                      0x01

/*** UARTʽ ***/
#define   SCI1_8BIT_1STOP                   0x00
#define   SCI1_9BIT_1STOP                   0x10

/*** żУʹ ***/
#define   SCI1_PARITY_FUNC_DISABLE          0x00
#define   SCI1_PARITY_FUNC_ENABLE           0x02

/*** żУѡ ***/
#define   SCI1_EVEN_PARITY                  0x00
#define   SCI1_ODD_PARITY                   0x01

/******************************************************************************
ĴֵԤ
******************************************************************************/
#define   SCI1_BAUD_RATE_REG                ((uint16_t)(BUSCLK / 16 / SCI1_BAUD_RATE) & 0x1FFF)
#define   SCI1_CFG_REG                      (SCI1_FORMAT | SCI1_PARITY_FUNC | SCI1_PARITY_TYPE)

/******************************************************************************
ͻṹ
******************************************************************************/
typedef struct
{
  uint8_t Data[SCI1_Tx_BUFFER_SIZE];
  uint8_t Len;
} SCI1TxBufferStruct;

/******************************************************************************

******************************************************************************/
void SCI1_UART_Byte_Rx(uint8_t Data);
void SCI1_UART_Byte_Tx(uint8_t Data);
void SCI1_UART_Block_Tx(uint8_t *Data, uint8_t Len);
uint8_t SCI1_UART_Get_Tx_Buffer_Status(void);
void SCI1_UART_Init(void);

#endif