/******************************************************************************
  MSCAN0.h
MSCAN0շƺļ
    ߣ
    V1.0
    ڣ2016.5.5
******************************************************************************/
#include "MSCAN0_J1939.h"


uint8_t          WakeUpFlag;
uint8_t          WakeUpID;
extern uint8_t   NM_RECEIVE;
extern uint8_t   sleepFl1g;
extern uint8_t   CanFrameExist;
extern INT8U     BUS_OFF_FLAG;       //----hyq--20180728
extern uint8_t DiagnosticReceived;
uint32_t                      MSCAN0TxID[3];
MSCAN0BusoffMonitorStruct     MSCAN0Busoff;

//
extern void CoCAN_L_Data_Indication(uint32_t Identifier, uint8_t DLC, uint8_t *Data);
//extern void CoCAN_L_Data_Confirm(uint32_t Identifier, uint8_t TransferStatus);

//
extern void DoCAN_L_Data_Indication(uint32_t Identifier, uint8_t dlc, uint8_t *pData);
extern void DoCAN_L_Data_Confirm(uint32_t Identifier, uint8_t TransferStatus);

/*
extern FUNC(void, CANNM_CODE) CanNm_RxIndication 
(
    PduIdType RxPudId,
    const uint16 RxId,
    P2CONST(PduInfoType, AUTOMATIC, CANNM_APPL_DATA)PduInfoPtr   
);

extern FUNC(void, CANNM_CODE) CanNm_TxConfirmation
(
    PduIdType TxPudId
);
*/
/******************************************************************************
MSCAN0_L_Data_Request
   ܣúϲ,Ϸһ鱨
   IdentifierID
        DLC       ĳ
        Data      
        Priority  ȼ 0 - 2 ԽСȼԽ
ֵ
******************************************************************************/

//ⷢĵIDб
static uint16_t CAN_TXIDS[] = {0x26D, 0x315, 0x530, 0x402, 0x7EB};
#define CAN_TXIDS_LEN 5

//CANݷ
void MSCAN0_L_Data_Request(uint32_t Identifier, uint8_t DLC, uint8_t *Data, uint8_t Priority)
{
  uint8_t  i;
  uint8_t  BufSel;

  //MSCANCAN BUSͬ,IDЧ,ݳȴ8,ȼôʱ,ϱʧܲ˳
  if ((CAN0CTL0_SYNCH == 0) || (DLC > 8) || (Priority > 2))
  {
    MSCAN0_L_Data_Confirm(Identifier, NOT_COMPLETE);
    return;
  }

  //IDڷ͵ıID
  /*
  for(i=0; i<CAN_TXIDS_LEN; i++)
  {
    if(Identifier==CAN_TXIDS[i])
	  break;
  }
  if(i>=CAN_TXIDS_LEN)
  	return;
  */
  
  //ͻָ
  BufSel = (0x01 << Priority);
  
  //ǰȼķͻΪʱ,ϱʧܲ˳
  if (CAN0TFLG & BufSel == 0)
  {
    MSCAN0_L_Data_Confirm(Identifier, NOT_COMPLETE);
    return;
  }

  //ǰһαķδõBuffer
  if (MSCAN0TxID[Priority] != 0xFFFFFFFF)
    MSCAN0_L_Data_Confirm(MSCAN0TxID[Priority], NOT_COMPLETE);
  
  MSCAN0TxID[Priority] = Identifier;        //ID

  //!!Ĵ
  //ѡָָķͻ
  CAN0TBSEL  = BufSel;   		            
  //дʶID
  CAN0TXIDR0 =  (uint8_t)(Identifier >> 21);
  CAN0TXIDR1 =  ((uint8_t)(Identifier >> 13) & 0xE0) | ((uint8_t)(Identifier >> 15) & 0x07);
  CAN0TXIDR2 =  (uint8_t)(Identifier >> 7);
  CAN0TXIDR3 =  (uint8_t)(Identifier << 1) & 0xFE;

  //ͣչ֡
  CAN0TXIDR1_SRR = 1;
  CAN0TXIDR1_IDE = 1;

  //д
  for (i = 0; i < DLC; i++)
    *((&CAN0TXDSR0)+i) = Data[i];
  
  CAN0TXDLR = DLC;//DLC
  
  //CAN0TXTBPR = 0;                         //ȼ,Bufferȼͬ,BufferIDԽС,ȼԽ
  CAN0TFLG  = BufSel;                       //
  CAN0TIER |= BufSel;                       //ӦCANж
  //end
}

/******************************************************************************
MSCAN0_L_Data_Indication
  ܣ úϲָʾһ֡ĵĵ,ͬʱݴϲ
        ע⣺1.ʹʱӦϲıĴݺڱ֮,ĵʱ
                Ӧĺݱ
              2.ж,õϲıĴݺӦܼ
   IdentifierID
        DLC       ĳ
        Data      
ֵ
******************************************************************************/
//չ֡ݽ
unsigned long recv_id = 0UL;
void MSCAN0_L_Data_Indication(uint32_t Identifier, uint8_t DLC, uint8_t *Data)
{

  MSCANIDStruct * pID = (MSCANIDStruct*)(&Identifier);
  //Ĵ
  //ı
  //if(pID->PS==0x28 || pID->PS==0xBF || Identifier==0x1810A6A0)  //----hyq--20180728  ID
  recv_id =               Identifier;
  if ((Identifier == 0x18DB33F1UL) || (Identifier == 0x18DAFCF1UL))
  {
    DoCAN_L_Data_Indication ( Identifier, DLC, Data );
  }
  else
  {
    CoCAN_L_Data_Indication(Identifier, DLC, Data);
    }
}

/******************************************************************************
MSCAN0_L_Data_Confirm
  ܣúϲָʾ͵ıĵķͽ
        ע⣺1.ʹʱӦϲıķͽݺڱ֮,ķ
                ʱӦĺݱķͽ
              2.ж,õϲıķͽݺӦܼ
  Identifier    ID
       TransferStatusķͽCOMPLETE     
                                     NOT_COMPLETE δܷ
ֵ
******************************************************************************/
void MSCAN0_L_Data_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
  if (Identifier == 0x7EB)//0x7EBǱӦID
  {
    DoCAN_L_Data_Confirm(Identifier, TransferStatus);
  }
  //
  else if( ( Identifier >= 0x400 ) && ( Identifier <= 0x47F ) )
  {
    ;//CanNm_TxConfirmation(0);
  }
}

/******************************************************************************
MSCAN0_Bus_Off_Monitoring_Service
   ܣMSCAN0 Bus-off״̬ط,Bus-off״̬Իָ
   
ֵ
*******************************************************************************
ע  ⣺÷ÿ20msһ
******************************************************************************/
void MSCAN0_Bus_Off_Monitoring_Service(void)
{
  #if !MSCAN0_BUS_OFF_AUTO_RECOVERY
    #if MSCAN0_BUS_LIMP_MODE_ENABLE
	  //CANѾģʽ(λָʧ),ٻָ
      if (MSCAN0Busoff.Status == MSCAN0_BUS_LIMP)
        return;
    #endif
    //Bus-off
    if (CAN0MISC_BOHOLD)
    {
      MSCAN0Busoff.Timer++;//bus off ʱ
      //һbus off״̬
      if(MSCAN0Busoff.Status == MSCAN0_BUS_STABLE)
        MSCAN0Busoff.Status = MSCAN0_BUS_OFF_LV1;

	  //һbus off״̬
      if (MSCAN0Busoff.Status == MSCAN0_BUS_OFF_LV1)
      {
        if (MSCAN0Busoff.Timer >= MSCAN0_BUS_OFF_LV1_RECOVERY_TIME / 20)
        {
          MSCAN0Busoff.Timer = 0;
          
          CAN0MISC_BOHOLD = 1;                      //д1,ָBus-off

          MSCAN0Busoff.Cnt++;
		  //bus off 
          if (MSCAN0Busoff.Cnt >= 10)
          {
            BUS_OFF_FLAG = 1;
            MSCAN0Busoff.Cnt = 0;
            MSCAN0Busoff.Status = MSCAN0_BUS_OFF_LV2;
          }
        }
      }
	  //ģʽ
      else if (MSCAN0Busoff.Status == MSCAN0_BUS_OFF_LV2)
      {
        if (MSCAN0Busoff.Timer >= MSCAN0_BUS_OFF_LV2_RECOVERY_TIME / 20)
        {
          MSCAN0Busoff.Timer = 0;
          
          CAN0MISC_BOHOLD = 1;                      //д1,ָBus-off
        }

		//ģʽ
        #if MSCAN0_BUS_LIMP_MODE_ENABLE         
          MSCAN0Busoff.Cnt++;
          if (MSCAN0Busoff.Cnt > MSCAN0_BUS_LIMP_MODE_THRESHOLD)
          {
            MSCAN0Busoff.Cnt = 0;
            
            MSCAN0Busoff.Status = MSCAN0_BUS_LIMP;  //CANģʽ
            CAN0_PHY_STB = 1;                       //ʡģʽ
            MSCAN0_Init();				            //ͨʼֹCANշ
            CAN0RIER_RXFIE = 0;   		            //ֹCANж
            CAN0RIER_WUPIE = 0;                     //رջж
            CAN0CTL0_WUPE  = 0;                     //ֹʹ
            if (CAN0RFLG_WUPIF)
              CAN0RFLG_WUPIF = 1;                   //лж־Ҳһ(д1)
          }
        #endif
      }
    }
    else                                          //,ûBus-off
    { 
      BUS_OFF_FLAG = 0;
      MSCAN0Busoff.Status = MSCAN0_BUS_STABLE;
      MSCAN0Busoff.Timer = 0;
      MSCAN0Busoff.Cnt   = 0;
    }
  #endif
}

/******************************************************************************
MSCAN0_Get_Bus_Status
  ܣȡMSCAN0״̬
  
ֵMSCAN0_BUS_STABLE,ȶ
        MSCAN0_BUS_OFF   ߴBus-off״̬
        MSCAN0_BUS_LIMP  ߴ״̬(Bus-offλָʧܶر)
******************************************************************************/
uint8_t MSCAN0_Get_Bus_Status(void)
{
  return MSCAN0Busoff.Status;
}

/******************************************************************************
MSCAN0_Init
  ܣMSCAN0ʼ
  
ֵ
******************************************************************************/
void MSCAN0_Init(void)  
{
  uint8_t i;
  
  CAN0CTL0 = 0x01;            // MSCANʼģʽ					
  while(!(CAN0CTL1_INITAK));  //ȴʼģʽ

  CAN0IDAC = 0;   		        //ռĴĹʽ  two 32-bit filter 
	
  CAN0IDAR0 = 0x00;     	    //ռĴ
  CAN0IDAR1 = 0x00;
  CAN0IDAR2 = 0x00;
  CAN0IDAR3 = 0x00;

  CAN0IDMR0 = 0xFF;             //μĴ (ΪбID)
  CAN0IDMR1 = 0xFF; 
  CAN0IDMR2 = 0xFF;
  CAN0IDMR3 = 0xFF;
  
  CAN0IDAR4 = 0x00;      	    //ռĴ
  CAN0IDAR5 = 0x00; 
  CAN0IDAR6 = 0x00;
  CAN0IDAR7 = 0x00;
  
  CAN0IDMR4 = 0xFF;           //μĴ (ΪбID)
  CAN0IDMR5 = 0xFF;
  CAN0IDMR6 = 0xFF;
  CAN0IDMR7 = 0xFF;
  
  CAN0CTL1_CANE   = 1;        //ʹMSCANģ
  CAN0CTL1_CLKSRC = 0;        //ѡOSCCLK(8MHz)ΪMSCANʱԴ
  CAN0CTL1_LISTEN = 0;        //ģʽ(Ǽģʽ)
  
  #if MSCAN0_BUS_OFF_AUTO_RECOVERY
    CAN0CTL1_BORM = 0;	      //ԶBUS_OFFָ
  #else
    CAN0CTL1_BORM = 1;	      //BUS_OFFûƻָ
  #endif
    
  CAN0CTL1_WUPM = 1;		      //Ѽ˲ 
  
  CAN0BTR0 = 0X43;            // 0x4314 250k  0x802B 500K
  CAN0BTR1 = 0X14;

  //˳ʼģʽ
  CAN0CTL0 = 0x00;            
  while (CAN0CTL1_INITAK);    //ȴ˳ʼģʽ
  while (!CAN0CTL0_SYNCH);    //ȴMSCANCANͬ
 	
  CAN0TIER = 0x00;            //ֹCANж  

  //CANյݺж
  CAN0RIER_RXFIE = 1;   	  //ʹCANж
  CAN0RIER_WUPIE = 1;         //ʹWakeUPж
  
  CAN0_STB = 0;   	          //ʹCANշ
	
  MSCAN0Busoff.Status = MSCAN0_BUS_STABLE;
  MSCAN0Busoff.Timer = 0;
  
  #if MSCAN0_BUS_LIMP_MODE_ENABLE 
    MSCAN0Busoff.Cnt   = 0; 
  #endif

  for(i = 0; i < 3; i++)
    MSCAN0TxID[i] = 0xFFFF;   //0xFFFFʾЧID
}

/******************************************************************************
MSCAN0_Enter_Low_Power_Mode
  ܣMSCAN0͹ģʽ
  
ֵ
******************************************************************************/
void MSCAN0_Enter_Low_Power_Mode(void)
{
  MSCAN0_Init();              //͸ʼֹCANշ
  
  CAN0_STB = 1;   	          //ʹCANշ
  
  if(CAN0RFLG_WUPIF)          //ж־ = 1 д10
    CAN0RFLG_WUPIF = 1;
  CAN0CTL0_WUPE = 1;			    //ʹ
	
	//1,MSCANз(Ͷп),Ҳ(CAN߿),
	//MSCAN SLEEPģʽ, CAN0CTL1_SLPAK=1ʾȷ
	//ôλǰ CAN0RFLG_WUPIF 
          
	//CAN0CTL0_SLPRQ=1,CAN0CTL1_SLPAK=1 ,ʾMSCANѾ˯ģʽ
	CAN0CTL0_SLPRQ = 1;			    //MSCAN˯ģʽ  
	
	//MSCAN˯ģʽ, CAN0CTL0_WUPE = 1 յCANĺ,MSCAN˳˯,CAN0RFLG_WUPIF1
	//ͬʱ CAN0CTL0_SLPRQ,CAN0CTL1_SLPAK ҲԶ0.   
	
	//MSCAN˯ģʽ,ҲCAN0CTL0_SLPRQ = 0,ʹMSCAN˳˯,CAN0CTL1_SLPAK ҲԶ0. 
	// CAN0CTL0_SLPRQ = 1,MSCANûн˯ģʽ,ôCAN0CTL0_SLPRQ = 0.

  CAN0TARQ = 0x07;            //ֹбķ.
  
  //CAN0RIER_RXFIE = 0;   			//ֹCANж
}

/******************************************************************************
MSCAN0_Exit_Low_Power_Mode
  ܣMSCAN0˳͹ģʽ
  
ֵ
******************************************************************************/
void MSCAN0_Exit_Low_Power_Mode(void)
{
  CAN0CTL0_SLPRQ = 0;         //ʹMSCAN˳˯
  
  if(CAN0RFLG_WUPIF)          //ж־ = 1 д10
    CAN0RFLG_WUPIF = 1;
  CAN0CTL0_WUPE = 0;			    //ûѹ
  
  CAN0_STB = 0;               //ʹCANշ
  
  CAN0RIER_RXFIE = 1;   			//ʹCANж
}

/******************************************************************************
MSCAN0_Get_Wake_Up_Flag
  ܣȡMSCAN0Ļ״̬
  
ֵ0 - δ 1 - ѱ
******************************************************************************/
uint8_t MSCAN0_Get_Wake_Up_Flag(void)
{
  if (CAN0CTL0_SLPRQ == 0)
    return 1;
  
  //if (WakeUpFlag)
  //{
  //  WakeUpFlag = 0;
  //  return 1;
  //}
  
  return 0;
}

#pragma CODE_SEG __NEAR_SEG NON_BANKED   	//жϺFLASHķǷҳ

/******************************************************************************
MSCAN0_TX_ISR
   ܣMSCAN0жϷ
        CANķϻֹʱִд˺
   
ֵ
******************************************************************************/
void interrupt MSCAN0_TX_ISR(void)
{
  uint8_t i;
  uint8_t TxFlag;
  uint8_t TxBuf;
  uint8_t BufDetect;
  
  do
  {
    TxFlag = CAN0TFLG;
    
    TxBuf = CAN0TIER & TxFlag;              //ȡϻֹ͵ıBuffer
    CAN0TIER &= ~TxBuf;                     //رշϻֹ͵ıBufferӦж
    
    BufDetect = 1;
    for (i = 0; i < 3; i++)
    {
      if (BufDetect & TxBuf)
      {
        if (BufDetect & CAN0TAAK)           //ıɹֹ
          MSCAN0_L_Data_Confirm(MSCAN0TxID[i], NOT_COMPLETE);
        else                                //ķͳɹ
          MSCAN0_L_Data_Confirm(MSCAN0TxID[i], COMPLETE);
          
        MSCAN0TxID[i] = 0xFFFF;             //ļ¼
      }
      
      BufDetect <<= 1;
    }
  }
  while (TxFlag != CAN0TFLG);               //жϴڼµıķ

  //end
}

/******************************************************************************
MSCAN0_RX_ISR
   ܣMSCAN0жϷ
        CANʹʱCAN
   
ֵ
******************************************************************************/
//J1939ЭRXжϽ
void interrupt MSCAN0_RX_ISR(void)
{
  uint32_t tmp;
  uint32_t CANMsgID;
  
  //CAN0RIER_RXFIE = 0;                      //ȽֹMSCANж

  //ͨ֡
  if(!CAN0RXIDR1_IDE)                        //׼֡ʶ 0 ׼֡ 11 λ 1 չ֡ 29 λ
  {
    CAN0RFLG_RXF   = 1;                      //жϱ־
    CAN0RIER_RXFIE = 1;                      //MSCANж
    return;
  }

  //ݽ
  tmp = (uint32_t)(CAN0RXIDR0) << 21;
  tmp &= 0x1FE00000; 
  CANMsgID =  tmp | ((uint32_t)(CAN0RXIDR1 & 0xE0) <<13) |  ((uint32_t)(CAN0RXIDR1 & 0x07) <<15)
                  | ((uint32_t)(CAN0RXIDR2) << 7)
                  | ((uint32_t)(CAN0RXIDR3) >> 1);//ID
                  
  MSCAN0_L_Data_Indication(CANMsgID, CAN0RXDLR & 0x0F, &CAN0RXDSR0);
  
  CanFrameExist=1;
  CAN0RFLG_RXF   = 1;                      //жϱ־
  //CAN0RIER_RXFIE = 1;                      //MSCANж
  //end
}

/*
void interrupt MSCAN0_RX_ISR(void)
{
  uint16_t CANMsgID;
	
	CAN0RIER_RXFIE = 0;                      //ȽֹMSCANж
	                                
	if (CAN0RXIDR1_IDE || CAN0RXIDR1_SRR)    //յΪչ֡,ΪԶ֡
	{
    CAN0RFLG_RXF=1;                        //жϱ־
		CAN0RIER_RXFIE=1;                      //MSCANж
		
    return;
	}
	
	CANMsgID = ((uint16_t)(CAN0RXIDR0 << 3)) | ((uint16_t)(CAN0RXIDR1 >> 5));

  if((CANMsgID >= 0x400) && (CANMsgID <= 0x47F))
    MSCAN0_L_Data_Indication(CANMsgID, CAN0RXDLR & 0x0F, &CAN0RXDSR0);
  else
  {
  	switch(CANMsgID)
  	{
    	case  0x068 :
    	case  0x268 :
    	case  0x2D7 :
      case  0x4D4 :
      case  0x1C8 :
      case  0x370 :
      case  0x1C9 :
      case  0x0F2 :
      case  0x0E2 :
      case  0x082 :
      case  0x094 :
      case  0x288 :
      case  0x088 :
      case  0x120 :
      case  0x293 :
      case  0x115 :
      case  0x160 :
      case  0x07A :
      case  0x30F :
      case  0x2F1 :
      case  0x10D :
      case  0x7E3 :
      case  0x7DF :
      case  0x279 : MSCAN0_L_Data_Indication(CANMsgID, CAN0RXDLR & 0x0F, &CAN0RXDSR0);
                    break;
      default     : break;
  	}
	}
	
  CAN0RFLG_RXF = 1;                        //жϱ־
	CAN0RIER_RXFIE = 1;                      //MSCANж
}*/

/******************************************************************************
MSCAN0_WAKEUP_ISR
  ܣMSCAN0ж
  
ֵ
******************************************************************************/
void interrupt MSCAN0_WAKEUP_ISR(void)
{
  CAN0RFLG_WUPIF = 1;
  CAN0_STB = 0;             //----hyq--20180806
  WakeUpFlag     = 1;
}
#pragma CODE_SEG DEFAULT

//
/*
Std_ReturnType CanIf_Transmit(PduIdType CanTxPduId, PduInfoType* PduInfoPtr) 
{
  (void)CanTxPduId;
  MSCAN0_L_Data_Request( 0x402, (uint8_t)PduInfoPtr->SduLength, (uint8_t*)PduInfoPtr->SduDataPtr, 0 );
  return E_OK;
} */