/******************************************************************************
  SCI1_UART.c
UARTģʽSCI1ļ
    ߣ
    V1.0
    ڣ2016.11.17
******************************************************************************/

#include "SCI1_UART.h"

SCI1TxBufferStruct  SCI1TxBuffer;

//extern void Disp_Receive_Reply(uint8_t Data);

/******************************************************************************
SCI1_UART_Byte_Rx
  ܣUARTֽڽպ
        ڸúϲĽպ,ϲָʾѽյ,Data
  Dataյ
ֵ
******************************************************************************/
void SCI1_UART_Byte_Rx(uint8_t Data)
{
   uint8_t Parity;

   Parity = SCI1SR1_PF; 
}

/******************************************************************************
SCI1_UART_Byte_Tx
  ܣUARTֽڷͺ
        һֽ,ô˺֮ǰ,ȷBufferǿյ,
        ݵĶʧ
  DataҪ͵
ֵ
******************************************************************************/
void SCI1_UART_Byte_Tx(uint8_t Data)
{
  SCI1DRL = Data;
}

/******************************************************************************
SCI1_UART_Block_Tx
  ܣUART鷢ͺ
        Nֽ,ô˺֮ǰ,ȷBufferǿյ,
        ݵĶʧ
  DataҪ͵
        Len Ҫ͵ݳ
ֵ
******************************************************************************/
void SCI1_UART_Block_Tx(uint8_t *Data, uint8_t Len)
{
  uint8_t i;

  SCI1TxBuffer.Len = Len - 1;
  for (i = 0; i < Len; i++)
    SCI1TxBuffer.Data[Len - i - 1] = Data[i];

  SCI1DRL = SCI1TxBuffer.Data[SCI1TxBuffer.Len];  //͵һֽ
  SCI1CR2_TIE = 1;                                //ʹܷBufferж
}

/******************************************************************************
SCI1_UART_Get_Tx_Buffer_Status
  ܣȡBufferĵǰ״̬
  
ֵ0 - Ŀǰûڷ
        1 - Ŀǰڷ
******************************************************************************/
uint8_t SCI1_UART_Get_Tx_Buffer_Status(void)
{
  if ((SCI1SR1_TDRE != 0) && (SCI1TxBuffer.Len == 0))
    return 0;
  return 1;
}

/******************************************************************************
SCI1_UART_Init
  ܣʼSCI1ΪUARTģʽ,SCI1_UART.hõUART
  
ֵ
******************************************************************************/
void SCI1_UART_Init(void)
{
  SCI1TxBuffer.Len = 0;

  PTHRR   = SCI1_GPIO_SELECT;          //----hyq--20180711 IOӳ

  SCI1BD  = SCI1_BAUD_RATE_REG;
  SCI1CR1 = SCI1_CFG_REG;

  if (SCI1SR1)        //ȡSCI1SR1жϱ־λ
    nop();

  SCI1CR2 = 0x2C;     //ж,ʹշ
}

#pragma CODE_SEG __NEAR_SEG NON_BANKED   	//жϺFLASHķǷҳ

/******************************************************************************
SCI1_ISR
  ܣSCI1жϷ,ڽ
  
ֵ
******************************************************************************/
void interrupt SCI1_ISR(void)
{
  uint8_t SR1Reg;

  SR1Reg = SCI1SR1;

  if (SR1Reg & SCI1SR1_RDRF_MASK)         //յ
  {
    SCI1_UART_Byte_Rx(SCI1DRL);
  }
  else if (SR1Reg & SCI1SR1_TDRE_MASK)    //һηͽ
  {
    if (SCI1TxBuffer.Len)                 //ûз
    {
      SCI1TxBuffer.Len--;                 //һֽ
      SCI1DRL = SCI1TxBuffer.Data[SCI1TxBuffer.Len];
    }
    else                                  //ȫ
      SCI1CR2_TIE = 0;                    //رշBufferж
  }
}

#pragma CODE_SEG DEFAULT
