/******************************************************************************
  TFT_LCD.c
TFTɫҺʾƺļ
    ߣ
    V1.0
    ڣ2017.4.8
******************************************************************************/

#include "TFT_LCD.h"

TFTLCDLayerStatusStruct   TFTLCDLayerStatus[YVC_LYR_NUM_CPU];
TFTLCDLayerBufferStruct   TFTLCDLayer[YVC_LYR_NUM_CPU];

TFTLCDUpdateCtrlStruct    TFTLCDUpdateCtrl;

/******************************************************************************
TFT_LCD_Display_Sprite
  ܣTFTɫҺʾͼ
  LyrId   ͼ 0 - YVC_LYR_NUM_CPU(YvcConfig.h)
        SpriteIDͼƬ()
        PosX    ͼƬʾʾϵx
        PosY    ͼƬʾʾϵy
        Scale   : ͼƬű,Ϊ0.015625(1 / 64),Ϊ64ʱͼƬΪԭʼ
ֵ
******************************************************************************/
void TFT_LCD_Display_Sprite(uint16_t LyrId, uint16_t SpriteID, uint16_t PosX, uint16_t PosY, uint8_t Scale)
{
  if (TFTLCDUpdateCtrl.Enable == 0)
    return;

  if (TFTLCDLayerStatus[LyrId].LyrEn)                 //ͼѾʹ
  {
    if ((TFTLCDLayerStatus[LyrId].SpriteID == SpriteID) && \
        (TFTLCDLayerStatus[LyrId].PosX == PosX) && \
        (TFTLCDLayerStatus[LyrId].PosY == PosY) && \
        (TFTLCDLayerStatus[LyrId].Scale == Scale))    //ͼʾͼ뵱ǰҪһ
      return;                                           //ֱӷ
  }

  TFT_LCD_Update_Layer_Buffer(LyrId, SpriteID, PosX, PosY, Scale);

  TFTLCDLayerStatus[LyrId].LyrEn = 1;
  TFTLCDLayerStatus[LyrId].SpriteID = SpriteID;
  TFTLCDLayerStatus[LyrId].PosX = PosX;
  TFTLCDLayerStatus[LyrId].PosY = PosY;
  TFTLCDLayerStatus[LyrId].Scale = Scale;
}

/******************************************************************************
TFT_LCD_Clear_Layer
  ܣָͼϵͼƬʾ
  LyrIdͼ 0 - YVC_LYR_NUM_CPU(YvcConfig.h)
ֵ
******************************************************************************/
void TFT_LCD_Clear_Layer(uint16_t LyrId)
{
  uint8_t i;

  if (TFTLCDUpdateCtrl.Enable == 0)
    return;

  if (TFTLCDLayerStatus[LyrId].LyrEn)
  {
    //1.Buffer֮ǰȽֹ䵱ǰBufferеݵYGV642
    TFTLCDLayer[LyrId].UpdateCnt = 0;

    //2.Buffer
    for (i = 0; i < 12; i++)
      TFTLCDLayer[LyrId].Buffer[i] = TFTLCDBlankLayer[i];

    //3.òBufferеҪµYGV642еĴ
    TFTLCDLayer[LyrId].UpdateCnt = 2;                   //YGV642ǰ̨̨ʾҪ

    TFTLCDLayerStatus[LyrId].LyrEn = 0;
  }
}

/******************************************************************************
TFT_LCD_Clear_Multi_Layer
  ܣָĶͼϵͼƬʾ
  LyrIdLoʼͼ 0 - YVC_LYR_NUM_CPU(YvcConfig.h)
        LyrIdHiͼ 0 - YVC_LYR_NUM_CPU(YvcConfig.h)
ֵ
******************************************************************************/
void TFT_LCD_Clear_Multi_Layer(uint16_t LyrIdLo, uint16_t LyrIdHi)
{
  uint16_t LyrId;

  for (LyrId = LyrIdLo; LyrId <= LyrIdHi; LyrId++)
    TFT_LCD_Clear_Layer(LyrId);
}

/******************************************************************************
TFT_LCD_Startup
  ܣTFTɫҺʾ
  
ֵ
******************************************************************************/
void TFT_LCD_Startup(void)
{
  uint8_t i;
  
  YMA_CTL = 1;    //----hyq--20180317
  YGV642_Wait_ms(200);
  
  //1.ԴǰȷλźΪұر
  TFT_nRST = 0;
  LCD_BL   = 0;

  //2.TFTYGV642ĵԴ
  //PWR_nVIOEN = 1;   //Power up VDD5 and then power up VDDIN.    ܽ
  PWR_3V3EN  = 1;

  //3.ʱ10ms
  wdt_reset();
  YGV642_Wait_ms(200);

  //4.ͷŸλź
  TFT_nRST = 1;

  //5.ʼYGV642
  LCD_Init();
  YGV642_Init();
  //LCD_Init();   
  /*--- Transparent Color output (͸ɫ) ---*/
  //͸ɫֵӦXFL converterļʱTransparent colorɫֵӦ
  YGV642_Set_Transparent_Color(0xFF, 0x00, 0xFF);

  /*--- Border Color output (߿ɫ)---*/
  YGV642_Set_Border_Color(0x00, 0x00, 0x00);

  /*--- Host layer enable ---*/
  YGV642_Enable_Host_Controlled_Layer();

  //6.ʼݱ־
  for (i = 0; i < YVC_LYR_NUM_CPU; i++)
  {
    TFTLCDLayerStatus[i].LyrEn = 0;
    TFTLCDLayer[i].UpdateCnt   = 0;
  }

  TFTLCDUpdateCtrl.TblUpdate   = 0;
  TFTLCDUpdateCtrl.LyrBaseAddr = YGV642_Get_Updateable_Table();
  TFTLCDUpdateCtrl.Timer       = 0;
  TFTLCDUpdateCtrl.State       = 0;
  TFTLCDUpdateCtrl.Brightness  = 0;
  TFTLCDUpdateCtrl.Enable      = 1;

  //7.ʼҺ
  //LCD_Init();
  TFT_STB =1;
  PWM_Channel_Init(5, PWM_CLOCK_SA, PWM_POL_POS, PWM_LEFT_ALIGN, PWM5_PM1);
  PWM_Channel_Set_Freq(5, 500);
  PWM_Channel_Set_Duty_Cycle(5, 0);   //ʼΪر,ɺӦó
  PWM_Channel_Start(5); 
 }

void TFT_LCD_Shutdown(void)
{
  PWM_Channel_Stop(4);
  LCD_BL   = 0;
  TFT_STB = 0;
  TFTLCDUpdateCtrl.Enable = 0;
  //YMA_CTL = 0;
}

/******************************************************************************
TFT_LCD_Set_Brightness
  ܣTFTɫҺȿ
  Brȵȼ 0() - 100()
ֵ
******************************************************************************/
void TFT_LCD_Set_Brightness(uint8_t Br)
{
  if (TFTLCDUpdateCtrl.Enable == 0)
    return;

  if (Br > 100)
    Br = 100;

  if (Br != TFTLCDUpdateCtrl.Brightness)
  {
    TFTLCDUpdateCtrl.Brightness = Br;
    PWM_Channel_Set_Duty_Cycle(4, Br);
  }
}

/******************************************************************************
TFT_LCD_Display_Update_Service
  ܣTFTɫҺʾʾ·
  
ֵ
*******************************************************************************
ע  ⣺÷ÿ2msһ
******************************************************************************/
void TFT_LCD_Display_Update_Service(void)
{
  if (TFTLCDUpdateCtrl.Enable == 0)
    return;

  if (TFTLCDUpdateCtrl.Timer < 0xFF)
    TFTLCDUpdateCtrl.Timer++;

  switch (TFTLCDUpdateCtrl.State)
  {
  case 0  :
    if (YGV642_Get_Table_Flip_Status() == YVC1_TBL_FLIP_COMPLETE)
      TFTLCDUpdateCtrl.State  = 1;
    break;

  case 1  :
    TFT_LCD_Start_Update_General_Table();
    TFTLCDUpdateCtrl.State  = 2;
    break;

  case 2  :
    if ((TFT_LCD_Get_General_Table_Update_Status() == 0) && \
        (TFTLCDUpdateCtrl.Timer >= 10))
    {
      TFTLCDUpdateCtrl.LyrBaseAddr = YGV642_Flip_Table();
      TFTLCDUpdateCtrl.Timer = 0;
      TFTLCDUpdateCtrl.State = 0;
    }
    break;

  default :
    TFTLCDUpdateCtrl.TblUpdate   = 0;
    TFTLCDUpdateCtrl.LyrBaseAddr = YGV642_Get_Updateable_Table();
    TFTLCDUpdateCtrl.Timer       = 0;
    TFTLCDUpdateCtrl.State       = 0;
    break;
  }
}

/******************************************************************************
TFT_LCD_Update_Layer_Buffer
  ܣTFTɫҺʾʾ
  LyrId   ͼ 0 - YVC_LYR_NUM_CPU(YvcConfig.h)
        SpriteIDͼƬ()
        PosX    ͼƬʾʾϵx
        PosY    ͼƬʾʾϵy
        Scale   : ͼƬű,Ϊ0.015625(1 / 64),Ϊ64ʱͼƬΪԭʼ
ֵ
******************************************************************************/
#pragma CONST_SEG __GPAGE_SEG DEFAULT
void TFT_LCD_Update_Layer_Buffer(uint16_t LyrId, uint16_t SpriteID, uint16_t PosX, uint16_t PosY, uint8_t Scale)
{
  uint8_t i;

  T_Y642_LYR_SPRTATTR  LyrSprtAttr;

  //1.ȡӦͼƬ12ֽ
  for (i = 0; i < 12; i++)
    LyrSprtAttr.BYTE[i] = tVc1hPatternData[SpriteID].SpriteAttributeData[i];

  //2.޸ͼƬx,y
  LyrSprtAttr.BIT.DOX_0 = (uint8_t)( PosX       & 0x00FF);
  LyrSprtAttr.BIT.DOX_8 = (uint8_t)((PosX >> 8) & 0x0007);
  LyrSprtAttr.BIT.DOY_0 = (uint8_t)( PosY       & 0x00FF);
  LyrSprtAttr.BIT.DOY_8 = (uint8_t)((PosY >> 8) & 0x0007);

  //3.ͼƬű
  LyrSprtAttr.BIT.MAGX  = Scale;
  LyrSprtAttr.BIT.MAGY  = Scale;

  //LyrSprtAttr.BIT.ALPHA_1  = 1;
  //LyrSprtAttr.BIT.ALPHA_0  = 0;

  //4.²Buffer֮ǰȽֹ䵱ǰBufferеݵYGV642
  TFTLCDLayer[LyrId].UpdateCnt = 0;

  //5.²Buffer
  for (i = 0; i < 12; i++)
    TFTLCDLayer[LyrId].Buffer[i] = LyrSprtAttr.BYTE[i];

  //6.òBufferеҪµYGV642еĴ
  TFTLCDLayer[LyrId].UpdateCnt = 2;                   //YGV642ǰ̨̨ʾҪ
}
#pragma CONST_SEG DEFAULT

/******************************************************************************
TFT_LCD_Start_Update_General_Table
  ܣʼͼοоƬڵʾݱ
  
ֵ
******************************************************************************/
void TFT_LCD_Start_Update_General_Table(void)
{
  TFTLCDUpdateCtrl.TblUpdate  = 1;
  TFTLCDUpdateCtrl.CurrentLyr = 0;
  TFTLCDUpdateCtrl.Step       = 0;
}

/******************************************************************************
TFT_LCD_Get_General_Table_Update_Status
  ܣȡͼοоƬڵʾݱĸ״̬
  
ֵ0 - ǰûڸ
        1 - ǰڸ
******************************************************************************/
uint8_t TFT_LCD_Get_General_Table_Update_Status(void)
{
  return TFTLCDUpdateCtrl.TblUpdate;
}

/******************************************************************************
TFT_LCD_General_Table_Write_Service
  ܣͼοоƬڵʾݱݸ·
  
ֵ
*******************************************************************************
ע  ⣺÷ÿϵͳʱʵʱ
******************************************************************************/
void TFT_LCD_General_Table_Write_Service(void)
{
  uint8_t   i;
  uint16_t  TblAddr;

  if (TFTLCDUpdateCtrl.Enable == 0)
    return;

  if (TFTLCDUpdateCtrl.TblUpdate)
  {
    switch (TFTLCDUpdateCtrl.Step)
    {
      //Step 0  ׼
    case 0  :
      if(TFTLCDUpdateCtrl.CurrentLyr < YVC_LYR_NUM_CPU)
      {
        if (TFTLCDLayer[TFTLCDUpdateCtrl.CurrentLyr].UpdateCnt)
        {
          TblAddr = TFTLCDUpdateCtrl.LyrBaseAddr + TFTLCDUpdateCtrl.CurrentLyr * Y642_LYR_SIZE;
          TFTLCDUpdateCtrl.AddrBuffer[0] = (uint8_t)(TblAddr >> 8);
          TFTLCDUpdateCtrl.AddrBuffer[1] = (uint8_t)TblAddr;

          for (i = 0; i < 12; i++)
            TFTLCDUpdateCtrl.Data[i] = TFTLCDLayer[TFTLCDUpdateCtrl.CurrentLyr].Buffer[i];

          TFTLCDLayer[TFTLCDUpdateCtrl.CurrentLyr].UpdateCnt--;
          TFTLCDUpdateCtrl.Step = 1;
        }
      }
      else
        TFTLCDUpdateCtrl.TblUpdate = 0;
      TFTLCDUpdateCtrl.CurrentLyr++;
      break;

      //Step  1nCS
    case 1  :
      YGV642_SPI_nCS_Low();
      TFTLCDUpdateCtrl.Step = 2;
      break;

      //Step  2ѡĴַ˿
    case 2  :
      YGV642_SPI_Byte_Write(YVC1_PORT_REG_SEL);
      TFTLCDUpdateCtrl.Step = 3;
      break;

      //Step  328HĴ(General Tableַ)+ַ
    case 3  :
      YGV642_SPI_Byte_Write(REG_R28H | YVC1REG_AIRG);
      TFTLCDUpdateCtrl.Step = 4;
      break;

      //Step  4nCS
    case 4  :
      YGV642_SPI_nCS_High();
      TFTLCDUpdateCtrl.Step = 5;
      break;

      //Step  5nCS
    case 5  :
      YGV642_SPI_nCS_Low();
      TFTLCDUpdateCtrl.BytePtr = 0;
      TFTLCDUpdateCtrl.Step = 6;
      break;

      //Step  6ѡĴݶ˿
    case 6  :
      YGV642_SPI_Byte_Write(YVC1_PORT_REG_DATA);
      TFTLCDUpdateCtrl.Step = 7;
      break;

      //Step  7дGeneral Tableַ
    case 7  :
      YGV642_SPI_Byte_Write(TFTLCDUpdateCtrl.AddrBuffer[TFTLCDUpdateCtrl.BytePtr]);
      TFTLCDUpdateCtrl.BytePtr++;
      if (TFTLCDUpdateCtrl.BytePtr >= 2)
        TFTLCDUpdateCtrl.Step = 8;
      break;


      //Step  8nCS
    case 8  :
      YGV642_SPI_nCS_High();
      TFTLCDUpdateCtrl.Step = 9;
      break;

      //Step  9nCS
    case 9  :
      YGV642_SPI_nCS_Low();
      TFTLCDUpdateCtrl.BytePtr = 0;
      TFTLCDUpdateCtrl.Step = 10;
      break;

      //Step 10ѡGeneral Tableݶ˿
    case 10 :
      YGV642_SPI_Byte_Write(Y642_PORT_GENTBL_DATA);
      TFTLCDUpdateCtrl.Step = 11;
      break;

      //Step 11дGeneral Table
    case 11 :
      YGV642_SPI_Byte_Write(TFTLCDUpdateCtrl.Data[TFTLCDUpdateCtrl.BytePtr]);
      TFTLCDUpdateCtrl.BytePtr++;
      if (TFTLCDUpdateCtrl.BytePtr >= 12)
        TFTLCDUpdateCtrl.Step = 12;
      break;

      //Step 12nCS
    case 12 :
      YGV642_SPI_nCS_High();
      TFTLCDUpdateCtrl.Step = 0;
      break;

    default :
      TFTLCDUpdateCtrl.TblUpdate = 0;
      break;
    }
  }
}