/******************************************************************************
  ADC.h
ADCͷļ
    ߣ
    V1.0
    ڣ2017.03.25
******************************************************************************/

#ifndef _ADC_H_
#define _ADC_H_

#include "stdint.h"
#include "mc9s12xhy256.h"
#include "CRG.h"

/******************************************************************************
ADCȫ
******************************************************************************/
#define   ADC_RESOLUTION_BIT                10
#define   ADC_SAMPLE_POINT                  16
#define   ADC_CLOCK                         4000000
#define   ADC_VREF                          5000            //οѹ,λmV              
#define   ADC_MAX_CHANNEL_CNT               12
//#define   ADC_CONV_VALUE_MAX                ----            //תֵ,ֱһ

/******************************************************************************
ADCת״̬
******************************************************************************/
#define   ADC_CONV_COMPLETE                 0x00
#define   ADC_CONV_NOT_COMPLETE             (!ADC_CONV_COMPLETE)

/******************************************************************************
ADCԤ
******************************************************************************/

/*** ֱ ***/
#if   (ADC_RESOLUTION_BIT == 8)
  #define ADC_ATDCTL1_VALUE                 0x0F
  #define ADC_CONV_VALUE_MAX                255
#elif (ADC_RESOLUTION_BIT == 10)
  #define ADC_ATDCTL1_VALUE                 0x2F
  #define ADC_CONV_VALUE_MAX                1023
#else
  #error Unsupported ADC resolution
#endif

/***  ***/
#if   (ADC_SAMPLE_POINT == 4)
  #define ADC_SMP_VALUE                     0x00
#elif (ADC_SAMPLE_POINT == 6)
  #define ADC_SMP_VALUE                     0x20
#elif (ADC_SAMPLE_POINT == 8)
  #define ADC_SMP_VALUE                     0x40
#elif (ADC_SAMPLE_POINT == 10)
  #define ADC_SMP_VALUE                     0x60
#elif (ADC_SAMPLE_POINT == 12)
  #define ADC_SMP_VALUE                     0x80
#elif (ADC_SAMPLE_POINT == 16)
  #define ADC_SMP_VALUE                     0xA0
#elif (ADC_SAMPLE_POINT == 20)
  #define ADC_SMP_VALUE                     0xC0
#elif (ADC_SAMPLE_POINT == 24)
  #define ADC_SMP_VALUE                     0xE0
#else
  #error Unsupported ADC sample point
#endif

/*** ʱ ***/
#if (ADC_CLOCK < 250000)
  #error ADC clock is too low
#elif (ADC_CLOCK > 8300000)
  #error ADC clock is too high
#else
  #define ADC_PRS_VALUE                     (BUSCLK / ADC_CLOCK / 2 - 1)
#endif

/******************************************************************************

******************************************************************************/
void ADC_Init(void);
void ADC_Channel_Enable(uint8_t Ch);
void ADC_Start_Conversion(uint8_t Ch);
uint8_t   ADC_Get_Conversion_Status(void);
uint16_t  ADC_Get_Conversion_Result(void);

#endif
