/********************************************************************************/
/*  CONFIDENTIAL                                                                */
/*  Copyright(c) 2011-2012 Yamaha Corporation. All rights reserved.             */
/*  Module          : $Workfile: YGV642.h $                                     */
/*  Description     : YGV642 Driver include header                              */
/*  Version         : $Rev: 173 $                                               */
/*  Last UpDate Time: $Date:: 2012-08-30 14:29:01#$                             */
/*  FOOT NOTE       : adjust 2tab                                               */
/*  AUTHOR          : H.Katayama                                                */
/********************************************************************************/

#ifndef _YGV642_H_
#define _YGV642_H_

/*------------------------------------------------------------------------------*/
/*                      I N C L U D E                                           */
/*------------------------------------------------------------------------------*/
#include "stdint.h"
#include "API.h"
#include "CRG.h"
#include "GPIO.h"
#include "YGV642_SPI.h"
#include "YvcConfig.h"

/*------------------------------------------------------------------------------*/
/*                      D E F I N E                                             */
/*------------------------------------------------------------------------------*/

/*--- Shift operation definition ---*/
#define SHIFT_01BIT				(1)
#define SHIFT_02BIT				(2)
#define SHIFT_03BIT				(3)
#define SHIFT_04BIT				(4)
#define SHIFT_05BIT				(5)
#define SHIFT_06BIT				(6)
#define SHIFT_07BIT				(7)
#define SHIFT_08BIT				(8)
#define SHIFT_09BIT				(9)
#define SHIFT_10BIT				(10)
#define SHIFT_11BIT				(11)
#define SHIFT_12BIT				(12)
#define SHIFT_13BIT				(13)
#define SHIFT_14BIT				(14)
#define SHIFT_15BIT				(15)
#define SHIFT_16BIT				(16)
#define SHIFT_17BIT				(17)
#define SHIFT_18BIT				(18)
#define SHIFT_19BIT				(19)
#define SHIFT_20BIT				(20)
#define SHIFT_21BIT				(21)
#define SHIFT_22BIT				(22)
#define SHIFT_23BIT				(23)
#define SHIFT_24BIT				(24)
#define SHIFT_25BIT				(25)
#define SHIFT_26BIT				(26)
#define SHIFT_27BIT				(27)
#define SHIFT_28BIT				(28)
#define SHIFT_29BIT				(29)
#define SHIFT_30BIT				(30)
#define SHIFT_31BIT				(31)

/*--- Mask operation definition ---*/
#define MASK_01H				(0x01U)
#define MASK_02H				(0x02U)
#define MASK_04H				(0x04U)
#define MASK_08H				(0x08U)
#define MASK_10H				(0x10U)
#define MASK_20H				(0x20U)
#define MASK_40H				(0x40U)
#define MASK_80H				(0x80U)
#define MASK_03H				(0x03U)
#define MASK_07H				(0x07U)
#define MASK_0FH				(0x0FU)
#define MASK_1FH				(0x1FU)
#define MASK_3FH				(0x3FU)
#define MASK_7FH				(0x7FU)
#define MASK_BFH				(0xBFU)
#define MASK_E0H				(0xE0U)
#define MASK_EFH				(0xEFU)
#define MASK_F0H				(0xF0U)
#define MASK_F8H				(0xF8U)
#define MASK_FCH				(0xFCU)
#define MASK_FFH				(0xFFU)
#define MASK_00FFH				(0x00FFU)
#define MASK_FF00H				(0xFF00U)

/*------------------------------------------------*/
/* YGV642 Basic Definition                        */
/*------------------------------------------------*/
#define Y642_POLLING_MAX        (300000UL)      /* Driver polling maximum                   */
#define Y642_DOUBLE_BUFF_ADDR   (0x1000U)       /* Double buffer start address              */
#define Y642_EXGTBL_ADDR        (0x2000U)       /* Extended general table start address     */
#define Y642_REG_SIZE           (128)           /* Number of registers                      */
#define Y642_GTBL_SIZE          (8192)          /* General table size                       */
#define Y642_EXGTBL_SIZE        (512)           /* Extended general table size              */
#define Y642_LYR_SIZE           (12)            /* General table layer size                 */
#define Y642_EXLYR_SIZE         (8)             /* Extended general table layer size        */
#define Y642_LINEATTR_SIZE      (8)             /* General table line attribute data size   */
#define Y642_FONTTYPATTR_SIZE   (8)             /* Font type attribute data size            */
#define Y642_FTEXT_SIZE         (2)             /* Fixed-pitch font data size               */
#define Y642_PTEXT_SIZE         (4)             /* Proportional font data size              */
#define Y642_COLORPLT_SIZE      (4096)          /* Color palette size                       */
#define Y642_PLTI_SIZE          (1024)          /* PLTI size                                */
#define Y642_PMEM_SIZE          (0x04000000UL)  /* Pattern memory size                      */
#define Y642_PMEM_TOP_ADDR      (0x00000000UL)  /* Pattern memory start address             */
#define Y642_PMEM_END_ADDR      (0x03FFFFFFUL)  /* Pattern memory end address               */

/*--- Layer type ---*/
#define LYSEL_FONT				(6)
#define LYSEL_LINE				(7)
#define LYSEL_CLP				(7)

/*--- Register ---*/
#define Y642REG_AIRG			(uint8_t)(0x80)

/*--- General table ---*/
#define YVC1_GENERAL_TABLE1         (0x0000U)
#define YVC1_GENERAL_TABLE2         (Y642_DOUBLE_BUFF_ADDR)
#define YVC1_TBL_FLIP_COMPLETE      (0x00U)
#define YVC1_TBL_FLIP_NOT_COMPLETE  (!YVC1_TBL_FLIP_COMPLETE)
#define YVC1_LYBSELC_MASK           (0x40U)
#define YVC1_LYBSELC_TBL1           (0)
#define SET_LYR_ERASE_ATTR_DEF      {0x10U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U}
#define SET_EXLYR_ERASE_ATTR_DEF    {0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U}

/*------------------------------------------------*/
/* Port Access Number                             */
/*------------------------------------------------*/
typedef enum {
	Y642_PORT_GENTBL_DATA = 0,
	Y642_PORT_PLT_DATA,
	Y642_PORT_PTNMEM_READACS,
	Y642_PORT_PTNMEM_DATA,
	Y642_PORT_REG_SEL,
	Y642_PORT_REG_DATA,
	Y642_PORT_FLG_STATUS1,
	Y642_PORT_FLG_STATUS2
} T_Y642_PORT_NUMBER;

/*------------------------------------------------*/
/* Register  number                               */
/*------------------------------------------------*/
typedef enum {
	REG_R00H = 0,	REG_R01H,	REG_R02H,	REG_R03H,	REG_R04H,	REG_R05H,	REG_R06H,	REG_R07H,
	REG_R08H,		REG_R09H,	REG_R0AH,	REG_R0BH,	REG_R0CH,	REG_R0DH,	REG_R0EH,	REG_R0FH,
	REG_R10H,		REG_R11H,	REG_R12H,	REG_R13H,	REG_R14H,	REG_R15H,	REG_R16H,	REG_R17H,
	REG_R18H,		REG_R19H,	REG_R1AH,	REG_R1BH,	REG_R1CH,	REG_R1DH,	REG_R1EH,	REG_R1FH,
	REG_R20H,		REG_R21H,	REG_R22H,	REG_R23H,	REG_R24H,	REG_R25H,	REG_R26H,	REG_R27H,
	REG_R28H,		REG_R29H,	REG_R2AH,	REG_R2BH,	REG_R2CH,	REG_R2DH,	REG_R2EH,	REG_R2FH,
	REG_R30H,		REG_R31H,	REG_R32H,	REG_R33H,	REG_R34H,	REG_R35H,	REG_R36H,	REG_R37H,
	REG_R38H,		REG_R39H,	REG_R3AH,	REG_R3BH,	REG_R3CH,	REG_R3DH,	REG_R3EH,	REG_R3FH,
	REG_R40H,		REG_R41H,	REG_R42H,	REG_R43H,	REG_R44H,	REG_R45H,	REG_R46H,	REG_R47H,
	REG_R48H,		REG_R49H,	REG_R4AH,	REG_R4BH,	REG_R4CH,	REG_R4DH,	REG_R4EH,	REG_R4FH,
	REG_R50H,		REG_R51H,	REG_R52H,	REG_R53H,	REG_R54H,	REG_R55H,	REG_R56H,	REG_R57H,
	REG_R58H,		REG_R59H,	REG_R5AH,	REG_R5BH,	REG_R5CH,	REG_R5DH,	REG_R5EH,	REG_R5FH,
	REG_R60H,		REG_R61H,	REG_R62H,	REG_R63H
} T_Y642_REG_NUMBER_0;

typedef enum {
	REG_R64H = 100,	REG_R65H,	REG_R66H,	REG_R67H,	REG_R68H,	REG_R69H,	REG_R6AH,	REG_R6BH,
	REG_R6CH,		REG_R6DH,	REG_R6EH,	REG_R6FH,	REG_R70H,	REG_R71H,	REG_R72H,	REG_R73H,
	REG_R74H,		REG_R75H,	REG_R76H,	REG_R77H,	REG_R78H,	REG_R79H,	REG_R7AH,	REG_R7BH,
	REG_R7CH,	REG_R7DH,	REG_R7EH,	REG_R7FH
} T_Y642_REG_NUMBER_1;

/*--- Y***_ -> YVC_ Convert Setting ---*/
/*--- Port ---*/
#define YVC1_PORT_GENTBL_DATA		    Y642_PORT_GENTBL_DATA
#define YVC1_PORT_PLT_DATA			    Y642_PORT_PLT_DATA
#define YVC1_PORT_PTNMEM_READACS	  Y642_PORT_PTNMEM_READACS
#define YVC1_PORT_PTNMEM_DATA		    Y642_PORT_PTNMEM_DATA
#define YVC1_PORT_REG_SEL			      Y642_PORT_REG_SEL
#define YVC1_PORT_REG_DATA			    Y642_PORT_REG_DATA
#define YVC1_PORT_FLG_STATUS1		    Y642_PORT_FLG_STATUS1
#define YVC1_PORT_FLG_STATUS2		    Y642_PORT_FLG_STATUS2

/*--- Register ---*/
#define YVC1REG_AIRG				        Y642REG_AIRG

/*--- Device ---*/
#define YVC1_POLLING_MAX            Y642_POLLING_MAX
#define YVC1_DOUBLE_BUFF_ADDR       Y642_DOUBLE_BUFF_ADDR
#define YVC1_EXGTBL_ADDR            Y642_EXGTBL_ADDR
#define YVC1_REG_SIZE               Y642_REG_SIZE
#define YVC1_GTBL_SIZE              Y642_GTBL_SIZE
#define YVC1_EXGTBL_SIZE            Y642_EXGTBL_SIZE
#define YVC1_LYR_SIZE               Y642_LYR_SIZE
#define YVC1_EXLYR_SIZE             Y642_EXLYR_SIZE
#define YVC1_LINEATTR_SIZE          Y642_LINEATTR_SIZE
#define YVC1_FONTTYPATTR_SIZE       Y642_FONTTYPATTR_SIZE
#define YVC1_FTEXT_SIZE             Y642_FTEXT_SIZE
#define YVC1_PTEXT_SIZE             Y642_PTEXT_SIZE
#define YVC1_COLORPLT_SIZE          Y642_COLORPLT_SIZE
#define YVC1_PLTI_SIZE              Y642_PLTI_SIZE
#define YVC1_PMEM_SIZE              Y642_PMEM_SIZE
#define YVC1_PMEM_TOP_ADDR          Y642_PMEM_TOP_ADDR
#define YVC1_PMEM_END_ADDR          Y642_PMEM_END_ADDR

#define YVC1_EXGTBL1_START_ADDR     YVC1_EXGTBL_ADDR
#define YVC1_EXGTBL2_START_ADDR     YVC1_DOUBLE_BUFF_ADDR + YVC1_EXGTBL_ADDR

/*------------------------------------------------------------------------------*/
/*                      S T R U C T - S E T                                     */
/*------------------------------------------------------------------------------*/

#if YVC_BIT_FIELD

	/********************************************************************************/
	/* Y642 PORT ACCESS STRUCT                                                      */
	/********************************************************************************/
	/*--- LSB priority allocation ---*/
	/*----------------------------------------*/
	/* Port number 2                          */
	/* Pattern memory read access port        */
	/*----------------------------------------*/
	typedef union {
		uint8_t 	BYTE;
		struct {
			uint8_t 	STARES		:1;
			uint8_t		FSE			:1;
			uint8_t		FSS			:1;
			uint8_t		FSA			:1;
			uint8_t 	CSNEG		:1;
			uint8_t 	INIEND		:1;
			uint8_t 	PWBUSY		:1;
			uint8_t 	PMRREQ		:1;
		} BIT;
	} T_Y642_PORT_PTNMEM;

	/*----------------------------------------*/
	/* Port number 4                          */
	/* Register select port                   */
	/*----------------------------------------*/
	typedef union {
		uint8_t 	BYTE;
		struct {
			uint8_t 	RGN 		:7;
			uint8_t 	AIRG		:1;
		} BIT;
	} T_Y642_PORT_REGSEL;

	/*----------------------------------------*/
	/* Port number 6                          */
	/* Flag & Status port                     */
	/*----------------------------------------*/
	typedef union {
		uint8_t 	BYTE;
		struct {
			uint8_t 	VB			:1;
			uint8_t 	FB			:1;
			uint8_t 	STALN		:1;
			uint8_t 	FD			:1;
			uint8_t 	FERR		:1;
			uint8_t 	FV			:1;
			uint8_t 	FP			:1;
			uint8_t 	FR			:1;
		} BIT;
	} T_Y642_PORT_FLAG1;

	/*----------------------------------------*/
	/* Port number 7                          */
	/* Flag & Status port                     */
	/*----------------------------------------*/
	typedef union {
		uint8_t 	BYTE;
		struct {
			uint8_t 	FRSE		:1;
			uint8_t 	FRRE		:1;
			uint8_t 	FWE 		:1;
			uint8_t 	FMCE		:1;
			uint8_t 	FMF 		:1;
			uint8_t 	FML 		:1;
			uint8_t 	FME 		:1;
			uint8_t 	FMC 		:1;
		} BIT;
	} T_Y642_PORT_FLAG2;
	
	/********************************************************************************/
	/* VC1H REGISTER STRUCT                                                         */
	/********************************************************************************/
	
	/*----------------------------------------*/
	/* Power Down                             */ 
	/* Stand-Alone/Alpha Coefficient Controls */
	/*----------------------------------------*/

	typedef union {
		uint8_t		BYTE;
		struct {
			uint8_t ALPBSEL		:1;
			uint8_t EXLY		:1;
			uint8_t dummy1		:1;
			uint8_t STAPLY		:1;
			uint8_t PSEN		:4;
		} BIT;
	} T_Y642_R30H;

	/*----------------------------------------*/
	/* Host Controlled Layer                  */
	/*----------------------------------------*/
	typedef union {
		uint8_t		BYTE;
		struct {
			uint8_t LYSAC_8		:4;
			uint8_t dummy1		:2;
			uint8_t LYBSELC		:1;
			uint8_t LYDC		:1;
		} BIT;
	} T_Y642_R3EH;

	typedef union {
		uint8_t		BYTE;
		struct {
			uint8_t dummy1		:2;
			uint8_t LYSAC_2		:6;
		} BIT;
	} T_Y642_R3FH;

	typedef union {
		uint8_t		BYTE;
		struct {
			uint8_t LYEAC_8		:4;
			uint8_t dummy1		:4;
		} BIT;
	} T_Y642_R40H;

	typedef union {
		uint8_t		BYTE;
		struct {
			uint8_t dummy1		:2;
			uint8_t LYEAC_2		:6;
		} BIT;
	} T_Y642_R41H;
	 
	/********************************************************************************/
	/*	VC1H GENERAL TABLE ACCESS STRUCT                                            */
	/********************************************************************************/
	/*----------------------------------------
	 *	Layer structure for Sprite display
	 *----------------------------------------*/
	typedef union {
    uint8_t BYTE[12];
		struct {
			uint8_t DOY_8	:3;				/* BYTE[0]						*/
			uint8_t MXSL	:1;
			uint8_t MX8		:1;
			uint8_t CLM		:3;
			uint8_t DOY_0	:8;				/* BYTE[1]						*/
			uint8_t DOX_8	:3;				/* BYTE[2]						*/
			uint8_t PLTI_8	:1;
			uint8_t MX_4	:4;
			uint8_t DOX_0	:8;				/* BYTE[3]						*/
			uint8_t SZY		:6;				/* BYTE[4]						*/
			uint8_t TP		:1;
			uint8_t ALPHA_1	:1;
			uint8_t SZX		:6;				/* BYTE[5]						*/
			uint8_t COMPM	:2;
			union {						/* BYTE[6]						*/
				struct {
					uint8_t LSYM	:3;
					uint8_t LSYE	:1;
					uint8_t DCM		:2;
					uint8_t LSYS	:1;
					uint8_t dummy1	:1;
				} RGB;
				struct {
					uint8_t PLTI_0	:8;
				} PLT;
			} COLOR;
			uint8_t PN_19	:7;				/* BYTE[7]						*/
			uint8_t ALPHA_0	:1;
			uint8_t PN_11	:8;				/* BYTE[8]						*/
			uint8_t PN_3	:8;				/* BYTE[9]						*/
			uint8_t MAGY	:8;				/* BYTE[10]						*/
			uint8_t MAGX	:8;				/* BYTE[11]						*/
		} BIT;
	} T_Y642_LYR_SPRTATTR;

	/*----------------------------------------
	 *	Layer structure for Text display
	 *----------------------------------------*/
	typedef union {
		uint8_t BYTE[12];
		struct {
			uint8_t FDOY_8	:3;				/* BYTE[0]						*/
			uint8_t FMXSL	:1;
			uint8_t FMX8	:1;
			uint8_t LYSEL	:3;
			uint8_t FDOY_0	:8;				/* BYTE[1]						*/
			uint8_t FDOX_8	:3;				/* BYTE[2]						*/
			uint8_t FPLTI_8	:1;
			uint8_t FMX_4	:4;
			uint8_t FDOX_0	:8;				/* BYTE[3]						*/
			uint8_t FTYP_10	:2;				/* BYTE[4]						*/
			uint8_t FKNE	:1;
			uint8_t FDIR	:1;
			uint8_t FPFE	:1;
			uint8_t FPLTS	:1;
			uint8_t FTP		:1;
			uint8_t dummy1	:1;
			uint8_t FTYP_2	:8;				/* BYTE[5]						*/
			uint8_t FPLTI_0	:8;				/* BYTE[6]						*/
			uint8_t FCEA_9	:3;				/* BYTE[7]						*/
			uint8_t dummy2	:1;
			uint8_t FCSA_9	:3;
			uint8_t dummy3	:1;
			uint8_t FCSA_1	:8;				/* BYTE[8]						*/
			uint8_t FCEA_1	:8;				/* BYTE[9]						*/
			uint8_t dummy4	:8;				/* BYTE[10]						*/
			uint8_t dummy5	:8;				/* BYTE[11]						*/
		} BIT;
	} T_Y642_LYR_FONTATTR;

	/*----------------------------------------
	 *	Font type attribute structure
	 *----------------------------------------*/
	typedef union {
		uint8_t BYTE[8];
		struct {
			uint8_t FN_19		:7;			/* BYTE[0]						*/
			uint8_t CMODE		:1;
			uint8_t FN_11		:8;			/* BYTE[1]						*/
			uint8_t FN_3		:8;			/* BYTE[2]						*/
			uint8_t dummy1		:5;			/* BYTE[3]						*/
			uint8_t FCOMPV		:1;
			uint8_t FCOMPE		:1;
			uint8_t FHSZ		:1;
			uint8_t FSZX		:6;			/* BYTE[4]						*/
			uint8_t dummy2		:2;
			uint8_t FSZY		:6;			/* BYTE[5]						*/
			uint8_t dummy3		:2;
			uint8_t FDAB		:5;			/* BYTE[6]						*/
			uint8_t dummy4		:3;
			uint8_t FDLB		:5;			/* BYTE[7]						*/
			uint8_t dummy5		:3;
		} BIT;
	} T_Y642_FONT_TYPATTR;

	/*----------------------------------------
	 *	Proportional character code structure
	 *----------------------------------------*/
	typedef union {
		uint8_t BYTE[4];
		struct {
			union {
				struct {
					uint8_t FCODE_8		:8;			/* BYTE[0]				*/
					uint8_t FCODE_0		:8;			/* BYTE[1]				*/
					uint8_t XS			:6;			/* BYTE[2]				*/
					uint8_t dummy1		:2;
					uint8_t XE			:6;			/* BYTE[3]				*/
					uint8_t dummy2		:2;
				} DOUBLE;
				struct {
					uint8_t FCODE_8		:7;			/* BYTE[0]				*/
					uint8_t dummy1		:1;
					uint8_t FCODE_0		:8;			/* BYTE[1]				*/
					uint8_t XS			:6;			/* BYTE[2]				*/
					uint8_t dummy2		:2;
					uint8_t XE			:6;			/* BYTE[3]				*/
					uint8_t dummy3		:2;
				} MIX;
			} GLYPH;

		} BIT;
	} T_Y642_TEXT_PFONT;
	
#else

	/********************************************************************************/
	/* Y642 PORT ACCESS STRUCT                                                      */
	/********************************************************************************/
	
	/*--- MSB priority allocation ---*/
	/*------------------------------------------*/
	/* Port number 2                            */
	/* Pattern memory read access port          */
	/*------------------------------------------*/
	typedef union {
		uint8_t 	BYTE;
		struct {
			uint8_t 	PMRREQ		:1;
			uint8_t 	PWBUSY		:1;
			uint8_t 	INIEND		:1;
			uint8_t 	CSNEG		:1;
			uint8_t 	FSA			:1;
			uint8_t 	FSS			:1;
			uint8_t 	FSE			:1;
			uint8_t 	STARES		:1;
		} BIT;
	} T_Y642_PORT_PTNMEM;

	/*----------------------------------------*/
	/* Port number 4                          */
	/* Register select port                   */
	/*----------------------------------------*/
	typedef union {
		uint8_t 	BYTE;
		struct {
			uint8_t 	AIRG		:1;
			uint8_t 	RGN 		:7;
		} BIT;
	} T_Y642_PORT_REGSEL;

	/*----------------------------------------*/
	/* Port number 6                          */
	/* Flag & Status port                     */
	/*----------------------------------------*/
	typedef union {
		uint8_t 	BYTE;
		struct {
			uint8_t 	FR			:1;
			uint8_t 	FP			:1;
			uint8_t 	FV			:1;
			uint8_t 	FERR		:1;
			uint8_t 	FD			:1;
			uint8_t 	STALN		:1;
			uint8_t 	FB			:1;
			uint8_t 	VB			:1;
		} BIT;
	} T_Y642_PORT_FLAG1;

	/*----------------------------------------*/
	/* Port number 7                          */
	/* Flag & Status port                     */
	/*----------------------------------------*/
	typedef union {
		uint8_t 	BYTE;
		struct {
			uint8_t 	FMC 		:1;
			uint8_t 	FME 		:1;
			uint8_t 	FML 		:1;
			uint8_t 	FMF 		:1;
			uint8_t 	FMCE		:1;
			uint8_t 	FWE 		:1;
			uint8_t 	FRRE		:1;
			uint8_t 	FRSE		:1;
		} BIT;
	} T_Y642_PORT_FLAG2;
	
	/****************************************************************************
	 * VC1H REGISTER STRUCT
	 ****************************************************************************/
	/*----------------------------------------*/
	/* Power Down                             */ 
	/* Stand-Alone/Alpha Coefficient Controls */
	/*----------------------------------------*/
	typedef union {
		uint8_t		BYTE;
		struct {
			uint8_t PSEN		:4;
			uint8_t STAPLY		:1;
			uint8_t dummy1		:1;
			uint8_t EXLY		:1;
			uint8_t ALPBSEL		:1;
		} BIT;
	} T_Y642_R30H;

	/*----------------------------------------*/
	/* Host Controlled Layer                  */
	/*----------------------------------------*/
	typedef union {
		uint8_t		BYTE;
		struct {
			uint8_t LYDC		:1;
			uint8_t LYBSELC		:1;
			uint8_t dummy1		:2;
			uint8_t LYSAC_8		:4;
		} BIT;
	} T_Y642_R3EH;

	typedef union {
		uint8_t		BYTE;
		struct {
			uint8_t LYSAC_2		:6;
			uint8_t dummy1		:2;
		} BIT;
	} T_Y642_R3FH;

	typedef union {
		uint8_t		BYTE;
		struct {
			uint8_t dummy1		:4;
			uint8_t LYEAC_8		:4;
		} BIT;
	} T_Y642_R40H;

	typedef union {
		uint8_t		BYTE;
		struct {
			uint8_t LYEAC_2		:6;
			uint8_t dummy1		:2;
		} BIT;
	} T_Y642_R41H;
	
	/********************************************************************************/
	/*	VC1H GENERAL TABLE ACCESS STRUCT                                            */
	/********************************************************************************/
	/*----------------------------------------
	 *	Layer structure for Sprite display
	 *----------------------------------------*/
	typedef union {
		uint8_t BYTE[12];
		struct {
			uint8_t CLM		:3;				/* BYTE[0]						*/
			uint8_t MX8		:1;
			uint8_t MXSL	:1;
			uint8_t DOY_8	:3;
			uint8_t DOY_0	:8;				/* BYTE[1]						*/
			uint8_t MX_4	:4;				/* BYTE[2]						*/
			uint8_t PLTI_8	:1;
			uint8_t DOX_8	:3;
			uint8_t DOX_0	:8;				/* BYTE[3]						*/
			uint8_t ALPHA_1	:1;				/* BYTE[4]						*/
			uint8_t TP		:1;
			uint8_t SZY		:6;
			uint8_t COMPM	:2;				/* BYTE[5]						*/
			uint8_t SZX		:6;
			union {						/* BYTE[6]						*/
				struct {
					uint8_t dummy1	:1;
					uint8_t LSYS	:1;
					uint8_t DCM		:2;
					uint8_t LSYE	:1;
					uint8_t LSYM	:3;
				} RGB;
				struct {
					uint8_t PLTI_0	:8;
				} PLT;
			} COLOR;
			uint8_t ALPHA_0	:1;				/* BYTE[7]						*/
			uint8_t PN_19	:7;
			uint8_t PN_11	:8;				/* BYTE[8]						*/
			uint8_t PN_3	:8;				/* BYTE[9]						*/
			uint8_t MAGY	:8;				/* BYTE[10]						*/
			uint8_t MAGX	:8;				/* BYTE[11]						*/
		} BIT;
	} T_Y642_LYR_SPRTATTR;

	/*----------------------------------------
	 *	Layer structure for Text display
	 *----------------------------------------*/
	typedef union {
		uint8_t BYTE[12];
		struct {
			uint8_t LYSEL	:3;				/* BYTE[0]						*/
			uint8_t FMX8	:1;
			uint8_t FMXSL	:1;
			uint8_t FDOY_8	:3;
			uint8_t FDOY_0	:8;				/* BYTE[1]						*/
			uint8_t FMX_4	:4;				/* BYTE[2]						*/
			uint8_t FPLTI_8	:1;
			uint8_t FDOX_8	:3;
			uint8_t FDOX_0	:8;				/* BYTE[3]						*/
			uint8_t dummy1	:1;				/* BYTE[4]						*/
			uint8_t FTP		:1;
			uint8_t FPLTS	:1;
			uint8_t FPFE	:1;
			uint8_t FDIR	:1;
			uint8_t FKNE	:1;
			uint8_t FTYP_10	:2;
			uint8_t FTYP_2	:8;				/* BYTE[5]						*/
			uint8_t FPLTI_0	:8;				/* BYTE[6]						*/
			uint8_t dummy2	:1;				/* BYTE[7]						*/
			uint8_t FCSA_9	:3;
			uint8_t dummy3	:1;
			uint8_t FCEA_9	:3;
			uint8_t FCSA_1	:8;				/* BYTE[8]						*/
			uint8_t FCEA_1	:8;				/* BYTE[9]						*/
			uint8_t dummy4	:8;				/* BYTE[10]						*/
			uint8_t dummy5	:8;				/* BYTE[11]						*/
		} BIT;
	} T_Y642_LYR_FONTATTR;

	/*----------------------------------------
	 *	Font type attribute structure
	 *----------------------------------------*/
	typedef union {
		uint8_t BYTE[8];
		struct {
			uint8_t CMODE		:1;			/* BYTE[0]						*/
			uint8_t FN_19		:7;
			uint8_t FN_11		:8;			/* BYTE[1]						*/
			uint8_t FN_3		:8;			/* BYTE[2]						*/
			uint8_t FHSZ		:1;			/* BYTE[3]						*/
			uint8_t FCOMPE		:1;
			uint8_t FCOMPV		:1;
			uint8_t dummy1		:5;
			uint8_t dummy2		:2;			/* BYTE[4]						*/
			uint8_t FSZX		:6;
			uint8_t dummy3		:2;			/* BYTE[5]						*/
			uint8_t FSZY		:6;
			uint8_t dummy4		:3;			/* BYTE[6]						*/
			uint8_t FDAB		:5;
			uint8_t dummy5		:3;			/* BYTE[7]						*/
			uint8_t FDLB		:5;
		} BIT;
	} T_Y642_FONT_TYPATTR;

	/*----------------------------------------
	 *	Proportional character code structure 
	 *----------------------------------------*/
	typedef union {
		uint8_t BYTE[4];
		struct {
			union {
				struct {
					uint8_t FCODE_8		:8;			/* BYTE[0]				*/
					uint8_t FCODE_0		:8;			/* BYTE[1]				*/
					uint8_t dummy1		:2;			/* BYTE[2]				*/
					uint8_t XS			:6;
					uint8_t dummy2		:2;			/* BYTE[3]				*/
					uint8_t XE			:6;
				} DOUBLE;
				struct {
					uint8_t dummy1		:1;			/* BYTE[0]				*/
					uint8_t FCODE_8		:7;
					uint8_t FCODE_0		:8;			/* BYTE[1]				*/
					uint8_t dummy2		:2;			/* BYTE[2]				*/
					uint8_t XS			:6;
					uint8_t dummy3		:2;			/* BYTE[3]				*/
					uint8_t XE			:6;
				} MIX;
			} GLYPH;
		} BIT;
	} T_Y642_TEXT_PFONT;
	
#endif	/* YVC_BIT_FIELD	*/

/*------------------------------*/
/*  TEXT PALETTE DATA STRUCTURE */
/*------------------------------*/
typedef struct {							/*--------------------------*/
  uint8_t  TextBgColorR;           /* Back ground color - R		*/
  uint8_t  TextBgColorG;           /* Back ground color - G		*/
  uint8_t  TextBgColorB;           /* Back ground color - B		*/
  uint8_t  TextBgDummyByte;        /* Dummy Byte               */
  uint8_t  TextFgColorR;           /* Front ground color - R		*/
  uint8_t  TextFgColorG;           /* Front ground color - G		*/
  uint8_t  TextFgColorB;           /* Front ground color - B		*/
  uint8_t  TextFgDummyByte;        /* Dummy Byte               */
} T_Y642_TEXTPALETTEDATA;     /*--------------------------*/

/*----------------------------------*/
/* YGF Search table data            */
/*----------------------------------*/
typedef struct {
	uint16_t	StartCode1;						  /* Top character code 1 in the block				*/
	uint16_t	EndCode1;						    /* End character code 1 in the block				*/
	uint16_t	StartCode2;						  /* Top character code 2 in the block				*/
	uint16_t	EndCode2;						    /* End character code 2 in the block				*/
	uint16_t	SeqOffset;						  /* Search character code offset						*/
	uint8_t 	PropData;						    /* Proportional data existence  0:not 1:existence	*/
	uint8_t 	HalfSizeFont;					  /* Half-size control  0 : Normal 1 : Half Size Font	*/
} T_YGFONT_TBL;

#if YVC_TEXT_SEGMENTED_KERNING
/*----------------------------------*/
/* YGF Proportional data            */
/*----------------------------------*/
typedef struct {
	uint16_t	StartCode;						  /* Top character code in the segment      */
	uint16_t	EndCode;						    /* End character code in the segment      */ 
	uint8_t 	XS;										  /* Proportional data on the font left side	*/
	uint8_t 	XE;										  /* Proportional data on the font right side	*/
} T_YGFONT_PDATA;

/*----------------------------------*/
/* Font data structure              */
/*----------------------------------*/
typedef struct {
	const T_Y642_FONT_TYPATTR	*FontTypAttr;	      /* Font type attribute data					*/
	uint8_t                    YgfontTblSize;	    /* Number of Search table data		        */
	const T_YGFONT_TBL        *YgfontTbl;	        /* YGF Search table data					*/
  uint8_t                    YgfontPDataSize;	  /* Number of Proportional data		        */
	const T_YGFONT_PDATA      *YgfontPData;       /* YGF Proportional data					*/
} T_YGFONT_DATA;

#else
  
/*----------------------------------*/
/* YGF Proportional data            */
/*----------------------------------*/
typedef struct {
	uint8_t 	XS;										  /* Proportional data on the font left side	*/
	uint8_t 	XE;										  /* Proportional data on the font right side	*/
} T_YGFONT_PDATA;

/*----------------------------------*/
/* Font data structure              */
/*----------------------------------*/
typedef struct {
	const T_Y642_FONT_TYPATTR	*FontTypAttr;	/* Font type attribute data					*/
	uint8_t                    YgfontTblSize;	/* Number of Search table data		        */
	const T_YGFONT_TBL        *YgfontTbl;	    /* YGF Search table data					*/
	const T_YGFONT_PDATA      *YgfontPData;   /* YGF Proportional data					*/
} T_YGFONT_DATA;

#endif /* YVC_TEXT_SEGMENTED_KERNING	*/

/*------------------------------------------------------------------------------*/
/*                     D E V I C E   S E T T I N G S                            */
/*------------------------------------------------------------------------------*/
#define YVC1_PLL_LOCKUP_WAIT            (4)                     /* ms           */
#define YVC1_INIEND_CHK                 (0x20)
#define YVC1_INIEND_WAIT                (2)                     /* ms           */

#define YVC1_SR                         (0x80)
#define YVC1_GTBL_BUFF_LOOP_SIZE        ((YVC1_GTBL_SIZE / 2) - YVC1_LYR_SIZE)
#define YVC1_CPULYR_ADDR_MAX            (4080)
#define YVC1_CPULYR_ADDR_12N            (12)
#define YVC1_CPULYR_NUM_MAX             (341)
#define YVC1_CPULYR_ADDR_END_MAX        (4092)

#if (YVC_LYR_ADDR_CPU > YVC1_CPULYR_ADDR_MAX) 
  #error Layer parameters of YGV642 are configured incorrectly, Please modify the configurations in YvcConfig.h
#endif

#if (YVC_LYR_ADDR_CPU % YVC1_CPULYR_ADDR_12N != 0)
  #error Layer parameters of YGV642 are configured incorrectly, Please modify the configurations in YvcConfig.h
#endif

#if (YVC_LYR_NUM_CPU > YVC1_CPULYR_NUM_MAX) 
  #error Layer parameters of YGV642 are configured incorrectly, Please modify the configurations in YvcConfig.h
#endif

#if ((YVC_LYR_ADDR_CPU + (YVC_LYR_NUM_CPU * Y642_LYR_SIZE)) > YVC1_CPULYR_ADDR_END_MAX)
  #error Layer parameters of YGV642 are configured incorrectly, Please modify the configurations in YvcConfig.h
#endif

/*------------------------------------------------------------------------------*/
/*                      P R O T O T Y P E                                       */
/*------------------------------------------------------------------------------*/
void YGV642_Init(void);
void YGV642_Pattern_Memory_Init(void);

void YGV642_Set_Transparent_Color(uint8_t ColorR, uint8_t ColorG, uint8_t ColorB);
void YGV642_Set_Border_Color(uint8_t ColorR, uint8_t ColorG, uint8_t ColorB);

#if YVC_TEXT_LYR_ENABLE
void YGV642_Set_Text_Color_Palettes(const uint8_t *Buff, uint16_t Num);
void YGV642_Set_Text_Fonts(const uint8_t *Buff, uint16_t Num);
#endif

void YGV642_Enable_Host_Controlled_Layer(void);

uint16_t YGV642_Get_Updateable_Table(void);
uint16_t YGV642_Flip_Table(void);
uint8_t  YGV642_Get_Table_Flip_Status(void);

uint16_t YGV642_Calc_Pattern_Memory_CheckSum(uint32_t StartAddr, uint32_t EndAddr);

#if YVC_GENERAL_TABLE_INIT
void YGV642_General_Table_Init(void);
#endif

void YGV642_Write_Reg(uint8_t RegNo, uint8_t Data);
void YGV642_Write_Reg_Pll(uint8_t RegNo, uint8_t Data);
void YGV642_Write_Regs(uint8_t RegNo, const uint8_t *Buff, uint8_t Num);
void YGV642_Read_Reg(uint8_t RegNo, uint8_t *Data);
void YGV642_INIEND_Wait_Polling(void);

void YGV642_Write_Port(uint8_t Port, uint8_t Data);
uint8_t YGV642_Read_Port(uint8_t Port);

void YGV642_Wait_ms(uint8_t msCnt);

#endif