/******************************************************************************
  PWM.c
PWMļ
    ߣ
    V1.0
    ڣ2016.11.3
******************************************************************************/

#include "PWM.h"

/******************************************************************************
PWM_Init
  ܣPWMʼ
        ʼPWMʱԴ clock A, clock B, clock SA  clock SB
        ҪԤPWM.hжʱԴƵ
  
ֵ
******************************************************************************/
void PWM_Init(void)
{
  PWME     = 0;
  PWMPOL   = 0;
  PWMCLK   = 0;
  PWMCAE   = 0;
  PWMPRCLK = (PWM_CLKA_FREQ << 4) | PWM_CLKB_FREQ;  //PWM clock A/B Ƶ
  PWMSCLA  = PWMSCLAREG;                            //PWM clock SA
  PWMSCLB  = PWMSCLBREG;                            //PWM clock SB
}

/******************************************************************************
PWM_Channel_Init
  ܣʼָPWMͨʱԴԡ뷽ʽ˿
  Ch     ͨ 0 - 7
        ClkSrc ʱԴ
                 ͨ 0 / 1 / 4 / 5 ѡ  PWM_CLOCK_A  PWM_CLOCK_SA
                 ͨ 2 / 3 / 6 / 7 ѡ  PWM_CLOCK_B  PWM_CLOCK_SB
        Pol    ѡ
                 PWM_POL_NGE  ʼΪ͵ƽתΪߵƽ,ʱΪߵƽ
                 PWM_POL_POS  ʼΪߵƽתΪ͵ƽ,ʱΪ͵ƽ
        Cae    : 뷽ʽ
                 PWM_LEFT_ALIGN    
                 PWM_CENTER_ALIGN  Ķ
        IOSel  ˿ѡ
                 ͨ 0 ʹö˿  PWM0_PP0  PWM0_PS4
                 ͨ 1 ʹö˿  PWM1_PP1  PWM1_PS5
                 ͨ 2 ʹö˿  PWM2_PP2  PWM2_PS6
                 ͨ 3 ʹö˿  PWM3_PP3  PWM3_PS7
                 ͨ 4 ʹö˿  PWM4_PP4  PWM4_PS2  PWM4_PV0  PWM4_PM0
                 ͨ 5 ʹö˿  PWM5_PP5  PWM5_PS3  PWM5_PV1  PWM5_PM1
                 ͨ 6 ʹö˿  PWM6_PP6  PWM6_PS0  PWM6_PV2  PWM6_PM2
                 ͨ 7 ʹö˿  PWM7_PP7  PWM7_PS1  PWM7_PV3  PWM7_PM3
ֵ
******************************************************************************/
void PWM_Channel_Init(uint8_t Ch, uint8_t ClkSrc, uint8_t Pol, uint8_t Cae, uint8_t IOSel)
{
  uint8_t ChBit;

  if (Ch > 7)
    return;

  ChBit = 1 << Ch;

  if(ClkSrc)
    PWMCLK |= ChBit;
  else
    PWMCLK &= ~ChBit;

  if (Pol)
    PWMPOL |= ChBit;
  else
    PWMPOL &= ~ChBit;

  if (Cae)
    PWMCAE |= ChBit;
  else
    PWMCAE &= ~ChBit;

  if (Ch < 4)
  {
    PTPRRL &= ~ChBit;
    PTPRRL |= IOSel;
  }
  else
  {
    ChBit   = 0x03 << (Ch - 4) * 2;
    PTPRRH &= ~ChBit;
    PTPRRH |= IOSel;
  }
}

/******************************************************************************
PWM_Channel_Set_Freq
  ܣָPWMͨƵ
  Ch   ͨ 0 - 7
        Freq Ƶ,λ Hz
ֵ
******************************************************************************/
void PWM_Channel_Set_Freq(uint8_t Ch, uint32_t Freq)
{
  uint8_t   ChBit;
  uint8_t   RegVal;
  uint8_t   *pReg;
  uint32_t  Prescaler;
  uint32_t  ClkFreq;

  if (Ch > 7)
    return;

  ChBit = 1 << Ch;

#pragma MESSAGE DISABLE C5912
#pragma MESSAGE DISABLE C4000
  if(ChBit & 0x33)        // 0 / 1 / 4 / 5 ͨ,ʹclock A/SA
  {
    if (PWMCLK & ChBit)    //ʹclock SA
      ClkFreq = PWMCLKSA;
    else                   //ʹclock A
      ClkFreq = PWMCLKA;
  }
  else                     // 2 / 3 / 6 / 7 ͨ,ʹclock B/SB
  {
    if (PWMCLK & ChBit)    //ʹclock SB
      ClkFreq = PWMCLKSB;
    else                   //ʹclock B
      ClkFreq = PWMCLKB;
  }

  if (PWMCAE & ChBit)
    ClkFreq /= 2;

  Prescaler = ClkFreq / Freq;

  if (Prescaler > 255)
    RegVal = 255;
  else
    RegVal = (uint8_t)Prescaler;

  if (RegVal == 0)
    RegVal = 1;

  pReg = &PWMPER0 + Ch;
  *pReg = RegVal;
}

/******************************************************************************
PWM_Channel_Set_Duty_Cycle
  ܣָPWMͨռձ
  Ch  ͨ 0 - 7
        Dty ռձȵİٷֵ,Χ 0 - 100
ֵ
******************************************************************************/
void PWM_Channel_Set_Duty_Cycle(uint8_t Ch, uint8_t Dty)
{
  uint8_t   ChBit;
  uint8_t   *pPERReg;
  uint8_t   *pDTYReg;
  uint16_t  Val;

  if (Ch > 7)
    return;

  ChBit = 1 << Ch;

  if (Dty > 100)
    Dty = 100;

  pPERReg = &PWMPER0 + Ch;
  pDTYReg = &PWMDTY0 + Ch;

  if (PWMPOL & ChBit)
    Val = (uint16_t)Dty;
  else
    Val = (uint16_t)(100 - Dty);

  Val *= (uint16_t)(*pPERReg);
  *pDTYReg = (uint8_t)(Val / 100);
}

/******************************************************************************
PWM_Channel_Start
  ܣָPWMͨ
  Ch  ͨ 0 - 7
ֵ
******************************************************************************/
void PWM_Channel_Start(uint8_t Ch)
{
  uint8_t ChBit;

  if (Ch > 7)
    return;

  ChBit = 1 << Ch;
  PWME |= ChBit;
}

/******************************************************************************
PWM_Channel_Stop
  ܣرָPWMͨ
  Ch  ͨ 0 - 7
ֵ
******************************************************************************/
void PWM_Channel_Stop(uint8_t Ch)
{
  uint8_t ChBit;

  if (Ch > 7)
    return;

  ChBit = 1 << Ch;
  PWME &= ~ChBit;
}