
#ifndef _RADAR_R3_H_
#define _RADAR_R3_H_

#include "API.h"
#include "SCI0_UART.h"
#include "Line_In.h"
#include "Radar_Common.h"
#include "CAN_Communication_Matrix.h"

/******************************************************************************
״
******************************************************************************/
#define   RADAR_R3_MSG_LOST_THRESHOLD       2     //unit:s

/******************************************************************************
ȫֱ
******************************************************************************/
//extern volatile uint8_t RadarMsgLost;
//#ifndef   RADAR_MSG_LOST
//#define   RADAR_MSG_LOST                    RadarMsgLost
//#define   RADAR_R3_DECLARE_MSG_LOST
//#endif

/******************************************************************************
֡
******************************************************************************/
//#define   RADAR_R3_SELF_TEST_FRAME          0xAA
//#define   RADAR_R3_MESSAGE_FRAME            0x55
#define   RADAR_R3_MESSAGE_FRAME            0x55

/******************************************************************************
֡/֡β
******************************************************************************/
//#define   RADAR_R3_SOF_SELF_TEST            0xAA
//#define   RADAR_R3_EOF_SELF_TEST            0xAF
#define   RADAR_R3_EOF1_MESSAGE              0xFE
#define   RADAR_R3_EOF2_MESSAGE              0xFF

/******************************************************************************
Bufferṹ
******************************************************************************/
typedef union
{
  uint8_t   Byte[12];
  
  struct
  {
    uint8_t   Type      : 8;              //1
    uint8_t             : 8;              //2
    uint8_t             : 8;              //3
    uint8_t             : 8;              //4
    uint8_t             : 8;              //5
    uint8_t             : 8;              //6
    uint8_t             : 8;              //7
    uint8_t             : 8;              //8
    uint8_t             : 8;              //9
    uint8_t             : 8;              //10 У
    uint8_t             : 8;              //11
    uint8_t             : 8;              //12
  }Frame;  
  struct
  {
    uint8_t   SOF       : 8; 
    uint8_t   RL_H      : 8;
    uint8_t   RL_L      : 8;
    uint8_t   RLM_H     : 8;
    uint8_t   RLM_L     : 8;
    uint8_t   RRM_H     : 8;
    uint8_t   RRM_L     : 8;
    uint8_t   RR_H      : 8;
    uint8_t   RR_L      : 8;
    uint8_t   SND       : 8;            //10 У
    uint8_t   EOF1      : 8; 
    uint8_t   EOF2      : 8; 
  }Msg;
}RadarR3DataBufferUnion;

/******************************************************************************
տƽṹ
******************************************************************************/
typedef struct
{
  uint8_t   Enable;            //
  uint8_t   SelfTest;          //Լ
  uint8_t   Rsvd;
  uint8_t   Ptr;
  uint8_t   Len;
  uint8_t   Complete;
  uint16_t  Timer;             //ʱ
  uint16_t  Counter;           //
}RadarR3ReceivingCtrlStruct;

/******************************************************************************

******************************************************************************/
void Radar_R3_Init(void);
void Radar_R3_Receiving_Service(void);
void Radar_R3_Receive_Enable(uint8_t En);
void Radar_R3_Receive_Data(uint8_t Data, uint8_t Parity);

#endif
