/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.testutils;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DebuggingOutputStream
extends FilterOutputStream {
    private static final int LINE_LENGTH = 20;
    private int lineLength;
    private boolean debug;

    public DebuggingOutputStream(OutputStream out, boolean debug) {
        super(out);
        this.debug = debug;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] byArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            byte bi = byArray[n2];
            this.write(bi);
            ++n2;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.debug) {
            System.out.print(String.valueOf(Integer.toHexString(0xFF & b)) + " ");
            if (++this.lineLength == 20) {
                System.out.println();
                this.lineLength = 0;
            }
        }
        super.write(b);
    }
}

