/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import java.util.List;

public class HorizontalMetricsTableBuilder {
    private final Font.Builder fontBuilder;
    private final List<LongHorMetric> metrics;

    public HorizontalMetricsTableBuilder(Font.Builder fontBuilder, List<LongHorMetric> metrics) {
        this.fontBuilder = fontBuilder;
        this.metrics = metrics;
    }

    public void build() {
        int nMetrics = this.metrics.size();
        if (nMetrics <= 0) {
            throw new IllegalArgumentException("nMetrics must be positive");
        }
        int lastWidth = this.metrics.get((int)(nMetrics - 1)).advanceWidth;
        int numberOfHMetrics = nMetrics;
        while (numberOfHMetrics > 1 && this.metrics.get((int)(numberOfHMetrics - 2)).advanceWidth == lastWidth) {
            --numberOfHMetrics;
        }
        int size = 4 * numberOfHMetrics + 2 * (nMetrics - numberOfHMetrics);
        WritableFontData data = WritableFontData.createWritableFontData(size);
        int index = 0;
        int advanceWidthMax = 0;
        int i = 0;
        while (i < numberOfHMetrics) {
            int advanceWidth = this.metrics.get((int)i).advanceWidth;
            advanceWidthMax = Math.max(advanceWidth, advanceWidthMax);
            index += data.writeUShort(index, advanceWidth);
            index += data.writeShort(index, this.metrics.get((int)i).lsb);
            ++i;
        }
        i = numberOfHMetrics;
        while (i < nMetrics) {
            index += data.writeShort(index, this.metrics.get((int)i).lsb);
            ++i;
        }
        this.fontBuilder.newTableBuilder(Tag.hmtx, data);
        HorizontalHeaderTable.Builder hheaBuilder = (HorizontalHeaderTable.Builder)this.fontBuilder.getTableBuilder(Tag.hhea);
        hheaBuilder.setNumberOfHMetrics(numberOfHMetrics);
        hheaBuilder.setAdvanceWidthMax(advanceWidthMax);
    }

    public static class LongHorMetric {
        public int advanceWidth;
        public int lsb;

        public LongHorMetric(int advanceWidth, int lsb) {
            this.advanceWidth = advanceWidth;
            this.lsb = lsb;
        }
    }
}

