/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.sfntly.testutils.TestFont;
import com.google.typography.font.sfntly.testutils.TestFontUtils;
import com.google.typography.font.sfntly.testutils.TestUtils;
import java.io.File;
import java.nio.charset.CharsetEncoder;
import junit.framework.TestCase;

public class GlyphTests
extends TestCase {
    private static final TestSet[] GLYPH_TESTS = new TestSet[]{new TestSet(TestFont.TestFontNames.OPENSANS.getFile(), Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value(), 32, 127)};

    public GlyphTests(String name) {
        super(name);
    }

    public void testGlyphs() throws Exception {
        TestSet[] testSetArray = GLYPH_TESTS;
        int n = GLYPH_TESTS.length;
        int n2 = 0;
        while (n2 < n) {
            TestSet test = testSetArray[n2];
            this.checkTestSet(test);
            ++n2;
        }
    }

    private void checkTestSet(TestSet test) throws Exception {
        Font[] fonts = TestFontUtils.loadFont(test.fontFile);
        Font font = fonts[0];
        CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        CMap cmap = cmapTable.cmap(test.platformId, test.encodingId);
        GlyphTests.assertNotNull(cmap);
        CharsetEncoder encoder = TestUtils.getEncoder(test.charSetName);
        int uchar = test.lowChar;
        while (uchar < test.highChar) {
            int glyphId;
            int encChar = uchar;
            if (encoder != null) {
                encChar = TestUtils.encodeOneChar(encoder, uchar);
            }
            if ((glyphId = cmap.glyphId(encChar)) != 0) {
                int offset = locaTable.glyphOffset(glyphId);
                int length = locaTable.glyphLength(glyphId);
                this.checkGlyph(glyphTable, offset, length);
            }
            ++uchar;
        }
    }

    private void checkGlyph(GlyphTable table, int offset, int length) {
        Glyph glyph = table.glyph(offset, length);
        if (length != 0) {
            GlyphTests.assertNotNull(glyph);
        }
        int padding1 = glyph.padding();
        glyph.instructionSize();
        int padding2 = glyph.padding();
        GlyphTests.assertEquals(padding1, padding2);
    }

    private static final class TestSet {
        private final File fontFile;
        private final int platformId;
        private final int encodingId;
        private final String charSetName;
        private final int lowChar;
        private final int highChar;

        public TestSet(File fontFile, int platformId, int encodingId, String charSetName, int lowChar, int highChar) {
            this.fontFile = fontFile;
            this.platformId = platformId;
            this.encodingId = encodingId;
            this.charSetName = charSetName;
            this.lowChar = lowChar;
            this.highChar = highChar;
        }

        public TestSet(File fontFile, int platformId, int encodingId, int lowChar, int highChar) {
            this(fontFile, platformId, encodingId, "", lowChar, highChar);
        }
    }
}

