/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.opentype;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.SubTable;
import com.google.typography.font.sfntly.table.opentype.LookupTable;
import com.google.typography.font.sfntly.table.opentype.component.LookupType;
import java.util.ArrayList;
import java.util.List;

abstract class LookupList
extends SubTable {
    private static final int LOOKUP_COUNT_OFFSET = 0;
    private static final int LOOKUP_OFFSET_BASE = 2;
    private static final int LOOKUP_OFFSET_SIZE = 2;

    private LookupList(ReadableFontData data, boolean dataIsCanonical) {
        super(data);
    }

    private static int readLookupCount(ReadableFontData data) {
        if (data == null) {
            return 0;
        }
        return data.readUShort(0);
    }

    private static int readLookupOffsetAt(ReadableFontData data, int index) {
        if (data == null) {
            return -1;
        }
        return data.readUShort(2 + index * 2);
    }

    private static ReadableFontData readLookupData(ReadableFontData data, boolean dataIsCanonical, int index) {
        ReadableFontData newData;
        int offset = LookupList.readLookupOffsetAt(data, index);
        if (dataIsCanonical) {
            int nextOffset = index < LookupList.readLookupCount(data) - 1 ? LookupList.readLookupOffsetAt(data, index + 1) : data.length();
            newData = data.slice(offset, nextOffset - offset);
        } else {
            newData = data.slice(offset);
        }
        return newData;
    }

    protected abstract LookupType lookupTypeAt(int var1);

    protected abstract LookupTable createLookup(ReadableFontData var1);

    static abstract class Builder
    extends SubTable.Builder<LookupList> {
        private List<LookupTable.Builder> builders;
        private boolean dataIsCanonical;
        private int serializedCount;
        private int serializedLength;

        protected Builder(ReadableFontData data, boolean dataIsCanonical) {
            super(data);
            this.dataIsCanonical = dataIsCanonical;
        }

        protected Builder() {
            this(null, false);
        }

        protected abstract LookupTable.Builder createLookupBuilder(ReadableFontData var1);

        private void initFromData(ReadableFontData data) {
            int count = LookupList.readLookupCount(data);
            this.builders = new ArrayList<LookupTable.Builder>(count);
            int i = 0;
            while (i < count) {
                ReadableFontData lookupData = LookupList.readLookupData(data, this.dataIsCanonical, i);
                LookupTable.Builder lookup = this.createLookupBuilder(lookupData);
                if (lookup != null) {
                    this.builders.add(lookup);
                }
                ++i;
            }
        }

        private void prepareToEdit() {
            if (this.builders == null) {
                this.initFromData(this.internalReadData());
            }
        }

        private int serializeFromBuilders(WritableFontData newData) {
            if (this.serializedCount == 0) {
                return 0;
            }
            newData.writeUShort(0, this.serializedCount);
            int rpos = 2;
            int spos = rpos + this.serializedCount * 2;
            int i = 0;
            while (i < this.builders.size()) {
                LookupTable.Builder builder = this.builders.get(i);
                int s = builder.subDataSizeToSerialize();
                if (s > 0) {
                    newData.writeUShort(rpos, spos);
                    rpos += 2;
                    WritableFontData targetData = newData.slice(spos);
                    builder.subSerialize(targetData);
                    spos += s;
                }
                ++i;
            }
            return this.serializedLength;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            if (this.builders == null) {
                ReadableFontData data = this.internalReadData();
                data.copyTo(newData);
                return data.length();
            }
            return this.serializeFromBuilders(newData);
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        private int computeSerializedSizeFromBuilders() {
            int size = 0;
            int count = 0;
            int i = 0;
            while (i < this.builders.size()) {
                int s = this.builders.get(i).subDataSizeToSerialize();
                if (s > 0) {
                    ++count;
                    size += s;
                }
                ++i;
            }
            if (count > 0) {
                size += 2 + count * 2;
            }
            this.serializedCount = count;
            this.serializedLength = size;
            return this.serializedLength;
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.builders == null) {
                if (this.dataIsCanonical) {
                    return this.internalReadData().length();
                }
                this.prepareToEdit();
            }
            return this.computeSerializedSizeFromBuilders();
        }

        @Override
        protected void subDataSet() {
            this.builders = null;
        }

        @Override
        protected abstract LookupList subBuildTable(ReadableFontData var1);
    }
}

