/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import com.google.typography.font.sfntly.data.MemoryByteArray;
import com.google.typography.font.sfntly.data.ReadableFontData;
import java.util.Arrays;
import junit.framework.TestCase;

public class OpenTypeDataTests
extends TestCase {
    private static final byte[] testBytes = new byte[]{-1, 1, 1, 1, 1, 1, 1, 1};

    public OpenTypeDataTests(String name) {
        super(name);
    }

    public void testRead() {
        MemoryByteArray array = new MemoryByteArray(Arrays.copyOf(testBytes, testBytes.length));
        ReadableFontData data = new ReadableFontData(array);
        OpenTypeDataTests.assertEquals(-1, data.readByte(0));
        OpenTypeDataTests.assertEquals(255, data.readUByte(0));
        OpenTypeDataTests.assertEquals(1, data.readUByte(1));
        OpenTypeDataTests.assertEquals(65281, data.readUShort(0));
        OpenTypeDataTests.assertEquals(-255, data.readShort(0));
        OpenTypeDataTests.assertEquals(0xFF0101, data.readUInt24(0));
        OpenTypeDataTests.assertEquals(0xFF010101L, data.readULong(0));
        OpenTypeDataTests.assertEquals(-16711423, data.readLong(0));
    }

    public void testCopy() throws Exception {
        byte[] sourceBytes = new byte[1024];
        int i = 0;
        while (i < sourceBytes.length) {
            sourceBytes[i] = (byte)i;
            ++i;
        }
        MemoryByteArray source = new MemoryByteArray(sourceBytes);
        byte[] destinationBytes = new byte[1024];
        MemoryByteArray destination = new MemoryByteArray(destinationBytes);
        int length = source.copyTo(destination);
        OpenTypeDataTests.assertEquals(sourceBytes.length, length);
        int i2 = 0;
        while (i2 < sourceBytes.length) {
            OpenTypeDataTests.assertEquals(sourceBytes[i2], destinationBytes[i2]);
            ++i2;
        }
    }
}

