/******************************
	Map Data
	Filename	: mapData.h
	Format Ver	: 1.1.0.27
	Date		: 2019/9/17 16:28:38 +08:00
*******************************/

#ifndef _MAPDATA_H_
#define _MAPDATA_H_

#if 1

/*------------------------------*/
/*	BASIC - DEFINITION			*/
/*------------------------------*/
typedef signed char		S08;				/* signed  8 bit integer	*/
typedef signed short	S16;				/* signed 16 bit integer	*/
typedef signed long		S32;				/* signed 32 bit integer	*/
typedef unsigned char	U08;				/* unsigned  8 bit integer	*/
typedef unsigned short	U16;				/* unsigned 16 bit integer	*/
typedef unsigned long	U32;				/* unsigned 32 bit integer	*/

#endif

/*------------------------------*/
/*	PATTERN DATA STRUCTURE		*/
/*------------------------------*/
typedef struct {							/*--------------------------*/
	U08 SpriteAttributeData[12];			/* Sprite Attribute Data	*/
	S32 PaletteID;							/* Palette ID				*/
} T_VC1H_PATTERNDATA;						/*--------------------------*/

/*------------------------------*/
/*	PALETTE DATA STRUCTURE		*/
/*------------------------------*/
typedef struct {							/*--------------------------*/
	U32 PaletteDataIndex;					/* Palette Data Index		*/
	U16 PaletteNumber;						/* Palette Number			*/
} T_VC1H_PALETTEDATA;						/*--------------------------*/

#define ROMDATA_STARTADDR	(0x00000000)
#define ROMDATA_ENDADDR	(0x009246EF)
#define ROMDATA_CHECKSUM	(0x497D)

#define PATTERN_DATA_NUMBER	(510)

enum SpriteName {
	SN_adas_png = 0,	/* adas.png - S1 */
	SN_ALARM_01_png,	/* ALARM_01.png - S2 */
	SN_ALARM_02_png,	/* ALARM_02.png - S3 */
	SN_ALARM_03_png,	/* ALARM_03.png - S4 */
	SN_ALARM_04_png,	/* ALARM_04.png - S5 */
	SN_ALARM_05_png,	/* ALARM_05.png - S6 */
	SN_ALARM_06_png,	/* ALARM_06.png - S7 */
	SN_ALARM_07_png,	/* ALARM_07.png - S8 */
	SN_ALARM_08_png,	/* ALARM_08.png - S9 */
	SN_ALARM_09_png,	/* ALARM_09.png - S10 */
	SN_ALARM_10_png,	/* ALARM_10.png - S11 */
	SN_ALARM_11_png,	/* ALARM_11.png - S12 */
	SN_ALARM_12_png,	/* ALARM_12.png - S13 */
	SN_ALARM_13_png,	/* ALARM_13.png - S14 */
	SN_ALARM_14_png,	/* ALARM_14.png - S15 */
	SN_ALARM_15_png,	/* ALARM_15.png - S16 */
	SN_ALARM_16_png,	/* ALARM_16.png - S17 */
	SN_ALARM_17_png,	/* ALARM_17.png - S18 */
	SN_ALARM_18_png,	/* ALARM_18.png - S19 */
	SN_ALARM_19_png,	/* ALARM_19.png - S20 */
	SN_ALARM_20_png,	/* ALARM_20.png - S21 */
	SN_ALARM_21_png,	/* ALARM_21.png - S22 */
	SN_ALARM_22_png,	/* ALARM_22.png - S23 */
	SN_ALARM_23_png,	/* ALARM_23.png - S24 */
	SN_ALARM_24_png,	/* ALARM_24.png - S25 */
	SN_ALARM_25_png,	/* ALARM_25.png - S26 */
	SN_ALARM_26_png,	/* ALARM_26.png - S27 */
	SN_AnimationLeft_0000_png,	/* AnimationLeft_0000.png - S28 */
	SN_AnimationLeft_0001_png,	/* AnimationLeft_0001.png - S29 */
	SN_AnimationLeft_0002_png,	/* AnimationLeft_0002.png - S30 */
	SN_AnimationLeft_0003_png,	/* AnimationLeft_0003.png - S31 */
	SN_AnimationLeft_0004_png,	/* AnimationLeft_0004.png - S32 */
	SN_AnimationLeft_0005_png,	/* AnimationLeft_0005.png - S33 */
	SN_AnimationLeft_0006_png,	/* AnimationLeft_0006.png - S34 */
	SN_AnimationLeft_0007_png,	/* AnimationLeft_0007.png - S35 */
	SN_AnimationLeft_0008_png,	/* AnimationLeft_0008.png - S36 */
	SN_AnimationLeft_0009_png,	/* AnimationLeft_0009.png - S37 */
	SN_AnimationLeft_0010_png,	/* AnimationLeft_0010.png - S38 */
	SN_AnimationLeft_0011_png,	/* AnimationLeft_0011.png - S39 */
	SN_AnimationLeft_0012_png,	/* AnimationLeft_0012.png - S40 */
	SN_AnimationLeft_0013_png,	/* AnimationLeft_0013.png - S41 */
	SN_AnimationLeft_0014_png,	/* AnimationLeft_0014.png - S42 */
	SN_AnimationLeft_0015_png,	/* AnimationLeft_0015.png - S43 */
	SN_AnimationLeft_0016_png,	/* AnimationLeft_0016.png - S44 */
	SN_AnimationLeft_0017_png,	/* AnimationLeft_0017.png - S45 */
	SN_AnimationLeft_0018_png,	/* AnimationLeft_0018.png - S46 */
	SN_AnimationLeft_0019_png,	/* AnimationLeft_0019.png - S47 */
	SN_AnimationLeft_0020_png,	/* AnimationLeft_0020.png - S48 */
	SN_AnimationLeft_0021_png,	/* AnimationLeft_0021.png - S49 */
	SN_AnimationLeft_0022_png,	/* AnimationLeft_0022.png - S50 */
	SN_AnimationLeft_0023_png,	/* AnimationLeft_0023.png - S51 */
	SN_AnimationLeft_0024_png,	/* AnimationLeft_0024.png - S52 */
	SN_AnimationLeft_0025_png,	/* AnimationLeft_0025.png - S53 */
	SN_AnimationLeft_0026_png,	/* AnimationLeft_0026.png - S54 */
	SN_AnimationLeft_0027_png,	/* AnimationLeft_0027.png - S55 */
	SN_AnimationLeft_0028_png,	/* AnimationLeft_0028.png - S56 */
	SN_AnimationLeft_0029_png,	/* AnimationLeft_0029.png - S57 */
	SN_AnimationLeft_0030_png,	/* AnimationLeft_0030.png - S58 */
	SN_AnimationLeft_0031_png,	/* AnimationLeft_0031.png - S59 */
	SN_AnimationLeft_0032_png,	/* AnimationLeft_0032.png - S60 */
	SN_AnimationLeft_0033_png,	/* AnimationLeft_0033.png - S61 */
	SN_AnimationLeft_0034_png,	/* AnimationLeft_0034.png - S62 */
	SN_AnimationLeft_0035_png,	/* AnimationLeft_0035.png - S63 */
	SN_AnimationLeft_0036_png,	/* AnimationLeft_0036.png - S64 */
	SN_AnimationLeft_0037_png,	/* AnimationLeft_0037.png - S65 */
	SN_AnimationLeft_0038_png,	/* AnimationLeft_0038.png - S66 */
	SN_AnimationLeft_0039_png,	/* AnimationLeft_0039.png - S67 */
	SN_AnimationLeft_0040_png,	/* AnimationLeft_0040.png - S68 */
	SN_AnimationLeft_0041_png,	/* AnimationLeft_0041.png - S69 */
	SN_AnimationLeft_0042_png,	/* AnimationLeft_0042.png - S70 */
	SN_AnimationLeft_0043_png,	/* AnimationLeft_0043.png - S71 */
	SN_AnimationLeft_0044_png,	/* AnimationLeft_0044.png - S72 */
	SN_AnimationLeft_0045_png,	/* AnimationLeft_0045.png - S73 */
	SN_AnimationLeft_0046_png,	/* AnimationLeft_0046.png - S74 */
	SN_AnimationLeft_0047_png,	/* AnimationLeft_0047.png - S75 */
	SN_AnimationLeft_0048_png,	/* AnimationLeft_0048.png - S76 */
	SN_AnimationLeft_0049_png,	/* AnimationLeft_0049.png - S77 */
	SN_AnimationLeft_0050_png,	/* AnimationLeft_0050.png - S78 */
	SN_AnimationLeft_0051_png,	/* AnimationLeft_0051.png - S79 */
	SN_AnimationLeft_0052_png,	/* AnimationLeft_0052.png - S80 */
	SN_AnimationLeft_0053_png,	/* AnimationLeft_0053.png - S81 */
	SN_AnimationLeft_0054_png,	/* AnimationLeft_0054.png - S82 */
	SN_AnimationLeft_0055_png,	/* AnimationLeft_0055.png - S83 */
	SN_AnimationLeft_0056_png,	/* AnimationLeft_0056.png - S84 */
	SN_AnimationLeft_0057_png,	/* AnimationLeft_0057.png - S85 */
	SN_AnimationLeft_0058_png,	/* AnimationLeft_0058.png - S86 */
	SN_AnimationLeft_0059_png,	/* AnimationLeft_0059.png - S87 */
	SN_AnimationLeft_0060_png,	/* AnimationLeft_0060.png - S88 */
	SN_AnimationLeft_0061_png,	/* AnimationLeft_0061.png - S89 */
	SN_AnimationLeft_0062_png,	/* AnimationLeft_0062.png - S90 */
	SN_AnimationLeft_0063_png,	/* AnimationLeft_0063.png - S91 */
	SN_AnimationLeft_0064_png,	/* AnimationLeft_0064.png - S92 */
	SN_AnimationLeft_0065_png,	/* AnimationLeft_0065.png - S93 */
	SN_AnimationLeft_0066_png,	/* AnimationLeft_0066.png - S94 */
	SN_AnimationLeft_0067_png,	/* AnimationLeft_0067.png - S95 */
	SN_AnimationLeft_0068_png,	/* AnimationLeft_0068.png - S96 */
	SN_AnimationLeft_0069_png,	/* AnimationLeft_0069.png - S97 */
	SN_AnimationLeft_0070_png,	/* AnimationLeft_0070.png - S98 */
	SN_AnimationLeft_0071_png,	/* AnimationLeft_0071.png - S99 */
	SN_AnimationLeft_0072_png,	/* AnimationLeft_0072.png - S100 */
	SN_AnimationLeft_0073_png,	/* AnimationLeft_0073.png - S101 */
	SN_AnimationLeft_0074_png,	/* AnimationLeft_0074.png - S102 */
	SN_AnimationLeft_0075_png,	/* AnimationLeft_0075.png - S103 */
	SN_AnimationLeft_0076_png,	/* AnimationLeft_0076.png - S104 */
	SN_AnimationLeft_0077_png,	/* AnimationLeft_0077.png - S105 */
	SN_AnimationLeft_0078_png,	/* AnimationLeft_0078.png - S106 */
	SN_AnimationLeft_0079_png,	/* AnimationLeft_0079.png - S107 */
	SN_AnimationLeft_0080_png,	/* AnimationLeft_0080.png - S108 */
	SN_AnimationLeft_0081_png,	/* AnimationLeft_0081.png - S109 */
	SN_AnimationLeft_0082_png,	/* AnimationLeft_0082.png - S110 */
	SN_AnimationLeft_0083_png,	/* AnimationLeft_0083.png - S111 */
	SN_AnimationLeft_0084_png,	/* AnimationLeft_0084.png - S112 */
	SN_AnimationLeft_0085_png,	/* AnimationLeft_0085.png - S113 */
	SN_AnimationLeft_0086_png,	/* AnimationLeft_0086.png - S114 */
	SN_AnimationLeft_0087_png,	/* AnimationLeft_0087.png - S115 */
	SN_AnimationLeft_0088_png,	/* AnimationLeft_0088.png - S116 */
	SN_AnimationRight_0000_png,	/* AnimationRight_0000.png - S117 */
	SN_AnimationRight_0001_png,	/* AnimationRight_0001.png - S118 */
	SN_AnimationRight_0002_png,	/* AnimationRight_0002.png - S119 */
	SN_AnimationRight_0003_png,	/* AnimationRight_0003.png - S120 */
	SN_AnimationRight_0004_png,	/* AnimationRight_0004.png - S121 */
	SN_AnimationRight_0005_png,	/* AnimationRight_0005.png - S122 */
	SN_AnimationRight_0006_png,	/* AnimationRight_0006.png - S123 */
	SN_AnimationRight_0007_png,	/* AnimationRight_0007.png - S124 */
	SN_AnimationRight_0008_png,	/* AnimationRight_0008.png - S125 */
	SN_AnimationRight_0009_png,	/* AnimationRight_0009.png - S126 */
	SN_AnimationRight_0010_png,	/* AnimationRight_0010.png - S127 */
	SN_AnimationRight_0011_png,	/* AnimationRight_0011.png - S128 */
	SN_AnimationRight_0012_png,	/* AnimationRight_0012.png - S129 */
	SN_AnimationRight_0013_png,	/* AnimationRight_0013.png - S130 */
	SN_AnimationRight_0014_png,	/* AnimationRight_0014.png - S131 */
	SN_AnimationRight_0015_png,	/* AnimationRight_0015.png - S132 */
	SN_AnimationRight_0016_png,	/* AnimationRight_0016.png - S133 */
	SN_AnimationRight_0017_png,	/* AnimationRight_0017.png - S134 */
	SN_AnimationRight_0018_png,	/* AnimationRight_0018.png - S135 */
	SN_AnimationRight_0019_png,	/* AnimationRight_0019.png - S136 */
	SN_AnimationRight_0020_png,	/* AnimationRight_0020.png - S137 */
	SN_AnimationRight_0021_png,	/* AnimationRight_0021.png - S138 */
	SN_AnimationRight_0022_png,	/* AnimationRight_0022.png - S139 */
	SN_AnimationRight_0023_png,	/* AnimationRight_0023.png - S140 */
	SN_AnimationRight_0024_png,	/* AnimationRight_0024.png - S141 */
	SN_AnimationRight_0025_png,	/* AnimationRight_0025.png - S142 */
	SN_AnimationRight_0026_png,	/* AnimationRight_0026.png - S143 */
	SN_AnimationRight_0027_png,	/* AnimationRight_0027.png - S144 */
	SN_AnimationRight_0028_png,	/* AnimationRight_0028.png - S145 */
	SN_AnimationRight_0029_png,	/* AnimationRight_0029.png - S146 */
	SN_AnimationRight_0030_png,	/* AnimationRight_0030.png - S147 */
	SN_AnimationRight_0031_png,	/* AnimationRight_0031.png - S148 */
	SN_AnimationRight_0032_png,	/* AnimationRight_0032.png - S149 */
	SN_AnimationRight_0033_png,	/* AnimationRight_0033.png - S150 */
	SN_AnimationRight_0034_png,	/* AnimationRight_0034.png - S151 */
	SN_AnimationRight_0035_png,	/* AnimationRight_0035.png - S152 */
	SN_AnimationRight_0036_png,	/* AnimationRight_0036.png - S153 */
	SN_AnimationRight_0037_png,	/* AnimationRight_0037.png - S154 */
	SN_AnimationRight_0038_png,	/* AnimationRight_0038.png - S155 */
	SN_AnimationRight_0039_png,	/* AnimationRight_0039.png - S156 */
	SN_AnimationRight_0040_png,	/* AnimationRight_0040.png - S157 */
	SN_AnimationRight_0041_png,	/* AnimationRight_0041.png - S158 */
	SN_AnimationRight_0042_png,	/* AnimationRight_0042.png - S159 */
	SN_AnimationRight_0043_png,	/* AnimationRight_0043.png - S160 */
	SN_AnimationRight_0044_png,	/* AnimationRight_0044.png - S161 */
	SN_AnimationRight_0045_png,	/* AnimationRight_0045.png - S162 */
	SN_AnimationRight_0046_png,	/* AnimationRight_0046.png - S163 */
	SN_AnimationRight_0047_png,	/* AnimationRight_0047.png - S164 */
	SN_AnimationRight_0048_png,	/* AnimationRight_0048.png - S165 */
	SN_AnimationRight_0049_png,	/* AnimationRight_0049.png - S166 */
	SN_AnimationRight_0050_png,	/* AnimationRight_0050.png - S167 */
	SN_AnimationRight_0051_png,	/* AnimationRight_0051.png - S168 */
	SN_AnimationRight_0052_png,	/* AnimationRight_0052.png - S169 */
	SN_AnimationRight_0053_png,	/* AnimationRight_0053.png - S170 */
	SN_AnimationRight_0054_png,	/* AnimationRight_0054.png - S171 */
	SN_AnimationRight_0055_png,	/* AnimationRight_0055.png - S172 */
	SN_AnimationRight_0056_png,	/* AnimationRight_0056.png - S173 */
	SN_AnimationRight_0057_png,	/* AnimationRight_0057.png - S174 */
	SN_AnimationRight_0058_png,	/* AnimationRight_0058.png - S175 */
	SN_AnimationRight_0059_png,	/* AnimationRight_0059.png - S176 */
	SN_AnimationRight_0060_png,	/* AnimationRight_0060.png - S177 */
	SN_AnimationRight_0061_png,	/* AnimationRight_0061.png - S178 */
	SN_AnimationRight_0062_png,	/* AnimationRight_0062.png - S179 */
	SN_AnimationRight_0063_png,	/* AnimationRight_0063.png - S180 */
	SN_AnimationRight_0064_png,	/* AnimationRight_0064.png - S181 */
	SN_AnimationRight_0065_png,	/* AnimationRight_0065.png - S182 */
	SN_AnimationRight_0066_png,	/* AnimationRight_0066.png - S183 */
	SN_AnimationRight_0067_png,	/* AnimationRight_0067.png - S184 */
	SN_AnimationRight_0068_png,	/* AnimationRight_0068.png - S185 */
	SN_AnimationRight_0069_png,	/* AnimationRight_0069.png - S186 */
	SN_AnimationRight_0070_png,	/* AnimationRight_0070.png - S187 */
	SN_AnimationRight_0071_png,	/* AnimationRight_0071.png - S188 */
	SN_AnimationRight_0072_png,	/* AnimationRight_0072.png - S189 */
	SN_AnimationRight_0073_png,	/* AnimationRight_0073.png - S190 */
	SN_AnimationRight_0074_png,	/* AnimationRight_0074.png - S191 */
	SN_AnimationRight_0075_png,	/* AnimationRight_0075.png - S192 */
	SN_AnimationRight_0076_png,	/* AnimationRight_0076.png - S193 */
	SN_AnimationRight_0077_png,	/* AnimationRight_0077.png - S194 */
	SN_AnimationRight_0078_png,	/* AnimationRight_0078.png - S195 */
	SN_AnimationRight_0079_png,	/* AnimationRight_0079.png - S196 */
	SN_AnimationRight_0080_png,	/* AnimationRight_0080.png - S197 */
	SN_AnimationRight_0081_png,	/* AnimationRight_0081.png - S198 */
	SN_AnimationRight_0082_png,	/* AnimationRight_0082.png - S199 */
	SN_AnimationRight_0083_png,	/* AnimationRight_0083.png - S200 */
	SN_AnimationRight_0084_png,	/* AnimationRight_0084.png - S201 */
	SN_AnimationRight_0085_png,	/* AnimationRight_0085.png - S202 */
	SN_AnimationRight_0086_png,	/* AnimationRight_0086.png - S203 */
	SN_AnimationRight_0087_png,	/* AnimationRight_0087.png - S204 */
	SN_AnimationRight_0088_png,	/* AnimationRight_0088.png - S205 */
	SN_chedaohuangyou_png,	/* chedaohuangyou.png - S206 */
	SN_chedaohuangzuo_png,	/* chedaohuangzuo.png - S207 */
	SN_chedaohuiyou_png,	/* chedaohuiyou.png - S208 */
	SN_chedaohuizuo_png,	/* chedaohuizuo.png - S209 */
	SN_chesu_16_1_00_png,	/* chesu-16-1-00.png - S210 */
	SN_chesu_16_1_01_png,	/* chesu-16-1-01.png - S211 */
	SN_chesu_16_1_02_png,	/* chesu-16-1-02.png - S212 */
	SN_chesu_16_1_03_png,	/* chesu-16-1-03.png - S213 */
	SN_chesu_16_1_04_png,	/* chesu-16-1-04.png - S214 */
	SN_chesu_16_1_05_png,	/* chesu-16-1-05.png - S215 */
	SN_chesu_16_1_06_png,	/* chesu-16-1-06.png - S216 */
	SN_chesu_16_1_07_png,	/* chesu-16-1-07.png - S217 */
	SN_chesu_16_1_08_png,	/* chesu-16-1-08.png - S218 */
	SN_chesu_16_2_07_png,	/* chesu-16-2-07.png - S219 */
	SN_chesu_16_2_08_png,	/* chesu-16-2-08.png - S220 */
	SN_chesu_16_2_09_png,	/* chesu-16-2-09.png - S221 */
	SN_chesu_16_2_10_png,	/* chesu-16-2-10.png - S222 */
	SN_chesu_16_2_11_png,	/* chesu-16-2-11.png - S223 */
	SN_chesu_16_2_12_png,	/* chesu-16-2-12.png - S224 */
	SN_chesu_16_2_13_png,	/* chesu-16-2-13.png - S225 */
	SN_chesu_16_2_14_png,	/* chesu-16-2-14.png - S226 */
	SN_chesu_16_2_15_png,	/* chesu-16-2-15.png - S227 */
	SN_chesu_16_2_16_png,	/* chesu-16-2-16.png - S228 */
	SN_cheti1_png,	/* cheti1.png - S229 */
	SN_cheti2_png,	/* cheti2.png - S230 */
	SN_cheti3_png,	/* cheti3.png - S231 */
	SN_ChildLock_png,	/* ChildLock.png - S232 */
	SN_daxiaoji_01_png,	/* daxiaoji-01.png - S233 */
	SN_daxiaoji_02_png,	/* daxiaoji-02.png - S234 */
	SN_G_dian_png,	/* G_dian.png - S235 */
	SN_G00_png,	/* G00.png - S236 */
	SN_G01_png,	/* G01.png - S237 */
	SN_G02_png,	/* G02.png - S238 */
	SN_G03_png,	/* G03.png - S239 */
	SN_G04_png,	/* G04.png - S240 */
	SN_G05_png,	/* G05.png - S241 */
	SN_G06_png,	/* G06.png - S242 */
	SN_G07_png,	/* G07.png - S243 */
	SN_G08_png,	/* G08.png - S244 */
	SN_G09_png,	/* G09.png - S245 */
	SN_GasPressLow_png,	/* GasPressLow.png - S246 */
	SN_Gear_0_png,	/* Gear_0.png - S247 */
	SN_Gear_1_png,	/* Gear_1.png - S248 */
	SN_Gear_2_png,	/* Gear_2.png - S249 */
	SN_Gear_3_png,	/* Gear_3.png - S250 */
	SN_Gear_4_png,	/* Gear_4.png - S251 */
	SN_Gear_5_png,	/* Gear_5.png - S252 */
	SN_Gear_6_png,	/* Gear_6.png - S253 */
	SN_Gear_7_png,	/* Gear_7.png - S254 */
	SN_Gear_8_png,	/* Gear_8.png - S255 */
	SN_Gear_9_png,	/* Gear_9.png - S256 */
	SN_Gear_Ax367y427_png,	/* Gear_Ax367y427.png - S257 */
	SN_GEAR_D_png,	/* GEAR_D.png - S258 */
	SN_GEAR_H_png,	/* GEAR_H.png - S259 */
	SN_GEAR_L_png,	/* GEAR_L.png - S260 */
	SN_GEAR_M_png,	/* GEAR_M.png - S261 */
	SN_Gear_Mx366y428_png,	/* Gear_Mx366y428.png - S262 */
	SN_GEAR_N_png,	/* GEAR_N.png - S263 */
	SN_GEAR_R_png,	/* GEAR_R.png - S264 */
	SN_heiqu_png,	/* heiqu.png - S265 */
	SN_heisequyu_png,	/* heisequyu.png - S266 */
	SN_menu00_png,	/* menu00.png - S267 */
	SN_menu01_png,	/* menu01.png - S268 */
	SN_menu02_png,	/* menu02.png - S269 */
	SN_menu03_png,	/* menu03.png - S270 */
	SN_menu04_png,	/* menu04.png - S271 */
	SN_NB_16_8_00_png,	/* NB_16.8_00.png - S272 */
	SN_NB_16_8_01_png,	/* NB_16.8_01.png - S273 */
	SN_NB_16_8_02_png,	/* NB_16.8_02.png - S274 */
	SN_NB_16_8_03_png,	/* NB_16.8_03.png - S275 */
	SN_NB_16_8_04_png,	/* NB_16.8_04.png - S276 */
	SN_NB_16_8_05_png,	/* NB_16.8_05.png - S277 */
	SN_NB_16_8_06_png,	/* NB_16.8_06.png - S278 */
	SN_NB_16_8_07_png,	/* NB_16.8_07.png - S279 */
	SN_NB_16_8_08_png,	/* NB_16.8_08.png - S280 */
	SN_NB_16_8_09_png,	/* NB_16.8_09.png - S281 */
	SN_NB_16_00_png,	/* NB_16_00.png - S282 */
	SN_NB_16_01_png,	/* NB_16_01.png - S283 */
	SN_NB_16_02_png,	/* NB_16_02.png - S284 */
	SN_NB_16_03_png,	/* NB_16_03.png - S285 */
	SN_NB_16_04_png,	/* NB_16_04.png - S286 */
	SN_NB_16_05_png,	/* NB_16_05.png - S287 */
	SN_NB_16_06_png,	/* NB_16_06.png - S288 */
	SN_NB_16_07_png,	/* NB_16_07.png - S289 */
	SN_NB_16_08_png,	/* NB_16_08.png - S290 */
	SN_NB_16_09_png,	/* NB_16_09.png - S291 */
	SN_NB_16_dian_png,	/* NB_16_dian.png - S292 */
	SN_NB_16_maohao_png,	/* NB_16_maohao.png - S293 */
	SN_NB_17_00_png,	/* NB_17_00.png - S294 */
	SN_NB_17_01_png,	/* NB_17_01.png - S295 */
	SN_NB_17_02_png,	/* NB_17_02.png - S296 */
	SN_NB_17_03_png,	/* NB_17_03.png - S297 */
	SN_NB_17_04_png,	/* NB_17_04.png - S298 */
	SN_NB_17_05_png,	/* NB_17_05.png - S299 */
	SN_NB_17_06_png,	/* NB_17_06.png - S300 */
	SN_NB_17_07_png,	/* NB_17_07.png - S301 */
	SN_NB_17_08_png,	/* NB_17_08.png - S302 */
	SN_NB_17_09_png,	/* NB_17_09.png - S303 */
	SN_NB_17_point_png,	/* NB_17_point.png - S304 */
	SN_NB_22_00_png,	/* NB_22_00.png - S305 */
	SN_NB_22_01_png,	/* NB_22_01.png - S306 */
	SN_NB_22_02_png,	/* NB_22_02.png - S307 */
	SN_NB_22_03_png,	/* NB_22_03.png - S308 */
	SN_NB_22_04_png,	/* NB_22_04.png - S309 */
	SN_NB_22_05_png,	/* NB_22_05.png - S310 */
	SN_NB_22_06_png,	/* NB_22_06.png - S311 */
	SN_NB_22_07_png,	/* NB_22_07.png - S312 */
	SN_NB_22_08_png,	/* NB_22_08.png - S313 */
	SN_NB_22_09_png,	/* NB_22_09.png - S314 */
	SN_NB_22_dian_png,	/* NB_22_dian.png - S315 */
	SN_NB_22_henggang_png,	/* NB_22_henggang.png - S316 */
	SN_NB_22_red_00_png,	/* NB_22_red_00.png - S317 */
	SN_NB_22_red_01_png,	/* NB_22_red_01.png - S318 */
	SN_NB_22_red_02_png,	/* NB_22_red_02.png - S319 */
	SN_NB_22_red_03_png,	/* NB_22_red_03.png - S320 */
	SN_NB_22_red_04_png,	/* NB_22_red_04.png - S321 */
	SN_NB_22_red_05_png,	/* NB_22_red_05.png - S322 */
	SN_NB_22_red_06_png,	/* NB_22_red_06.png - S323 */
	SN_NB_22_red_07_png,	/* NB_22_red_07.png - S324 */
	SN_NB_22_red_08_png,	/* NB_22_red_08.png - S325 */
	SN_NB_22_red_09_png,	/* NB_22_red_09.png - S326 */
	SN_NB_23_00_png,	/* NB_23_00.png - S327 */
	SN_NB_23_01_png,	/* NB_23_01.png - S328 */
	SN_NB_23_02_png,	/* NB_23_02.png - S329 */
	SN_NB_23_03_png,	/* NB_23_03.png - S330 */
	SN_NB_23_04_png,	/* NB_23_04.png - S331 */
	SN_NB_23_05_png,	/* NB_23_05.png - S332 */
	SN_NB_23_06_png,	/* NB_23_06.png - S333 */
	SN_NB_23_07_png,	/* NB_23_07.png - S334 */
	SN_NB_23_08_png,	/* NB_23_08.png - S335 */
	SN_NB_23_09_png,	/* NB_23_09.png - S336 */
	SN_NB_23_black_00_png,	/* NB_23_black_00.png - S337 */
	SN_NB_23_black_01_png,	/* NB_23_black_01.png - S338 */
	SN_NB_23_black_02_png,	/* NB_23_black_02.png - S339 */
	SN_NB_23_black_03_png,	/* NB_23_black_03.png - S340 */
	SN_NB_23_black_04_png,	/* NB_23_black_04.png - S341 */
	SN_NB_23_black_05_png,	/* NB_23_black_05.png - S342 */
	SN_NB_23_black_06_png,	/* NB_23_black_06.png - S343 */
	SN_NB_23_black_07_png,	/* NB_23_black_07.png - S344 */
	SN_NB_23_black_08_png,	/* NB_23_black_08.png - S345 */
	SN_NB_23_black_09_png,	/* NB_23_black_09.png - S346 */
	SN_NB_23_maohao_png,	/* NB_23_maohao.png - S347 */
	SN_NB_32_5_00_png,	/* NB_32.5_00.png - S348 */
	SN_NB_32_5_01_png,	/* NB_32.5_01.png - S349 */
	SN_NB_32_5_02_png,	/* NB_32.5_02.png - S350 */
	SN_NB_32_5_03_png,	/* NB_32.5_03.png - S351 */
	SN_NB_32_5_04_png,	/* NB_32.5_04.png - S352 */
	SN_NB_32_5_05_png,	/* NB_32.5_05.png - S353 */
	SN_NB_32_5_06_png,	/* NB_32.5_06.png - S354 */
	SN_NB_32_5_07_png,	/* NB_32.5_07.png - S355 */
	SN_NB_32_5_08_png,	/* NB_32.5_08.png - S356 */
	SN_NB_32_5_09_png,	/* NB_32.5_09.png - S357 */
	SN_NB_32_5_dian_png,	/* NB_32.5_dian.png - S358 */
	SN_NB_55_00_png,	/* NB_55_00.png - S359 */
	SN_NB_55_01_png,	/* NB_55_01.png - S360 */
	SN_NB_55_02_png,	/* NB_55_02.png - S361 */
	SN_NB_55_03_png,	/* NB_55_03.png - S362 */
	SN_NB_55_04_png,	/* NB_55_04.png - S363 */
	SN_NB_55_05_png,	/* NB_55_05.png - S364 */
	SN_NB_55_06_png,	/* NB_55_06.png - S365 */
	SN_NB_55_07_png,	/* NB_55_07.png - S366 */
	SN_NB_55_08_png,	/* NB_55_08.png - S367 */
	SN_NB_55_09_png,	/* NB_55_09.png - S368 */
	SN_NSignal_FL_png,	/* NSignal_FL.png - S369 */
	SN_NSignal_FR_png,	/* NSignal_FR.png - S370 */
	SN_NStudy_FL_png,	/* NStudy_FL.png - S371 */
	SN_NStudy_FR_png,	/* NStudy_FR.png - S372 */
	SN_PressStoptoP_png,	/* PressStoptoP.png - S373 */
	SN_qiya1_png,	/* qiya1.png - S374 */
	SN_qiya2_png,	/* qiya2.png - S375 */
	SN_RED_00_png,	/* RED_00.png - S376 */
	SN_RED_01_png,	/* RED_01.png - S377 */
	SN_RED_02_png,	/* RED_02.png - S378 */
	SN_RED_03_png,	/* RED_03.png - S379 */
	SN_RED_04_png,	/* RED_04.png - S380 */
	SN_RED_05_png,	/* RED_05.png - S381 */
	SN_RED_06_png,	/* RED_06.png - S382 */
	SN_RED_07_png,	/* RED_07.png - S383 */
	SN_RED_08_png,	/* RED_08.png - S384 */
	SN_RED_09_png,	/* RED_09.png - S385 */
	SN_RED_dian_png,	/* RED_dian.png - S386 */
	SN_ren1_png,	/* ren1.png - S387 */
	SN_ren2_png,	/* ren2.png - S388 */
	SN_set_1_01_png,	/* set_1_01.png - S389 */
	SN_set_1_02_png,	/* set_1_02.png - S390 */
	SN_set_1_03_png,	/* set_1_03.png - S391 */
	SN_set_1_04_png,	/* set_1_04.png - S392 */
	SN_set_1_05_png,	/* set_1_05.png - S393 */
	SN_Set_2_01_png,	/* Set_2_01.png - S394 */
	SN_Set_2_02_png,	/* Set_2_02.png - S395 */
	SN_Set_2_03_png,	/* Set_2_03.png - S396 */
	SN_Set_3_01_png,	/* Set_3_01.png - S397 */
	SN_Set_3_02_png,	/* Set_3_02.png - S398 */
	SN_Set_3_03_png,	/* Set_3_03.png - S399 */
	SN_Set_3_04_png,	/* Set_3_04.png - S400 */
	SN_Set_3_05_png,	/* Set_3_05.png - S401 */
	SN_Tire_Icon_x335y251_png,	/* Tire_Icon_x335y251.png - S402 */
	SN_Tire_Pressure_BAR_png,	/* Tire_Pressure_BAR.png - S403 */
	SN_Tire_Pressure_BARhong_png,	/* Tire_Pressure_BARhong.png - S404 */
	SN_Tire_Pressure___png,	/* Tire_Pressure_℃.png - S405 */
	SN_Tire_Pressure_cheti_png,	/* Tire_Pressure_cheti.png - S406 */
	SN_TPH_FL_png,	/* TPH_FL.png - S407 */
	SN_TPH_FR_png,	/* TPH_FR.png - S408 */
	SN_TPL_FL_png,	/* TPL_FL.png - S409 */
	SN_TPL_FR_png,	/* TPL_FR.png - S410 */
	SN_TTH_FL_png,	/* TTH_FL.png - S411 */
	SN_TTH_FR_png,	/* TTH_FR.png - S412 */
	SN_Tyre_G_png,	/* Tyre_G.png - S413 */
	SN_Tyre_Y_png,	/* Tyre_Y.png - S414 */
	SN_Vehicle_Information_Display_uint_png,	/* Vehicle_Information_Display_uint.png - S415 */
	SN_Vehicle_Information_Display1_png,	/* Vehicle_Information_Display1.png - S416 */
	SN_Vehicle_Information_Display2_png,	/* Vehicle_Information_Display2.png - S417 */
	SN_Vehicle_Information_Display3_png,	/* Vehicle_Information_Display3.png - S418 */
	SN_Vehicle_Information_Display3_uint_png,	/* Vehicle_Information_Display3_uint.png - S419 */
	SN_w40y45_png,	/* w40y45.png - S420 */
	SN_w45y45_png,	/* w45y45.png - S421 */
	SN_YELLOW_00__png,	/* YELLOW_00 .png - S422 */
	SN_YELLOW_01_png,	/* YELLOW_01.png - S423 */
	SN_YELLOW_02_png,	/* YELLOW_02.png - S424 */
	SN_YELLOW_03_png,	/* YELLOW_03.png - S425 */
	SN_YELLOW_04_png,	/* YELLOW_04.png - S426 */
	SN_YELLOW_05_png,	/* YELLOW_05.png - S427 */
	SN_YELLOW_06_png,	/* YELLOW_06.png - S428 */
	SN_YELLOW_07_png,	/* YELLOW_07.png - S429 */
	SN_YELLOW_08_png,	/* YELLOW_08.png - S430 */
	SN_YELLOW_09_png,	/* YELLOW_09.png - S431 */
	SN_YELLOW_POINT_png,	/* YELLOW_POINT.png - S432 */
	SN_youqiya00_png,	/* youqiya00.png - S433 */
	SN_youqiya01_png,	/* youqiya01.png - S434 */
	SN_youqiya02_png,	/* youqiya02.png - S435 */
	SN_youqiya03_png,	/* youqiya03.png - S436 */
	SN_youqiya04_png,	/* youqiya04.png - S437 */
	SN_youqiya05_png,	/* youqiya05.png - S438 */
	SN_youqiya06_png,	/* youqiya06.png - S439 */
	SN_youqiya07_png,	/* youqiya07.png - S440 */
	SN_youqiya08_png,	/* youqiya08.png - S441 */
	SN_youqiya09_png,	/* youqiya09.png - S442 */
	SN_youqiya10_png,	/* youqiya10.png - S443 */
	SN_youqiya11_png,	/* youqiya11.png - S444 */
	SN_youqiya12_png,	/* youqiya12.png - S445 */
	SN_youqiya13_png,	/* youqiya13.png - S446 */
	SN_youqiya14_png,	/* youqiya14.png - S447 */
	SN_youqiya15_png,	/* youqiya15.png - S448 */
	SN_youqiyashuzi_png,	/* youqiyashuzi.png - S449 */
	SN_zhishideng_01_png,	/* zhishideng-01.png - S450 */
	SN_zhishideng_01_1_png,	/* zhishideng-01-1.png - S451 */
	SN_zhishideng_02_png,	/* zhishideng-02.png - S452 */
	SN_zhishideng_03_png,	/* zhishideng-03.png - S453 */
	SN_zhishideng_04_png,	/* zhishideng-04.png - S454 */
	SN_zhishideng_05_png,	/* zhishideng-05.png - S455 */
	SN_zhishideng_06_png,	/* zhishideng-06.png - S456 */
	SN_zhishideng_07_png,	/* zhishideng-07.png - S457 */
	SN_zhishideng_08_png,	/* zhishideng-08.png - S458 */
	SN_zhishideng_09_png,	/* zhishideng-09.png - S459 */
	SN_zhishideng_10_png,	/* zhishideng-10.png - S460 */
	SN_zhishideng_11_png,	/* zhishideng-11.png - S461 */
	SN_zhishideng_12_png,	/* zhishideng-12.png - S462 */
	SN_zhishideng_13_png,	/* zhishideng-13.png - S463 */
	SN_zhishideng_14_png,	/* zhishideng-14.png - S464 */
	SN_zhishideng_15_png,	/* zhishideng-15.png - S465 */
	SN_zhishideng_16_png,	/* zhishideng-16.png - S466 */
	SN_zhishideng_17_png,	/* zhishideng-17.png - S467 */
	SN_zhishideng_18_png,	/* zhishideng-18.png - S468 */
	SN_zhishideng_19_png,	/* zhishideng-19.png - S469 */
	SN_zhishideng_20_png,	/* zhishideng-20.png - S470 */
	SN_zhishideng_21_png,	/* zhishideng-21.png - S471 */
	SN_zhishideng_22_png,	/* zhishideng-22.png - S472 */
	SN_zhishideng_23_png,	/* zhishideng-23.png - S473 */
	SN_zhishideng_23_1_png,	/* zhishideng-23-1.png - S474 */
	SN_zhishideng_24_png,	/* zhishideng-24.png - S475 */
	SN_zhishideng_25_png,	/* zhishideng-25.png - S476 */
	SN_zhishideng_26_png,	/* zhishideng-26.png - S477 */
	SN_zhishideng_27_png,	/* zhishideng-27.png - S478 */
	SN_zhishideng_28_png,	/* zhishideng-28.png - S479 */
	SN_zhishideng_29_png,	/* zhishideng-29.png - S480 */
	SN_zhuansu_1_00_png,	/* zhuansu-1-00.png - S481 */
	SN_zhuansu_1_01_png,	/* zhuansu-1-01.png - S482 */
	SN_zhuansu_1_02_png,	/* zhuansu-1-02.png - S483 */
	SN_zhuansu_1_03_png,	/* zhuansu-1-03.png - S484 */
	SN_zhuansu_1_04_png,	/* zhuansu-1-04.png - S485 */
	SN_zhuansu_1_05_png,	/* zhuansu-1-05.png - S486 */
	SN_zhuansu_1_06_png,	/* zhuansu-1-06.png - S487 */
	SN_zhuansu_2_05_png,	/* zhuansu-2-05.png - S488 */
	SN_zhuansu_2_06_png,	/* zhuansu-2-06.png - S489 */
	SN_zhuansu_2_07_png,	/* zhuansu-2-07.png - S490 */
	SN_zhuansu_2_08_png,	/* zhuansu-2-08.png - S491 */
	SN_zhuansu_2_09_png,	/* zhuansu-2-09.png - S492 */
	SN_zhuansu_2_10_png,	/* zhuansu-2-10.png - S493 */
	SN_zuoqiya00_png,	/* zuoqiya00.png - S494 */
	SN_zuoqiya01_png,	/* zuoqiya01.png - S495 */
	SN_zuoqiya02_png,	/* zuoqiya02.png - S496 */
	SN_zuoqiya03_png,	/* zuoqiya03.png - S497 */
	SN_zuoqiya04_png,	/* zuoqiya04.png - S498 */
	SN_zuoqiya05_png,	/* zuoqiya05.png - S499 */
	SN_zuoqiya06_png,	/* zuoqiya06.png - S500 */
	SN_zuoqiya07_png,	/* zuoqiya07.png - S501 */
	SN_zuoqiya08_png,	/* zuoqiya08.png - S502 */
	SN_zuoqiya09_png,	/* zuoqiya09.png - S503 */
	SN_zuoqiya10_png,	/* zuoqiya10.png - S504 */
	SN_zuoqiya11_png,	/* zuoqiya11.png - S505 */
	SN_zuoqiya12_png,	/* zuoqiya12.png - S506 */
	SN_zuoqiya13_png,	/* zuoqiya13.png - S507 */
	SN_zuoqiya14_png,	/* zuoqiya14.png - S508 */
	SN_zuoqiya15_png,	/* zuoqiya15.png - S509 */
	SN_zuoqiyashuzi_png	/* zuoqiyashuzi.png - S510 */
};
#pragma CONST_SEG __GPAGE_SEG MAPDATA_ROM
static const T_VC1H_PATTERNDATA tVc1hPatternData[] = {
	/* SpriteAttributeData[12], PaletteID */
	{{0xA0,0x00,0x00,0x00,0x01,0x44,0x00,0x80,0x00,0x00,0x40,0x40}, -1},	/* adas.png - S1 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x30,0x00,0x00,0x52,0x40,0x40}, -1},	/* ALARM_01.png - S2 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x30,0x00,0x03,0x59,0x40,0x40}, -1},	/* ALARM_02.png - S3 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x30,0x00,0x07,0x11,0x40,0x40}, -1},	/* ALARM_03.png - S4 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x30,0x00,0x0B,0x4D,0x40,0x40}, -1},	/* ALARM_04.png - S5 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x0F,0x81,0x40,0x40}, -1},	/* ALARM_05.png - S6 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x13,0xBA,0x40,0x40}, -1},	/* ALARM_06.png - S7 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x1A,0xF2,0x40,0x40}, -1},	/* ALARM_07.png - S8 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x30,0x00,0x1D,0xD6,0x40,0x40}, -1},	/* ALARM_08.png - S9 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x22,0x3D,0x40,0x40}, -1},	/* ALARM_09.png - S10 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x24,0x51,0x40,0x40}, -1},	/* ALARM_10.png - S11 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x27,0x10,0x40,0x40}, -1},	/* ALARM_11.png - S12 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x29,0x6B,0x40,0x40}, -1},	/* ALARM_12.png - S13 */
	{{0xA0,0x00,0x00,0x00,0x02,0x53,0x10,0x80,0x2B,0x84,0x40,0x40}, -1},	/* ALARM_13.png - S14 */
	{{0xA0,0x00,0x00,0x00,0x02,0x53,0x10,0x80,0x2C,0x2D,0x40,0x40}, -1},	/* ALARM_14.png - S15 */
	{{0xA0,0x00,0x00,0x00,0x02,0x53,0x10,0x80,0x2D,0x36,0x40,0x40}, -1},	/* ALARM_15.png - S16 */
	{{0xA0,0x00,0x00,0x00,0x02,0x53,0x10,0x80,0x2E,0x91,0x40,0x40}, -1},	/* ALARM_16.png - S17 */
	{{0xA0,0x00,0x00,0x00,0x02,0x53,0x10,0x80,0x2F,0xEF,0x40,0x40}, -1},	/* ALARM_17.png - S18 */
	{{0xA0,0x00,0x00,0x00,0x02,0x53,0x10,0x80,0x30,0xCA,0x40,0x40}, -1},	/* ALARM_18.png - S19 */
	{{0xA0,0x00,0x00,0x00,0x02,0x53,0x10,0x80,0x31,0x8B,0x40,0x40}, -1},	/* ALARM_19.png - S20 */
	{{0xA0,0x00,0x00,0x00,0x02,0x53,0x10,0x80,0x32,0xF6,0x40,0x40}, -1},	/* ALARM_20.png - S21 */
	{{0xA0,0x00,0x00,0x00,0x0C,0x4A,0x10,0x80,0x34,0x37,0x40,0x40}, -1},	/* ALARM_21.png - S22 */
	{{0xA0,0x00,0x00,0x00,0x0C,0x4A,0x20,0x80,0x38,0x21,0x40,0x40}, -1},	/* ALARM_22.png - S23 */
	{{0xA0,0x00,0x00,0x00,0x02,0x56,0x10,0x80,0x3A,0xF5,0x40,0x40}, -1},	/* ALARM_23.png - S24 */
	{{0xA0,0x00,0x00,0x00,0x02,0x56,0x10,0x80,0x3C,0x9F,0x40,0x40}, -1},	/* ALARM_24.png - S25 */
	{{0xA0,0x00,0x00,0x00,0x02,0x56,0x10,0x80,0x3E,0x21,0x40,0x40}, -1},	/* ALARM_25.png - S26 */
	{{0xA0,0x00,0x00,0x00,0x02,0x56,0x10,0x80,0x3E,0xE2,0x40,0x40}, -1},	/* ALARM_26.png - S27 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x80,0x40,0x0E,0x40,0x40}, -1},	/* AnimationLeft_0000.png - S28 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x80,0x46,0xAF,0x40,0x40}, -1},	/* AnimationLeft_0001.png - S29 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x80,0x4D,0x50,0x40,0x40}, -1},	/* AnimationLeft_0002.png - S30 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x80,0x57,0x52,0x40,0x40}, -1},	/* AnimationLeft_0003.png - S31 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x80,0x62,0x22,0x40,0x40}, -1},	/* AnimationLeft_0004.png - S32 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x80,0x6E,0x80,0x40,0x40}, -1},	/* AnimationLeft_0005.png - S33 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x80,0x7B,0xB3,0x40,0x40}, -1},	/* AnimationLeft_0006.png - S34 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x80,0x89,0xC5,0x40,0x40}, -1},	/* AnimationLeft_0007.png - S35 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x80,0x97,0xD7,0x40,0x40}, -1},	/* AnimationLeft_0008.png - S36 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x80,0xA6,0x90,0x40,0x40}, -1},	/* AnimationLeft_0009.png - S37 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x80,0xB6,0x00,0x40,0x40}, -1},	/* AnimationLeft_0010.png - S38 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x80,0xC6,0x29,0x40,0x40}, -1},	/* AnimationLeft_0011.png - S39 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x80,0xD6,0xF5,0x40,0x40}, -1},	/* AnimationLeft_0012.png - S40 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x80,0xE8,0x5D,0x40,0x40}, -1},	/* AnimationLeft_0013.png - S41 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x80,0xF9,0xC5,0x40,0x40}, -1},	/* AnimationLeft_0014.png - S42 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0x0B,0x6D,0x40,0x40}, -1},	/* AnimationLeft_0015.png - S43 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0x1D,0x89,0x40,0x40}, -1},	/* AnimationLeft_0016.png - S44 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0x2F,0xCB,0x40,0x40}, -1},	/* AnimationLeft_0017.png - S45 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0x42,0xBA,0x40,0x40}, -1},	/* AnimationLeft_0018.png - S46 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0x55,0xB8,0x40,0x40}, -1},	/* AnimationLeft_0019.png - S47 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0x68,0xB6,0x40,0x40}, -1},	/* AnimationLeft_0020.png - S48 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0x7C,0x47,0x40,0x40}, -1},	/* AnimationLeft_0021.png - S49 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0x90,0x11,0x40,0x40}, -1},	/* AnimationLeft_0022.png - S50 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0xA4,0x6D,0x40,0x40}, -1},	/* AnimationLeft_0023.png - S51 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0xB8,0xFD,0x40,0x40}, -1},	/* AnimationLeft_0024.png - S52 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0xCD,0xEE,0x40,0x40}, -1},	/* AnimationLeft_0025.png - S53 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0xE2,0xDF,0x40,0x40}, -1},	/* AnimationLeft_0026.png - S54 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x81,0xF7,0xFE,0x40,0x40}, -1},	/* AnimationLeft_0027.png - S55 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x82,0x0D,0x69,0x40,0x40}, -1},	/* AnimationLeft_0028.png - S56 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x82,0x23,0x14,0x40,0x40}, -1},	/* AnimationLeft_0029.png - S57 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x82,0x38,0xE6,0x40,0x40}, -1},	/* AnimationLeft_0030.png - S58 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x82,0x4E,0xFE,0x40,0x40}, -1},	/* AnimationLeft_0031.png - S59 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x82,0x65,0x16,0x40,0x40}, -1},	/* AnimationLeft_0032.png - S60 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x82,0x7B,0x5C,0x40,0x40}, -1},	/* AnimationLeft_0033.png - S61 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x82,0x91,0xC7,0x40,0x40}, -1},	/* AnimationLeft_0034.png - S62 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x82,0xA8,0x50,0x40,0x40}, -1},	/* AnimationLeft_0035.png - S63 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x82,0xBF,0x17,0x40,0x40}, -1},	/* AnimationLeft_0036.png - S64 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x82,0xD6,0x14,0x40,0x40}, -1},	/* AnimationLeft_0037.png - S65 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x82,0xED,0x11,0x40,0x40}, -1},	/* AnimationLeft_0038.png - S66 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x83,0x04,0x33,0x40,0x40}, -1},	/* AnimationLeft_0039.png - S67 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x83,0x1B,0x88,0x40,0x40}, -1},	/* AnimationLeft_0040.png - S68 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x83,0x33,0x19,0x40,0x40}, -1},	/* AnimationLeft_0041.png - S69 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x83,0x4A,0xE1,0x40,0x40}, -1},	/* AnimationLeft_0042.png - S70 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x83,0x62,0xC9,0x40,0x40}, -1},	/* AnimationLeft_0043.png - S71 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x83,0x7A,0xB1,0x40,0x40}, -1},	/* AnimationLeft_0044.png - S72 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x83,0x92,0xC6,0x40,0x40}, -1},	/* AnimationLeft_0045.png - S73 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x83,0xAA,0xF5,0x40,0x40}, -1},	/* AnimationLeft_0046.png - S74 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x83,0xC4,0xAA,0x40,0x40}, -1},	/* AnimationLeft_0047.png - S75 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x83,0xDE,0x8D,0x40,0x40}, -1},	/* AnimationLeft_0048.png - S76 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x83,0xF8,0xB3,0x40,0x40}, -1},	/* AnimationLeft_0049.png - S77 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x84,0x12,0xD9,0x40,0x40}, -1},	/* AnimationLeft_0050.png - S78 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x84,0x2D,0x1C,0x40,0x40}, -1},	/* AnimationLeft_0051.png - S79 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x84,0x47,0x8B,0x40,0x40}, -1},	/* AnimationLeft_0052.png - S80 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x84,0x62,0x0E,0x40,0x40}, -1},	/* AnimationLeft_0053.png - S81 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x84,0x7C,0xAA,0x40,0x40}, -1},	/* AnimationLeft_0054.png - S82 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x84,0x97,0x56,0x40,0x40}, -1},	/* AnimationLeft_0055.png - S83 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x84,0xB2,0x02,0x40,0x40}, -1},	/* AnimationLeft_0056.png - S84 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x84,0xCC,0xCF,0x40,0x40}, -1},	/* AnimationLeft_0057.png - S85 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x84,0xE7,0xB4,0x40,0x40}, -1},	/* AnimationLeft_0058.png - S86 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x85,0x02,0xA8,0x40,0x40}, -1},	/* AnimationLeft_0059.png - S87 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x85,0x1D,0xAA,0x40,0x40}, -1},	/* AnimationLeft_0060.png - S88 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x85,0x38,0xB8,0x40,0x40}, -1},	/* AnimationLeft_0061.png - S89 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x85,0x53,0xC6,0x40,0x40}, -1},	/* AnimationLeft_0062.png - S90 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x85,0x6E,0xDF,0x40,0x40}, -1},	/* AnimationLeft_0063.png - S91 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x85,0x8A,0x03,0x40,0x40}, -1},	/* AnimationLeft_0064.png - S92 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x85,0xA5,0x32,0x40,0x40}, -1},	/* AnimationLeft_0065.png - S93 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x85,0xC0,0x6F,0x40,0x40}, -1},	/* AnimationLeft_0066.png - S94 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x85,0xDB,0xC0,0x40,0x40}, -1},	/* AnimationLeft_0067.png - S95 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x85,0xF7,0x11,0x40,0x40}, -1},	/* AnimationLeft_0068.png - S96 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x86,0x12,0x6B,0x40,0x40}, -1},	/* AnimationLeft_0069.png - S97 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x86,0x2D,0xC7,0x40,0x40}, -1},	/* AnimationLeft_0070.png - S98 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x86,0x49,0x2E,0x40,0x40}, -1},	/* AnimationLeft_0071.png - S99 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x86,0x64,0x98,0x40,0x40}, -1},	/* AnimationLeft_0072.png - S100 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x86,0x80,0x06,0x40,0x40}, -1},	/* AnimationLeft_0073.png - S101 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x86,0x9B,0x74,0x40,0x40}, -1},	/* AnimationLeft_0074.png - S102 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x86,0xB6,0xF4,0x40,0x40}, -1},	/* AnimationLeft_0075.png - S103 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x86,0xD2,0x7C,0x40,0x40}, -1},	/* AnimationLeft_0076.png - S104 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x86,0xEE,0x08,0x40,0x40}, -1},	/* AnimationLeft_0077.png - S105 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x87,0x09,0x97,0x40,0x40}, -1},	/* AnimationLeft_0078.png - S106 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x87,0x25,0x23,0x40,0x40}, -1},	/* AnimationLeft_0079.png - S107 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x87,0x40,0xAF,0x40,0x40}, -1},	/* AnimationLeft_0080.png - S108 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x87,0x5C,0x45,0x40,0x40}, -1},	/* AnimationLeft_0081.png - S109 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x87,0x77,0xDF,0x40,0x40}, -1},	/* AnimationLeft_0082.png - S110 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x87,0x93,0x7C,0x40,0x40}, -1},	/* AnimationLeft_0083.png - S111 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x87,0xAF,0x14,0x40,0x40}, -1},	/* AnimationLeft_0084.png - S112 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x87,0xCA,0xB3,0x40,0x40}, -1},	/* AnimationLeft_0085.png - S113 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x87,0xE6,0x52,0x40,0x40}, -1},	/* AnimationLeft_0086.png - S114 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x88,0x01,0xF3,0x40,0x40}, -1},	/* AnimationLeft_0087.png - S115 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x88,0x1D,0x9B,0x40,0x40}, -1},	/* AnimationLeft_0088.png - S116 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x88,0x39,0x4F,0x40,0x40}, -1},	/* AnimationRight_0000.png - S117 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x88,0x40,0x85,0x40,0x40}, -1},	/* AnimationRight_0001.png - S118 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x88,0x47,0xBB,0x40,0x40}, -1},	/* AnimationRight_0002.png - S119 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x88,0x52,0x91,0x40,0x40}, -1},	/* AnimationRight_0003.png - S120 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x88,0x5E,0x19,0x40,0x40}, -1},	/* AnimationRight_0004.png - S121 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x88,0x6B,0x1B,0x40,0x40}, -1},	/* AnimationRight_0005.png - S122 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x88,0x78,0xC0,0x40,0x40}, -1},	/* AnimationRight_0006.png - S123 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x88,0x87,0x42,0x40,0x40}, -1},	/* AnimationRight_0007.png - S124 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x88,0x95,0xC4,0x40,0x40}, -1},	/* AnimationRight_0008.png - S125 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x88,0xA4,0xE6,0x40,0x40}, -1},	/* AnimationRight_0009.png - S126 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x88,0xB4,0x62,0x40,0x40}, -1},	/* AnimationRight_0010.png - S127 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x88,0xC4,0xD6,0x40,0x40}, -1},	/* AnimationRight_0011.png - S128 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x88,0xD5,0x95,0x40,0x40}, -1},	/* AnimationRight_0012.png - S129 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x88,0xE6,0xF6,0x40,0x40}, -1},	/* AnimationRight_0013.png - S130 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x88,0xF8,0x57,0x40,0x40}, -1},	/* AnimationRight_0014.png - S131 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0x09,0xE3,0x40,0x40}, -1},	/* AnimationRight_0015.png - S132 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0x1C,0x00,0x40,0x40}, -1},	/* AnimationRight_0016.png - S133 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0x2E,0x38,0x40,0x40}, -1},	/* AnimationRight_0017.png - S134 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0x41,0x1D,0x40,0x40}, -1},	/* AnimationRight_0018.png - S135 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0x54,0x03,0x40,0x40}, -1},	/* AnimationRight_0019.png - S136 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0x66,0xE9,0x40,0x40}, -1},	/* AnimationRight_0020.png - S137 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0x7A,0x85,0x40,0x40}, -1},	/* AnimationRight_0021.png - S138 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0x8E,0x3B,0x40,0x40}, -1},	/* AnimationRight_0022.png - S139 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0xA2,0x66,0x40,0x40}, -1},	/* AnimationRight_0023.png - S140 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0xB6,0xAF,0x40,0x40}, -1},	/* AnimationRight_0024.png - S141 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0xCB,0x3E,0x40,0x40}, -1},	/* AnimationRight_0025.png - S142 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0xDF,0xCD,0x40,0x40}, -1},	/* AnimationRight_0026.png - S143 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x89,0xF4,0x92,0x40,0x40}, -1},	/* AnimationRight_0027.png - S144 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8A,0x09,0xE3,0x40,0x40}, -1},	/* AnimationRight_0028.png - S145 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8A,0x1F,0x7A,0x40,0x40}, -1},	/* AnimationRight_0029.png - S146 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8A,0x35,0x29,0x40,0x40}, -1},	/* AnimationRight_0030.png - S147 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8A,0x4B,0x22,0x40,0x40}, -1},	/* AnimationRight_0031.png - S148 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8A,0x61,0x1B,0x40,0x40}, -1},	/* AnimationRight_0032.png - S149 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8A,0x77,0x4E,0x40,0x40}, -1},	/* AnimationRight_0033.png - S150 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8A,0x8D,0xA8,0x40,0x40}, -1},	/* AnimationRight_0034.png - S151 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8A,0xA4,0x1E,0x40,0x40}, -1},	/* AnimationRight_0035.png - S152 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8A,0xBA,0xE1,0x40,0x40}, -1},	/* AnimationRight_0036.png - S153 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8A,0xD1,0xD5,0x40,0x40}, -1},	/* AnimationRight_0037.png - S154 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8A,0xE8,0xC9,0x40,0x40}, -1},	/* AnimationRight_0038.png - S155 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8A,0xFF,0xED,0x40,0x40}, -1},	/* AnimationRight_0039.png - S156 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8B,0x17,0x4F,0x40,0x40}, -1},	/* AnimationRight_0040.png - S157 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8B,0x2E,0xE6,0x40,0x40}, -1},	/* AnimationRight_0041.png - S158 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8B,0x46,0x91,0x40,0x40}, -1},	/* AnimationRight_0042.png - S159 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8B,0x5E,0x6B,0x40,0x40}, -1},	/* AnimationRight_0043.png - S160 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8B,0x76,0x45,0x40,0x40}, -1},	/* AnimationRight_0044.png - S161 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8B,0x8E,0x43,0x40,0x40}, -1},	/* AnimationRight_0045.png - S162 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8B,0xA6,0x79,0x40,0x40}, -1},	/* AnimationRight_0046.png - S163 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8B,0xC0,0x8A,0x40,0x40}, -1},	/* AnimationRight_0047.png - S164 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8B,0xDA,0xDC,0x40,0x40}, -1},	/* AnimationRight_0048.png - S165 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8B,0xF5,0x7A,0x40,0x40}, -1},	/* AnimationRight_0049.png - S166 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8C,0x10,0x18,0x40,0x40}, -1},	/* AnimationRight_0050.png - S167 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8C,0x2A,0xE7,0x40,0x40}, -1},	/* AnimationRight_0051.png - S168 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8C,0x45,0xFF,0x40,0x40}, -1},	/* AnimationRight_0052.png - S169 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8C,0x61,0x31,0x40,0x40}, -1},	/* AnimationRight_0053.png - S170 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8C,0x7C,0x8F,0x40,0x40}, -1},	/* AnimationRight_0054.png - S171 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8C,0x98,0x08,0x40,0x40}, -1},	/* AnimationRight_0055.png - S172 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8C,0xB3,0x81,0x40,0x40}, -1},	/* AnimationRight_0056.png - S173 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8C,0xCF,0x20,0x40,0x40}, -1},	/* AnimationRight_0057.png - S174 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8C,0xEA,0xE0,0x40,0x40}, -1},	/* AnimationRight_0058.png - S175 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8D,0x06,0xBB,0x40,0x40}, -1},	/* AnimationRight_0059.png - S176 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8D,0x22,0xB0,0x40,0x40}, -1},	/* AnimationRight_0060.png - S177 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8D,0x3E,0xB4,0x40,0x40}, -1},	/* AnimationRight_0061.png - S178 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8D,0x5A,0xB8,0x40,0x40}, -1},	/* AnimationRight_0062.png - S179 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8D,0x76,0xD0,0x40,0x40}, -1},	/* AnimationRight_0063.png - S180 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8D,0x92,0xF7,0x40,0x40}, -1},	/* AnimationRight_0064.png - S181 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8D,0xAF,0x2F,0x40,0x40}, -1},	/* AnimationRight_0065.png - S182 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8D,0xCB,0x7B,0x40,0x40}, -1},	/* AnimationRight_0066.png - S183 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8D,0xE7,0xE8,0x40,0x40}, -1},	/* AnimationRight_0067.png - S184 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8E,0x04,0x55,0x40,0x40}, -1},	/* AnimationRight_0068.png - S185 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8E,0x20,0xD4,0x40,0x40}, -1},	/* AnimationRight_0069.png - S186 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8E,0x3D,0x59,0x40,0x40}, -1},	/* AnimationRight_0070.png - S187 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8E,0x59,0xE8,0x40,0x40}, -1},	/* AnimationRight_0071.png - S188 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8E,0x76,0x7B,0x40,0x40}, -1},	/* AnimationRight_0072.png - S189 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8E,0x93,0x17,0x40,0x40}, -1},	/* AnimationRight_0073.png - S190 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8E,0xAF,0xB3,0x40,0x40}, -1},	/* AnimationRight_0074.png - S191 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8E,0xCC,0x6B,0x40,0x40}, -1},	/* AnimationRight_0075.png - S192 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8E,0xE9,0x2B,0x40,0x40}, -1},	/* AnimationRight_0076.png - S193 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8F,0x05,0xF5,0x40,0x40}, -1},	/* AnimationRight_0077.png - S194 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8F,0x22,0xC4,0x40,0x40}, -1},	/* AnimationRight_0078.png - S195 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8F,0x3F,0x9A,0x40,0x40}, -1},	/* AnimationRight_0079.png - S196 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8F,0x5C,0x70,0x40,0x40}, -1},	/* AnimationRight_0080.png - S197 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8F,0x79,0x52,0x40,0x40}, -1},	/* AnimationRight_0081.png - S198 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8F,0x96,0x39,0x40,0x40}, -1},	/* AnimationRight_0082.png - S199 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8F,0xB3,0x21,0x40,0x40}, -1},	/* AnimationRight_0083.png - S200 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8F,0xD0,0x0A,0x40,0x40}, -1},	/* AnimationRight_0084.png - S201 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x8F,0xEC,0xFB,0x40,0x40}, -1},	/* AnimationRight_0085.png - S202 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x90,0x09,0xEC,0x40,0x40}, -1},	/* AnimationRight_0086.png - S203 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x90,0x26,0xE2,0x40,0x40}, -1},	/* AnimationRight_0087.png - S204 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x90,0x43,0xE4,0x40,0x40}, -1},	/* AnimationRight_0088.png - S205 */
	{{0xA0,0x00,0x00,0x00,0x09,0x42,0x00,0x90,0x60,0xF1,0x40,0x40}, -1},	/* chedaohuangyou.png - S206 */
	{{0xA0,0x00,0x00,0x00,0x09,0x42,0x00,0x90,0x61,0x41,0x40,0x40}, -1},	/* chedaohuangzuo.png - S207 */
	{{0xA0,0x00,0x00,0x00,0x09,0x42,0x10,0x90,0x61,0x8F,0x40,0x40}, -1},	/* chedaohuiyou.png - S208 */
	{{0xA0,0x00,0x00,0x00,0x09,0x42,0x10,0x90,0x61,0xDE,0x40,0x40}, -1},	/* chedaohuizuo.png - S209 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x10,0x10,0x62,0x2B,0x40,0x40}, -1},	/* chesu-16-1-00.png - S210 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x10,0x10,0x64,0xD1,0x40,0x40}, -1},	/* chesu-16-1-01.png - S211 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x10,0x10,0x67,0xBE,0x40,0x40}, -1},	/* chesu-16-1-02.png - S212 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x10,0x10,0x6A,0xD2,0x40,0x40}, -1},	/* chesu-16-1-03.png - S213 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x20,0x10,0x6E,0x26,0x40,0x40}, -1},	/* chesu-16-1-04.png - S214 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x10,0x10,0x71,0x9D,0x40,0x40}, -1},	/* chesu-16-1-05.png - S215 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x20,0x10,0x75,0x1A,0x40,0x40}, -1},	/* chesu-16-1-06.png - S216 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x30,0x10,0x78,0xA2,0x40,0x40}, -1},	/* chesu-16-1-07.png - S217 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x30,0x10,0x7C,0x1D,0x40,0x40}, -1},	/* chesu-16-1-08.png - S218 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x20,0x10,0x7F,0x56,0x40,0x40}, -1},	/* chesu-16-2-07.png - S219 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x20,0x10,0x82,0xB1,0x40,0x40}, -1},	/* chesu-16-2-08.png - S220 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x20,0x10,0x86,0x44,0x40,0x40}, -1},	/* chesu-16-2-09.png - S221 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x20,0x10,0x89,0xF7,0x40,0x40}, -1},	/* chesu-16-2-10.png - S222 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x20,0x10,0x8D,0xCC,0x40,0x40}, -1},	/* chesu-16-2-11.png - S223 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x20,0x10,0x91,0xB5,0x40,0x40}, -1},	/* chesu-16-2-12.png - S224 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x20,0x10,0x95,0xB7,0x40,0x40}, -1},	/* chesu-16-2-13.png - S225 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x20,0x10,0x99,0xDF,0x40,0x40}, -1},	/* chesu-16-2-14.png - S226 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x20,0x10,0x9E,0x22,0x40,0x40}, -1},	/* chesu-16-2-15.png - S227 */
	{{0xA0,0x00,0x00,0x00,0x49,0x63,0x20,0x10,0xA2,0x50,0x40,0x40}, -1},	/* chesu-16-2-16.png - S228 */
	{{0xA0,0x00,0x00,0x00,0x04,0x47,0x10,0x90,0xA6,0x5B,0x40,0x40}, -1},	/* cheti1.png - S229 */
	{{0xA0,0x00,0x00,0x00,0x04,0x47,0x00,0x90,0xA7,0x93,0x40,0x40}, -1},	/* cheti2.png - S230 */
	{{0xA0,0x00,0x00,0x00,0x04,0x47,0x00,0x90,0xA8,0xC9,0x40,0x40}, -1},	/* cheti3.png - S231 */
	{{0xA0,0x00,0x00,0x00,0x02,0x57,0x00,0x90,0xAA,0x69,0x40,0x40}, -1},	/* ChildLock.png - S232 */
	{{0xA0,0x00,0x00,0x00,0x47,0x71,0x30,0x10,0xAB,0x61,0x40,0x40}, -1},	/* daxiaoji-01.png - S233 */
	{{0xA0,0x00,0x00,0x00,0x47,0x71,0x30,0x10,0xAD,0x3D,0x40,0x40}, -1},	/* daxiaoji-02.png - S234 */
	{{0xA0,0x00,0x00,0x00,0x00,0x40,0x00,0x90,0xAE,0xF2,0x40,0x40}, -1},	/* G_dian.png - S235 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xAE,0xF9,0x40,0x40}, -1},	/* G00.png - S236 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xAF,0x1B,0x40,0x40}, -1},	/* G01.png - S237 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xAF,0x32,0x40,0x40}, -1},	/* G02.png - S238 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xAF,0x56,0x40,0x40}, -1},	/* G03.png - S239 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xAF,0x7A,0x40,0x40}, -1},	/* G04.png - S240 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xAF,0x99,0x40,0x40}, -1},	/* G05.png - S241 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xAF,0xBA,0x40,0x40}, -1},	/* G06.png - S242 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xAF,0xDF,0x40,0x40}, -1},	/* G07.png - S243 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xAF,0xF9,0x40,0x40}, -1},	/* G08.png - S244 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xB0,0x1E,0x40,0x40}, -1},	/* G09.png - S245 */
	{{0xA0,0x00,0x00,0x00,0x02,0x53,0x10,0x90,0xB0,0x45,0x40,0x40}, -1},	/* GasPressLow.png - S246 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x20,0x90,0xB0,0xD4,0x40,0x40}, -1},	/* Gear_0.png - S247 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x30,0x90,0xB1,0x2F,0x40,0x40}, -1},	/* Gear_1.png - S248 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x20,0x90,0xB1,0x5A,0x40,0x40}, -1},	/* Gear_2.png - S249 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x20,0x90,0xB1,0xA8,0x40,0x40}, -1},	/* Gear_3.png - S250 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x20,0x90,0xB2,0x08,0x40,0x40}, -1},	/* Gear_4.png - S251 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x20,0x90,0xB2,0x4A,0x40,0x40}, -1},	/* Gear_5.png - S252 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x20,0x90,0xB2,0xA0,0x40,0x40}, -1},	/* Gear_6.png - S253 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x20,0x90,0xB3,0x07,0x40,0x40}, -1},	/* Gear_7.png - S254 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x20,0x90,0xB3,0x3F,0x40,0x40}, -1},	/* Gear_8.png - S255 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x20,0x90,0xB3,0xAA,0x40,0x40}, -1},	/* Gear_9.png - S256 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x20,0x90,0xB4,0x11,0x40,0x40}, -1},	/* Gear_Ax367y427.png - S257 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x20,0x90,0xB5,0x46,0x40,0x40}, -1},	/* GEAR_D.png - S258 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x90,0xB5,0xE2,0x40,0x40}, -1},	/* GEAR_H.png - S259 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x30,0x90,0xB6,0x22,0x40,0x40}, -1},	/* GEAR_L.png - S260 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x20,0x90,0xB6,0x47,0x40,0x40}, -1},	/* GEAR_M.png - S261 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x20,0x90,0xB7,0x80,0x40,0x40}, -1},	/* Gear_Mx366y428.png - S262 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x20,0x90,0xB8,0xC6,0x40,0x40}, -1},	/* GEAR_N.png - S263 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x20,0x90,0xB9,0xD7,0x40,0x40}, -1},	/* GEAR_R.png - S264 */
	{{0xA0,0x00,0x00,0x00,0x51,0x52,0x00,0x10,0xBA,0xB0,0x40,0x40}, -1},	/* heiqu.png - S265 */
	{{0xA0,0x00,0x00,0x00,0x41,0x71,0x00,0x10,0xBA,0xDB,0x40,0x40}, -1},	/* heisequyu.png - S266 */
	{{0xA0,0x00,0x00,0x00,0x03,0x56,0x00,0x90,0xBA,0xE0,0x40,0x40}, -1},	/* menu00.png - S267 */
	{{0xA0,0x00,0x00,0x00,0x02,0x51,0x10,0x90,0xBB,0xD3,0x40,0x40}, -1},	/* menu01.png - S268 */
	{{0xA0,0x00,0x00,0x00,0x02,0x51,0x10,0x90,0xBC,0xEA,0x40,0x40}, -1},	/* menu02.png - S269 */
	{{0xA0,0x00,0x00,0x00,0x02,0x51,0x10,0x90,0xBD,0xFB,0x40,0x40}, -1},	/* menu03.png - S270 */
	{{0xA0,0x00,0x00,0x00,0x02,0x51,0x10,0x90,0xBE,0xA4,0x40,0x40}, -1},	/* menu04.png - S271 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x90,0xBF,0x46,0x40,0x40}, -1},	/* NB_16.8_00.png - S272 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x30,0x90,0xBF,0xA8,0x40,0x40}, -1},	/* NB_16.8_01.png - S273 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x90,0xBF,0xD6,0x40,0x40}, -1},	/* NB_16.8_02.png - S274 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x90,0xC0,0x39,0x40,0x40}, -1},	/* NB_16.8_03.png - S275 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x90,0xC0,0x9C,0x40,0x40}, -1},	/* NB_16.8_04.png - S276 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x90,0xC0,0xF4,0x40,0x40}, -1},	/* NB_16.8_05.png - S277 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x90,0xC1,0x51,0x40,0x40}, -1},	/* NB_16.8_06.png - S278 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x90,0xC1,0xC0,0x40,0x40}, -1},	/* NB_16.8_07.png - S279 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x90,0xC1,0xFC,0x40,0x40}, -1},	/* NB_16.8_08.png - S280 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x90,0xC2,0x70,0x40,0x40}, -1},	/* NB_16.8_09.png - S281 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC2,0xE0,0x40,0x40}, -1},	/* NB_16_00.png - S282 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC3,0x0A,0x40,0x40}, -1},	/* NB_16_01.png - S283 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC3,0x1C,0x40,0x40}, -1},	/* NB_16_02.png - S284 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC3,0x41,0x40,0x40}, -1},	/* NB_16_03.png - S285 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC3,0x6C,0x40,0x40}, -1},	/* NB_16_04.png - S286 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC3,0x85,0x40,0x40}, -1},	/* NB_16_05.png - S287 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC3,0xAC,0x40,0x40}, -1},	/* NB_16_06.png - S288 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC3,0xDC,0x40,0x40}, -1},	/* NB_16_07.png - S289 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC3,0xF7,0x40,0x40}, -1},	/* NB_16_08.png - S290 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC4,0x27,0x40,0x40}, -1},	/* NB_16_09.png - S291 */
	{{0xA0,0x00,0x00,0x00,0x01,0x40,0x00,0x90,0xC4,0x57,0x40,0x40}, -1},	/* NB_16_dian.png - S292 */
	{{0xA0,0x00,0x00,0x00,0x01,0x40,0x10,0x90,0xC4,0x5F,0x40,0x40}, -1},	/* NB_16_maohao.png - S293 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xC4,0x6A,0x40,0x40}, -1},	/* NB_17_00.png - S294 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x00,0x90,0xC4,0xA7,0x40,0x40}, -1},	/* NB_17_01.png - S295 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xC4,0xBF,0x40,0x40}, -1},	/* NB_17_02.png - S296 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xC4,0xF4,0x40,0x40}, -1},	/* NB_17_03.png - S297 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xC5,0x34,0x40,0x40}, -1},	/* NB_17_04.png - S298 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xC5,0x59,0x40,0x40}, -1},	/* NB_17_05.png - S299 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xC5,0x8F,0x40,0x40}, -1},	/* NB_17_06.png - S300 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x00,0x90,0xC5,0xD5,0x40,0x40}, -1},	/* NB_17_07.png - S301 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xC5,0xF7,0x40,0x40}, -1},	/* NB_17_08.png - S302 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xC6,0x40,0x40,0x40}, -1},	/* NB_17_09.png - S303 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x00,0x90,0xC6,0x85,0x40,0x40}, -1},	/* NB_17_point.png - S304 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC6,0x95,0x40,0x40}, -1},	/* NB_22_00.png - S305 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC6,0xB5,0x40,0x40}, -1},	/* NB_22_01.png - S306 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC6,0xC6,0x40,0x40}, -1},	/* NB_22_02.png - S307 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC6,0xE5,0x40,0x40}, -1},	/* NB_22_03.png - S308 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC7,0x07,0x40,0x40}, -1},	/* NB_22_04.png - S309 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC7,0x20,0x40,0x40}, -1},	/* NB_22_05.png - S310 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC7,0x40,0x40,0x40}, -1},	/* NB_22_06.png - S311 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC7,0x64,0x40,0x40}, -1},	/* NB_22_07.png - S312 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC7,0x7C,0x40,0x40}, -1},	/* NB_22_08.png - S313 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC7,0xA0,0x40,0x40}, -1},	/* NB_22_09.png - S314 */
	{{0xA0,0x00,0x00,0x00,0x02,0x40,0x00,0x90,0xC7,0xC4,0x40,0x40}, -1},	/* NB_22_dian.png - S315 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC7,0xD0,0x40,0x40}, -1},	/* NB_22_henggang.png - S316 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC7,0xDC,0x40,0x40}, -1},	/* NB_22_red_00.png - S317 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC8,0x03,0x40,0x40}, -1},	/* NB_22_red_01.png - S318 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC8,0x17,0x40,0x40}, -1},	/* NB_22_red_02.png - S319 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC8,0x3D,0x40,0x40}, -1},	/* NB_22_red_03.png - S320 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC8,0x67,0x40,0x40}, -1},	/* NB_22_red_04.png - S321 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x10,0x90,0xC8,0x84,0x40,0x40}, -1},	/* NB_22_red_05.png - S322 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC8,0xAA,0x40,0x40}, -1},	/* NB_22_red_06.png - S323 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC8,0xD7,0x40,0x40}, -1},	/* NB_22_red_07.png - S324 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC8,0xF3,0x40,0x40}, -1},	/* NB_22_red_08.png - S325 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x90,0xC9,0x20,0x40,0x40}, -1},	/* NB_22_red_09.png - S326 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xC9,0x4C,0x40,0x40}, -1},	/* NB_23_00.png - S327 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x00,0x90,0xC9,0x8E,0x40,0x40}, -1},	/* NB_23_01.png - S328 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xC9,0xA1,0x40,0x40}, -1},	/* NB_23_02.png - S329 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xC9,0xDB,0x40,0x40}, -1},	/* NB_23_03.png - S330 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xCA,0x20,0x40,0x40}, -1},	/* NB_23_04.png - S331 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xCA,0x45,0x40,0x40}, -1},	/* NB_23_05.png - S332 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xCA,0x7E,0x40,0x40}, -1},	/* NB_23_06.png - S333 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xCA,0xCA,0x40,0x40}, -1},	/* NB_23_07.png - S334 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xCA,0xF3,0x40,0x40}, -1},	/* NB_23_08.png - S335 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x90,0xCB,0x3D,0x40,0x40}, -1},	/* NB_23_09.png - S336 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x30,0x90,0xCB,0x8A,0x40,0x40}, -1},	/* NB_23_black_00.png - S337 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x20,0x90,0xCB,0xFD,0x40,0x40}, -1},	/* NB_23_black_01.png - S338 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x30,0x90,0xCC,0x4B,0x40,0x40}, -1},	/* NB_23_black_02.png - S339 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x20,0x90,0xCC,0xAA,0x40,0x40}, -1},	/* NB_23_black_03.png - S340 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x20,0x90,0xCD,0x17,0x40,0x40}, -1},	/* NB_23_black_04.png - S341 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x20,0x90,0xCD,0x6B,0x40,0x40}, -1},	/* NB_23_black_05.png - S342 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x20,0x90,0xCD,0xD0,0x40,0x40}, -1},	/* NB_23_black_06.png - S343 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x30,0x90,0xCE,0x4B,0x40,0x40}, -1},	/* NB_23_black_07.png - S344 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x20,0x90,0xCE,0x9C,0x40,0x40}, -1},	/* NB_23_black_08.png - S345 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x30,0x90,0xCF,0x0E,0x40,0x40}, -1},	/* NB_23_black_09.png - S346 */
	{{0xA0,0x00,0x00,0x00,0x02,0x40,0x00,0x90,0xCF,0x86,0x40,0x40}, -1},	/* NB_23_maohao.png - S347 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x90,0xCF,0xA2,0x40,0x40}, -1},	/* NB_32.5_00.png - S348 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x30,0x90,0xD0,0x93,0x40,0x40}, -1},	/* NB_32.5_01.png - S349 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x90,0xD1,0x17,0x40,0x40}, -1},	/* NB_32.5_02.png - S350 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x90,0xD1,0xE5,0x40,0x40}, -1},	/* NB_32.5_03.png - S351 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x90,0xD2,0xD4,0x40,0x40}, -1},	/* NB_32.5_04.png - S352 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x90,0xD3,0x90,0x40,0x40}, -1},	/* NB_32.5_05.png - S353 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x90,0xD4,0x65,0x40,0x40}, -1},	/* NB_32.5_06.png - S354 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x90,0xD5,0x59,0x40,0x40}, -1},	/* NB_32.5_07.png - S355 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x90,0xD5,0xFD,0x40,0x40}, -1},	/* NB_32.5_08.png - S356 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x90,0xD6,0xFD,0x40,0x40}, -1},	/* NB_32.5_09.png - S357 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x20,0x90,0xD8,0x00,0x40,0x40}, -1},	/* NB_32.5_dian.png - S358 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x90,0xD8,0x15,0x40,0x40}, -1},	/* NB_55_00.png - S359 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x90,0xD9,0xE2,0x40,0x40}, -1},	/* NB_55_01.png - S360 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x90,0xDA,0xCE,0x40,0x40}, -1},	/* NB_55_02.png - S361 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x90,0xDC,0x60,0x40,0x40}, -1},	/* NB_55_03.png - S362 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x90,0xDE,0x2D,0x40,0x40}, -1},	/* NB_55_04.png - S363 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x90,0xDF,0xA0,0x40,0x40}, -1},	/* NB_55_05.png - S364 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x90,0xE1,0x2E,0x40,0x40}, -1},	/* NB_55_06.png - S365 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x30,0x90,0xE3,0x27,0x40,0x40}, -1},	/* NB_55_07.png - S366 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x90,0xE4,0x5E,0x40,0x40}, -1},	/* NB_55_08.png - S367 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x90,0xE6,0x69,0x40,0x40}, -1},	/* NB_55_09.png - S368 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4C,0x10,0x90,0xE8,0x69,0x40,0x40}, -1},	/* NSignal_FL.png - S369 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4C,0x10,0x90,0xE9,0x3C,0x40,0x40}, -1},	/* NSignal_FR.png - S370 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4C,0x10,0x90,0xEA,0x11,0x40,0x40}, -1},	/* NStudy_FL.png - S371 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4C,0x10,0x90,0xEA,0xF2,0x40,0x40}, -1},	/* NStudy_FR.png - S372 */
	{{0xA0,0x00,0x00,0x00,0x02,0x53,0x10,0x90,0xEB,0xD6,0x40,0x40}, -1},	/* PressStoptoP.png - S373 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x30,0x90,0xED,0x2F,0x40,0x40}, -1},	/* qiya1.png - S374 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x30,0x90,0xEE,0x92,0x40,0x40}, -1},	/* qiya2.png - S375 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xF0,0x05,0x40,0x40}, -1},	/* RED_00.png - S376 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xF0,0x25,0x40,0x40}, -1},	/* RED_01.png - S377 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xF0,0x3C,0x40,0x40}, -1},	/* RED_02.png - S378 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xF0,0x5E,0x40,0x40}, -1},	/* RED_03.png - S379 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xF0,0x80,0x40,0x40}, -1},	/* RED_04.png - S380 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xF0,0x9E,0x40,0x40}, -1},	/* RED_05.png - S381 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xF0,0xBD,0x40,0x40}, -1},	/* RED_06.png - S382 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xF0,0xE0,0x40,0x40}, -1},	/* RED_07.png - S383 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x10,0x90,0xF0,0xF9,0x40,0x40}, -1},	/* RED_08.png - S384 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x90,0xF1,0x1C,0x40,0x40}, -1},	/* RED_09.png - S385 */
	{{0xA0,0x00,0x00,0x00,0x00,0x40,0x00,0x90,0xF1,0x41,0x40,0x40}, -1},	/* RED_dian.png - S386 */
	{{0xA0,0x00,0x00,0x00,0x04,0x42,0x30,0x90,0xF1,0x47,0x40,0x40}, -1},	/* ren1.png - S387 */
	{{0xA0,0x00,0x00,0x00,0x04,0x42,0x20,0x90,0xF2,0x29,0x40,0x40}, -1},	/* ren2.png - S388 */
	{{0xA0,0x00,0x00,0x00,0x03,0x51,0x10,0x90,0xF2,0xFC,0x40,0x40}, -1},	/* set_1_01.png - S389 */
	{{0xA0,0x00,0x00,0x00,0x03,0x51,0x10,0x90,0xF3,0xA3,0x40,0x40}, -1},	/* set_1_02.png - S390 */
	{{0xA0,0x00,0x00,0x00,0x03,0x51,0x10,0x90,0xF4,0xB7,0x40,0x40}, -1},	/* set_1_03.png - S391 */
	{{0xA0,0x00,0x00,0x00,0x03,0x51,0x10,0x90,0xF5,0x5E,0x40,0x40}, -1},	/* set_1_04.png - S392 */
	{{0xA0,0x00,0x00,0x00,0x02,0x50,0x10,0x90,0xF6,0x7F,0x40,0x40}, -1},	/* set_1_05.png - S393 */
	{{0xA0,0x00,0x00,0x00,0x03,0x51,0x10,0x90,0xF6,0xDD,0x40,0x40}, -1},	/* Set_2_01.png - S394 */
	{{0xA0,0x00,0x00,0x00,0x03,0x51,0x10,0x90,0xF7,0x8F,0x40,0x40}, -1},	/* Set_2_02.png - S395 */
	{{0xA0,0x00,0x00,0x00,0x02,0x50,0x10,0x90,0xF8,0xA5,0x40,0x40}, -1},	/* Set_2_03.png - S396 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4B,0x10,0x90,0xF9,0x06,0x40,0x40}, -1},	/* Set_3_01.png - S397 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4B,0x10,0x90,0xF9,0xCD,0x40,0x40}, -1},	/* Set_3_02.png - S398 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4B,0x10,0x90,0xFA,0x40,0x40,0x40}, -1},	/* Set_3_03.png - S399 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4B,0x10,0x90,0xFA,0x9D,0x40,0x40}, -1},	/* Set_3_04.png - S400 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x00,0x90,0xFB,0x3B,0x40,0x40}, -1},	/* Set_3_05.png - S401 */
	{{0xA0,0x00,0x00,0x00,0x03,0x43,0x00,0x90,0xFB,0x4F,0x40,0x40}, -1},	/* Tire_Icon_x335y251.png - S402 */
	{{0xA0,0x00,0x00,0x00,0x02,0x44,0x10,0x90,0xFB,0xB6,0x40,0x40}, -1},	/* Tire_Pressure_BAR.png - S403 */
	{{0xA0,0x00,0x00,0x00,0x02,0x44,0x00,0x90,0xFB,0xF5,0x40,0x40}, -1},	/* Tire_Pressure_BARhong.png - S404 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x10,0x90,0xFC,0x2D,0x40,0x40}, -1},	/* Tire_Pressure_℃.png - S405 */
	{{0xA0,0x00,0x00,0x00,0x0C,0x5D,0x10,0x90,0xFC,0x60,0x40,0x40}, -1},	/* Tire_Pressure_cheti.png - S406 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4C,0x10,0x90,0xFE,0x9E,0x40,0x40}, -1},	/* TPH_FL.png - S407 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4C,0x10,0x90,0xFF,0x81,0x40,0x40}, -1},	/* TPH_FR.png - S408 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4C,0x10,0x91,0x00,0x67,0x40,0x40}, -1},	/* TPL_FL.png - S409 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4C,0x10,0x91,0x01,0x57,0x40,0x40}, -1},	/* TPL_FR.png - S410 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4C,0x10,0x91,0x02,0x49,0x40,0x40}, -1},	/* TTH_FL.png - S411 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4C,0x10,0x91,0x03,0x35,0x40,0x40}, -1},	/* TTH_FR.png - S412 */
	{{0xA0,0x00,0x00,0x00,0x01,0x40,0x10,0x91,0x04,0x24,0x40,0x40}, -1},	/* Tyre_G.png - S413 */
	{{0xA0,0x00,0x00,0x00,0x01,0x40,0x10,0x91,0x04,0x39,0x40,0x40}, -1},	/* Tyre_Y.png - S414 */
	{{0xA0,0x00,0x00,0x00,0x01,0x47,0x10,0x91,0x04,0x53,0x40,0x40}, -1},	/* Vehicle_Information_Display_uint.png - S415 */
	{{0xA0,0x00,0x00,0x00,0x01,0x47,0x20,0x91,0x04,0xB0,0x40,0x40}, -1},	/* Vehicle_Information_Display1.png - S416 */
	{{0xA0,0x00,0x00,0x00,0x01,0x47,0x20,0x91,0x05,0x67,0x40,0x40}, -1},	/* Vehicle_Information_Display2.png - S417 */
	{{0xA0,0x00,0x00,0x00,0x01,0x47,0x20,0x91,0x06,0x25,0x40,0x40}, -1},	/* Vehicle_Information_Display3.png - S418 */
	{{0xA0,0x00,0x00,0x00,0x01,0x47,0x10,0x91,0x06,0xC3,0x40,0x40}, -1},	/* Vehicle_Information_Display3_uint.png - S419 */
	{{0xA0,0x00,0x00,0x00,0x45,0x44,0x00,0x11,0x06,0xED,0x40,0x40}, -1},	/* w40y45.png - S420 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x06,0xFC,0x40,0x40}, -1},	/* w45y45.png - S421 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x91,0x07,0x0C,0x40,0x40}, -1},	/* YELLOW_00 .png - S422 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x91,0x07,0x2B,0x40,0x40}, -1},	/* YELLOW_01.png - S423 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x91,0x07,0x41,0x40,0x40}, -1},	/* YELLOW_02.png - S424 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x91,0x07,0x61,0x40,0x40}, -1},	/* YELLOW_03.png - S425 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x91,0x07,0x80,0x40,0x40}, -1},	/* YELLOW_04.png - S426 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x91,0x07,0x9C,0x40,0x40}, -1},	/* YELLOW_05.png - S427 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x91,0x07,0xB9,0x40,0x40}, -1},	/* YELLOW_06.png - S428 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x91,0x07,0xDB,0x40,0x40}, -1},	/* YELLOW_07.png - S429 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x91,0x07,0xF3,0x40,0x40}, -1},	/* YELLOW_08.png - S430 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x00,0x91,0x08,0x14,0x40,0x40}, -1},	/* YELLOW_09.png - S431 */
	{{0xA0,0x00,0x00,0x00,0x00,0x40,0x00,0x91,0x08,0x37,0x40,0x40}, -1},	/* YELLOW_POINT.png - S432 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x08,0x3D,0x40,0x40}, -1},	/* youqiya00.png - S433 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x0D,0x3F,0x40,0x40}, -1},	/* youqiya01.png - S434 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x12,0x9B,0x40,0x40}, -1},	/* youqiya02.png - S435 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x18,0x34,0x40,0x40}, -1},	/* youqiya03.png - S436 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x1E,0x19,0x40,0x40}, -1},	/* youqiya04.png - S437 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x24,0x23,0x40,0x40}, -1},	/* youqiya05.png - S438 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x2A,0x43,0x40,0x40}, -1},	/* youqiya06.png - S439 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x30,0x70,0x40,0x40}, -1},	/* youqiya07.png - S440 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x36,0xB1,0x40,0x40}, -1},	/* youqiya08.png - S441 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x3D,0x20,0x40,0x40}, -1},	/* youqiya09.png - S442 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x43,0xCE,0x40,0x40}, -1},	/* youqiya10.png - S443 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x4A,0xAC,0x40,0x40}, -1},	/* youqiya11.png - S444 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x51,0xCB,0x40,0x40}, -1},	/* youqiya12.png - S445 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x59,0x3A,0x40,0x40}, -1},	/* youqiya13.png - S446 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x61,0x0D,0x40,0x40}, -1},	/* youqiya14.png - S447 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0x69,0x53,0x40,0x40}, -1},	/* youqiya15.png - S448 */
	{{0xA0,0x00,0x00,0x00,0x24,0x46,0x30,0x91,0x71,0xF2,0x40,0x40}, -1},	/* youqiyashuzi.png - S449 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x20,0x11,0x74,0x40,0x40,0x40}, -1},	/* zhishideng-01.png - S450 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x75,0x0A,0x40,0x40}, -1},	/* zhishideng-01-1.png - S451 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x75,0xCF,0x40,0x40}, -1},	/* zhishideng-02.png - S452 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x76,0xD9,0x40,0x40}, -1},	/* zhishideng-03.png - S453 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x77,0x87,0x40,0x40}, -1},	/* zhishideng-04.png - S454 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x78,0xD8,0x40,0x40}, -1},	/* zhishideng-05.png - S455 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x79,0xC2,0x40,0x40}, -1},	/* zhishideng-06.png - S456 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x7A,0x1E,0x40,0x40}, -1},	/* zhishideng-07.png - S457 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x7A,0xBD,0x40,0x40}, -1},	/* zhishideng-08.png - S458 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x7B,0xA5,0x40,0x40}, -1},	/* zhishideng-09.png - S459 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x7C,0x7A,0x40,0x40}, -1},	/* zhishideng-10.png - S460 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x7D,0x34,0x40,0x40}, -1},	/* zhishideng-11.png - S461 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x7D,0xC4,0x40,0x40}, -1},	/* zhishideng-12.png - S462 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x7E,0xA5,0x40,0x40}, -1},	/* zhishideng-13.png - S463 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x7F,0x13,0x40,0x40}, -1},	/* zhishideng-14.png - S464 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x30,0x11,0x7F,0xBF,0x40,0x40}, -1},	/* zhishideng-15.png - S465 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x80,0x7E,0x40,0x40}, -1},	/* zhishideng-16.png - S466 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x81,0x9A,0x40,0x40}, -1},	/* zhishideng-17.png - S467 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x91,0x82,0x84,0x40,0x40}, -1},	/* zhishideng-18.png - S468 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x91,0x82,0xD9,0x40,0x40}, -1},	/* zhishideng-19.png - S469 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x91,0x84,0x91,0x40,0x40}, -1},	/* zhishideng-20.png - S470 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x91,0x85,0x30,0x40,0x40}, -1},	/* zhishideng-21.png - S471 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x91,0x86,0x37,0x40,0x40}, -1},	/* zhishideng-22.png - S472 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x91,0x86,0x83,0x40,0x40}, -1},	/* zhishideng-23.png - S473 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x91,0x87,0x2F,0x40,0x40}, -1},	/* zhishideng-23-1.png - S474 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x91,0x87,0xF5,0x40,0x40}, -1},	/* zhishideng-24.png - S475 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x91,0x88,0x82,0x40,0x40}, -1},	/* zhishideng-25.png - S476 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x91,0x89,0x0B,0x40,0x40}, -1},	/* zhishideng-26.png - S477 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x91,0x89,0xAD,0x40,0x40}, -1},	/* zhishideng-27.png - S478 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x91,0x8A,0x2A,0x40,0x40}, -1},	/* zhishideng-28.png - S479 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x11,0x8A,0x8C,0x40,0x40}, -1},	/* zhishideng-29.png - S480 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0x8B,0x9A,0x40,0x40}, -1},	/* zhuansu-1-00.png - S481 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0x90,0x18,0x40,0x40}, -1},	/* zhuansu-1-01.png - S482 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0x95,0x9B,0x40,0x40}, -1},	/* zhuansu-1-02.png - S483 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0x9B,0xB4,0x40,0x40}, -1},	/* zhuansu-1-03.png - S484 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0xA2,0x32,0x40,0x40}, -1},	/* zhuansu-1-04.png - S485 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0xA8,0xEE,0x40,0x40}, -1},	/* zhuansu-1-05.png - S486 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0xAF,0xCB,0x40,0x40}, -1},	/* zhuansu-1-06.png - S487 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0xB6,0xB7,0x40,0x40}, -1},	/* zhuansu-2-05.png - S488 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0xBB,0x7C,0x40,0x40}, -1},	/* zhuansu-2-06.png - S489 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0xC0,0x95,0x40,0x40}, -1},	/* zhuansu-2-07.png - S490 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0xC6,0x0C,0x40,0x40}, -1},	/* zhuansu-2-08.png - S491 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0xCB,0xD5,0x40,0x40}, -1},	/* zhuansu-2-09.png - S492 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x11,0xD2,0x1D,0x40,0x40}, -1},	/* zhuansu-2-10.png - S493 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0xD8,0x8F,0x40,0x40}, -1},	/* zuoqiya00.png - S494 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0xDD,0xBC,0x40,0x40}, -1},	/* zuoqiya01.png - S495 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0xE3,0x4F,0x40,0x40}, -1},	/* zuoqiya02.png - S496 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0xE9,0x37,0x40,0x40}, -1},	/* zuoqiya03.png - S497 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0xEF,0x73,0x40,0x40}, -1},	/* zuoqiya04.png - S498 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0xF5,0xDF,0x40,0x40}, -1},	/* zuoqiya05.png - S499 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x11,0xFC,0x86,0x40,0x40}, -1},	/* zuoqiya06.png - S500 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x12,0x03,0x27,0x40,0x40}, -1},	/* zuoqiya07.png - S501 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x12,0x09,0xD1,0x40,0x40}, -1},	/* zuoqiya08.png - S502 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x12,0x10,0x7F,0x40,0x40}, -1},	/* zuoqiya09.png - S503 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x12,0x17,0x85,0x40,0x40}, -1},	/* zuoqiya10.png - S504 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x12,0x1E,0xAC,0x40,0x40}, -1},	/* zuoqiya11.png - S505 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x12,0x26,0x06,0x40,0x40}, -1},	/* zuoqiya12.png - S506 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x12,0x2D,0xB7,0x40,0x40}, -1},	/* zuoqiya13.png - S507 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x12,0x35,0xCF,0x40,0x40}, -1},	/* zuoqiya14.png - S508 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x12,0x3E,0x07,0x40,0x40}, -1},	/* zuoqiya15.png - S509 */
	{{0xA0,0x00,0x00,0x00,0x24,0x46,0x30,0x92,0x46,0xA7,0x40,0x40}, -1}	/* zuoqiyashuzi.png - S510 */
};

#pragma CONST_SEG DEFAULT 

#define PALETTE_DATA_NUMBER	(0)

#define FONTTYPE_DATA_NUMBER	(0)

#define FONT_DATA_NUMBER	(0)

#endif