/******************************************************************************
  Buzzer.c
ͷļ
    ߣ
    V1.0
    ڣ2016.5.18
******************************************************************************/

#ifndef _BUZZER_H_
#define _BUZZER_H_

#include "GPIO.h"
#include "PWM.h"
#include "Sound_Tracks.h"



/******************************************************************************
Ӳ
******************************************************************************/
#define   BUZZER_PWM_CHANNEL                4
#ifndef   BUZZER_CTRL
  #define BUZZER_CTRL                       LINE_BUZZER
#endif





#define   BUZZER_MODE_IDLE                  0
#define   BUZZER_MODE_SINGLE                1
#define   BUZZER_MODE_LOOP                  2


typedef struct
{
  uint8_t   Mode;
  uint8_t   Track;
  uint8_t   Note;
  uint16_t  Timer;
  uint16_t  Fade;
}BuzzerPlayCtrlStruct;









/******************************************************************************

******************************************************************************/
void Buzzer_Start_Up(void);
void Buzzer_Shutdown(void);
void Buzzer_Play_Track(uint8_t TrackID);
void Buzzer_Repeat_Play_Track(uint8_t TrackID);
void Buzzer_Stop_Play(void);
void Buzzer_Play_ISR(void);
#endif