
#ifndef _RADAR_F2R3_H_
#define _RADAR_F2R3_H_

#include "API.h"
#include "SCI0_UART.h"
#include "Line_In.h"
#include "Radar_Common.h"

/******************************************************************************
״
******************************************************************************/
#define   RADAR_F2R3_MSG_LOST_THRESHOLD     1.5   //unit:s
#define   RADAR_F2R3_MSG_INVALID_THRESHOLD  1.5   //unit:s
#define   RADAR_CONFIGURATION               RADAR_F2R3_CFG_F2R4

/******************************************************************************
״
******************************************************************************/
#define   RADAR_F2R3_CFG_R3                 0x1
#define   RADAR_F2R3_CFG_R4                 0x2
#define   RADAR_F2R3_CFG_F2R3               0x3
#define   RADAR_F2R3_CFG_F2R4               0x4
#define   RADAR_F2R3_CFG_F4R4               0x5
#define   RADAR_F2R3_NO_CFG                 0x7

/******************************************************************************
ϵͳ״̬
******************************************************************************/
#define   RADAR_SYS_ST_DISABLE              0x0
#define   RADAR_SYS_ST_ENABLE               0x1
#define   RADAR_SYS_ST_FAIL                 0x2

/******************************************************************************
Bufferṹ
******************************************************************************/
typedef union
{
  uint8_t   Byte[5];

  struct
  {
    uint8_t             : 3;
    uint8_t   R_SYS_ST  : 2;
    uint8_t   Config    : 3;
    uint8_t   F_SYS_ST  : 2;
    uint8_t             : 6;
    uint8_t             : 8;
    uint8_t             : 1;
    uint8_t   Snd       : 3;
    uint8_t   SndDir    : 1;
    uint8_t             : 3;
    uint8_t   CheckSum  : 8;
  }Frame;
  
  struct
  {
    uint8_t   RRM       : 1;
    uint8_t   RLM       : 1;
    uint8_t   RL        : 1;
    uint8_t   R_SYS_ST  : 2;
    uint8_t   Config    : 3;
    uint8_t   F_SYS_ST  : 2;
    uint8_t             : 2;
    uint8_t   LED0      : 1;
    uint8_t   SWITCH0   : 1;
    uint8_t   HOST0     : 1;
    uint8_t   RR        : 1;    
    uint8_t             : 1;
    uint8_t   LED1      : 1;
    uint8_t   SWITCH1   : 1;
    uint8_t   HOST1     : 1;
    uint8_t   FR        : 1;
    uint8_t   FRM       : 1;
    uint8_t   FLM       : 1; 
    uint8_t   FL        : 1; 
    uint8_t             : 1;
    uint8_t   Snd       : 3;
    uint8_t   SndDir    : 1;
    uint8_t             : 3;
    uint8_t   CheckSum  : 8;
  }Failure;
  
  struct
  {
    uint8_t   RL        : 3;
    uint8_t   R_SYS_ST  : 2;
    uint8_t   Config    : 3;
    uint8_t   F_SYS_ST  : 2;
    uint8_t   RR        : 3;
    uint8_t   RM        : 3;
    uint8_t             : 2;
    uint8_t   FM        : 3;
    uint8_t   FL        : 3;
    uint8_t             : 1;
    uint8_t   Snd       : 3;
    uint8_t   SndDir    : 1;
    uint8_t   FR        : 3;
    uint8_t   CheckSum  : 8;
  }Msg;
}RadarF2R3DataBufferUnion;

/******************************************************************************
ֵת
******************************************************************************/
static const uint8_t RadarF2R3DataConvTable[] = {0x0, 0x3, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0};

/******************************************************************************
տƽṹ
******************************************************************************/
typedef struct
{
  uint8_t   Enable;
  uint8_t   Complete;
  uint8_t   Ptr;
  uint16_t  Timer;
  uint16_t  InvalidTimer;
  uint16_t  LostTimer;
  uint16_t  Counter;
}RadarF2R3ReceivingCtrlStruct;

/******************************************************************************

******************************************************************************/
void Radar_F2R3_Init(void);
void Radar_F2R3_Receiving_Service(void);
void Radar_F2R3_Receive_Enable(uint8_t En);
void Radar_F2R3_Receive_Data(uint8_t Data, uint8_t Parity);

#endif
