

#ifndef   _EEPROM_24CXX_REMAP_H_
#define   _EEPROM_24CXX_REMAP_H_

#include  "CRG.h"
#include  "EEPROM_24Cxx.h"

/***************************************************************************************************************************
1.洢ַӳ

Ϊд󳤶Ϊһҳ(Page),ӳҳ(Page)Ϊλ,EEPROM洢Ŀռ䱻Ϊĵȷ,γһN(N = ҳ / 4)
4еҳ(Page)

Page  ^                    Physical                    Physical                    Physical                    Physical
Row   |                    Address                     Address                     Address                     Address
      |
      |   +---------------+ MC/4-1    +---------------+ 2MC/4-1   +---------------+ 3MC/4-1   +---------------+  MC-1
T/4-1 |   | Page (T/4-1)  |           | Page (2T/4-1) |           | Page (3T/4-1) |           |  Page (T-1)   |
      |   +---------------+           +---------------+           +---------------+           +---------------+
  :   |   |       :       |           |       :       |           |       :       |           |       :       |
  :   |   |       :       |           |       :       |           |       :       |           |       :       |
  :   |   |       :       |           |       :       |           |       :       |           |       :       |
      |   +---------------+           +---------------+           +---------------+           +---------------+
  1   |   |    Page (1)   |           | Page (T/4+1)  |           | Page (2T/4+1) |           | Page (3T/4+1) |
      |   +---------------+           +---------------+           +---------------+           +---------------+
  0   |   |    Page (0)   |           |  Page (T/4)   |           |  Page (2T/4)  |           |  Page (3T/4)  |
      |   +---------------+   0       +---------------+   MC/4    +---------------+  2MC/4    +---------------+  3MC/4
      +------------------------------------------------------------------------------------------------------------------>
                  0                           1                           2                           3           Page Col

* MC = Memory Capacity  洢
* T  = Total pages      ҳ

2.

ݵİȫԵȼͬݴ洢:

 - HiRel     ߿ɿݴ洢.ô洢͵ݴȡԪֽںУֽ,УֽΪֽڰλȡ.ڽ
             洢ʱ,ÿݴȡԪҳͬһ(Row)ĵ123(Col)洢һ,0Ϊҳʹ.ڽݶȡʱ,
             ÿݴȡԪеֽڻʹͬһԪеУֽڽУ,Уʧʱ, Ȼд洢λ
             ݵԪΪ,Ӷ֤ݴ洢Ŀɿ.
             ߿ɿԵһ;ҳͬһ(Row)еĲͬ(Col)ַǷɢEEPROM֮е,EEPROM
             Ŷʧĳһʱ,Ȼ洢ڸݴȡԪһͬʧ,洢δӰݵԪ
             ԿԱ֤ݿ˳ȡ.

 - ExtLife   չݴ洢.EEPROMĲдԼΪ 1,000,000 ,ĳЩҪƵд,һҲд
             Ҫ.չݴ洢ǽݴȡԪش洢ҳ3(Row)4(Col)12ͬλ,Ӷ
             12,ﵽ 12,000,000 βд.ִ洢͵ݴȡԪΪ,һΪ16λĹ,ڶΪ
             ,Ϊ16λֽڵChecksum.ÿδ洢ʱ,µݽ洢ҳеһµλ,
             ͬʱ,Ĺ1.ȡʱ,ҳееĹȡ,ݹֵ
             һݴ洢Ԫаµ.
             չݴ洢ȻԱ֤ϸߵݿɿ,洢ʱ,ͬʱֽڵChecksumһ洢,ʱʹø
             CheckSumԶֽڽУ,Уʧ,ȡǰһδ洢,ֱݱ.һ,߿ɿݴ洢
             ͬ,ݴȡԪɢEEPROMд洢,ɵⶪʧ.

 - Normal    ͨݴ洢.ڴ洢һԵ,ִ洢ʽİȫEEPROMĿɿ,ڴһԵ

 3.ݷֲ

 +-------------------+-------+------------+------------+------------+------------+
 |     Data Type     |  Row  |   Col 0    |   Col 1    |   Col 2    |   Col 3    |
 +-------------------+-------+------------+------------+------------+------------+
 |                   | T/4-1 | NPage(M-4) | NPage(M-3) | NPage(M-2) | NPage(M-1) |
 |                   +-------+------------+------------+------------+------------+
 |                   |   :   |     :      |     :      |     :      |     :      |
 |                   |   :   |     :      |     :      |     :      |     :      |
 |      Normal       +-------+------------+------------+------------+------------+
 |                   |  N+1  |  NPage(4)  |  NPage(5)  |  NPage(6)  |  NPage(7)  |
 |                   +-------+------------+------------+------------+------------+
 |                   |   N   |  NPage(0)  |  NPage(1)  |  NPage(2)  |  NPage(3)  |
 +---------+---------+-------+------------+------------+------------+------------+
 |         |    :    |   :   |     :      |     :      |     :      |     :      |
 |         |    :    |   :   |     :      |     :      |     :      |     :      |
 |         +---------+-------+------------+------------+------------+------------+
 |         |         |  E+5  |  EPage(8)  |  EPage(9)  |  EPage(10) |  EPage(11) |
 |         |         +-------+------------+------------+------------+------------+
 |         | EData 1 |  E+4  |  EPage(4)  |  EPage(5)  |  EPage(6)  |  EPage(7)  |
 |         |         +-------+------------+------------+------------+------------+
 | ExtLife |         |  E+3  |  EPage(0)  |  EPage(1)  |  EPage(2)  |  EPage(3)  |
 |         +---------+-------+------------+------------+------------+------------+
 |         |         |  E+2  |  EPage(8)  |  EPage(9)  |  EPage(10) |  EPage(11) |
 |         |         +-------+------------+------------+------------+------------+
 |         | EData 0 |  E+1  |  EPage(4)  |  EPage(5)  |  EPage(6)  |  EPage(7)  |
 |         |         +-------+------------+------------+------------+------------+
 |         |         |   E   |  EPage(0)  |  EPage(1)  |  EPage(2)  |  EPage(3)  |
 +---------+---------+-------+------------+------------+------------+------------+
 |         |    :    |   :   |     :      |     :      |     :      |     :      |
 |         |    :    |   :   |     :      |     :      |     :      |     :      |
 |         +---------+-------+------------+------------+------------+------------+
 | HiRel   | HData 1 |   1   |   Rsvd.    |  HPage(0)  |  HPage(1)  |  HPage(2)  |
 |         +---------+-------+------------+------------+------------+------------+
 |         | HData 0 |   0   |   Rsvd.    |  HPage(0)  |  HPage(1)  |  HPage(2)  |
 +---------+---------+-------+------------+------------+------------+------------+

 * T     = Total pages                ҳ
 * M     = Total Normal Data pages    ͨݴ洢ҳ
 * N     = Start row of Normal Data   ͨݴ洢ʼ
 * NPage = Normal Data page           ͨݴ洢ҳ
 * E     = Start row of ExtLife Data  չݴ洢ʼ
 * EPage = ExtLife Data page          չݴ洢ҳ
 * EData = ExtLife Data               չ
 * HPage = HiRel Data page            ߿ɿݴ洢ҳ
 * HData = HiRel Data                 ߿ɿ

***************************************************************************************************************************/

/***************************************************************************************************************************
洢
***************************************************************************************************************************/
#define   EEPPROM_HIREL_DATA_NUM                  2              //߿ɿ
#define   EEPPROM_EXTLIFE_DATA_NUM                0              //չ

#define   EEPPROM_DATA_BUFFER_SIZE                32

#define   EEPPROM_DEVICE_ADDR                     0              //洢Ӳַ

/***************************************************************************************************************************
Ԥ
***************************************************************************************************************************/
/*** 洢ȫ ***/
#define   EEPPROM_TOTAL_ROW_NUM                   (EEPROM_TOTAL_PAGE_NUM / 4)

/*** ߿ɿ ***/
#define   EEPPROM_HIREL_DATA_MAX_LEN              (EEPROM_PAGE_SIZE / 2)

/*** չ ***/
#define   EEPPROM_EXTLIFE_DATA_ROW_OFFSEET        EEPPROM_HIREL_DATA_NUM
#define   EEPPROM_EXTLIFE_DATA_MAX_LEN            (EEPROM_PAGE_SIZE - 4)

/*** ͨ ***/
#define   EEPPROM_DATA_ROW_OFFSEET                (EEPPROM_HIREL_DATA_NUM + EEPPROM_EXTLIFE_DATA_NUM * 3)
#define   EEPPROM_DATA_TOTAL_PAGE_NUM             ((EEPPROM_TOTAL_ROW_NUM - EEPPROM_DATA_ROW_OFFSEET) * 4)
#define   EEPPROM_DATA_MAX_ADDR                   (EEPROM_PAGE_SIZE * EEPPROM_DATA_TOTAL_PAGE_NUM - 1)

/***************************************************************************************************************************

***************************************************************************************************************************/
#define   EEPROM_HIREL_DATA_TYPE                  0
#define   EEPROM_EXTLIFE_DATA_TYPE                1
#define   EEPROM_NORMAL_DATA_TYPE                 2

/***************************************************************************************************************************
״̬
***************************************************************************************************************************/
typedef enum
{
  EEPROM_DATA_OK = 0,
  EEPROM_DATA_PARTIAL_LOST,
  EEPROM_DATA_LOST,
  EEPROM_DATA_ADDR_ERR,
  EEPROM_DATA_LEN_ERR,
  EEPROM_DATA_RW_FAIL,
  EEPROM_MEMORY_BUSY,
  EEPROM_MEMORY_ABSENT,
} EEPROMAccessStatusEnum;

/***************************************************************************************************************************
ݴȡ
***************************************************************************************************************************/
#if (EEPPROM_DATA_BUFFER_SIZE < EEPROM_PAGE_SIZE)

typedef struct
{
  uint8_t   Type;
  uint8_t   Data[EEPROM_PAGE_SIZE];
  uint16_t  DataLen;
  uint8_t   Row;
  uint8_t   Col;
  uint8_t   Offset;
  uint8_t   Retry;
  uint8_t   WrLen;
  uint16_t  WrCnt;
  uint8_t   Busy;
  EEPROMAccessStatusEnum  Result;
} EEPROMDataWrCtrlStruct;

#else

typedef struct
{
  uint8_t   Type;
  uint8_t   Data[EEPPROM_DATA_BUFFER_SIZE];
  uint16_t  DataLen;
  uint8_t   Row;
  uint8_t   Col;
  uint8_t   Offset;
  uint8_t   Retry;
  uint8_t   WrLen;
  uint16_t  WrCnt;
  uint8_t   Busy;
  EEPROMAccessStatusEnum  Result;
} EEPROMDataWrCtrlStruct;

#endif









/***************************************************************************************************************************

***************************************************************************************************************************/
/*** ⲿ ***/
EEPROMAccessStatusEnum EEPROM_Data_Write(uint8_t Type, uint16_t Addr, uint8_t *pData, uint8_t Len);
EEPROMAccessStatusEnum EEPROM_Get_Data_Write_Status(void);
EEPROMAccessStatusEnum EEPROM_Startup_Data_Read(uint8_t Type, uint16_t Addr, uint8_t *pData, uint8_t Len);
void    EEPROM_Access_Service(void);

/**************************************************************************************************************************/
/*** HiRelݶд ***/
EEPROMAccessStatusEnum EEPROM_HiRel_Data_Write(uint16_t Addr, uint8_t *pData, uint8_t Len);
EEPROMAccessStatusEnum EEPROM_Startup_HiRel_Data_Read(uint16_t Addr, uint8_t *pData, uint8_t Len);
EEPROMAccessStatusEnum EEPROM_Startup_HiRel_Page_Read(uint8_t Row, uint8_t Col, uint8_t *pData, uint8_t Len);
uint8_t EEPROM_HiRel_Data_Check(uint8_t *pData, uint8_t Len);
void    EEPROM_HiRel_Data_Write_Service(void);

/*** ExtLifeݶд ***/

/*** Normalݶд ***/
EEPROMAccessStatusEnum EEPROM_Normal_Data_Write(uint16_t Addr, uint8_t *pData, uint16_t Len);
EEPROMAccessStatusEnum EEPROM_Startup_Normal_Data_Read(uint16_t Addr, uint8_t *pData, uint8_t Len);
void    EEPROM_Normal_Data_Write_Service(void);

/*** ַ ***/
void    EEPROM_Copy_Data(uint8_t *pDstData, uint8_t *pSrcData, uint8_t Len);
uint8_t EEPROM_Compare_Data(uint8_t *pDstData, uint8_t *pSrcData, uint8_t Len);




#endif