/* 
 *	SPI Flash Memory support functions
 *
 *	Copyright(c) 2011 Yamaha Corporation
 */

#include "YGV642_SPI_Flash_IS25LP256D.h"
#include "YGV642_SPI_Flash_S25FL256S.h"
#include "YGV642_SPI_Flash_W25Q256FV.h"
#include "YGV642_SPI_Flash_W25Q128FV.h"
#include "YGV642_SPI_Flash_GD25Q127C.h"

/*------------------------------------------------------------------------------*/
/* Function name    : YGV642_Pattern_Memory_Init                                */
/* Contents         : Initialize Pattern Memory                                 */
/* Argument         : void                                                      */
/* Return value     : TRUE or FALSE                                             */
/*------------------------------------------------------------------------------*/
void YGV642_Pattern_Memory_Init(void)
{
  for (;;)
  {
    #ifdef USE_ISSI_IS25LP256D
    if (PM_IS25LP256D_ID_Check())
    {
      PM_IS25LP256D_Init();
      return;
    }
    #endif
    
    #ifdef USE_SPANSION_S25FL256S
    if (PM_S25FL256S_ID_Check())
    {
      PM_S25FL256S_Init();
      return;
    }
    #endif
    
    #ifdef USE_WINBOND_W25Q256FV
    if (PM_W25Q256FV_ID_Check())
    {
      PM_W25Q256FV_Init();
      return;
    }
    #endif
    
    #ifdef USE_WINBOND_W25Q128FV
    if (PM_W25Q128FV_ID_Check())
    {
      PM_W25Q128FV_Init();
      return;
    }
    #endif
    
    #ifdef USE_GIGADEVICE_GD25Q127C
    if (PM_GD25Q127C_ID_Check())
    {
      PM_GD25Q127C_Init();
      return;
    }
    #endif
  }
}