
#include "Popup_Scheduler.h"

/*** Ϣ״̬() ***/
PopupStatusStruct         PopupStatus[POPUP_NUMBER_TOTAL];

/*=====================================================
                  Ϣ
-------------------------------------------------------
                |            
 (±) |
-------------------------------------------------------
          0         | POPUP_LINK_LIST_NEW_FATAL
          1         | POPUP_LINK_LIST_FATAL
                    |
          2         | POPUP_LINK_LIST_NEW_HINT
          3         | POPUP_LINK_LIST_HINT
                    |
          3         | POPUP_LINK_LIST_NEW_WARNING
          4         | POPUP_LINK_LIST_WARNING
          5         | POPUP_LINK_LIST_MASKED_WARNING
=====================================================*/
PopupLinkListCtrlStruct   PopupLinkList[7];

/*** Ϣȹ ***/
PopupSchedulingStruct     PopupScheduling;

/******************************************************************************
Popup_Scheduler_Init
  ܣʼϢ
  
ֵ
******************************************************************************/
void Popup_Scheduler_Init(void)
{
  uint8_t i;

  for (i = 0; i < POPUP_NUMBER_TOTAL; i++)
  {
    PopupStatus[i].Status     = POPUP_STATUS_OFF;
    PopupStatus[i].LinkList   = POPUP_LINK_LIST_NONE;
    PopupStatus[i].Prev       = i;
    PopupStatus[i].Next       = i;
    PopupStatus[i].SndReqCode = 1;
  }

  Popup_Link_List_Init(     POPUP_LINK_LIST_NEW_FATAL, POPUP_PRIORITY_NUMBER_FATAL);
  Popup_Link_List_Init(         POPUP_LINK_LIST_FATAL, POPUP_PRIORITY_NUMBER_FATAL);

  Popup_Link_List_Init(      POPUP_LINK_LIST_NEW_HINT, POPUP_PRIORITY_NUMBER_HINT);
  Popup_Link_List_Init(          POPUP_LINK_LIST_HINT, POPUP_PRIORITY_NUMBER_HINT);

  Popup_Link_List_Init(   POPUP_LINK_LIST_NEW_WARNING, POPUP_PRIORITY_NUMBER_WARNING);
  Popup_Link_List_Init(       POPUP_LINK_LIST_WARNING, POPUP_PRIORITY_NUMBER_WARNING);
  Popup_Link_List_Init(POPUP_LINK_LIST_MASKED_WARNING, POPUP_PRIORITY_NUMBER_WARNING);

  PopupScheduling.Timer         = 0;
  PopupScheduling.Current       = POPUP_NONE;
  PopupScheduling.NewSnd        = 0;
  PopupScheduling.WarningExist  = 0;
  PopupScheduling.MaskReq       = 0;
  PopupScheduling.LastMasked    = POPUP_NONE;
  PopupScheduling.MaskedPolling = 0;
}

/******************************************************************************
Popup_Scheduling_Service
  ܣȵϢ,µǰӦʾĵϢӦŵı
        ܵʾĵϢл    1.ǰʾĵϢɾ
                                                2.ǰʾĵϢ
                                                3.µϢ
                                                4.ǰϢʾʱ䵽
  
ֵ
*******************************************************************************
ע  ⣺÷ÿ100msһ
******************************************************************************/
void Popup_Scheduling_Service(void)
{
  uint8_t   i;
  uint8_t   PopupID;
  uint8_t   PopupMbr;
  uint8_t   PopupNext;
  uint8_t   PopupMaskEn;

  if (SYS_SELF_TEST_DISP_MODE)
    return;

  if (PopupScheduling.Timer < 0xFF)
    PopupScheduling.Timer++;

  PopupMaskEn = 0;                            //רڴαʱ,ǡõǰʾıɾ

  /*===========================================================================
  1.ǰʾĵϢɾ
  ============================================================================*/
  if (PopupScheduling.Current < POPUP_NUMBER_TOTAL)
  {
    if (PopupStatus[PopupScheduling.Current].Status == POPUP_STATUS_DELETE)
    {
      if ((PopupStatus[PopupScheduling.Current].LinkList == POPUP_LINK_LIST_NEW_FATAL) || \
          (PopupStatus[PopupScheduling.Current].LinkList == POPUP_LINK_LIST_NEW_WARNING))
      {
        if ((PopupStatus[PopupScheduling.Current].LinkList == POPUP_LINK_LIST_NEW_WARNING) &&
            (PopupScheduling.Timer >= POPUP_DISP_TIME_MIN * 10))
          PopupMaskEn = 1;

        /*if ((PopupScheduling.Timer >= POPUP_DISP_TIME_MIN * 10)   || \
            (PopupAttributeTable[PopupScheduling.Current].Message == POPUP_MSG_DOOR_OPEN_HI_SPEED) || \
            (PopupAttributeTable[PopupScheduling.Current].Message == POPUP_MSG_DOOR_OPEN_LOW_SPEED))*/
        if (PopupScheduling.Timer >= POPUP_DISP_TIME_MIN * 10)
        {
          Popup_Link_List_Remove(PopupScheduling.Current);
          PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_OFF;
          PopupScheduling.Current = POPUP_NONE;
          PopupScheduling.Timer   = POPUP_DISP_TIME_NORMAL * 10;
        }
      }
      else
      {
        if (PopupStatus[PopupScheduling.Current].LinkList == POPUP_LINK_LIST_WARNING)
          PopupMaskEn = 1;

        Popup_Link_List_Remove(PopupScheduling.Current);
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_OFF;
        PopupScheduling.Current = POPUP_NONE;
        PopupScheduling.Timer   = POPUP_DISP_TIME_NORMAL * 10;
      }
    }
    else if (PopupStatus[PopupScheduling.Current].Status == POPUP_STATUS_CLEAR)
    {
      if ((PopupStatus[PopupScheduling.Current].LinkList == POPUP_LINK_LIST_NEW_WARNING) || \
          (PopupStatus[PopupScheduling.Current].LinkList == POPUP_LINK_LIST_WARNING))
        PopupMaskEn = 1;

      Popup_Link_List_Remove(PopupScheduling.Current);
      PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_OFF;
      PopupScheduling.Current = POPUP_NONE;
      PopupScheduling.Timer   = POPUP_DISP_TIME_NORMAL * 10;
    }
  }

  /*===========================================================================
  2.еϢ
  ============================================================================*/
  /*** #2.1 ***/
  if (PopupScheduling.MaskReq)
  {
    PopupScheduling.MaskReq = 0;

    if (PopupScheduling.Current != POPUP_NONE)
    {
      if (((PopupStatus[PopupScheduling.Current].LinkList == POPUP_LINK_LIST_NEW_WARNING) && \
           (PopupScheduling.Timer >= POPUP_DISP_TIME_MIN * 10)) || \
          (PopupStatus[PopupScheduling.Current].LinkList == POPUP_LINK_LIST_WARNING))
      {
        /*** #2.1.1ñϢѭʾбָ ***/
        i = 0;
        while (i < PopupLinkList[POPUP_LINK_LIST_WARNING].PrioNum)
        {
          if (PopupLinkList[POPUP_LINK_LIST_WARNING].Prio[i].First != POPUP_NONE)
          {
            PopupLinkList[POPUP_LINK_LIST_WARNING].Cur = PopupLinkList[POPUP_LINK_LIST_WARNING].Prio[i].First;
            break;
          }
          i++;
        }

        /*** #2.1.2αϢѭʾбеıϢ ***/
        PopupID = PopupLinkList[POPUP_LINK_LIST_WARNING].Cur;
        while (PopupLinkList[POPUP_LINK_LIST_WARNING].Cnt)
        {
          PopupNext = PopupStatus[PopupID].Next;
          Popup_Link_List_Remove(PopupID);
          Popup_Link_List_Insert(POPUP_LINK_LIST_MASKED_WARNING, PopupID);
          PopupStatus[PopupID].Status = POPUP_STATUS_MASKED;
          PopupID   = PopupNext;
        }

        /*** #2.1.3ʾеıϢ ***/
        Popup_Link_List_Remove(PopupScheduling.Current);
        Popup_Link_List_Insert(POPUP_LINK_LIST_MASKED_WARNING, PopupScheduling.Current);
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_MASKED;
        PopupScheduling.Current = POPUP_NONE;
        PopupScheduling.Timer   = POPUP_DISP_TIME_NORMAL * 10;

        /*** #2.1.4һαϢ ***/
        i = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].PrioNum;
        while (i)
        {
          i--;

          if (PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].Last != POPUP_NONE)
          {
            PopupScheduling.LastMasked = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].Last;
            break;
          }
        }
      }
    }
    else
    {
      if (PopupMaskEn)
      {
        /*** #2.2.1ñϢѭʾбָ ***/
        i = 0;
        while (i < PopupLinkList[POPUP_LINK_LIST_WARNING].PrioNum)
        {
          if (PopupLinkList[POPUP_LINK_LIST_WARNING].Prio[i].First != POPUP_NONE)
          {
            PopupLinkList[POPUP_LINK_LIST_WARNING].Cur = PopupLinkList[POPUP_LINK_LIST_WARNING].Prio[i].First;
            break;
          }
          i++;
        }

        /*** #2.2.2αϢѭʾбеıϢ ***/
        PopupID = PopupLinkList[POPUP_LINK_LIST_WARNING].Cur;
        while (PopupLinkList[POPUP_LINK_LIST_WARNING].Cnt)
        {
          PopupNext = PopupStatus[PopupID].Next;
          Popup_Link_List_Remove(PopupID);
          Popup_Link_List_Insert(POPUP_LINK_LIST_MASKED_WARNING, PopupID);
          PopupStatus[PopupID].Status = POPUP_STATUS_MASKED;
          PopupID   = PopupNext;
        }

        /*** #2.2.3һαϢ ***/
        i = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].PrioNum;
        while (i)
        {
          i--;

          if (PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].Last != POPUP_NONE)
          {
            PopupScheduling.LastMasked = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].Last;
            break;
          }
        }
      }
    }
  }

  /*** #2.2ʾϢ ***/
  if (PopupScheduling.Current < POPUP_NUMBER_TOTAL)
  {
    if ((PopupAttributeTable[PopupScheduling.Current].Type == POPUP_TYPE_HINT) && \
        (PopupStatus[PopupScheduling.Current].Status == POPUP_STATUS_MASKED))
    {
      Popup_Link_List_Remove(PopupScheduling.Current);
      PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_LOOP;
      PopupScheduling.Current = POPUP_NONE;
      PopupScheduling.Timer   = POPUP_DISP_TIME_NORMAL * 10;
    }
  }

  /*===========================================================================
  4.µϢ
  ============================================================================*/
  /*** #4.1µر ***/
  if ((PopupLinkList[POPUP_LINK_LIST_NEW_FATAL].Cur != POPUP_NONE) && \
      (PopupStatus[PopupLinkList[POPUP_LINK_LIST_NEW_FATAL].Cur].Status == POPUP_STATUS_NEW))
  {
    if (PopupScheduling.Current != POPUP_NONE)
    {
      switch (PopupStatus[PopupScheduling.Current].LinkList)
      {
      case  POPUP_LINK_LIST_NEW_FATAL :     //ǰرϢ״ʾ

        //,ϢȼȻԭϢȼ
        //״ʾʱѴﵽ򳬹Сʾʱ,ԭʾ
        if (PopupScheduling.Timer >= POPUP_DISP_TIME_MIN * 10)
        {
          if (PopupScheduling.Current != PopupLinkList[POPUP_LINK_LIST_NEW_FATAL].Cur)
          {
            Popup_Link_List_Remove(PopupScheduling.Current);                            //ԭϢתرб
            Popup_Link_List_Insert(POPUP_LINK_LIST_FATAL, PopupScheduling.Current);
            PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_LOOP;            //ԭϢѭʾ
          }
          if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)            //ԭϢһ
          {
            for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)   //¸гԱ״̬
            {
              PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
              if (PopupStatus[PopupMbr].Status == POPUP_STATUS_FIRST)
                PopupStatus[PopupMbr].Status = POPUP_STATUS_LOOP;                       //ǳԱѭʾ
            }
          }

          PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_NEW_FATAL].Cur;       //µر뵱ǰʾ
          PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;             //ǴϢ״ʾ
          if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)            //һ
          {
            for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)   //¸гԱ״̬
            {
              PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
              if (PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW)
                PopupStatus[PopupMbr].Status = POPUP_STATUS_FIRST;                      //ǳԱ״ʾ
            }

            if (PopupStatus[PopupScheduling.Current].SndReqCode == 0xFF)                //
              PopupStatus[PopupScheduling.Current].SndReqCode = 0x01;
            else
              PopupStatus[PopupScheduling.Current].SndReqCode++;
          }

          PopupScheduling.Timer = 0;                                                    //ʾʱ
        }
        break;

      case  POPUP_LINK_LIST_HINT :          //ǰʾϢ״ʾ

        //رʾеʾϢ,δʾʾϢҪʾ
        PopupID = PopupScheduling.Current;
        while (PopupLinkList[POPUP_LINK_LIST_HINT].Cnt)
        {
          PopupNext = PopupStatus[PopupID].Next;
          Popup_Link_List_Remove(PopupID);
          PopupStatus[PopupID].Status = POPUP_STATUS_LOOP;
          PopupID   = PopupNext;
        }

        PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_NEW_FATAL].Cur;         //µر뵱ǰʾ
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;               //ǴϢ״ʾ
        if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)              //һ
        {
          for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)     //¸гԱ״̬
          {
            PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
            if (PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW)
              PopupStatus[PopupMbr].Status = POPUP_STATUS_FIRST;                        //ǳԱ״ʾ
          }

          if (PopupStatus[PopupScheduling.Current].SndReqCode == 0xFF)                  //
            PopupStatus[PopupScheduling.Current].SndReqCode = 0x01;
          else
            PopupStatus[PopupScheduling.Current].SndReqCode++;
        }

        PopupScheduling.Timer = 0;                                                      //ʾʱ
        break;

      case  POPUP_LINK_LIST_NEW_WARNING :   //ǰǱϢ״ʾ

        //رʾеıϢ
        Popup_Link_List_Remove(PopupScheduling.Current);                                //ԭϢתб
        if (PopupStatus[PopupScheduling.Current].Status == POPUP_STATUS_DELETE)
          PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_OFF;
        else
        {
          if (PopupAttributeTable[PopupScheduling.Current].DispMode == POPUP_MODE_SINGLE)
          {
            Popup_Link_List_Insert(POPUP_LINK_LIST_MASKED_WARNING, PopupScheduling.Current);
            PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_MASKED;             //ԭϢΪ״̬

            i = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].PrioNum;                     //һα
            while (i)
            {
              i--;

              if (PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].Last != POPUP_NONE)
              {
                PopupScheduling.LastMasked = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].Last;
                break;
              }
            }
          }
          else
          {
            Popup_Link_List_Insert(POPUP_LINK_LIST_WARNING, PopupScheduling.Current);
            PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_LOOP;              //ԭϢѭʾ
            if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)            //ԭϢһ
            {
              for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)   //¸гԱ״̬
              {
                PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
                if (PopupStatus[PopupMbr].Status == POPUP_STATUS_FIRST)
                  PopupStatus[PopupMbr].Status = POPUP_STATUS_LOOP;                       //ǳԱѭʾ
              }
            }
          }
        }

        PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_NEW_FATAL].Cur;         //µر뵱ǰʾ
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;               //ǴϢ״ʾ
        if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)              //һ
        {
          for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)     //¸гԱ״̬
          {
            PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
            if (PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW)
              PopupStatus[PopupMbr].Status = POPUP_STATUS_FIRST;                        //ǳԱ״ʾ
          }

          if (PopupStatus[PopupScheduling.Current].SndReqCode == 0xFF)                  //
            PopupStatus[PopupScheduling.Current].SndReqCode = 0x01;
          else
            PopupStatus[PopupScheduling.Current].SndReqCode++;
        }

        PopupScheduling.Timer = 0;                                                      //ʾʱ
        break;

      case  POPUP_LINK_LIST_FATAL :         //ǰرϢѭʾ
      case  POPUP_LINK_LIST_WARNING :       //ǰǱϢѭʾ
      default :                             //

        PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_NEW_FATAL].Cur;         //µر뵱ǰʾ
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;               //ǴϢ״ʾ
        if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)              //һ
        {
          for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)     //¸гԱ״̬
          {
            PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
            if (PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW)
              PopupStatus[PopupMbr].Status = POPUP_STATUS_FIRST;                        //ǳԱ״ʾ
          }

          if (PopupStatus[PopupScheduling.Current].SndReqCode == 0xFF)                  //
            PopupStatus[PopupScheduling.Current].SndReqCode = 0x01;
          else
            PopupStatus[PopupScheduling.Current].SndReqCode++;
        }

        PopupScheduling.Timer = 0;                                                      //ʾʱ
        break;
      }
    }
    else                                      //ϢʱϢʾ
    {
      PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_NEW_FATAL].Cur;                 //µر뵱ǰʾ
      PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;                       //ǴϢ״ʾ
      if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)                      //һ
      {
        for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)             //¸гԱ״̬
        {
          PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
          if (PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW)
            PopupStatus[PopupMbr].Status = POPUP_STATUS_FIRST;                                 //ǳԱ״ʾ
        }

        if (PopupStatus[PopupScheduling.Current].SndReqCode == 0xFF)                           //
          PopupStatus[PopupScheduling.Current].SndReqCode = 0x01;
        else
          PopupStatus[PopupScheduling.Current].SndReqCode++;
      }

      PopupScheduling.Timer = 0;                                                              //ʾʱ
    }
  }

  /*** #4.2µʾϢ ***/
  else if ((PopupLinkList[POPUP_LINK_LIST_NEW_HINT].Cur != POPUP_NONE) && \
           (PopupStatus[PopupLinkList[POPUP_LINK_LIST_NEW_HINT].Cur].Status == POPUP_STATUS_NEW))
  {
    if (PopupScheduling.Current != POPUP_NONE)
    {
      switch (PopupStatus[PopupScheduling.Current].LinkList)
      {
      case  POPUP_LINK_LIST_NEW_FATAL :     //ǰرϢ״ʾ
      case  POPUP_LINK_LIST_FATAL :         //ǰرϢѭʾ

        //ʾϢԴرϢʾ,ҲҪʾ
        PopupID = PopupLinkList[POPUP_LINK_LIST_NEW_HINT].Cur;
        while (PopupLinkList[POPUP_LINK_LIST_NEW_HINT].Cnt)
        {
          PopupNext = PopupStatus[PopupID].Next;
          Popup_Link_List_Remove(PopupID);
          PopupStatus[PopupID].Status = POPUP_STATUS_LOOP;
          PopupID   = PopupNext;
        }
        break;

      case  POPUP_LINK_LIST_HINT :          //ǰʾϢ״ʾ

        //ʾϢʾϢ,ǰʾϢҪٽʾ
        //Step 1ɾʾϢʾеϢ
        PopupID = PopupScheduling.Current;
        while (PopupLinkList[POPUP_LINK_LIST_HINT].Cnt)
        {
          PopupNext = PopupStatus[PopupID].Next;
          Popup_Link_List_Remove(PopupID);
          PopupStatus[PopupID].Status = POPUP_STATUS_LOOP;
          PopupID   = PopupNext;
        }

        //Step 2ʾϢתʾϢʾ
        PopupID = PopupLinkList[POPUP_LINK_LIST_NEW_HINT].Cur;
        while (PopupLinkList[POPUP_LINK_LIST_NEW_HINT].Cnt)
        {
          PopupNext = PopupStatus[PopupID].Next;
          Popup_Link_List_Remove(PopupID);
          Popup_Link_List_Insert(POPUP_LINK_LIST_HINT, PopupID);
          PopupID   = PopupNext;
        }
        PopupLinkList[POPUP_LINK_LIST_HINT].Cur = PopupStatus[PopupLinkList[POPUP_LINK_LIST_HINT].Cur].Next;

        //Step 3ʾϢʾȡϢʾ
        PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_HINT].Cur;              //µʾϢ뵱ǰʾ
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;               //ǴϢ״ʾ
        PopupScheduling.Timer = 0;                                                      //ʾʱ
        break;

      case  POPUP_LINK_LIST_NEW_WARNING :   //ǰǱϢ״ʾ

        //ʾϢϱϢ
        //Step 1ϵǰıϢʾ
        Popup_Link_List_Remove(PopupScheduling.Current);                                //ԭϢתб
        if (PopupStatus[PopupScheduling.Current].Status == POPUP_STATUS_DELETE)
          PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_OFF;
        else
        {
          if (PopupAttributeTable[PopupScheduling.Current].DispMode == POPUP_MODE_SINGLE)
          {
            Popup_Link_List_Insert(POPUP_LINK_LIST_MASKED_WARNING, PopupScheduling.Current);
            PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_MASKED;             //ԭϢΪ״̬

            i = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].PrioNum;                     //һα
            while (i)
            {
              i--;

              if (PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].Last != POPUP_NONE)
              {
                PopupScheduling.LastMasked = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].Last;
                break;
              }
            }
          }
          else
          {
            Popup_Link_List_Insert(POPUP_LINK_LIST_WARNING, PopupScheduling.Current);
            PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_LOOP;              //ԭϢѭʾ
            PopupLinkList[POPUP_LINK_LIST_WARNING].Cur  = PopupScheduling.Current;        //ضָ  //----hyq--20180424
            if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)            //ԭϢһ
            {
              for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)   //¸гԱ״̬
              {
                PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
                if (PopupStatus[PopupMbr].Status == POPUP_STATUS_FIRST)
                  PopupStatus[PopupMbr].Status = POPUP_STATUS_LOOP;                       //ǳԱѭʾ
              }
            }
          }
        }
        //PopupLinkList[POPUP_LINK_LIST_WARNING].Cur  = PopupScheduling.Current;          //ضָ

        //Step 2ʾϢתʾϢʾ
        PopupID = PopupLinkList[POPUP_LINK_LIST_NEW_HINT].Cur;
        while (PopupLinkList[POPUP_LINK_LIST_NEW_HINT].Cnt)
        {
          PopupNext = PopupStatus[PopupID].Next;
          Popup_Link_List_Remove(PopupID);
          Popup_Link_List_Insert(POPUP_LINK_LIST_HINT, PopupID);
          PopupID   = PopupNext;
        }
        PopupLinkList[POPUP_LINK_LIST_HINT].Cur = PopupStatus[PopupLinkList[POPUP_LINK_LIST_HINT].Cur].Next;

        //Step 3ʾϢʾȡϢʾ
        PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_HINT].Cur;              //µʾϢ뵱ǰʾ
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;               //ǴϢ״ʾ
        PopupScheduling.Timer = 0;                                                      //ʾʱ
        break;

      case  POPUP_LINK_LIST_WARNING :       //ǰǱϢѭʾ
      default :                             //

        //Step 1ʾϢתʾϢʾ
        PopupID = PopupLinkList[POPUP_LINK_LIST_NEW_HINT].Cur;
        while (PopupLinkList[POPUP_LINK_LIST_NEW_HINT].Cnt)
        {
          PopupNext = PopupStatus[PopupID].Next;
          Popup_Link_List_Remove(PopupID);
          Popup_Link_List_Insert(POPUP_LINK_LIST_HINT, PopupID);
          PopupID   = PopupNext;
        }
        PopupLinkList[POPUP_LINK_LIST_HINT].Cur = PopupStatus[PopupLinkList[POPUP_LINK_LIST_HINT].Cur].Next;

        //Step 2ʾϢʾȡϢʾ
        PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_HINT].Cur;              //µʾϢ뵱ǰʾ
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;               //ǴϢ״ʾ
        PopupScheduling.Timer = 0;                                                      //ʾʱ
        break;
      }
    }
    else                                      //ϢʱϢʾ
    {
      //Step 1ʾϢתʾϢʾ
      PopupID = PopupLinkList[POPUP_LINK_LIST_NEW_HINT].Cur;
      while (PopupLinkList[POPUP_LINK_LIST_NEW_HINT].Cnt)
      {
        PopupNext = PopupStatus[PopupID].Next;
        Popup_Link_List_Remove(PopupID);
        Popup_Link_List_Insert(POPUP_LINK_LIST_HINT, PopupID);
        PopupID   = PopupNext;
      }
      PopupLinkList[POPUP_LINK_LIST_HINT].Cur = PopupStatus[PopupLinkList[POPUP_LINK_LIST_HINT].Cur].Next;

      //Step 2ʾϢʾȡϢʾ
      PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_HINT].Cur;                      //µʾϢ뵱ǰʾ
      PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;                       //ǴϢ״ʾ
      PopupScheduling.Timer = 0;                                                              //ʾʱ
    }
  }

  /*** #4.3µıϢ ***/
  else if ((PopupLinkList[POPUP_LINK_LIST_NEW_WARNING].Cur != POPUP_NONE) && \
           (PopupStatus[PopupLinkList[POPUP_LINK_LIST_NEW_WARNING].Cur].Status == POPUP_STATUS_NEW))
  {
    if (PopupScheduling.Current != POPUP_NONE)
    {
      switch (PopupStatus[PopupScheduling.Current].LinkList)
      {
      case  POPUP_LINK_LIST_NEW_FATAL :     //ǰرϢ״ʾ
      case  POPUP_LINK_LIST_FATAL :         //ǰرϢѭʾ

        //ϢԴرϢʾ
        break;

      case  POPUP_LINK_LIST_HINT :          //ǰʾϢ״ʾ

        //ϢԴʾϢ,ʾϢʾﵽ򳬹Сʾʱ,ϺǰʾϢҪٽʾ
        if (PopupScheduling.Timer >= POPUP_DISP_TIME_MIN * 10)
        {
          PopupID = PopupScheduling.Current;
          while (PopupLinkList[POPUP_LINK_LIST_HINT].Cnt)
          {
            PopupNext = PopupStatus[PopupID].Next;
            Popup_Link_List_Remove(PopupID);
            PopupStatus[PopupID].Status = POPUP_STATUS_LOOP;
            PopupID   = PopupNext;
          }

          PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_NEW_WARNING].Cur;     //µı뵱ǰʾ
          PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;             //ǴϢ״ʾ
          if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)            //һ
          {
            for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)   //¸гԱ״̬
            {
              PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
              if (PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW)
                PopupStatus[PopupMbr].Status = POPUP_STATUS_FIRST;                      //ǳԱ״ʾ
            }

            if (PopupStatus[PopupScheduling.Current].SndReqCode == 0xFF)                //
              PopupStatus[PopupScheduling.Current].SndReqCode = 0x01;
            else
              PopupStatus[PopupScheduling.Current].SndReqCode++;
          }

          PopupScheduling.Timer = 0;                                                    //ʾʱ
        }
        break;

      case  POPUP_LINK_LIST_NEW_WARNING :   //ǰǱϢ״ʾ

        //ϢԴϱϢ,ϵıϢʾﵽ򳬹Сʾʱ
        if (PopupScheduling.Timer >= POPUP_DISP_TIME_MIN * 10)
        {
          if (PopupScheduling.Current != PopupLinkList[POPUP_LINK_LIST_NEW_WARNING].Cur)
          {
            Popup_Link_List_Remove(PopupScheduling.Current);

            if (PopupAttributeTable[PopupScheduling.Current].DispMode == POPUP_MODE_SINGLE)
            {
              Popup_Link_List_Insert(POPUP_LINK_LIST_MASKED_WARNING, PopupScheduling.Current);
              PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_MASKED;           //ԭϢΪ״̬

              i = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].PrioNum;                   //һα
              while (i)
              {
                i--;

                if (PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].Last != POPUP_NONE)
                {
                  PopupScheduling.LastMasked = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].Last;
                  break;
                }
              }
            }
            else
            {
              Popup_Link_List_Insert(POPUP_LINK_LIST_WARNING, PopupScheduling.Current);
              PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_LOOP;            //ԭϢѭʾ
              if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)          //ԭϢһ
              {
                for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++) //¸гԱ״̬
                {
                  PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
                  if (PopupStatus[PopupMbr].Status == POPUP_STATUS_FIRST)
                    PopupStatus[PopupMbr].Status = POPUP_STATUS_LOOP;                     //ǳԱѭʾ
                }
              }
            }
          }
          else
          {
            if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)            //ԭϢһ
            {
              for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)   //¸гԱ״̬
              {
                PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
                if (PopupStatus[PopupMbr].Status == POPUP_STATUS_FIRST)
                  PopupStatus[PopupMbr].Status = POPUP_STATUS_LOOP;                       //ǳԱѭʾ
              }
            }
          }

          PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_NEW_WARNING].Cur;     //µı뵱ǰʾ
          PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;             //ǴϢ״ʾ
          if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)            //һ
          {
            for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)   //¸гԱ״̬
            {
              PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
              if (PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW)
                PopupStatus[PopupMbr].Status = POPUP_STATUS_FIRST;                      //ǳԱ״ʾ
            }

            if (PopupStatus[PopupScheduling.Current].SndReqCode == 0xFF)                  //
              PopupStatus[PopupScheduling.Current].SndReqCode = 0x01;
            else
              PopupStatus[PopupScheduling.Current].SndReqCode++;
          }

          PopupScheduling.Timer = 0;                                                    //ʾʱ
        }
        break;

      case  POPUP_LINK_LIST_WARNING :       //ǰǱϢѭʾ
      default :                             //

        PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_NEW_WARNING].Cur;       //µı뵱ǰʾ
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;               //ǴϢ״ʾ
        if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)              //һ
        {
          for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)     //¸гԱ״̬
          {
            PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
            if (PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW)
              PopupStatus[PopupMbr].Status = POPUP_STATUS_FIRST;                        //ǳԱ״ʾ
          }

          if (PopupStatus[PopupScheduling.Current].SndReqCode == 0xFF)                  //
            PopupStatus[PopupScheduling.Current].SndReqCode = 0x01;
          else
            PopupStatus[PopupScheduling.Current].SndReqCode++;
        }

        PopupScheduling.Timer = 0;                                                      //ʾʱ
        break;
      }
    }
    else                                      //ϢʱϢʾ
    {
      if (PopupLinkList[POPUP_LINK_LIST_FATAL].Cnt == 0)                                      //ûرϢҪʾ
      {
        PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_NEW_WARNING].Cur;             //µı뵱ǰʾ
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;                     //ǴϢ״ʾ
        if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)                    //һ
        {
          for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)           //¸гԱ״̬
          {
            PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
            if (PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW)
              PopupStatus[PopupMbr].Status = POPUP_STATUS_FIRST;                              //ǳԱ״ʾ
          }

          if (PopupStatus[PopupScheduling.Current].SndReqCode == 0xFF)                        //
            PopupStatus[PopupScheduling.Current].SndReqCode = 0x01;
          else
            PopupStatus[PopupScheduling.Current].SndReqCode++;
        }

        PopupScheduling.Timer = 0;                                                            //ʾʱ
      }
    }
  }

  /*===========================================================================
  5.ǰʾĵϢΪϢ
  ============================================================================*/
  if ((PopupScheduling.Current != POPUP_NONE) && \
      (PopupStatus[PopupScheduling.Current].Status == POPUP_STATUS_NEW))
  {
    PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;                         //ת״ʾ
    if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)                        //һ
    {
      PopupScheduling.Timer = 0;                                                              //ֻб,ֻбʾʱ

      for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)               //¸гԱ״̬
      {
        PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
        if (PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW)
          PopupStatus[PopupMbr].Status = POPUP_STATUS_FIRST;                                  //ǳԱ״ʾ
      }

      if (PopupStatus[PopupScheduling.Current].SndReqCode == 0xFF)                            //
        PopupStatus[PopupScheduling.Current].SndReqCode = 0x01;
      else
        PopupStatus[PopupScheduling.Current].SndReqCode++;
    }
  }

  /*===========================================================================
  6.ǰϢʾʱ䵽
  ============================================================================*/
  //ֻʾʱ䵽Ǹʱ,ʱΪǰ޵Ϣʾ
  if (PopupScheduling.Timer == POPUP_DISP_TIME_NORMAL * 10)
  {
    /*** #6.1ʾı ***/
    if (PopupScheduling.Current < POPUP_NUMBER_TOTAL)
    {
      switch (PopupStatus[PopupScheduling.Current].LinkList)
      {
      case POPUP_LINK_LIST_NEW_FATAL :

        Popup_Link_List_Remove(PopupScheduling.Current);                                 //ԭϢתرб
        Popup_Link_List_Insert(POPUP_LINK_LIST_FATAL, PopupScheduling.Current);
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_LOOP;                 //ԭϢѭʾ
        if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)               //ԭϢһ
        {
          for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)      //¸гԱ״̬
          {
            PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
            if (PopupStatus[PopupMbr].Status == POPUP_STATUS_FIRST)
              PopupStatus[PopupMbr].Status = POPUP_STATUS_LOOP;                          //ǳԱѭʾ
          }
        }
        PopupLinkList[POPUP_LINK_LIST_FATAL].Cur = PopupStatus[PopupScheduling.Current].Next;
        break;

      case POPUP_LINK_LIST_FATAL :

        PopupLinkList[POPUP_LINK_LIST_FATAL].Cur = PopupStatus[PopupScheduling.Current].Next;
        break;

      case POPUP_LINK_LIST_HINT :

        Popup_Link_List_Remove(PopupScheduling.Current);
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_LOOP;                 //ԭϢѭʾ
        break;

      case POPUP_LINK_LIST_NEW_WARNING :

        Popup_Link_List_Remove(PopupScheduling.Current);                                 //ԭϢתб

        if (PopupAttributeTable[PopupScheduling.Current].DispMode == POPUP_MODE_SINGLE)
        {
          Popup_Link_List_Insert(POPUP_LINK_LIST_MASKED_WARNING, PopupScheduling.Current);
          PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_MASKED;             //ԭϢΪ״̬

          i = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].PrioNum;                     //һα
          while (i)
          {
            i--;

            if (PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].Last != POPUP_NONE)
            {
              PopupScheduling.LastMasked = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].Last;
              break;
            }
          }
        }
        else
        {
          Popup_Link_List_Insert(POPUP_LINK_LIST_WARNING, PopupScheduling.Current);
          PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_LOOP;               //ԭϢѭʾ
          if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)             //ԭϢһ
          {
            for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)    //¸гԱ״̬
            {
              PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
              if (PopupStatus[PopupMbr].Status == POPUP_STATUS_FIRST)
                PopupStatus[PopupMbr].Status = POPUP_STATUS_LOOP;                        //ǳԱѭʾ
            }
          }
          PopupLinkList[POPUP_LINK_LIST_WARNING].Cur = PopupStatus[PopupScheduling.Current].Next;
        }
        break;

      case POPUP_LINK_LIST_WARNING :

        PopupLinkList[POPUP_LINK_LIST_WARNING].Cur = PopupStatus[PopupScheduling.Current].Next;
        break;

      default :

        break;
      }
    }

    /*** #6.2һʾı ***/
    PopupScheduling.Current = POPUP_NONE;

    if (PopupLinkList[POPUP_LINK_LIST_NEW_FATAL].Cnt)
      PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_NEW_FATAL].Cur;
    else if (PopupLinkList[POPUP_LINK_LIST_FATAL].Cnt)
      PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_FATAL].Cur;
    else if (PopupLinkList[POPUP_LINK_LIST_HINT].Cnt)
      PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_HINT].Cur;
    else if (PopupLinkList[POPUP_LINK_LIST_NEW_WARNING].Cnt)
      PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_NEW_WARNING].Cur;
    else if (PopupLinkList[POPUP_LINK_LIST_WARNING].Cnt)
      PopupScheduling.Current = PopupLinkList[POPUP_LINK_LIST_WARNING].Cur;

    if (PopupScheduling.Current < POPUP_NUMBER_TOTAL)
    {
      PopupScheduling.Timer = 0;

      if (PopupStatus[PopupScheduling.Current].Status == POPUP_STATUS_NEW)
      {
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_FIRST;
        if (PopupAttributeTable[PopupScheduling.Current].pMbrList != NULL)                    //һ
        {
          for (i = 0; i < PopupAttributeTable[PopupScheduling.Current].MbrCnt; i++)           //¸гԱ״̬
          {
            PopupMbr = PopupAttributeTable[PopupScheduling.Current].pMbrList[i];
            if (PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW)
              PopupStatus[PopupMbr].Status = POPUP_STATUS_FIRST;                              //ǳԱ״ʾ
          }

          if (PopupStatus[PopupScheduling.Current].SndReqCode == 0xFF)                        //
            PopupStatus[PopupScheduling.Current].SndReqCode = 0x01;
          else
            PopupStatus[PopupScheduling.Current].SndReqCode++;
        }
      }
      else
        PopupStatus[PopupScheduling.Current].Status = POPUP_STATUS_LOOP;
    }
  }

  /*===========================================================================
  7.±״̬
  ============================================================================*/
  if ((PopupLinkList[POPUP_LINK_LIST_NEW_WARNING].Cnt != 0) || \
      (PopupLinkList[POPUP_LINK_LIST_WARNING].Cnt != 0) || \
      (PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Cnt != 0))
    PopupScheduling.WarningExist = 1;
  else
    PopupScheduling.WarningExist = 0;

  /*===========================================================================
  8.λαָ(ڱѯ)
  ============================================================================*/
  if (PopupScheduling.MaskedPolling)
  {
    if (PopupScheduling.Current != POPUP_NONE)
    {
      PopupScheduling.MaskedPolling = 0;
      PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Cur = PopupStatus[PopupScheduling.LastMasked].Next;
    }
  }
}

/******************************************************************************
Popup_Request
  ܣʾһϢ
  PopupIDʾĵϢ
ֵ
******************************************************************************/
void Popup_Request(uint8_t PopupID)
{
  if (PopupStatus[PopupID].Status == POPUP_STATUS_OFF)
  {
    if (PopupAttributeTable[PopupID].MbrCnt == 0)       //ıĳĳԱ
    {
      PopupStatus[PopupID].Status = POPUP_STATUS_NEW;   //øõϢ״̬ΪϢ״̬

      PopupID = PopupAttributeTable[PopupID].Class;     //Ա,ȡñӦıе
      Popup_Link_List_Remove(PopupID);                  //ñƳԭб
    }

    PopupStatus[PopupID].Status = POPUP_STATUS_NEW;     //øõϢ״̬ΪϢ״̬

    switch (PopupAttributeTable[PopupID].Type)
    {
    case POPUP_TYPE_FATAL   :
      Popup_Link_List_Insert(POPUP_LINK_LIST_NEW_FATAL, PopupID);
      break;

    case POPUP_TYPE_HINT    :
      Popup_Link_List_Insert(POPUP_LINK_LIST_NEW_HINT, PopupID);
      break;

    case POPUP_TYPE_WARNING :
      Popup_Link_List_Insert(POPUP_LINK_LIST_NEW_WARNING, PopupID);
      break;

    default                 :
      break;
    }
  }
  else if (PopupStatus[PopupID].Status == POPUP_STATUS_DELETE)
  {
    //POPUP_STATUS_DELETE־һʾϢ
    //ֱӸָ״̬
    if ((PopupStatus[PopupID].LinkList == POPUP_LINK_LIST_NEW_FATAL) || \
        (PopupStatus[PopupID].LinkList == POPUP_LINK_LIST_NEW_WARNING) || \
        (PopupStatus[PopupID].LinkList == POPUP_LINK_LIST_HINT))
      PopupStatus[PopupID].Status = POPUP_STATUS_FIRST;
    else if ((PopupStatus[PopupID].LinkList == POPUP_LINK_LIST_FATAL) || \
             (PopupStatus[PopupID].LinkList == POPUP_LINK_LIST_WARNING))
      PopupStatus[PopupID].Status = POPUP_STATUS_LOOP;
    else if (PopupStatus[PopupID].LinkList == POPUP_LINK_LIST_MASKED_WARNING)
      PopupStatus[PopupID].Status = POPUP_STATUS_MASKED;
  }
}

/******************************************************************************
Popup_Delete
  ܣʾһϢ
  PopupIDʾĵϢ
ֵ
******************************************************************************/
void Popup_Delete(uint8_t PopupID)
{
  uint8_t i;
  uint8_t PopupCls;
  uint8_t PopupMbr;

  if ((PopupStatus[PopupID].Status == POPUP_STATUS_OFF) || \
      (PopupStatus[PopupID].Status == POPUP_STATUS_DELETE) || \
      (PopupStatus[PopupID].Status == POPUP_STATUS_CLEAR))
    return;

  if (PopupAttributeTable[PopupID].MbrCnt == 0)                 //ҪɾıĳĳԱ
  {
    Popup_Link_List_Remove(PopupID);
    PopupStatus[PopupID].Status = POPUP_STATUS_OFF;

    PopupCls = PopupAttributeTable[PopupID].Class;               //ȡñӦı
    for (i = 0; i < PopupAttributeTable[PopupCls].MbrCnt; i++)   //౨µĳԱ
    {
      PopupMbr = PopupAttributeTable[PopupCls].pMbrList[i];

      if ((PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW) || \
          (PopupStatus[PopupMbr].Status == POPUP_STATUS_FIRST) || \
          (PopupStatus[PopupMbr].Status == POPUP_STATUS_LOOP) || \
          (PopupStatus[PopupMbr].Status == POPUP_STATUS_MASKED))
        return;
    }

    PopupID = PopupCls;
  }

  if (PopupScheduling.Current == PopupID)         //ʾеıɾ,ñ־,ɵȳɾ
  {
    PopupStatus[PopupID].Status = POPUP_STATUS_DELETE;
    return;
  }

  Popup_Link_List_Remove(PopupID);
  PopupStatus[PopupID].Status = POPUP_STATUS_OFF;
}

/******************************************************************************
Popup_Clear
  ܣʾһϢ,۸ϢǷﵽСʾʱ
        IGN OFFʱ,Ϣʾ
  PopupIDʾĵϢ
ֵ
******************************************************************************/
void Popup_Clear(uint8_t PopupID)
{
  uint8_t i;
  uint8_t PopupCls;
  uint8_t PopupMbr;

  if ((PopupStatus[PopupID].Status == POPUP_STATUS_OFF) || \
      (PopupStatus[PopupID].Status == POPUP_STATUS_CLEAR))
    return;

  if (PopupAttributeTable[PopupID].MbrCnt == 0)                 //ҪɾıĳĳԱ
  {
    Popup_Link_List_Remove(PopupID);
    PopupStatus[PopupID].Status = POPUP_STATUS_OFF;

    PopupCls = PopupAttributeTable[PopupID].Class;               //ȡñӦı
    for (i = 0; i < PopupAttributeTable[PopupCls].MbrCnt; i++)   //౨µĳԱ
    {
      PopupMbr = PopupAttributeTable[PopupCls].pMbrList[i];

      if ((PopupStatus[PopupMbr].Status == POPUP_STATUS_NEW) || \
          (PopupStatus[PopupMbr].Status == POPUP_STATUS_FIRST) || \
          (PopupStatus[PopupMbr].Status == POPUP_STATUS_LOOP) || \
          (PopupStatus[PopupMbr].Status == POPUP_STATUS_MASKED))
        return;
    }

    PopupID = PopupCls;
  }

  if (PopupScheduling.Current == PopupID)         //ʾеıɾ,ñ־,ɵȳɾ
  {
    PopupStatus[PopupID].Status = POPUP_STATUS_CLEAR;
    return;
  }

  Popup_Link_List_Remove(PopupID);
  PopupStatus[PopupID].Status = POPUP_STATUS_OFF;
}

/******************************************************************************
Popup_Mask_Request
  ܣαϢ
        ʱ̷,ֻʱ,ϢŻᱻ
  
ֵ
******************************************************************************/
void Popup_Mask_Request(void)
{
  PopupScheduling.MaskReq = 1;
}

/******************************************************************************
Popup_Mask_Request
  ܣαϢ
        ʱ̷,ֻʱ,ϢŻᱻ
  
ֵ
******************************************************************************/
void Popup_Hint_Mask_Request(uint8_t PopupID)
{
  if (PopupID < POPUP_NUMBER_TOTAL)
  {
    if (PopupAttributeTable[PopupID].Type == POPUP_TYPE_HINT)
    {
      if (PopupScheduling.Current == PopupID)         //ʾеʾϢ,ñ־,ɵȳ
      {
        PopupStatus[PopupID].Status = POPUP_STATUS_MASKED;
        return;
      }

      PopupStatus[PopupID].Status = POPUP_STATUS_LOOP;
      Popup_Link_List_Remove(PopupScheduling.Current);
    }
  }
}

/******************************************************************************
Popup_Get_Status
  ܣȡϢĵǰ״̬
  PopupIDϢ
ֵϢĵǰ״̬
******************************************************************************/
uint8_t Popup_Get_Status(uint8_t PopupID)
{
  return PopupStatus[PopupID].Status;
}

/******************************************************************************
Popup_Get_Current_Type
  ܣȡǰʾĵϢ
  
ֵǰʾĵϢ
******************************************************************************/
uint8_t Popup_Get_Current_Type(void)
{
  if (PopupScheduling.Current >= POPUP_NUMBER_TOTAL)
    return 0xFF;

  return PopupAttributeTable[PopupScheduling.Current].Type;
}

/******************************************************************************
Popup_Get_Current_Message
  ܣȡǰӦʾĵϢ
  
ֵǰӦʾĵϢ
******************************************************************************/
uint8_t Popup_Get_Current_Message(void)
{
  if (PopupScheduling.Current >= POPUP_NUMBER_TOTAL)
    return POPUP_MSG_NONE;

  return PopupAttributeTable[PopupScheduling.Current].Message;
}

/******************************************************************************
Popup_Get_Current_Sound
  ܣȡǰӦŵ
  
ֵǰӦŵ
******************************************************************************/
uint8_t Popup_Get_Current_Sound(void)
{
  if (PopupScheduling.Current >= POPUP_NUMBER_TOTAL)
    return SND_NONE;

  return PopupAttributeTable[PopupScheduling.Current].Snd;
}

/******************************************************************************
Popup_Get_Current_Sound_Req_Code
  ܣȡǰӦŵ
  
ֵ
******************************************************************************/
uint8_t Popup_Get_Current_Sound_Req_Code(void)
{
  if (PopupScheduling.Current >= POPUP_NUMBER_TOTAL)
    return 0;

  if (PopupAttributeTable[PopupScheduling.Current].SndMode == POPUP_MODE_MULTI)
    return PopupStatus[PopupScheduling.Current].SndReqCode;

  if (PopupStatus[PopupScheduling.Current].Status == POPUP_STATUS_FIRST)
    return PopupStatus[PopupScheduling.Current].SndReqCode;

  return 0;
}

/******************************************************************************
Popup_Get_Warning_Status
  ܣȡϢ״̬,ھ̾ű־ʾ
  
ֵ0 - ǰûбϢ
        1 - ǰбϢ(±Ϣ  ѭʾϢ  εıϢ)
******************************************************************************/
uint8_t Popup_Get_Warning_Status(void)
{
  return PopupScheduling.WarningExist;
}

/******************************************************************************
Popup_Get_First_Masked_Warning
  ܣȡεıϢеĵһϢ
        ǰûεıϢʱ, POPUP_NONE
  
ֵεĵһϢ
******************************************************************************/
uint8_t Popup_Get_First_Masked_Warning(void)
{
  uint8_t i;
  uint8_t PopupID;

  if (PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Cnt)
  {
    i = 0;
    while (i < PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].PrioNum)
    {
      PopupID = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[i].First;
      if (PopupID != POPUP_NONE)
        return PopupID;

      i++;
    }
  }
  return POPUP_NONE;
}

/******************************************************************************
Popup_Get_Last_Masked_Warning
  ܣȡεıϢеһϢ
        ǰûεıϢʱ, POPUP_NONE
  
ֵεһϢ
******************************************************************************/
uint8_t Popup_Get_Last_Masked_Warning(void)
{
  uint8_t i;
  uint8_t j;
  uint8_t PopupID;

  if (PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Cnt)
  {
    i = 0;
    while (i < PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].PrioNum)
    {
      i++;
      j = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].PrioNum - i;

      PopupID = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Prio[j].Last;
      if (PopupID != POPUP_NONE)
        return PopupID;
    }
  }
  return POPUP_NONE;
}

/******************************************************************************
Popup_Get_Masked_Warning_Msg
  ܣȡεıϢ
        ǰûεıϢʱ, POPUP_NONE
  
ֵεıϢ
******************************************************************************/
uint8_t Popup_Get_Masked_Warning_Msg(void)
{
  uint8_t PopupID;

  PopupID = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Cur;

  if (PopupID >= POPUP_NUMBER_TOTAL)
    return POPUP_MSG_NONE;

  return PopupAttributeTable[PopupID].Message;
}

/******************************************************************************
Popup_Masked_Warning_Polling_Reset
  ܣεıѯ
  Modeѯģʽ POPUP_POLLING_FORWARD - ģʽ
                       POPUP_POLLING_REVERSE - ģʽ
ֵ
******************************************************************************/
void Popup_Masked_Warning_Polling_Reset(uint8_t Mode)
{
  uint8_t PopupID;

  if (Mode == POPUP_POLLING_FORWARD)
    PopupID = Popup_Get_First_Masked_Warning();
  else
    PopupID = Popup_Get_Last_Masked_Warning();

  PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Cur = PopupID;
}

/******************************************************************************
Popup_Masked_Warning_Polling
  ܣѯεı

        ÿһδ˺,αָᰴָƶһλ,ָָ
        ϵһϢʱ,ٴͬһѯ,ǰαϢΪ
        POPUP_NONE ʾѯѽ

        :ǰα ABCD,Popup_Masked_Warning_Polling_Reset
        ,趨Ϊ POPUP_POLLING_FORWARD ʱ,αָָ򱨾A,,
        øú趨Ϊ POPUP_POLLING_FORWARD ʱαָ뼴ָ򱨾B.
        ظô˺ҷ򲻱αָָ򱨾D,ͬô˺
        򷵻 POPUP_NONE,ʾѯѽ

        ͨPopup_Get_Masked_Warningɶǰαָָı

  Modeѯģʽ POPUP_POLLING_FORWARD - ģʽ
                       POPUP_POLLING_REVERSE - ģʽ
ֵ
******************************************************************************/
void Popup_Masked_Warning_Polling(uint8_t Mode)
{
  uint8_t PopupEnd;
  uint8_t PopupID;

  PopupID  = PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Cur;

  if (PopupID != POPUP_NONE)
  {
    if (Mode == POPUP_POLLING_FORWARD)
    {
      PopupEnd = Popup_Get_Last_Masked_Warning();

      if (PopupEnd != POPUP_NONE)
      {
        if (PopupID == PopupEnd)
          PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Cur = POPUP_NONE;
        else
          PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Cur = PopupStatus[PopupID].Next;
      }
    }
    else
    {
      PopupEnd = Popup_Get_First_Masked_Warning();

      if (PopupEnd != POPUP_NONE)
      {
        if (PopupID == PopupEnd)
          PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Cur = POPUP_NONE;
        else
          PopupLinkList[POPUP_LINK_LIST_MASKED_WARNING].Cur = PopupStatus[PopupID].Prev;
      }
    }
  }
}

/******************************************************************************
Popup_Link_List_Init
  ܣʼ
  LinkListID
        PrioNum   ȼ
ֵ
******************************************************************************/
void Popup_Link_List_Init(uint8_t LinkListID, uint8_t PrioNum)
{
  uint8_t i;

  PopupLinkList[LinkListID].Cnt     = 0;
  PopupLinkList[LinkListID].Cur     = POPUP_NONE;
  PopupLinkList[LinkListID].PrioNum = PrioNum;

  for (i = 0; i < PrioNum; i++)
  {
    PopupLinkList[LinkListID].Prio[i].First = POPUP_NONE;
    PopupLinkList[LinkListID].Prio[i].Last  = POPUP_NONE;
  }
}

/******************************************************************************
Popup_Link_List_Insert
  ܣв뵯Ϣ
  LinkListID
        PopupID   Ϣ
ֵ
******************************************************************************/
void Popup_Link_List_Insert(uint8_t LinkListID, uint8_t PopupID)
{
  uint8_t   i;
  uint8_t   FoundID;
  uint8_t   Prio;
  uint8_t   InsResult;

  if (PopupStatus[PopupID].LinkList == LinkListID)
    return;                                       //ϢѾڵǰ򷵻

  Prio = PopupAttributeTable[PopupID].Priority;   //ȡϢȼ

  if (PopupLinkList[LinkListID].Cnt == 0)         //ǰûκεϢ
  {
    PopupStatus[PopupID].Prev = PopupID;          //ֻһϢ,ǰ󵯳ϢָԼ
    PopupStatus[PopupID].Next = PopupID;

    PopupLinkList[LinkListID].Cur = PopupID;      //ǰָָõϢ

    PopupLinkList[LinkListID].Prio[Prio].First = PopupID;         //ȼά
    PopupLinkList[LinkListID].Prio[Prio].Last  = PopupID;
  }
  else                                            //ǰеϢ
  {
    InsResult = 0;                                //ɹʾ

    for (i = 0; i <= Prio; i++)                   //ӵǰȼǰµϢĽ
    {
      FoundID = PopupLinkList[LinkListID].Prio[Prio - i].Last;

      if (FoundID != POPUP_NONE)                  //ҵ
      {
        PopupStatus[PopupID].Prev = FoundID;      //뵯Ϣ,ά
        PopupStatus[PopupID].Next = PopupStatus[FoundID].Next;
        PopupStatus[PopupStatus[FoundID].Next].Prev = PopupID;
        PopupStatus[FoundID].Next = PopupID;

        InsResult = 1;                            //ɹ
        break;
      }
    }

    if (InsResult == 0)                           //ǰʱδܳɹµϢת
    {
      for (i = Prio + 1; i < PopupLinkList[LinkListID].PrioNum; i++)
      {
        FoundID = PopupLinkList[LinkListID].Prio[i].First;

        if (FoundID != POPUP_NONE)                //ҵ
        {
          PopupStatus[PopupID].Next = FoundID;    //뵯Ϣ,ά
          PopupStatus[PopupID].Prev = PopupStatus[FoundID].Prev;
          PopupStatus[PopupStatus[FoundID].Prev].Next = PopupID;
          PopupStatus[FoundID].Prev = PopupID;

          break;
        }
      }
    }

    if (Prio < PopupAttributeTable[PopupLinkList[LinkListID].Cur].Priority)
      PopupLinkList[LinkListID].Cur = PopupID;    //ǰָָȼϢ

    if(PopupLinkList[LinkListID].Prio[Prio].First == POPUP_NONE)  //ǰȼ޵Ϣ
    {
      PopupLinkList[LinkListID].Prio[Prio].First = PopupID;       //ǰȼµĩϢΪµϢ
      PopupLinkList[LinkListID].Prio[Prio].Last  = PopupID;
    }
    else                                                          //ǰȼеϢ
      PopupLinkList[LinkListID].Prio[Prio].Last  = PopupID;       //ղ,µϢڴȼµĩλ
  }

  PopupLinkList[LinkListID].Cnt++;
  PopupStatus[PopupID].LinkList = LinkListID;     //ǵϢ
}

/******************************************************************************
Popup_Link_List_Remove
  ܣӵϢƳϢ
  PopupID   Ϣ
ֵ
******************************************************************************/
void Popup_Link_List_Remove(uint8_t PopupID)
{
  uint8_t   Prio;
  uint8_t   LinkListID;

  LinkListID = PopupStatus[PopupID].LinkList;

  if (LinkListID == POPUP_LINK_LIST_NONE)
    return;                                       //Ϣ򷵻

  if (PopupLinkList[LinkListID].Cnt)
    PopupLinkList[LinkListID].Cnt--;

  Prio = PopupAttributeTable[PopupID].Priority;   //ȡϢȼ

  if (PopupLinkList[LinkListID].Cnt == 0)         //ɾǰûκεϢ
  {
    PopupLinkList[LinkListID].Prio[Prio].First = POPUP_NONE;         //ȼά
    PopupLinkList[LinkListID].Prio[Prio].Last  = POPUP_NONE;

    PopupLinkList[LinkListID].Cur = POPUP_NONE;   //õǰָ
  }
  else
  {
    if (PopupID == PopupLinkList[LinkListID].Prio[Prio].First)
    {
      if (PopupLinkList[LinkListID].Prio[Prio].First == PopupLinkList[LinkListID].Prio[Prio].Last)
      {
        PopupLinkList[LinkListID].Prio[Prio].First = POPUP_NONE;
        PopupLinkList[LinkListID].Prio[Prio].Last  = POPUP_NONE;
      }
      else
        PopupLinkList[LinkListID].Prio[Prio].First = PopupStatus[PopupID].Next;
    }
    else if (PopupID == PopupLinkList[LinkListID].Prio[Prio].Last)
      PopupLinkList[LinkListID].Prio[Prio].Last = PopupStatus[PopupID].Prev;

    if (PopupLinkList[LinkListID].Cur == PopupID)
      PopupLinkList[LinkListID].Cur = PopupStatus[PopupID].Next;

    PopupStatus[PopupStatus[PopupID].Prev].Next = PopupStatus[PopupID].Next;
    PopupStatus[PopupStatus[PopupID].Next].Prev = PopupStatus[PopupID].Prev;
  }

  PopupStatus[PopupID].Prev = PopupID;                      //Ϣɾ,ǰ󵯳ϢָԼ
  PopupStatus[PopupID].Next = PopupID;

  PopupStatus[PopupID].LinkList = POPUP_LINK_LIST_NONE;     //ϢѲκ
}
