#ifndef _TSzhen_H_
#define _TSzhen_H_
#include "UDS_ISO14229_Services.h"
#include "Data_Processor.h"
#include "Common.h"

/******************************************************************************
结构体声明
******************************************************************************/
//----hyq--20190505 ĸ  ԸС  cnRYB_KJDTBLen  cnSWB_KJDTBLen ԸĴ 7
#define   cnCSB_KJDTBLen		4
#define   cnZSB_KJDTBLen		4

#define   cnRYB_KJDTBLen		5   
#define   cnSWB_KJDTBLen		5

//#define cnWCjd		  	 9		                    //8度
//#define cnCZBWBjd			12	                      //车,转速表1度=12微步
//#define cnSYBWBjd			12		                    //水油表1度=12微步
extern  INT16U   		b_CSB_JD[cnCSB_KJDTBLen];     //车速表刻度--角度数据组
extern  INT16U   		b_ZSB_JD[cnZSB_KJDTBLen];     //转速表刻度--角度数据组 

typedef struct
{
  INT8U  YBala_N;        //油表报警点序号(分布角度值)(1/8度单位)
  INT8U  SBala_N;        //水表报警点序号(分布角度值)(1/8度单位)
  INT8U  SB_KT;          //用于设置水表多少时间当前值去逼近目标值(单位3.6MS)
  INT8U  CS_N;		       //车速传感器每转一圈的脉冲个数(4,8)
  INT8U  no_used1;       //保留
  INT8U  no_used2;       //保留
  INT16U YB_DTXS;	       //油表输入的动态系数
  INT16U SB_DTXS;	       //水表输入的动态系数

  INT16U ZS_G100;        //转速表的缸数(100倍)
  INT16U CSBIX;		       //车速比
} KPULSTRUCT;

typedef struct
{
  INT16U Kdu;      
  INT16U WBJD;       
} KDVJDSTRUCT;

//----hyq--20190505 ĸ޸
#define cnZSBFrJDTBLen    4+1             
extern  KDVJDSTRUCT  ZSBFrJDTB[cnZSBFrJDTBLen]; 
#define cnCSBFrJDTBLen    4+1           
extern  KDVJDSTRUCT  CSBFrJDTB[cnCSBFrJDTBLen];
#define cnSUIBVJDTBLen    8+1            
extern  KDVJDSTRUCT  SUIBVJDTB[cnSUIBVJDTBLen];  
#define cnYOUBVJDTBLen    8+1         
extern  KDVJDSTRUCT  YOUBVJDTB[cnYOUBVJDTBLen];  

/* 
extern  INT16U CSB_MAX_KUD10;
extern  INT16U ZSB_MAX_KUD;	
extern  INT8U  CSB_MAX_XH;
extern  INT8U  ZSB_MAX_XH;	
*/
         
extern  uint16_t CSB_JDMHLBUF_LS;
extern  uint16_t zs_JDMHLBUF_LS;
extern  uint16_t YOUB_FBJD_MHL;
extern  uint16_t SUIB_FBJD_MHL;

extern  KPULSTRUCT KPuls_cs; 
//extern  KDVJDSTRUCT  QYB1JDTB[cnCSBFrJDTBLen];
//extern  KDVJDSTRUCT  QYB2JDTB[cnCSBFrJDTBLen];

INT16U  GJ_KDV_JSSYBMBJD(KDVJDSTRUCT *mSTUCT, INT16U mV, INT8U mLEN);
void TSzhen_mode(void);
void SetModeProc(void);
void Read_CZSYBKPILSFR_FLASH(void);
void JSCZSBMAXFRPRG(void);
#endif