/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.TableBasedTableBuilder;
import java.util.EnumSet;

public final class OS2Table
extends Table {
    private OS2Table(Header header, ReadableFontData data) {
        super(header, data);
    }

    public int tableVersion() {
        return this.data.readUShort(Offset.version.offset);
    }

    public int xAvgCharWidth() {
        return this.data.readShort(Offset.xAvgCharWidth.offset);
    }

    public int usWeightClass() {
        return this.data.readUShort(Offset.usWeightClass.offset);
    }

    public int usWidthClass() {
        return this.data.readUShort(Offset.usWidthClass.offset);
    }

    public EnumSet<EmbeddingFlags> fsType() {
        return EmbeddingFlags.asSet(this.fsTypeAsInt());
    }

    public int fsTypeAsInt() {
        return this.data.readUShort(Offset.fsType.offset);
    }

    public int ySubscriptXSize() {
        return this.data.readShort(Offset.ySubscriptXSize.offset);
    }

    public int ySubscriptYSize() {
        return this.data.readShort(Offset.ySubscriptYSize.offset);
    }

    public int ySubscriptXOffset() {
        return this.data.readShort(Offset.ySubscriptXOffset.offset);
    }

    public int ySubscriptYOffset() {
        return this.data.readShort(Offset.ySubscriptYOffset.offset);
    }

    public int ySuperscriptXSize() {
        return this.data.readShort(Offset.ySuperscriptXSize.offset);
    }

    public int ySuperscriptYSize() {
        return this.data.readShort(Offset.ySuperscriptYSize.offset);
    }

    public int ySuperscriptXOffset() {
        return this.data.readShort(Offset.ySuperscriptXOffset.offset);
    }

    public int ySuperscriptYOffset() {
        return this.data.readShort(Offset.ySuperscriptYOffset.offset);
    }

    public int yStrikeoutSize() {
        return this.data.readShort(Offset.yStrikeoutSize.offset);
    }

    public int yStrikeoutPosition() {
        return this.data.readShort(Offset.yStrikeoutPosition.offset);
    }

    public int sFamilyClass() {
        return this.data.readShort(Offset.sFamilyClass.offset);
    }

    public byte[] panose() {
        byte[] panose = new byte[10];
        this.data.readBytes(Offset.panose.offset, panose, 0, panose.length);
        return panose;
    }

    public long ulUnicodeRange1() {
        return this.data.readULong(Offset.ulUnicodeRange1.offset);
    }

    public long ulUnicodeRange2() {
        return this.data.readULong(Offset.ulUnicodeRange2.offset);
    }

    public long ulUnicodeRange3() {
        return this.data.readULong(Offset.ulUnicodeRange3.offset);
    }

    public long ulUnicodeRange4() {
        return this.data.readULong(Offset.ulUnicodeRange4.offset);
    }

    public EnumSet<UnicodeRange> ulUnicodeRange() {
        return UnicodeRange.asSet(this.ulUnicodeRange1(), this.ulUnicodeRange2(), this.ulUnicodeRange3(), this.ulUnicodeRange4());
    }

    public byte[] achVendId() {
        byte[] b = new byte[4];
        this.data.readBytes(Offset.achVendId.offset, b, 0, b.length);
        return b;
    }

    public int fsSelectionAsInt() {
        return this.data.readUShort(Offset.fsSelection.offset);
    }

    public EnumSet<FsSelection> fsSelection() {
        return FsSelection.asSet(this.fsSelectionAsInt());
    }

    public int usFirstCharIndex() {
        return this.data.readUShort(Offset.usFirstCharIndex.offset);
    }

    public int usLastCharIndex() {
        return this.data.readUShort(Offset.usLastCharIndex.offset);
    }

    public int sTypoAscender() {
        return this.data.readShort(Offset.sTypoAscender.offset);
    }

    public int sTypoDescender() {
        return this.data.readShort(Offset.sTypoDescender.offset);
    }

    public int sTypoLineGap() {
        return this.data.readShort(Offset.sTypoLineGap.offset);
    }

    public int usWinAscent() {
        return this.data.readUShort(Offset.usWinAscent.offset);
    }

    public int usWinDescent() {
        return this.data.readUShort(Offset.usWinDescent.offset);
    }

    public long ulCodePageRange1() {
        return this.data.readULong(Offset.ulCodePageRange1.offset);
    }

    public long ulCodePageRange2() {
        return this.data.readULong(Offset.ulCodePageRange2.offset);
    }

    public EnumSet<CodePageRange> ulCodePageRange() {
        return CodePageRange.asSet(this.ulCodePageRange1(), this.ulCodePageRange1());
    }

    public int sxHeight() {
        return this.data.readShort(Offset.sxHeight.offset);
    }

    public int sCapHeight() {
        return this.data.readShort(Offset.sCapHeight.offset);
    }

    public int usDefaultChar() {
        return this.data.readUShort(Offset.usDefaultChar.offset);
    }

    public int usBreakChar() {
        return this.data.readUShort(Offset.usBreakChar.offset);
    }

    public int usMaxContext() {
        return this.data.readUShort(Offset.usMaxContext.offset);
    }

    /* synthetic */ OS2Table(Header header, ReadableFontData readableFontData, OS2Table oS2Table) {
        this(header, readableFontData);
    }

    public static class Builder
    extends TableBasedTableBuilder<OS2Table> {
        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        protected Builder(Header header, WritableFontData data) {
            super(header, data);
        }

        protected Builder(Header header, ReadableFontData data) {
            super(header, data);
        }

        @Override
        protected OS2Table subBuildTable(ReadableFontData data) {
            return new OS2Table(this.header(), data, null);
        }

        public int tableVersion() {
            return this.internalReadData().readUShort(Offset.version.offset);
        }

        public void setTableVersion(int version) {
            this.internalWriteData().writeUShort(Offset.version.offset, version);
        }

        public int xAvgCharWidth() {
            return this.internalReadData().readShort(Offset.xAvgCharWidth.offset);
        }

        public void setXAvgCharWidth(int width) {
            this.internalWriteData().writeShort(Offset.xAvgCharWidth.offset, width);
        }

        public int usWeightClass() {
            return this.internalReadData().readUShort(Offset.usWeightClass.offset);
        }

        public void setUsWeightClass(int weight) {
            this.internalWriteData().writeUShort(Offset.usWeightClass.offset, weight);
        }

        public int usWidthClass() {
            return this.internalReadData().readUShort(Offset.usWidthClass.offset);
        }

        public void setUsWidthClass(int width) {
            this.internalWriteData().writeUShort(Offset.usWidthClass.offset, width);
        }

        public EnumSet<EmbeddingFlags> fsType() {
            return EmbeddingFlags.asSet(this.fsTypeAsInt());
        }

        public int fsTypeAsInt() {
            return this.internalReadData().readUShort(Offset.fsType.offset);
        }

        public void setFsType(EnumSet<EmbeddingFlags> flagSet) {
            this.setFsType(EmbeddingFlags.asUShort(flagSet));
        }

        public void setFsType(int fsType) {
            this.internalWriteData().writeUShort(Offset.fsType.offset, fsType);
        }

        public int ySubscriptXSize() {
            return this.internalReadData().readShort(Offset.ySubscriptXSize.offset);
        }

        public void setYSubscriptXSize(int size) {
            this.internalWriteData().writeShort(Offset.ySubscriptXSize.offset, size);
        }

        public int ySubscriptYSize() {
            return this.internalReadData().readShort(Offset.ySubscriptYSize.offset);
        }

        public void setYSubscriptYSize(int size) {
            this.internalWriteData().writeShort(Offset.ySubscriptYSize.offset, size);
        }

        public int ySubscriptXOffset() {
            return this.internalReadData().readShort(Offset.ySubscriptXOffset.offset);
        }

        public void setYSubscriptXOffset(int offset) {
            this.internalWriteData().writeShort(Offset.ySubscriptXOffset.offset, offset);
        }

        public int ySubscriptYOffset() {
            return this.internalReadData().readShort(Offset.ySubscriptYOffset.offset);
        }

        public void setYSubscriptYOffset(int offset) {
            this.internalWriteData().writeShort(Offset.ySubscriptYOffset.offset, offset);
        }

        public int ySuperscriptXSize() {
            return this.internalReadData().readShort(Offset.ySuperscriptXSize.offset);
        }

        public void setYSuperscriptXSize(int size) {
            this.internalWriteData().writeShort(Offset.ySuperscriptXSize.offset, size);
        }

        public int ySuperscriptYSize() {
            return this.internalReadData().readShort(Offset.ySuperscriptYSize.offset);
        }

        public void setYSuperscriptYSize(int size) {
            this.internalWriteData().writeShort(Offset.ySuperscriptYSize.offset, size);
        }

        public int ySuperscriptXOffset() {
            return this.internalReadData().readShort(Offset.ySuperscriptXOffset.offset);
        }

        public void setYSuperscriptXOffset(int offset) {
            this.internalWriteData().writeShort(Offset.ySuperscriptXOffset.offset, offset);
        }

        public int ySuperscriptYOffset() {
            return this.internalReadData().readShort(Offset.ySuperscriptYOffset.offset);
        }

        public void setYSuperscriptYOffset(int offset) {
            this.internalWriteData().writeShort(Offset.ySuperscriptYOffset.offset, offset);
        }

        public int yStrikeoutSize() {
            return this.internalReadData().readShort(Offset.yStrikeoutSize.offset);
        }

        public void setYStrikeoutSize(int size) {
            this.internalWriteData().writeShort(Offset.yStrikeoutSize.offset, size);
        }

        public int yStrikeoutPosition() {
            return this.internalReadData().readShort(Offset.yStrikeoutPosition.offset);
        }

        public void setYStrikeoutPosition(int position) {
            this.internalWriteData().writeShort(Offset.yStrikeoutPosition.offset, position);
        }

        public int sFamilyClass() {
            return this.internalReadData().readShort(Offset.sFamilyClass.offset);
        }

        public void setSFamilyClass(int family) {
            this.internalWriteData().writeShort(Offset.sFamilyClass.offset, family);
        }

        public byte[] panose() {
            byte[] panose = new byte[Offset.panoseLength.offset];
            this.internalReadData().readBytes(Offset.panose.offset, panose, 0, panose.length);
            return panose;
        }

        public void setPanose(byte[] panose) {
            if (panose.length != Offset.panoseLength.offset) {
                throw new IllegalArgumentException("Panose bytes must be exactly 10 in length.");
            }
            this.internalWriteData().writeBytes(Offset.panose.offset, panose, 0, panose.length);
        }

        public long ulUnicodeRange1() {
            return this.internalReadData().readULong(Offset.ulUnicodeRange1.offset);
        }

        public void setUlUnicodeRange1(long range) {
            this.internalWriteData().writeULong(Offset.ulUnicodeRange1.offset, range);
        }

        public long ulUnicodeRange2() {
            return this.internalReadData().readULong(Offset.ulUnicodeRange2.offset);
        }

        public void setUlUnicodeRange2(long range) {
            this.internalWriteData().writeULong(Offset.ulUnicodeRange2.offset, range);
        }

        public long ulUnicodeRange3() {
            return this.internalReadData().readULong(Offset.ulUnicodeRange3.offset);
        }

        public void setUlUnicodeRange3(long range) {
            this.internalWriteData().writeULong(Offset.ulUnicodeRange3.offset, range);
        }

        public long ulUnicodeRange4() {
            return this.internalReadData().readULong(Offset.ulUnicodeRange4.offset);
        }

        public void setUlUnicodeRange4(long range) {
            this.internalWriteData().writeULong(Offset.ulUnicodeRange4.offset, range);
        }

        public EnumSet<UnicodeRange> ulUnicodeRange() {
            return UnicodeRange.asSet(this.ulUnicodeRange1(), this.ulUnicodeRange2(), this.ulUnicodeRange3(), this.ulUnicodeRange4());
        }

        public void setUlUnicodeRange(EnumSet<UnicodeRange> rangeSet) {
            long[] range = UnicodeRange.asArray(rangeSet);
            this.setUlUnicodeRange1(range[0]);
            this.setUlUnicodeRange2(range[1]);
            this.setUlUnicodeRange3(range[2]);
            this.setUlUnicodeRange4(range[3]);
        }

        public byte[] achVendId() {
            byte[] b = new byte[Offset.achVendIdLength.offset];
            this.internalReadData().readBytes(Offset.achVendId.offset, b, 0, b.length);
            return b;
        }

        public void setAchVendId(byte[] b) {
            this.internalWriteData().writeBytesPad(Offset.achVendId.offset, b, 0, Offset.achVendIdLength.offset, (byte)32);
        }

        public int fsSelectionAsInt() {
            return this.internalReadData().readUShort(Offset.fsSelection.offset);
        }

        public void setFsSelection(int fsSelection) {
            this.internalWriteData().writeUShort(Offset.fsSelection.offset, fsSelection);
        }

        public void fsSelection(EnumSet<FsSelection> fsSelection) {
            this.setFsSelection(FsSelection.asInt(fsSelection));
        }

        public int usFirstCharIndex() {
            return this.internalReadData().readUShort(Offset.usFirstCharIndex.offset);
        }

        public void setUsFirstCharIndex(int firstIndex) {
            this.internalWriteData().writeUShort(Offset.usFirstCharIndex.offset, firstIndex);
        }

        public int usLastCharIndex() {
            return this.internalReadData().readUShort(Offset.usLastCharIndex.offset);
        }

        public void setUsLastCharIndex(int lastIndex) {
            this.internalWriteData().writeUShort(Offset.usLastCharIndex.offset, lastIndex);
        }

        public int sTypoAscender() {
            return this.internalReadData().readShort(Offset.sTypoAscender.offset);
        }

        public void setSTypoAscender(int ascender) {
            this.internalWriteData().writeShort(Offset.sTypoAscender.offset, ascender);
        }

        public int sTypoDescender() {
            return this.internalReadData().readShort(Offset.sTypoDescender.offset);
        }

        public void setSTypoDescender(int descender) {
            this.internalWriteData().writeShort(Offset.sTypoDescender.offset, descender);
        }

        public int sTypoLineGap() {
            return this.internalReadData().readShort(Offset.sTypoLineGap.offset);
        }

        public void setSTypoLineGap(int lineGap) {
            this.internalWriteData().writeShort(Offset.sTypoLineGap.offset, lineGap);
        }

        public int usWinAscent() {
            return this.internalReadData().readUShort(Offset.usWinAscent.offset);
        }

        public void setUsWinAscent(int ascent) {
            this.internalWriteData().writeUShort(Offset.usWinAscent.offset, ascent);
        }

        public int usWinDescent() {
            return this.internalReadData().readUShort(Offset.usWinDescent.offset);
        }

        public void setUsWinDescent(int descent) {
            this.internalWriteData().writeUShort(Offset.usWinAscent.offset, descent);
        }

        public long ulCodePageRange1() {
            return this.internalReadData().readULong(Offset.ulCodePageRange1.offset);
        }

        public void setUlCodePageRange1(long range) {
            this.internalWriteData().writeULong(Offset.ulCodePageRange1.offset, range);
        }

        public long ulCodePageRange2() {
            return this.internalReadData().readULong(Offset.ulCodePageRange2.offset);
        }

        public void setUlCodePageRange2(long range) {
            this.internalWriteData().writeULong(Offset.ulCodePageRange2.offset, range);
        }

        public EnumSet<CodePageRange> ulCodePageRange() {
            return CodePageRange.asSet(this.ulCodePageRange1(), this.ulCodePageRange2());
        }

        public void setUlCodePageRange(EnumSet<CodePageRange> rangeSet) {
            long[] range = CodePageRange.asArray(rangeSet);
            this.setUlCodePageRange1(range[0]);
            this.setUlCodePageRange2(range[1]);
        }

        public int sxHeight() {
            return this.internalReadData().readShort(Offset.sxHeight.offset);
        }

        public void setSxHeight(int height) {
            this.internalWriteData().writeShort(Offset.sxHeight.offset, height);
        }

        public int sCapHeight() {
            return this.internalReadData().readShort(Offset.sCapHeight.offset);
        }

        public void setSCapHeight(int height) {
            this.internalWriteData().writeShort(Offset.sCapHeight.offset, height);
        }

        public int usDefaultChar() {
            return this.internalReadData().readUShort(Offset.usDefaultChar.offset);
        }

        public void setUsDefaultChar(int defaultChar) {
            this.internalWriteData().writeUShort(Offset.usDefaultChar.offset, defaultChar);
        }

        public int usBreakChar() {
            return this.internalReadData().readUShort(Offset.usBreakChar.offset);
        }

        public void setUsBreakChar(int breakChar) {
            this.internalWriteData().writeUShort(Offset.usBreakChar.offset, breakChar);
        }

        public int usMaxContext() {
            return this.internalReadData().readUShort(Offset.usMaxContext.offset);
        }

        public void setUsMaxContext(int maxContext) {
            this.internalWriteData().writeUShort(Offset.usMaxContext.offset, maxContext);
        }
    }

    public static enum CodePageRange {
        Latin1_1252,
        Latin2_1250,
        Cyrillic_1251,
        Greek_1253,
        Turkish_1254,
        Hebrew_1255,
        Arabic_1256,
        WindowsBaltic_1257,
        Vietnamese_1258,
        AlternateANSI9,
        AlternateANSI10,
        AlternateANSI11,
        AlternateANSI12,
        AlternateANSI13,
        AlternateANSI14,
        AlternateANSI15,
        Thai_874,
        JapanJIS_932,
        ChineseSimplified_936,
        KoreanWansung_949,
        ChineseTraditional_950,
        KoreanJohab_1361,
        AlternateANSI22,
        AlternateANSI23,
        AlternateANSI24,
        AlternateANSI25,
        AlternateANSI26,
        AlternateANSI27,
        AlternateANSI28,
        MacintoshCharacterSet,
        OEMCharacterSet,
        SymbolCharacterSet,
        ReservedForOEM32,
        ReservedForOEM33,
        ReservedForOEM34,
        ReservedForOEM35,
        ReservedForOEM36,
        ReservedForOEM37,
        ReservedForOEM38,
        ReservedForOEM39,
        ReservedForOEM40,
        ReservedForOEM41,
        ReservedForOEM42,
        ReservedForOEM43,
        ReservedForOEM44,
        ReservedForOEM45,
        ReservedForOEM46,
        ReservedForOEM47,
        IBMGreek_869,
        MSDOSRussion_866,
        MSDOSNordic_865,
        Arabic_864,
        MSDOSCanadianFrench_863,
        Hebrew_862,
        MSDOSIcelandic_861,
        MSDOSPortugese_860,
        IBMTurkish_857,
        IBMCyrillic_855,
        Latin2_852,
        MSDOSBaltic_775,
        Greek_737,
        Arabic_708,
        Latin1_850,
        US_437;


        public static UnicodeRange range(int bit) {
            if (bit > UnicodeRange.values().length) {
                return null;
            }
            return UnicodeRange.values()[bit];
        }

        public static EnumSet<CodePageRange> asSet(long range1, long range2) {
            EnumSet<CodePageRange> set = EnumSet.noneOf(CodePageRange.class);
            long[] range = new long[]{range1, range2};
            int rangeBit = 0;
            int rangeIndex = -1;
            CodePageRange[] codePageRangeArray = CodePageRange.values();
            int n = codePageRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CodePageRange cpr = codePageRangeArray[n2];
                if (cpr.ordinal() % 32 == 0) {
                    rangeBit = 0;
                    ++rangeIndex;
                } else {
                    ++rangeBit;
                }
                if ((range[rangeIndex] & (long)(1 << rangeBit)) == (long)(1 << rangeBit)) {
                    set.add(cpr);
                }
                ++n2;
            }
            return set;
        }

        public static long[] asArray(EnumSet<CodePageRange> rangeSet) {
            long[] range = new long[4];
            for (CodePageRange ur : rangeSet) {
                int urSegment = ur.ordinal() / 32;
                long urFlag = 1 << ur.ordinal() % 32;
                int n = urSegment;
                range[n] = range[n] | urFlag;
            }
            return range;
        }
    }

    public static enum EmbeddingFlags {
        Reserved0,
        RestrictedLicenseEmbedding,
        PreviewAndPrintEmbedding,
        EditableEmbedding,
        Reserved4,
        Reserved5,
        Reserved6,
        Reserved7,
        NoSubsetting,
        BitmapEmbeddingOnly,
        Reserved10,
        Reserved11,
        Reserved12,
        Reserved13,
        Reserved14,
        Reserved15;


        public int mask() {
            return 1 << this.ordinal();
        }

        public static EnumSet<EmbeddingFlags> asSet(int value) {
            EnumSet<EmbeddingFlags> set = EnumSet.noneOf(EmbeddingFlags.class);
            EmbeddingFlags[] embeddingFlagsArray = EmbeddingFlags.values();
            int n = embeddingFlagsArray.length;
            int n2 = 0;
            while (n2 < n) {
                EmbeddingFlags flag = embeddingFlagsArray[n2];
                if ((value & flag.mask()) == flag.mask()) {
                    set.add(flag);
                }
                ++n2;
            }
            return set;
        }

        public static int asUShort(EnumSet<EmbeddingFlags> flagSet) {
            int flags = 0;
            for (EmbeddingFlags flag : flagSet) {
                flags |= flag.mask();
            }
            return flags;
        }

        public static boolean isInstallableEditing(EnumSet<EmbeddingFlags> flagSet) {
            return flagSet.isEmpty();
        }

        public static boolean isInstallableEditing(int value) {
            return value == 0;
        }
    }

    public static enum FsSelection {
        ITALIC,
        UNDERSCORE,
        NEGATIVE,
        OUTLINED,
        STRIKEOUT,
        BOLD,
        REGULAR,
        USE_TYPO_METRICS,
        WWS,
        OBLIQUE;


        public int mask() {
            return 1 << this.ordinal();
        }

        public static EnumSet<FsSelection> asSet(int value) {
            EnumSet<FsSelection> set = EnumSet.noneOf(FsSelection.class);
            FsSelection[] fsSelectionArray = FsSelection.values();
            int n = fsSelectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                FsSelection selection = fsSelectionArray[n2];
                if ((value & selection.mask()) == selection.mask()) {
                    set.add(selection);
                }
                ++n2;
            }
            return set;
        }

        public static int asInt(EnumSet<FsSelection> fsSelectionSet) {
            int value = 0;
            for (FsSelection fsSelection : fsSelectionSet) {
                value |= fsSelection.mask();
            }
            return value;
        }
    }

    private static enum Offset {
        version(0),
        xAvgCharWidth(2),
        usWeightClass(4),
        usWidthClass(6),
        fsType(8),
        ySubscriptXSize(10),
        ySubscriptYSize(12),
        ySubscriptXOffset(14),
        ySubscriptYOffset(16),
        ySuperscriptXSize(18),
        ySuperscriptYSize(20),
        ySuperscriptXOffset(22),
        ySuperscriptYOffset(24),
        yStrikeoutSize(26),
        yStrikeoutPosition(28),
        sFamilyClass(30),
        panose(32),
        panoseLength(10),
        ulUnicodeRange1(42),
        ulUnicodeRange2(46),
        ulUnicodeRange3(50),
        ulUnicodeRange4(54),
        achVendId(58),
        achVendIdLength(4),
        fsSelection(62),
        usFirstCharIndex(64),
        usLastCharIndex(66),
        sTypoAscender(68),
        sTypoDescender(70),
        sTypoLineGap(72),
        usWinAscent(74),
        usWinDescent(76),
        ulCodePageRange1(78),
        ulCodePageRange2(82),
        sxHeight(86),
        sCapHeight(88),
        usDefaultChar(90),
        usBreakChar(92),
        usMaxContext(94);

        private final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }

    public static enum UnicodeRange {
        BasicLatin,
        Latin1Supplement,
        LatinExtendedA,
        LatinExtendedB,
        IPAExtensions,
        SpacingModifierLetters,
        CombiningDiacriticalMarks,
        GreekAndCoptic,
        Coptic,
        Cyrillic,
        Armenian,
        Hebrew,
        Vai,
        Arabic,
        NKo,
        Devanagari,
        Bengali,
        Gurmukhi,
        Gujarati,
        Oriya,
        Tamil,
        Telugu,
        Kannada,
        Malayalam,
        Thai,
        Lao,
        Georgian,
        Balinese,
        HangulJamo,
        LatinExtendedAdditional,
        GreekExtended,
        GeneralPunctuation,
        SuperscriptsAndSubscripts,
        CurrencySymbols,
        NumberForms,
        Arrows,
        MathematicalOperators,
        MiscTechnical,
        ControlPictures,
        OCR,
        EnclosedAlphanumerics,
        BoxDrawing,
        BlockElements,
        GeometricShapes,
        MiscSymbols,
        Dingbats,
        CJKSymbolsAndPunctuation,
        Hiragana,
        Katakana,
        Bopomofo,
        HangulCompatibilityJamo,
        Phagspa,
        EnclosedCJKLettersAndMonths,
        CJKCompatibility,
        HangulSyllables,
        NonPlane0,
        Phoenician,
        CJKUnifiedIdeographs,
        PrivateUseAreaPlane0,
        CJKStrokes,
        AlphabeticPresentationForms,
        ArabicPresentationFormsA,
        CombiningHalfMarks,
        VerticalForms,
        SmallFormVariants,
        ArabicPresentationFormsB,
        HalfwidthAndFullwidthForms,
        Specials,
        Tibetan,
        Syriac,
        Thaana,
        Sinhala,
        Myanmar,
        Ethiopic,
        Cherokee,
        UnifiedCanadianAboriginalSyllabics,
        Ogham,
        Runic,
        Khmer,
        Mongolian,
        BraillePatterns,
        YiSyllables,
        Tagalog,
        OldItalic,
        Gothic,
        Deseret,
        MusicalSymbols,
        MathematicalAlphanumericSymbols,
        PrivateUsePlane15And16,
        VariationSelectors,
        Tags,
        Limbu,
        TaiLe,
        NewTaiLue,
        Buginese,
        Glagolitic,
        Tifnagh,
        YijingHexagramSymbols,
        SylotiNagari,
        LinearB,
        AncientGreekNumbers,
        Ugaritic,
        OldPersian,
        Shavian,
        Osmanya,
        CypriotSyllabary,
        Kharoshthi,
        TaiXuanJingSymbols,
        Cuneiform,
        CountingRodNumerals,
        Sudanese,
        Lepcha,
        OlChiki,
        Saurashtra,
        KayahLi,
        Rejang,
        Charm,
        AncientSymbols,
        PhaistosDisc,
        Carian,
        DominoTiles,
        Reserved123,
        Reserved124,
        Reserved125,
        Reserved126,
        Reserved127;


        public static UnicodeRange range(int bit) {
            if (bit > UnicodeRange.values().length) {
                return null;
            }
            return UnicodeRange.values()[bit];
        }

        public static EnumSet<UnicodeRange> asSet(long range1, long range2, long range3, long range4) {
            EnumSet<UnicodeRange> set = EnumSet.noneOf(UnicodeRange.class);
            long[] range = new long[]{range1, range2, range3, range4};
            int rangeBit = 0;
            int rangeIndex = -1;
            UnicodeRange[] unicodeRangeArray = UnicodeRange.values();
            int n = unicodeRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                UnicodeRange ur = unicodeRangeArray[n2];
                if (ur.ordinal() % 32 == 0) {
                    rangeBit = 0;
                    ++rangeIndex;
                } else {
                    ++rangeBit;
                }
                if ((range[rangeIndex] & (long)(1 << rangeBit)) == (long)(1 << rangeBit)) {
                    set.add(ur);
                }
                ++n2;
            }
            return set;
        }

        public static long[] asArray(EnumSet<UnicodeRange> rangeSet) {
            long[] range = new long[4];
            for (UnicodeRange ur : rangeSet) {
                int urSegment = ur.ordinal() / 32;
                long urFlag = 1 << ur.ordinal() % 32;
                int n = urSegment;
                range[n] = range[n] | urFlag;
            }
            return range;
        }
    }

    public static enum WeightClass {
        Thin(100),
        ExtraLight(200),
        UltraLight(200),
        Light(300),
        Normal(400),
        Regular(400),
        Medium(500),
        SemiBold(600),
        DemiBold(600),
        Bold(700),
        ExtraBold(800),
        UltraBold(800),
        Black(900),
        Heavy(900);

        private final int value;

        private WeightClass(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int value) {
            return value == this.value;
        }

        public static WeightClass valueOf(String string) {
            return Enum.valueOf(WeightClass.class, string);
        }
    }

    public static enum WidthClass {
        UltraCondensed(1),
        ExtraCondensed(2),
        Condensed(3),
        SemiCondensed(4),
        Medium(5),
        Normal(5),
        SemiExpanded(6),
        Expanded(7),
        ExtraExpanded(8),
        UltraExpanded(9);

        private final int value;

        private WidthClass(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int value) {
            return value == this.value;
        }

        public static WidthClass valueOf(String string) {
            return Enum.valueOf(WidthClass.class, string);
        }
    }
}

