/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.tools.conversion.eot.GlyfEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.TestCase;

public class GlyfEncoderTest
extends TestCase {
    private void assertEqualsByteArray(byte[] expected, byte[] actual) {
        GlyfEncoderTest.assertEquals(expected.length, actual.length);
        int i = 0;
        while (i < expected.length) {
            GlyfEncoderTest.assertEquals(expected[i], actual[i]);
            ++i;
        }
    }

    public void test255UShort1() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255UShort(os, 142);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-114};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255UShort2() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255UShort(os, 254);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-1, 1};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255UShort3() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255UShort(os, 507);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-2, 1};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255UShort4() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255UShort(os, 4660);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-3, 18, 52};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short1() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, 249);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-7};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short2() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, -249);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-6, -7};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short3() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, 250);
        byte[] actual = os.toByteArray();
        byte[] byArray = new byte[2];
        byArray[0] = -1;
        byte[] expected = byArray;
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short4() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, -250);
        byte[] actual = os.toByteArray();
        byte[] byArray = new byte[3];
        byArray[0] = -6;
        byArray[1] = -1;
        byte[] expected = byArray;
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short5() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, 251);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-1, 1};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short6() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, 499);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-1, -7};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short7() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, -499);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-6, -1, -7};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short8() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, 500);
        byte[] actual = os.toByteArray();
        byte[] byArray = new byte[2];
        byArray[0] = -2;
        byte[] expected = byArray;
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short9() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, -500);
        byte[] actual = os.toByteArray();
        byte[] byArray = new byte[3];
        byArray[0] = -6;
        byArray[1] = -2;
        byte[] expected = byArray;
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short10() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, 749);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-2, -7};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short11() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, -749);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-6, -2, -7};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short12() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, 750);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-3, 2, -18};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short13() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, -750);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-3, -3, 18};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short14() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, -984);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-3, -4, 40};
        this.assertEqualsByteArray(expected, actual);
    }

    public void test255Short15() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GlyfEncoder.write255Short(os, 4660);
        byte[] actual = os.toByteArray();
        byte[] expected = new byte[]{-3, 18, 52};
        this.assertEqualsByteArray(expected, actual);
    }

    private byte[] tripletEncode(boolean onCurve, int x, int y) throws IOException {
        GlyfEncoder e = new GlyfEncoder();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        e.writeTriplet(os, onCurve, x, y);
        byte[] flagBytes = e.getGlyfBytes();
        GlyfEncoderTest.assertEquals(1, flagBytes.length);
        byte[] valueBytes = os.toByteArray();
        byte[] result = new byte[flagBytes.length + valueBytes.length];
        System.arraycopy(flagBytes, 0, result, 0, flagBytes.length);
        System.arraycopy(valueBytes, 0, result, flagBytes.length, valueBytes.length);
        return result;
    }

    public void testTriplet1() throws IOException {
        byte[] expected = new byte[]{1, 1};
        this.assertEqualsByteArray(expected, this.tripletEncode(true, 0, 1));
    }

    public void testTriplet2() throws IOException {
        byte[] expected = new byte[]{2, 1};
        this.assertEqualsByteArray(expected, this.tripletEncode(true, 0, -257));
    }

    public void testTriplet11() throws IOException {
        byte[] expected = new byte[]{11, 1};
        this.assertEqualsByteArray(expected, this.tripletEncode(true, 1, 0));
    }

    public void testTriplet15() throws IOException {
        byte[] expected = new byte[]{15, 1};
        this.assertEqualsByteArray(expected, this.tripletEncode(true, 513, 0));
    }

    public void testTriplet21() throws IOException {
        byte[] expected = new byte[]{21, 18};
        this.assertEqualsByteArray(expected, this.tripletEncode(true, 2, -3));
    }

    public void testTriplet56() throws IOException {
        byte[] expected = new byte[]{56, 18};
        this.assertEqualsByteArray(expected, this.tripletEncode(true, -34, -19));
    }

    public void testTriplet87() throws IOException {
        byte[] expected = new byte[]{87, -128, -126};
        this.assertEqualsByteArray(expected, this.tripletEncode(true, 129, 131));
    }

    public void testTriplet105() throws IOException {
        byte[] expected = new byte[]{105, -56, 100};
        this.assertEqualsByteArray(expected, this.tripletEncode(true, 457, -613));
    }

    public void testTriplet121() throws IOException {
        byte[] expected = new byte[]{121, 18, 52, 86};
        this.assertEqualsByteArray(expected, this.tripletEncode(true, 291, -1110));
    }

    public void testTriplet126() throws IOException {
        byte[] expected = new byte[]{126, 18, 52, 86, 120};
        this.assertEqualsByteArray(expected, this.tripletEncode(true, -4660, 22136));
    }

    public void testTriplet129() throws IOException {
        byte[] expected = new byte[]{-127, 1};
        this.assertEqualsByteArray(expected, this.tripletEncode(false, 0, 1));
    }

    public void testTriplet254() throws IOException {
        byte[] expected = new byte[]{-2, 18, 52, 86, 120};
        this.assertEqualsByteArray(expected, this.tripletEncode(false, -4660, 22136));
    }
}

