/******************************************************************************
  Line_In.c
·źŴļ
    ߣ
    V1.1
    ڣ2016.11.4
******************************************************************************/

#include "Line_In.h"

uint8_t LineInEnable;
volatile uint8_t    KeyLeftinStatus;
volatile uint8_t    KeyRightinStatus;
volatile uint8_t    KeyEnterinStatus;

#if CODEMODE==Normal
uint16_t Sample_Volt[] = {2500,3333,3750};   	   //ӦK1,K2K3ADɼĵѹֵ
#else
uint16_t Sample_Volt[] = {2250,3100,3500};   	   //ӦK1,K2K3ADɼĵѹֵ 4.48V汾
#endif
#ifdef    KEY_LEFT_SIGNAL
volatile uint8_t    KeyLeftStatus;
LineInDebounceStruct KeyLeftDeb;
#endif

#ifdef    KEY_RIGHT_SIGNAL
volatile uint8_t    KeyRightStatus;
LineInDebounceStruct KeyRightDeb;
#endif

#ifdef    KEY_ENTER_SIGNAL
volatile uint8_t    KeyEnterStatus;
LineInDebounceStruct KeyEnterDeb;
#endif


#ifdef LINE_IN_RIGHT_SIGNAL                     //ת
volatile uint8_t     LineInRIGHTStatus;
LineInDebounceStruct LineInRIGHTDeb;
#endif

#ifdef LINE_IN_LEFT_SIGNAL                      //ת
volatile uint8_t     LineInLEFTStatus;
LineInDebounceStruct LineInLEFTDeb;
#endif

#ifdef LINE_IN_SEATBELT_SIGNAL                  //ȫδϵ
volatile uint8_t     LineInSEATBELTStatus;
LineInDebounceStruct LineInSEATBELTDeb;
#endif

#ifdef LINE_IN_POSITION_SIGNAL                   //λõ   
volatile uint8_t     LineInPOSITIONStatus;
LineInDebounceStruct LineInPOSITIONDeb;
#endif

#ifdef LINE_IN_BREAK_FLUID_SIGNAL                   //ƶҺλ   
volatile uint8_t     LineInBREAKFLUIDStatus;
LineInDebounceStruct LineInBREAKFLUIDDeb;
#endif

#ifdef LINE_IN_BREAK_SIGNAL                   //פƶ   RF_HOOVES
volatile uint8_t     LineInBREAKStatus;
LineInDebounceStruct LineInBREAKDeb;
#endif

#ifdef LINE_IN_RF_HOOVES_SIGNAL                   //ǰƬĥ
volatile uint8_t     LineInRFHOOVESStatus;
LineInDebounceStruct LineInRFHOOVESDeb;
#endif

#ifdef LINE_IN_RR_HOOVES_SIGNAL                   //Ƭĥ      
volatile uint8_t     LineInRRHOOVESStatus;
LineInDebounceStruct LineInRRHOOVESDeb;
#endif

#ifdef LINE_IN_CAB_LOCK_SIGNAL                   //ʻδֹ
volatile uint8_t     LineInCABLOCKStatus;
LineInDebounceStruct LineInCABLOCKDeb;
#endif

#ifdef LINE_IN_PTO_SIGNAL                   // PTO 
volatile uint8_t     LineInPTOStatus;
LineInDebounceStruct LineInPTODeb;
#endif

#ifdef LINE_IN_FILT_BLOCK_SIGNAL                   //  FILT_BLOCK  
volatile uint8_t     LineInFILTBLOCKStatus;
LineInDebounceStruct LineInFILTBLOCKDeb;
#endif

#ifdef LINE_IN_CHARGE_SIGNAL                   // CHARGE   
volatile uint8_t     LineInCHARGEStatus;
LineInDebounceStruct LineInCHARGEDeb;
#endif

#ifdef LINE_IN_GEAR_SIGNAL                   //    GEAR
volatile uint8_t     LineInGEARStatus;
LineInDebounceStruct LineInGEARDeb;
#endif
/******************************************************************************
Line_In_Enable
  ܣ·빦ʹ
  Enable 0 -  ֹ 1 - ʹ
ֵ
******************************************************************************/
void Line_In_Enable(uint8_t Enable)
{
  if (Enable)
    Enable = 1;

  if (LineInEnable != Enable)
  {
    Line_In_Status_Reset();
    LineInEnable = Enable;
  }
}

/******************************************************************************
Line_In_Debounce
  ܣ·              
  Input        - ź
        DebCycleRise - 
        DebCycleFall - ½
        pDebCtrl     - ƽṹ
ֵǰ·ֵ
******************************************************************************/
#pragma INLINE
uint8_t Line_In_Debounce (uint8_t Input, uint8_t DebCycleRise, uint16_t DebCycleFall, LineInDebounceStruct *pDebCtrl)
{
  if (Input == pDebCtrl -> Last)
  {
    pDebCtrl -> Timer++;
    
    if (Input)
    {
      if (pDebCtrl -> Timer >= DebCycleRise)
      {
        pDebCtrl -> Timer   = 0;
        pDebCtrl -> Current = Input;
      }
    }
    else
    {
      if (pDebCtrl -> Timer >= DebCycleFall)
      {
        pDebCtrl -> Timer   = 0;
        pDebCtrl -> Current = Input;
      }
    }
  }
  else
  {
    pDebCtrl -> Timer = 0;
    pDebCtrl -> Last  = Input;
  }

  return pDebCtrl -> Current;  
}
/******************************************************************************
Line_In_Status_Reset
  ܣλ·״̬ΪĬ״̬
  
ֵ
******************************************************************************/
void Line_In_Status_Reset(void)
{
#ifdef KEY_LEFT_SIGNAL            //
  KEY_LEFT_SIGNAL = KEY_LEFT_DEFAULT;
  KeyLeftDeb.Timer = 0;
#endif

#ifdef KEY_RIGHT_SIGNAL            //
  KEY_RIGHT_SIGNAL = KEY_RIGHT_DEFAULT;
  KeyLeftDeb.Timer = 0;
#endif

#ifdef KEY_ENTER_SIGNAL            //
  KEY_ENTER_SIGNAL = KEY_ENTER_DEFAULT;
  KeyEnterDeb.Timer = 0;
#endif


#ifdef LINE_IN_RIGHT_SIGNAL                  //ת
  LINE_IN_RIGHT_SIGNAL = LINE_IN_RIGHT_DEFAULT;
  LineInRIGHTDeb .Timer = 0;
#endif

#ifdef LINE_IN_LEFT_SIGNAL                   //ת
  LINE_IN_LEFT_SIGNAL = LINE_IN_LEFT_DEFAULT;
  LineInLEFTDeb .Timer = 0;
#endif

#ifdef LINE_IN_SEATBELT_SIGNAL               //ȫ
  LINE_IN_SEATBELT_SIGNAL = LINE_IN_SEATBELT_DEFAULT;
  LineInSEATBELTDeb .Timer = 0;
#endif

#ifdef LINE_IN_POSITION_SIGNAL               //λõ   
  LINE_IN_POSITION_SIGNAL = LINE_IN_POSITION_DEFAULT;
  LineInPOSITIONDeb .Timer = 0;
#endif

#ifdef LINE_IN_BREAK_FLUID_SIGNAL               //ƶҺλ
  LINE_IN_BREAK_FLUID_SIGNAL = LINE_IN_BREAK_FLUID_DEFAULT;
  LineInBREAKFLUIDDeb .Timer = 0;
#endif

#ifdef LINE_IN_BREAK_SIGNAL               //פƶ
  LINE_IN_BREAK_SIGNAL = LINE_IN_BREAK_DEFAULT;
  LineInBREAKDeb .Timer = 0;
#endif

#ifdef LINE_IN_RF_HOOVES_SIGNAL               //ǰƬĥ
  LINE_IN_RF_HOOVES_SIGNAL = LINE_IN_RF_HOOVES_DEFAULT;
  LineInRFHOOVESDeb .Timer = 0;
#endif

#ifdef LINE_IN_RR_HOOVES_SIGNAL               //Ƭĥ    
  LINE_IN_RR_HOOVES_SIGNAL = LINE_IN_RR_HOOVES_DEFAULT;
  LineInRRHOOVESDeb .Timer = 0;
#endif

#ifdef LINE_IN_CAB_LOCK_SIGNAL               //     
  LINE_IN_CAB_LOCK_SIGNAL = LINE_IN_CAB_LOCK_DEFAULT;
  LineInCABLOCKDeb .Timer = 0;
#endif

#ifdef LINE_IN_PTO_SIGNAL               //      PTO  
  LINE_IN_PTO_SIGNAL = LINE_IN_PTO_DEFAULT;
  LineInPTODeb .Timer = 0;
#endif

#ifdef LINE_IN_FILT_BLOCK_SIGNAL               //FILT_BLOCK  
  LINE_IN_FILT_BLOCK_SIGNAL = LINE_IN_FILT_BLOCK_DEFAULT;
  LineInFILTBLOCKDeb .Timer = 0;
#endif

#ifdef LINE_IN_CHARGE_SIGNAL               //  CHARGE
  LINE_IN_CHARGE_SIGNAL = LINE_IN_CHARGE_DEFAULT;
  LineInCHARGEDeb .Timer = 0;
#endif

#ifdef LINE_IN_GEAR_SIGNAL               //  GEAR
  LINE_IN_GEAR_SIGNAL = LINE_IN_GEAR_DEFAULT;
  LineInGEARDeb .Timer = 0;
#endif
/////////////////////////////////////////////////////////////////////////
}

/******************************************************************************
Line_In_Debounce_Service
  ܣ·,ڽո·źŲ
  
ֵ
******************************************************************************
ע  ⣺÷ÿ20msһ
******************************************************************************/
void Line_In_Debounce_Service(void)
{
  uint8_t LineStatus;
  uint16_t KeyVolt;

      KeyVolt = ANALOG_KEY_SENSOR_Vol; 
    if( (KeyVolt >= (Sample_Volt[0]-300)) && KeyVolt <= (Sample_Volt[0]+300)) //
	   KeyLeftinStatus=1;
		else
		 KeyLeftinStatus =0;
		
		 if( (KeyVolt >= (Sample_Volt[1]-300)) && KeyVolt <= (Sample_Volt[1]+150)) //
	   KeyRightinStatus=1;
		else
		 KeyRightinStatus =0;
		
		if( (KeyVolt >= (Sample_Volt[2]-150)) && KeyVolt <= (Sample_Volt[2]+300)) //
	   KeyEnterinStatus=1;
		else
		 KeyEnterinStatus =0;
		
      #ifdef  KEY_LEFT_SIGNAL          //
    #ifdef  KEY_LEFT_IN
      KEY_LEFT_SIGNAL = Line_In_Debounce(KEY_LEFT_IN, 
                                            KEY_DEB_RISE / LINE_IN_DEBOUNCE_CYCLE,
                                            KEY_DEB_FALL / LINE_IN_DEBOUNCE_CYCLE,
                                            &KeyLeftDeb);
    #else
      KEY_LEFT_SIGNAL = Line_In_Debounce(!KEY_LEFT_INn, 
                                            KEY_DEB_RISE / LINE_IN_DEBOUNCE_CYCLE,
                                            KEY_DEB_FALL / LINE_IN_DEBOUNCE_CYCLE,
                                            &KeyLeftDeb);
    #endif
  #endif 

     #ifdef  KEY_RIGHT_SIGNAL          //
    #ifdef  KEY_RIGHT_IN
      KEY_RIGHT_SIGNAL = Line_In_Debounce(KEY_RIGHT_IN, 
                                            KEY_DEB_RISE / LINE_IN_DEBOUNCE_CYCLE,
                                            KEY_DEB_FALL / LINE_IN_DEBOUNCE_CYCLE,
                                            &KeyRightDeb);
    #else
      KEY_RIGHT_SIGNAL = Line_In_Debounce(!KEY_RIGHT_INn, 
                                            KEY_DEB_RISE / LINE_IN_DEBOUNCE_CYCLE,
                                            KEY_DEB_FALL / LINE_IN_DEBOUNCE_CYCLE,
                                            &KeyRightDeb);
    #endif
  #endif

     #ifdef  KEY_ENTER_SIGNAL          //
    #ifdef  KEY_ENTER_IN
      KEY_ENTER_SIGNAL = Line_In_Debounce(KEY_ENTER_IN, 
                                            KEY_DEB_RISE / LINE_IN_DEBOUNCE_CYCLE,
                                            KEY_DEB_FALL / LINE_IN_DEBOUNCE_CYCLE,
                                            &KeyEnterDeb);
    #else
      KEY_ENTER_SIGNAL = Line_In_Debounce(!KEY_ENTER_INn, 
                                            KEY_DEB_RISE / LINE_IN_DEBOUNCE_CYCLE,
                                            KEY_DEB_FALL / LINE_IN_DEBOUNCE_CYCLE,
                                            &KeyEnterDeb);
    #endif
  #endif
  if (LineInEnable == 0)
    return;



  // LED_RIGHT_G
  #ifdef  LINE_IN_RIGHT_SIGNAL
  #ifdef  LINE_IN_RIGHT
    LineStatus = LINE_IN_RIGHT;
  #else
    LineStatus = !LINE_IN_RIGHTn;
  #endif

    if (LineStatus == LineInRIGHTDeb.Last)
    {
      LineInRIGHTDeb.Timer++;
     if(LineStatus)
     {
      if (LineInRIGHTDeb.Timer >= 4)    //////////////////////////80ms
      {
        LineInRIGHTDeb.Timer = 0;
        LINE_IN_RIGHT_SIGNAL = LineStatus;
      }
     }
     else
     {
       if (LineInRIGHTDeb.Timer >= 4)    //////////////////////////80ms
      {
        LineInRIGHTDeb.Timer = 0;
        LINE_IN_RIGHT_SIGNAL = LineStatus;
      }
     }

    }
    else
    {
      LineInRIGHTDeb.Timer = 0;
      LineInRIGHTDeb.Last  = LineStatus;
    }
  #endif

  // LED_LEFT_G
  #ifdef  LINE_IN_LEFT_SIGNAL
  #ifdef  LINE_IN_LEFT
    LineStatus = LINE_IN_LEFT;
  #else
    LineStatus = !LINE_IN_LEFTn;
  #endif

    if (LineStatus == LineInLEFTDeb.Last)
    {
      LineInLEFTDeb.Timer++;
      if(LineStatus)
      {
       if (LineInLEFTDeb.Timer >= 4)     //////////////////////////////80ms
       {
        LineInLEFTDeb.Timer = 0;
        LINE_IN_LEFT_SIGNAL = LineStatus;
       } 
      }
      else
      {
       if(LineInLEFTDeb.Timer >= 4)     //////////////////////////////80ms
       {
        LineInLEFTDeb.Timer = 0;
        LINE_IN_LEFT_SIGNAL = LineStatus;
       }  
      }
    }
    else
    {
      LineInLEFTDeb.Timer = 0;
      LineInLEFTDeb.Last  = LineStatus;
    }
  #endif

  // LED_SEATBELT_R      //ȫ
  #ifdef  LINE_IN_SEATBELT_SIGNAL
  #ifdef  LINE_IN_SEATBELT
    LineStatus = LINE_IN_SEATBELT;
  #else
    LineStatus = !LINE_IN_SEATBELTn;
  #endif

    if (LineStatus == LineInSEATBELTDeb.Last)
    {
      LineInSEATBELTDeb.Timer++;
      if (LineInSEATBELTDeb.Timer >= LINE_TIME_CNT)
      {
        LineInSEATBELTDeb.Timer = 0;
        LINE_IN_SEATBELT_SIGNAL = LineStatus;
      }
    }
    else
    {
      LineInSEATBELTDeb.Timer = 0;
      LineInSEATBELTDeb.Last  = LineStatus;
    }
  #endif

  // LED_POSITION_G              
  #ifdef  LINE_IN_POSITION_SIGNAL
  #ifdef  LINE_IN_POSITION
    LineStatus = LINE_IN_POSITION;
  #else
    LineStatus = !LINE_IN_POSITIONn;
  #endif

    if (LineStatus == LineInPOSITIONDeb.Last)
    {
      LineInPOSITIONDeb.Timer++;
      if (LineInPOSITIONDeb.Timer >= LINE_TIME_CNT)
      {
        LineInPOSITIONDeb.Timer = 0;
        LINE_IN_POSITION_SIGNAL = LineStatus;
      }
    }
    else
    {
      LineInPOSITIONDeb.Timer = 0;
      LineInPOSITIONDeb.Last  = LineStatus;
    }
  #endif
  
    //ƶҺλ
  #ifdef  LINE_IN_BREAK_FLUID_SIGNAL
  #ifdef  LINE_IN_BREAK_FLUID
    LineStatus = LINE_IN_BREAK_FLUID;
  #else
    LineStatus = !LINE_IN_BREAK_FLUIDn;
  #endif

    if (LineStatus == LineInBREAKFLUIDDeb.Last)
    {
      LineInBREAKFLUIDDeb.Timer++;
      if (LineInBREAKFLUIDDeb.Timer >= LINE_IN_DEBOUNCE_L_CNT)
      {
        LineInBREAKFLUIDDeb.Timer = 0;
        LINE_IN_BREAK_FLUID_SIGNAL = LineStatus;
      }
    }
    else
    {
      LineInBREAKFLUIDDeb.Timer = 0;
      LineInBREAKFLUIDDeb.Last  = LineStatus;
    }
  #endif
  
      //פƶ
  #ifdef  LINE_IN_BREAK_SIGNAL
  #ifdef  LINE_IN_BREAK
    LineStatus = LINE_IN_BREAK;
  #else
    LineStatus = !LINE_IN_BREAKn;
  #endif

    if (LineStatus == LineInBREAKDeb.Last)
    {
      LineInBREAKDeb.Timer++;
      if (LineInBREAKDeb.Timer >= LINE_IN_DEBOUNCE_L_CNT)
      {
        LineInBREAKDeb.Timer = 0;
        LINE_IN_BREAK_SIGNAL = LineStatus;
      }
    }
    else
    {
      LineInBREAKDeb.Timer = 0;
      LineInBREAKDeb.Last  = LineStatus;
    }
  #endif
  
        //ǰƬĥ
  #ifdef  LINE_IN_RF_HOOVES_SIGNAL
  #ifdef  LINE_IN_RF_HOOVES
    LineStatus = LINE_IN_RF_HOOVES;
  #else
    LineStatus = !LINE_IN_RF_HOOVESn;
  #endif

    if (LineStatus == LineInRFHOOVESDeb.Last)
    {
      LineInRFHOOVESDeb.Timer++;
      if (LineInRFHOOVESDeb.Timer >= LINE_IN_DEBOUNCE_L_CNT)
      {
        LineInRFHOOVESDeb.Timer = 0;
        LINE_IN_RF_HOOVES_SIGNAL = LineStatus;
      }
    }
    else
    {
      LineInRFHOOVESDeb.Timer = 0;
      LineInRFHOOVESDeb.Last  = LineStatus;
    }
  #endif
  
        //Ƭĥ      
  #ifdef  LINE_IN_RR_HOOVES_SIGNAL
  #ifdef  LINE_IN_RR_HOOVES
    LineStatus = LINE_IN_RR_HOOVES;
  #else
    LineStatus = !LINE_IN_RR_HOOVESn;
  #endif

    if (LineStatus == LineInRRHOOVESDeb.Last)
    {
      LineInRRHOOVESDeb.Timer++;
      if (LineInRRHOOVESDeb.Timer >= LINE_IN_DEBOUNCE_L_CNT)
      {
        LineInRRHOOVESDeb.Timer = 0;
        LINE_IN_RR_HOOVES_SIGNAL = LineStatus;
      }
    }
    else
    {
      LineInRRHOOVESDeb.Timer = 0;
      LineInRRHOOVESDeb.Last  = LineStatus;
    }
  #endif
  
          //CAB_LOCK   PTO
  #ifdef  LINE_IN_CAB_LOCK_SIGNAL
  #ifdef  LINE_IN_CAB_LOCK
    LineStatus = LINE_IN_CAB_LOCK;
  #else
    LineStatus = !LINE_IN_CAB_LOCKn;
  #endif

    if (LineStatus == LineInCABLOCKDeb.Last)
    {
      LineInCABLOCKDeb.Timer++;
      if (LineInCABLOCKDeb.Timer >= LINE_IN_DEBOUNCE_L_CNT)
      {
        LineInCABLOCKDeb.Timer = 0;
        LINE_IN_CAB_LOCK_SIGNAL = LineStatus;
      }
    }
    else
    {
      LineInCABLOCKDeb.Timer = 0;
      LineInCABLOCKDeb.Last  = LineStatus;
    }
  #endif
  
            //  PTO   
  #ifdef  LINE_IN_PTO_SIGNAL
  #ifdef  LINE_IN_PTO
    LineStatus = LINE_IN_PTO;
  #else
    LineStatus = !LINE_IN_PTOn;
  #endif

    if (LineStatus == LineInPTODeb.Last)
    {
      LineInPTODeb.Timer++;
      if (LineInPTODeb.Timer >= LINE_IN_DEBOUNCE_L_CNT)
      {
        LineInPTODeb.Timer = 0;
        LINE_IN_PTO_SIGNAL = LineStatus;
      }
    }
    else
    {
      LineInPTODeb.Timer = 0;
      LineInPTODeb.Last  = LineStatus;
    }
  #endif
  
              //FILT_BLOCK        
  #ifdef  LINE_IN_FILT_BLOCK_SIGNAL
  #ifdef  LINE_IN_FILT_BLOCK
    LineStatus = LINE_IN_FILT_BLOCK;
  #else
    LineStatus = !LINE_IN_FILT_BLOCKn;
  #endif

    if (LineStatus == LineInFILTBLOCKDeb.Last)
    {
      LineInFILTBLOCKDeb.Timer++;
      if (LineInFILTBLOCKDeb.Timer >= LINE_IN_DEBOUNCE_L_CNT)
      {
        LineInFILTBLOCKDeb.Timer = 0;
        LINE_IN_FILT_BLOCK_SIGNAL = LineStatus;
      }
    }
    else
    {
      LineInFILTBLOCKDeb.Timer = 0;
      LineInFILTBLOCKDeb.Last  = LineStatus;
    }
  #endif
  
                //CHARGE       
  #ifdef  LINE_IN_CHARGE_SIGNAL
  #ifdef  LINE_IN_CHARGE
    LineStatus = LINE_IN_CHARGE;
  #else
    LineStatus = !LINE_IN_CHARGEn;
  #endif

    if (LineStatus == LineInCHARGEDeb.Last)
    {
      LineInCHARGEDeb.Timer++;
      if (LineInCHARGEDeb.Timer >= LINE_IN_DEBOUNCE_L_CNT)
      {
        LineInCHARGEDeb.Timer = 0;
        LINE_IN_CHARGE_SIGNAL = LineStatus;
      }
    }
    else
    {
      LineInCHARGEDeb.Timer = 0;
      LineInCHARGEDeb.Last  = LineStatus;
    }
  #endif
  
                  //GEAR       
  #ifdef  LINE_IN_GEAR_SIGNAL
  #ifdef  LINE_IN_GEAR
    LineStatus = LINE_IN_GEAR;
  #else
    LineStatus = !LINE_IN_GEARn;
  #endif

    if (LineStatus == LineInGEARDeb.Last)
    {
      LineInGEARDeb.Timer++;
      if (LineInGEARDeb.Timer >= LINE_IN_DEBOUNCE_L_CNT)
      {
        LineInGEARDeb.Timer = 0;
        LINE_IN_GEAR_SIGNAL = LineStatus;
      }
    }
    else
    {
      LineInGEARDeb.Timer = 0;
      LineInGEARDeb.Last  = LineStatus;
    }
  #endif
}
