/********************************************************************************/
/*  CONFIDENTIAL                                                                */
/*  Copyright (C) 2011 Yamaha Corporation. All rights reserved.                 */
/*  Module          : $Workfile: YvcConfig.h $                                  */
/*  Description     : XFL Driver Configuration parameter include header         */
/*  Version         : $Rev: 145 $                                                */
/*  Last UpDate Time: $Date:: 2012-08-24 13:55:38#$                             */
/*  FOOT NOTE       : adjust 4tab                                               */
/*  AUTHOR          : H.Katayama                                                */
/********************************************************************************/
#ifndef _def_YVC_CONFIG_H_
#define _def_YVC_CONFIG_H_

/********************************************************************************************
 *                          Development environment setting
 ********************************************************************************************/
 
/*--- Bit filed allocation ---*/
#define YVC_BIT_FIELD                       (1)     /* 0: MSB priority allocation           */
                                                    /* 1: LSB priority allocation           */

/********************************************************************************************
 *                            LCD panel settings
 ********************************************************************************************/
//#define USE_LCD_HSD043I9W1                  (1)
//#define USE_LCD_AUOC035QAN01                (1)
#define USE_LCD_CPTCLAP070LM01XN            (1)

/********************************************************************************************
 *                           Pattern memory setting
 ********************************************************************************************/
//#define   USE_SPANSION_S25FL256S            (1)
//#define   USE_ISSI_IS25LP256D               (1)
#define   USE_WINBOND_W25Q256FV             (1)   
//#define   USE_WINBOND_W25Q128FV             (1)
//#define   USE_GIGADEVICE_GD25Q127C          (1)

/********************************************************************************************
 *                          Expanded function setting
 ********************************************************************************************/
/*--- YVC1_Init function ---*/
#define YVC_GENERAL_TABLE_INIT              (1)     /* 0: General table is not initialized  */
                                                    /* 1: General table is initialized      */
                                                    
/********************************************************************************************
 *                               Text layer setting
 ********************************************************************************************/
#define YVC_TEXT_LYR_ENABLE                 (0)     /* 0: Text layer is disabled            */
                                                    /* 1: Text layer is enabled             */
#define YVC_TEXT_DISPLAY_DIR                (0)     /* 0: Horizontal direction              */
                                                    /* 1: Vertical direction                */
#define YVC_TEXT_SEGMENTED_KERNING          (0)     /* 0: Individually Kerning              */
                                                    /* 1: Segmented Kerning                 */
                                                                                                                                                            
/********************************************************************************************
 *                          General table area setting
 ********************************************************************************************/
/*--- Host Controlled Layer area setting ---*/
#define YVC_LYR_ADDR_CPU               (0x0000U)    /* Host Controlled Layer start address  */
#define YVC_LYR_NUM_CPU                (82)         /* Number of Host Controlled Layers     */

/*--- Character Code area setting ---*/
#define YVC_TBL_PTEXT_ADDR             (0x0C00U)    /* Character Code area start address    */
#define YVC_TBL_PTEXT_BLOCK_NUM        (12)         /* Number of Text block                 */
#define YVC_TBL_PTEXT_BLOCK_SIZE       (20)         /* Number of Characters in one block    */

/*--- Font Type Attribute Data area setting ---*/
#define YVC_TBL_FONT_ADDR              (0x0FC0U)    /* Font Type Attribute Data area start address */
#define YVC_TBL_FONT_NUM               (8)          /* Number of Font Type Attribute Data   */

/********************************************************************************************
 *                        Color palette table area setting
 ********************************************************************************************/
/*--- Sprite color palette area setting ---*/
#define YVC_SPRITE_PLT_ADDR            (0x0000U)    /* Sprite color palette start address   */
#define YVC_SPRITE_COLOR_NUM           (0)          /* Number of sprite color(4Byte/Color)  */

/*--- Text color palette area setting ---*/
#define YVC_TEXT_PLT_ADDR              (0x0E00U)    /* Text color palette start address     */
#define YVC_TEXT_COLOR_NUM             (64)         /* Number of text color(8Byte/Color)    */

#endif /* _def_YVC_CONFIG_H_	*/

/* ----------------------------- E O F ----------------------------------------*/
