/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.HorizontalDeviceMetricsTable;
import com.google.typography.font.sfntly.testutils.TestFont;
import com.google.typography.font.sfntly.testutils.TestFontUtils;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public class HdmxTests
extends TestCase {
    private static final File TEST_FONT_FILE = TestFont.TestFontNames.DROIDSANS.getFile();

    public void testBasicHdmx() throws IOException {
        Font font = TestFontUtils.loadFont(TEST_FONT_FILE)[0];
        HorizontalDeviceMetricsTable hdmxTable = (HorizontalDeviceMetricsTable)font.getTable(Tag.hdmx);
        HdmxTests.assertEquals(0, hdmxTable.version());
        HdmxTests.assertEquals(19, hdmxTable.numRecords());
        HdmxTests.assertEquals(900, hdmxTable.recordSize());
        HdmxTests.assertEquals(6, hdmxTable.pixelSize(0));
        HdmxTests.assertEquals(7, hdmxTable.pixelSize(1));
        HdmxTests.assertEquals(24, hdmxTable.pixelSize(18));
        HdmxTests.assertEquals(7, hdmxTable.maxWidth(0));
        HdmxTests.assertEquals(28, hdmxTable.maxWidth(18));
        HdmxTests.assertEquals(4, hdmxTable.width(0, 0));
        HdmxTests.assertEquals(4, hdmxTable.width(1, 0));
        HdmxTests.assertEquals(5, hdmxTable.width(2, 0));
        HdmxTests.assertEquals(14, hdmxTable.width(18, 0));
        HdmxTests.assertEquals(4, hdmxTable.width(0, 36));
        HdmxTests.assertEquals(5, hdmxTable.width(1, 36));
        HdmxTests.assertEquals(6, hdmxTable.width(2, 36));
        HdmxTests.assertEquals(15, hdmxTable.width(18, 36));
    }

    public void testHdmxBounds() throws IOException {
        int x2;
        Font font = TestFontUtils.loadFont(TEST_FONT_FILE)[0];
        HorizontalDeviceMetricsTable hdmxTable = (HorizontalDeviceMetricsTable)font.getTable(Tag.hdmx);
        try {
            x2 = hdmxTable.pixelSize(19);
            HdmxTests.fail("Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException x2) {
            // empty catch block
        }
        try {
            x2 = hdmxTable.pixelSize(-1);
            HdmxTests.fail("Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException x3) {
            // empty catch block
        }
        try {
            int x4 = hdmxTable.maxWidth(19);
            HdmxTests.fail("Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException x4) {
            // empty catch block
        }
        try {
            int x5 = hdmxTable.width(0, 898);
            HdmxTests.fail("Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException x5) {
            // empty catch block
        }
        try {
            int x6 = hdmxTable.width(1, -1);
            HdmxTests.fail("Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

