/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.tools.subsetter.CMapTableBuilder;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class CMapTableBuilderTest
extends TestCase {
    private static void verifyCmap(Map<Integer, Integer> mapping) {
        FontFactory fontFactory = FontFactory.getInstance();
        Font.Builder fontBuilder = fontFactory.newFontBuilder();
        new CMapTableBuilder(fontBuilder, mapping).build();
        Font font = fontBuilder.build();
        CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
        CMap cmap = cmapTable.cmap(3, 1);
        for (Map.Entry<Integer, Integer> entry : mapping.entrySet()) {
            int unicode = entry.getKey();
            int glyphId = entry.getValue();
            CMapTableBuilderTest.assertEquals(glyphId, cmap.glyphId(unicode));
        }
        CMapTableBuilderTest.assertEquals(0, cmap.glyphId(65535));
        CMapTableBuilderTest.assertEquals(0, cmap.glyphId(65534));
    }

    public void testCmapBuilding() {
        HashMap<Integer, Integer> mapping = new HashMap<Integer, Integer>();
        mapping.put(32, 0);
        mapping.put(33, 1);
        mapping.put(34, 2);
        mapping.put(42, 3);
        mapping.put(43, 2);
        mapping.put(4660, 4);
        CMapTableBuilderTest.verifyCmap(mapping);
    }
}

