/******************************************************************************
  Simulated_IIC_Master.c
IO˿ģIIC(I2C)ļ
    ߣ
    V1.0
    ڣ2016.12.21
******************************************************************************/

#include "Simulated_IIC_Master.h"

uint8_t IICReceivedACK;

/******************************************************************************
IIC_Init
  ܣʼIIC
  
ֵ
******************************************************************************/
void IIC_Init(void)
{
  IIC_SCL_DIR = 0;   //SCLΪ,IOΪ״̬,SCLź,ʱSCL = 1
  IIC_Delay();
  IIC_Delay();

  IIC_SDA_DIR = 0;   //SDAΪ,IOΪ״̬,SDAź,ʱSDA = 1
  IIC_Delay();
  IIC_Delay();

  IICReceivedACK = IIC_INVALID_ACK;
}

/******************************************************************************
IIC_Start
  ܣIICϷʼź,һIICͨ
  
ֵ
******************************************************************************/
void IIC_Start(void)
{
  IICReceivedACK = IIC_INVALID_ACK;

  IIC_SDA_DIR = 0;   //SDAΪ,IOΪ״̬,SDAź,ʱSDA = 1
  IIC_Delay();
  IIC_Delay();

  IIC_SCL_DIR = 0;   //SCLΪ,IOΪ״̬,SCLź,ʱSCL = 1
  IIC_Delay();
  IIC_Delay();

  IIC_SDA_DIR = 1;   //SDA0,ʱSDA = 0
  IIC_SDA = 0;
  IIC_Delay();
  IIC_Delay();

  IIC_SCL_DIR = 1;   //SCL0,ʱSCL = 0
  IIC_SCL = 0;
  IIC_Delay();
}

/******************************************************************************
IIC_Stop
  ܣIICϷֹͣź,ֹǰIICͨ
  
ֵ
******************************************************************************/
void IIC_Stop(void)
{
  IICReceivedACK = IIC_INVALID_ACK;

  IIC_SDA_DIR = 1;   //SDA0,ʱSDA = 0
  IIC_SDA = 0;
  IIC_Delay();
  IIC_Delay();

  IIC_SCL_DIR = 0;   //SCLΪ,IOΪ״̬,SCLź,ʱSCL = 1
  IIC_Delay();
  IIC_Delay();

  IIC_SDA_DIR = 0;   //SDAΪ,IOΪ״̬,SDAź,ʱSDA = 1
  IIC_Delay();
  IIC_Delay();
}

/******************************************************************************
IIC_Transmit_Data
  ܣIICϷ1ֽ
  Data͵
ֵȷ(ACK)  0 - ACK  1 - NAK
******************************************************************************/
void IIC_Transmit_Data(uint8_t Data)
{
  uint8_t i;

  IICReceivedACK = IIC_INVALID_ACK;

  for (i = 0; i < 8; i++)
  {
    if (Data & 0x80)
      IIC_SDA_DIR = 0;   //SDAΪ,IOΪ״̬,SDAź,ʱSDA = 1
    else
    {
      IIC_SDA_DIR = 1;   //SDA0,ʱSDA = 0
      IIC_SDA = 0;
    }
    IIC_Delay();
    IIC_Delay();

    IIC_SCL_DIR = 0;     //SCLΪ,IOΪ״̬,SCLź,ʱSCL = 1
    IIC_Delay();
    IIC_Delay();

    IIC_SCL_DIR = 1;     //SCL0,ʱSCL = 0
    IIC_SCL = 0;
    IIC_Delay();

    Data <<= 1;
  }

  IIC_SDA_DIR = 0;       //SDAΪ״̬
  IIC_Delay();
  IIC_Delay();

  IIC_SCL_DIR = 0;       //SCLΪ,IOΪ״̬,SCLź,ʱSCL = 1
  IIC_Delay();
  IIC_Delay();

  IICReceivedACK = IIC_SDA;

  IIC_SCL_DIR = 1;       //SCL0,ʱSCL = 0
  IIC_SCL = 0;
  IIC_Delay();
}

/******************************************************************************
IIC_Receive_Data
  ܣIICϽ1ֽ
  
ֵյ
******************************************************************************/
uint8_t IIC_Receive_Data(void)
{
  uint8_t i;
  uint8_t Data;

  Data = 0;

  IIC_SDA_DIR = 0;       //SDAΪ״̬
  IIC_Delay();
  IIC_Delay();

  for(i = 0; i < 8; i++)
  {
    Data <<= 1;

    IIC_SCL_DIR = 0;     //SCLΪ,IOΪ״̬,SCLź,ʱSCL = 1
    IIC_Delay();
    IIC_Delay();
    IIC_Delay();

    Data |= IIC_SDA;

    IIC_SCL_DIR = 1;     //SCL0,ʱSCL = 0
    IIC_SCL = 0;
    IIC_Delay();
    IIC_Delay();
  }

  return Data;
}

/******************************************************************************
IIC_Transmit_ACK
  ܣIICϷȷź
  ACKȷźŵͣ IIC_ACK  ϶Ӧ
                              IIC_NAK  Ӧ
ֵ
******************************************************************************/
void IIC_Transmit_ACK(uint8_t ACK)
{
  IICReceivedACK = IIC_INVALID_ACK;

  if (ACK > IIC_NAK)
    return;

  if(ACK)
    IIC_SDA_DIR = 0;     //SDAΪ,IOΪ״̬,SDAź,ʱSDA = 1
  else
  {
    IIC_SDA_DIR = 1;     //SDA0,ʱSDA = 0
    IIC_SDA = 0;
  }
  IIC_Delay();

  IIC_SCL_DIR = 0;       //SCLΪ,IOΪ״̬,SCLź,ʱSCL = 1
  IIC_Delay();
  IIC_Delay();

  IIC_SCL_DIR = 1;       //SCL0,ʱSCL = 0
  IIC_SCL = 0;
  IIC_Delay();
}

/******************************************************************************
IIC_Receive_ACK
  ܣȡϽյȷź
  
ֵȷźͣIIC_ACK         ϶Ӧ
                                  IIC_NAK         Ӧ
                                  IIC_INVALID_ACK ЧӦź(ӦźŻδյ)
******************************************************************************/
uint8_t IIC_Receive_ACK(void)
{
  uint8_t ACK;

  ACK = IICReceivedACK;
  IICReceivedACK = IIC_INVALID_ACK;

  return ACK;
}

/******************************************************************************
IIC_Delay
  ܣʱ5us,շеʱ
        ע⣺IIC_5us_DELAY_CALIBRATIONУ׼ʱʱ5us
  ACKȷźŵ  0 - ACK  1 - NAK
ֵ
******************************************************************************/
void IIC_Delay(void)
{
  uint8_t i;

  for(i = 0; i < IIC_FREQ_CALIBRATION; i++)
    nop();
}