
#ifndef _POPUP_SCHEDULER_H_
#define _POPUP_SCHEDULER_H_

#include "Popup_List.h"
#include "IO_Manager.h"

#define   POPUP_DISP_TIME_NORMAL            10
#define   POPUP_DISP_TIME_MIN               4

/******************************************************************************
״̬
******************************************************************************/
#define   POPUP_STATUS_OFF                  0x00
#define   POPUP_STATUS_NEW                  0x01
#define   POPUP_STATUS_FIRST                0x02
#define   POPUP_STATUS_LOOP                 0x03
#define   POPUP_STATUS_MASKED               0x04
#define   POPUP_STATUS_DELETE               0x05
#define   POPUP_STATUS_CLEAR                0x06

/******************************************************************************
ѯģʽ
******************************************************************************/
#define   POPUP_POLLING_FORWARD             0x00
#define   POPUP_POLLING_REVERSE             0x01

/******************************************************************************
ȼ
******************************************************************************/
#if       (POPUP_PRIORITY_NUMBER_FATAL >= POPUP_PRIORITY_NUMBER_HINT)
#if     (POPUP_PRIORITY_NUMBER_FATAL >= POPUP_PRIORITY_NUMBER_WARNING)
#define   POPUP_PRIORITY_NUMBER_MAX     POPUP_PRIORITY_NUMBER_FATAL
#else
#define   POPUP_PRIORITY_NUMBER_MAX     POPUP_PRIORITY_NUMBER_WARNING
#endif
#else
#if     (POPUP_PRIORITY_NUMBER_HINT >= POPUP_PRIORITY_NUMBER_WARNING)
#define   POPUP_PRIORITY_NUMBER_MAX     POPUP_PRIORITY_NUMBER_HINT
#else
#define   POPUP_PRIORITY_NUMBER_MAX     POPUP_PRIORITY_NUMBER_WARNING
#endif
#endif

/******************************************************************************

******************************************************************************/
#define   POPUP_LINK_LIST_NEW_FATAL         0
#define   POPUP_LINK_LIST_FATAL             1

#define   POPUP_LINK_LIST_NEW_HINT          2
#define   POPUP_LINK_LIST_HINT              3

#define   POPUP_LINK_LIST_NEW_WARNING       4
#define   POPUP_LINK_LIST_WARNING           5
#define   POPUP_LINK_LIST_MASKED_WARNING    6

#define   POPUP_LINK_LIST_NONE              255

/******************************************************************************
Ϣ״̬ṹ
******************************************************************************/
typedef struct
{
  uint8_t   Status;     //Ϣ״̬
  uint8_t   LinkList;   //Ϣ
  uint8_t   Prev;       //ǰһʹܵı
  uint8_t   Next;       //һʹܵı
  uint8_t   SndReqCode; //
} PopupStatusStruct;

/******************************************************************************
Ϣȼṹ
******************************************************************************/
typedef struct
{
  uint8_t   First;      //ǰȼµĵһϢ
  uint8_t   Last;       //ǰȼµһϢ
} PopupPrioCtrlStruct;

/******************************************************************************
Ϣȼṹ
******************************************************************************/
typedef struct
{
  uint8_t               Cnt;
  uint8_t               Cur;
  uint8_t               PrioNum;
  PopupPrioCtrlStruct   Prio[POPUP_PRIORITY_NUMBER_MAX];
} PopupLinkListCtrlStruct;

/******************************************************************************
ϢȽṹ
******************************************************************************/
typedef struct
{
  uint8_t   Timer;
  uint8_t   Current;
  uint8_t   Message;
  uint8_t   NewSnd;
  uint8_t   WarningExist;
  uint8_t   MaskReq;
  uint8_t   LastMasked;
  uint8_t   MaskedPolling;
} PopupSchedulingStruct;

/******************************************************************************

******************************************************************************/
void Popup_Scheduler_Init(void);
void Popup_Scheduling_Service(void);        //100ms
void Popup_Request(uint8_t PopupID);
void Popup_Delete(uint8_t PopupID);
void Popup_Clear(uint8_t PopupID);
void Popup_Mask_Request(void);
void Popup_Hint_Mask_Request(uint8_t PopupID);
uint8_t Popup_Get_Status(uint8_t PopupID);
uint8_t Popup_Get_Current_Type(void);
uint8_t Popup_Get_Current_Message(void);
uint8_t Popup_Get_Current_Sound(void);
uint8_t Popup_Get_Current_Sound_Req_Code(void);
uint8_t Popup_Get_Warning_Status(void);
uint8_t Popup_Get_First_Masked_Warning(void);
uint8_t Popup_Get_Last_Masked_Warning(void);
uint8_t Popup_Get_Masked_Warning_Msg(void);
void Popup_Masked_Warning_Polling_Reset(uint8_t Mode);
void Popup_Masked_Warning_Polling(uint8_t Mode);
void Popup_Link_List_Init(uint8_t LinkListID, uint8_t PrioNum);
void Popup_Link_List_Insert(uint8_t LinkListID, uint8_t PopupID);
void Popup_Link_List_Remove(uint8_t PopupID);

#endif
