/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetMBCS;
import com.ibm.icu.charset.UConverterStaticData;
import com.ibm.icu.impl.ICUBinary;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class UConverterDataReader
implements ICUBinary.Authenticate {
    int bytesRead = 0;
    int staticDataBytesRead = 0;
    DataInputStream dataInputStream;
    private static final byte[] DATA_FORMAT_ID = new byte[]{99, 110, 118, 116};
    private static final byte[] DATA_FORMAT_VERSION = new byte[]{6};

    protected UConverterDataReader(InputStream inputStream) throws IOException {
        ICUBinary.readHeader(inputStream, DATA_FORMAT_ID, this);
        this.dataInputStream = new DataInputStream(inputStream);
    }

    protected void readStaticData(UConverterStaticData sd) throws IOException {
        int bRead = 0;
        sd.structSize = this.dataInputStream.readInt();
        bRead += 4;
        byte[] name = new byte[60];
        this.dataInputStream.readFully(name);
        bRead += name.length;
        sd.name = new String(name, 0, name.length);
        sd.codepage = this.dataInputStream.readInt();
        bRead += 4;
        sd.platform = this.dataInputStream.readByte();
        ++bRead;
        sd.conversionType = this.dataInputStream.readByte();
        ++bRead;
        sd.minBytesPerChar = this.dataInputStream.readByte();
        ++bRead;
        sd.maxBytesPerChar = this.dataInputStream.readByte();
        ++bRead;
        this.dataInputStream.readFully(sd.subChar);
        bRead += sd.subChar.length;
        sd.subCharLen = this.dataInputStream.readByte();
        ++bRead;
        sd.hasToUnicodeFallback = this.dataInputStream.readByte();
        ++bRead;
        sd.hasFromUnicodeFallback = this.dataInputStream.readByte();
        ++bRead;
        sd.unicodeMask = (short)this.dataInputStream.readUnsignedByte();
        ++bRead;
        sd.subChar1 = this.dataInputStream.readByte();
        ++bRead;
        this.dataInputStream.readFully(sd.reserved);
        this.staticDataBytesRead = bRead += sd.reserved.length;
        this.bytesRead += bRead;
    }

    protected void readMBCSHeader(CharsetMBCS.MBCSHeader h) throws IOException {
        this.dataInputStream.readFully(h.version);
        this.bytesRead += h.version.length;
        h.countStates = this.dataInputStream.readInt();
        this.bytesRead += 4;
        h.countToUFallbacks = this.dataInputStream.readInt();
        this.bytesRead += 4;
        h.offsetToUCodeUnits = this.dataInputStream.readInt();
        this.bytesRead += 4;
        h.offsetFromUTable = this.dataInputStream.readInt();
        this.bytesRead += 4;
        h.offsetFromUBytes = this.dataInputStream.readInt();
        this.bytesRead += 4;
        h.flags = this.dataInputStream.readInt();
        this.bytesRead += 4;
        h.fromUBytesLength = this.dataInputStream.readInt();
        this.bytesRead += 4;
        if (h.version[0] == 5 && h.version[1] >= 3) {
            h.options = this.dataInputStream.readInt();
            this.bytesRead += 4;
            if ((h.options & 0x40) != 0) {
                h.fullStage2Length = this.dataInputStream.readInt();
                this.bytesRead += 4;
            }
        }
    }

    protected void readMBCSTable(int[][] stateTableArray, CharsetMBCS.MBCSToUFallback[] toUFallbacksArray, char[] unicodeCodeUnitsArray, char[] fromUnicodeTableArray, byte[] fromUnicodeBytesArray) throws IOException {
        int i;
        for (i = 0; i < stateTableArray.length; ++i) {
            for (int j = 0; j < stateTableArray[i].length; ++j) {
                stateTableArray[i][j] = this.dataInputStream.readInt();
                this.bytesRead += 4;
            }
        }
        for (i = 0; i < toUFallbacksArray.length; ++i) {
            toUFallbacksArray[i].offset = this.dataInputStream.readInt();
            this.bytesRead += 4;
            toUFallbacksArray[i].codePoint = this.dataInputStream.readInt();
            this.bytesRead += 4;
        }
        for (i = 0; i < unicodeCodeUnitsArray.length; ++i) {
            unicodeCodeUnitsArray[i] = this.dataInputStream.readChar();
            this.bytesRead += 2;
        }
        for (i = 0; i < fromUnicodeTableArray.length; ++i) {
            fromUnicodeTableArray[i] = this.dataInputStream.readChar();
            this.bytesRead += 2;
        }
        for (i = 0; i < fromUnicodeBytesArray.length; ++i) {
            fromUnicodeBytesArray[i] = this.dataInputStream.readByte();
            ++this.bytesRead;
        }
    }

    protected String readBaseTableName() throws IOException {
        char c;
        StringBuilder name = new StringBuilder();
        while ((c = (char)this.dataInputStream.readByte()) != '\u0000') {
            name.append(c);
            ++this.bytesRead;
        }
        ++this.bytesRead;
        return name.toString();
    }

    protected ByteBuffer readExtIndexes(int skip) throws IOException {
        int skipped = this.dataInputStream.skipBytes(skip);
        if (skipped != skip) {
            throw new IOException("could not skip " + skip + " bytes");
        }
        int n = this.dataInputStream.readInt();
        this.bytesRead += 4;
        int[] indexes = new int[n];
        indexes[0] = n;
        for (int i = 1; i < n; ++i) {
            indexes[i] = this.dataInputStream.readInt();
            this.bytesRead += 4;
        }
        ByteBuffer b = ByteBuffer.allocate(indexes[31]);
        for (int i = 0; i < n; ++i) {
            b.putInt(indexes[i]);
        }
        int len = this.dataInputStream.read(b.array(), b.position(), b.remaining());
        if (len == -1) {
            throw new IOException("Read failed");
        }
        this.bytesRead += len;
        return b;
    }

    byte[] getDataFormatVersion() {
        return DATA_FORMAT_VERSION;
    }

    public boolean isDataVersionAcceptable(byte[] version) {
        return version[0] == DATA_FORMAT_VERSION[0];
    }
}

