
#ifndef _IO_MANAGER_H_
#define _IO_MANAGER_H_

#include "Data_Processor.h"
#include "System_Status_Monitor.h"
#include "Key.h"
#include "Communication_Over_CAN.h"
#include "CRG.h"

/*************************************************************************
ʾб
*************************************************************************/
#define   IO_DISP_FUNC_NONE                 0x00
#define   IO_DISP_FUNC_DRIVE_INFO           0x01
#define   IO_DISP_FUNC_MENUS                0x02
#define   IO_DISP_FUNC_TIME_SETTING         0x04
#define   IO_DISP_FUNC_POPUPS               0x08
//#define   IO_DISP_FUNC_RADAR                0x10

/*************************************************************************
ʾʹ
*************************************************************************/
//extern volatile uint8_t IODispFuncEnable;
extern volatile uint8_t IODispFuncSwitch;
//#define   IO_DISP_FUNC_DRIVE_INFO_EN        (IODispFuncEnable == IO_DISP_FUNC_DRIVE_INFO)
//#define   IO_DISP_FUNC_MENUS_EN             (IODispFuncEnable == IO_DISP_FUNC_MENUS)
//#define   IO_DISP_FUNC_TIME_SETTING_EN      (IODispFuncEnable == IO_DISP_FUNC_TIME_SETTING)
//#define   IO_DISP_FUNC_POPUPS_EN            (IODispFuncEnable == IO_DISP_FUNC_POPUPS)
//#define   IO_DISP_FUNC_RADAR_EN             (IODispFuncEnable == IO_DISP_FUNC_RADAR)

#define     IO_DISP_FUNC_SWITCH_FLAG          IODispFuncSwitch

/*************************************************************************
Ϣ
*************************************************************************/
extern volatile uint8_t IOPopupMenuTipRunning;
extern volatile uint8_t IOPopupMenuTipWarning;

#define   IO_POPUP_REQ_MENU_TIP_RUNNING     IOPopupMenuTipRunning
#define   IO_POPUP_REQ_MENU_TIP_WARNING     IOPopupMenuTipWarning

/*************************************************************************
ضṹ
*************************************************************************/
typedef union
{
  uint8_t     Byte;
  struct
  {
    uint8_t   Key0  : 2;
    uint8_t   Key1  : 2;
    uint8_t   Key2  : 2;
    uint8_t   Key3  : 2;
  } Sig;
} IOKeysRedirUnion;

/*************************************************************************
״̬
*************************************************************************/
#define   IO_KEY_IDLE                       0x00
#define   IO_KEY_PRESS                      0x01
#define   IO_KEY_HOLD                       0x02
#define   IO_KEY_LONG                       0x03

/************************************************************************
ض
************************************************************************/
extern volatile IOKeysRedirUnion IOICUKeys;
extern volatile IOKeysRedirUnion IOCANKeys;

#define   IO_ICU_KEYS                       IOICUKeys.Byte
#define   IO_CAN_KEYS                       IOCANKeys.Byte

#define   IO_ICU_KEY_LEFT                   IOICUKeys.Sig.Key0
#define   IO_ICU_KEY_RIGHT                  IOICUKeys.Sig.Key1
//#define   IO_ICU_KEY_TRIP                   IOICUKeys.Sig.Key2

#define   IO_CAN_KEY_LEFT                   IOCANKeys.Sig.Key0
#define   IO_CAN_KEY_RIGHT                  IOCANKeys.Sig.Key1
#define   IO_CAN_KEY_ENTER                   IOCANKeys.Sig.Key2

extern volatile uint8_t IODispMode;
extern volatile uint8_t IOTFTLCDAccessRight;
#define   IO_DISPLAY_MODE    IODispMode

/******************************************************************************
TFT LCD ʾʹ
******************************************************************************/
#define   IO_ANIMATION_DISPLAY_ENABLE       (IOTFTLCDAccessRight & IO_ANIMATION_BIT)      //            1
#define   IO_BG_INFO_DISPLAY_ENABLE         (IOTFTLCDAccessRight & IO_BG_INFO_BIT)        //            2
#define   IO_TELLTALE_DISPLAY_ENABLE        (IOTFTLCDAccessRight & IO_TELLTALE_BIT)       //Ļָʾ      4
#define   IO_DRIVE_INFO_DISPLAY_ENABLE      (IOTFTLCDAccessRight & IO_DRIVE_INFO_BIT)     //г        8
#define   IO_POPUP_DISPLAY_ENABLE           (IOTFTLCDAccessRight & IO_POPUP_BIT)          //            10
#define   IO_TIME_DISPLAY_ENABLE            (IOTFTLCDAccessRight & IO_TIME_BIT)           //ʱʾ        20
#define   IO_TRAP_DISPLAY_ENABLE            (IOTFTLCDAccessRight & IO_TRAP_BIT)           //СGʾģʽ     40
#define   IO_TPMS_DISPLAY_ENABLE            (IOTFTLCDAccessRight & IO_TPMS_BIT)
/******************************************************************************
ʾģʽб
******************************************************************************/
#define   SYS_IGN_OFF_DISP_MODE             (IODispMode == IO_DISP_MODE_IGN_OFF)
#define   SYS_SELF_TEST_DISP_MODE           (IODispMode == IO_DISP_MODE_SELF_TEST)
#define   SYS_IGN_ON_DISP_MODE              (IODispMode == IO_DISP_MODE_IGN_ON)

/******************************************************************************
ʾ״̬
******************************************************************************/
#define   IO_DISP_MODE_IGN_OFF              0x00
#define   IO_DISP_MODE_SELF_TEST            0x01
#define   IO_DISP_MODE_IGN_ON               0x02
#define   IO_DISP_MODE_BLANK                0x03

/******************************************************************************
TFT LCDʿλ
******************************************************************************/
#define   IO_ANIMATION_BIT                  0x01       //            1
#define   IO_BG_INFO_BIT                    0x02       //            2
#define   IO_TELLTALE_BIT                   0x04       //Ļָʾ      4
#define   IO_DRIVE_INFO_BIT                 0x08       //г        8
#define   IO_POPUP_BIT                      0x10       //            10
#define   IO_TIME_BIT                       0x20       //ʱʾ        20
#define   IO_TRAP_BIT                       0x40       //СGʾģʽ     40
#define   IO_TPMS_BIT                       0x80
/******************************************************************************
Լ
******************************************************************************/
#define   IO_SELF_TEST_TIME                 3000      //Լʱ,λms
//#define   IO_SELF_TEST_TIME                 1500      //Լʱ,λms
#define   IO_DRIVE_INFO_AUTO_SWITCH_TIME    300       //Լɺ,ԶлгԵʱ,λms  300

typedef struct
{
  uint8_t   IGNStatusBackup;
  uint8_t   SelfTestComplete;
  uint16_t  SelfTestTimer;
} IODispModeCtrlStruct;

typedef struct
{
  uint8_t           TripEnable;
  IOKeysRedirUnion  ICUKeysBackup;
  IOKeysRedirUnion  CANKeysBackup;
} IOManageStruct;

/************************************************************************

************************************************************************/
void IO_Management_Init(void);
void IO_Management_Service(void);
void IO_Popups_Display_Request(void);
void IO_Popups_Display_Release(void);
void IO_Menus_Display_Release(void);
 void IO_Trip_Key_Mask(uint8_t Mask);
#endif
