/******************************************************************************
  UDS_ISO14229_Services.h
ISO 14229 淶涨Ϸ˷ʵֺͷļ
    ߣ
    V1.0
    ڣ2016.11.1
******************************************************************************/

/******************************************************************************
                         ϷOSIģӳ
===============================================================================
  *     NO.     OSI Layer        Diagnostics services
-------------------------------------------------------------------------------
  *      7      Application      ISO 14229-1 ISO 14229-3
         6      Presentation     -
  *      5      Session          ISO 14229-2
         4      Transport        ISO 15765-2
         3      Network          ISO 15765-2
         2      Data Link        ISO 11898
         1      Physical         ISO 11898
===============================================================================
******************************************************************************/

#ifndef _UDS_ISO14229_SERVICES_H_
#define _UDS_ISO14229_SERVICES_H_

#include "UDS_ISO14229_Server_Config.h"

/*-----------------------------------------------------------------------------

-----------------------------------------------------------------------------*/
#define POSITIVE_RSP                    0x00
#define NEGATIVE_RSP                    (!POSITIVE_RSP)
/******************************************************************************
Function and subFunction
Diagnostic Session
*******************************************************************************/
#define DiagnosticSessionContro         0x10
#define DefaultSession                  0x01
#define ProgrammingSession              0x02
#define ExtendedDiagnosticSession       0x03

/******************************************************************************
Function and subFunction
ECUReset
********************************************************************************/
#define ECUReset                        0x11
#define hardReset                       0x01
#define softReset                       0x03
/******************************************************************************
Function and subFunction
ClearDiagnosticInformation
********************************************************************************/
#define ClearDiagnosticInformation      0x14
/******************************************************************************
Function and subFunction
ReadDTCInformation
********************************************************************************/

#define   ReadDTCInformation              0x19
#define   cnDTCslen		8	//ע:Ҫ16

#define        U007388 0xC07388  //BUS OFF    
#define        U300316 0xF00316  //ѹ Internal local voltage < 16V  
#define        U300317 0xF00317  //ѹ Internal local voltage > 32V   
#define        U014087 0xC14087  //BCMͨѶʧ 0x18FE40210x18FFDB21ĶʧT=100ms ʧ5֡ϡ  
#define        U010087 0xC10087  //EMSͨѶʧ 0x0CF00400ĶʧT=10msʧ5֡   
#define        U012987 0xC12987  //EBS/ESCͨѶʧ 0x18FFE033ĶʧT=500msʧ5֡   
#define        U012887 0xC12887  //EPB ڵ㶪ʧ 0x18FDA5ECĶʧT=100msʧ5֡
#define        U010187 0xC10187  //TCUʧͨ  0x1801D003ĶʧT=100msʧ5֡ 
//#define        U015587 0xC15587  //IC ڵ㶪ʧ 0X0CFE6C17ĶʧT=50msʧ5֡    
//#define        U019887 0xC19887  //TBox ڵ㶪ʧ 0x18FEE69FĶʧT=1000msʧ5֡  


#define    cnU007388	0   //BUS OFF    
#define    cnU300316	1   //ѹ Internal local voltage < 16V  
#define    cnU300317	2   //ѹ Internal local voltage > 32V   
#define    cnU014087	3   //BCMͨѶʧ 0x18FE40210x18FFDB21ĶʧT=100ms ʧ5֡ϡ  
#define    cnU010087	4   //MMIͨѶʧ 0x18FEE641ĶʧT=1000msʧ5֡   
#define    cnU012987	5   //TPMSͨѶʧ 0x18FFE033ĶʧT=500msʧ5֡   
#define    cnU012887	6   //DCM ڵ㶪ʧ 0x18FDA5ECĶʧT=100msʧ5֡
#define    cnU010187	7   //TCUʧͨ  0x1801D003ĶʧT=100msʧ5֡      
//#define    cnU015587	8   //IC ڵ㶪ʧ 0X0CFE6C17ĶʧT=50msʧ5֡    
//#define    cnU019887	9   //TBox ڵ㶪ʧ 0x18FEE69FĶʧT=1000msʧ5֡

typedef struct
{
    uint16_t Timer;
    uint8_t  Flag;
    uint8_t  Status;
    uint8_t  LastStatus;
} RecDTC_WaitBusoff_STRUCT;

#define		 _CLRBIT(p,b)		p&=~(1<<b)	//0 pӦĵb BITλ (pֻΪ8BIT)  
#define		_SETBIT(p,b)		p|=(1<<b)	//1 pӦĵb BITλ (pֻΪ8BIT)      
#define		_bit_is_set(p,b)		p&(1<<b)

#define		CLRBIT(p,b)			p&=~(1<<b)	//0 pӦĵb BITλ (pֻΪ8BIT)  
#define		SETBIT(p,b)			p|=(1<<b)	//1 pӦĵb BITλ (pֻΪ8BIT)      
#define		bit_is_set(p,b)		p&(1<<b)

#define		bit_is_clear(p,b)		!(p&(1<<b))

//--------------20160425--------add start 001

#define         bit_2_set(p,b)       ((p>>b)&0x03)
#define         bit_3_set(p,b)       ((p>>b)&0x07)
#define         bit_4_set(p,b)       ((p>>b)&0x0F)
#define         bit_5_set(p,b)       ((p>>b)&0x1F)
#define         bit_6_set(p,b)       ((p>>b)&0x3F)
#define         bit_7_set(p,b)       ((p>>b)&0x7F)

/******************************************************************************
Function and subFunction
ReadDataByIdentifier
********************************************************************************/
#define ReadDataByIdentifier            0x22
/******************************************************************************
Function and subFunction
SecurityAccess
********************************************************************************/
#define SecurityAccess                  0x27
#define requestSeed_LV1                 0x01
#define sendKey_LV1                     0x02
#define requestSeed_LV3                 0x03
#define sendKey_LV3                     0x04
#define requestSeed_LV5                 0x05
#define sendKey_LV5                     0x06
#define requestSeed_LV11                0x11
#define sendKey_LV12                    0x12

//#define Level4UnLock                    0x05
#define Level2UnLock                    0x04
#define Level1UnLock                    0x03
#define NormalKeyUnlock                 0x02
#define NormalKeyLock                   0x00
#define BootKeyUnlock                   0x01
#define BootKeyLock                     0x00



#define FLASH_SECTOR_SIZE  0x400
/******************************************************************************
Function and subFunction and type
CommunicationControl
********************************************************************************/
#define CommunicationControl            0x28
#define enableRxAndTx                   0x00
#define enableRxAndDisableTx            0x01
#define disableRxAndEnableTx            0x02
#define disableRxAndTx                  0x03
#define normalCommunicationMessages     0x01     //
#define networkManagementCommunicationMessages  0x02    //
#define networkManagementCommunicationMessagesnormalCommunicationMessages   0x03  //+

/******************************************************************************
Function and subFunction
WriteDataByIdentifier
********************************************************************************/
#define WriteDataByIdentifier           0x2E

/******************************************************************************
Function and subFunction
InputOutputControlByIdentifier
********************************************************************************/
#define InputOutputControlByIdentifier  0x2F
#define WhiteColor                      0x01
#define BlackColor                      0x02
#define RedColor                        0x03
#define GreenColor                      0x04
#define BlueColor                       0x05
#define GaugeSpeed                      0x01
#define GaugeTacho                      0x02
#define GaugeFuel                       0x03
#define GaugeEngCoolantTemp             0x04
#define ZeroPosition                    0x00
#define HalfPosition                    0x01
#define FullPosition                    0x02


#define Contrl                          0x01
#define Resume                          0x00

/******************************************************************************
Function and subFunction
RoutineControl
********************************************************************************/
#define RoutineControl                  0x31
#define startRoutine                    0x01
#define stopRoutine                     0x02
#define requestRoutineResults           0x03

#define MaintenanceReset                0x62F1
#define CheckMemory                     0x0202
#define CheckProgrammingPreconditions   0x0203
#define ECU_selftest                    0xDF01
#define EraseMemory                     0xFF00
#define CheckProgrammingDependencies    0xFF01

#define RoutineCompletedSuccessfully    0x01
#define RoutineCompletedUnsuccessfully  0x00
/******************************************************************************
Function and subFunction
RequestDownload
********************************************************************************/
#define RequestDownload                 0X34
#define LengthFormatIdentifier          0x20
#define Download                        0x01

/******************************************************************************
Function and subFunction
TransferDataf
********************************************************************************/
#define TransferData                    0x36

/******************************************************************************
Function and subFunction
RequestTransferExit
********************************************************************************/
#define RequestTransferExit             0x37
/******************************************************************************
Function and subFunction
TesterPresent
********************************************************************************/
#define   TesterPresent                 0x3E
/******************************************************************************
Function and subFunction
ControlDTCSetting
********************************************************************************/
#define  ControlDTCSetting              0x85
#define  DTCSettingOn                   0x01
#define  DTCSettingOff                  0x02

/******************************************************************************
Supported negative response codes
*******************************************************************************/
#define	serviceNotSupported                             	0x11
#define	subFunctionNotSupported                         	0x12
#define	incorrectMessageLength                          	0x13
#define	responseTooLong                                 	0x14
#define	conditionsNotCorrect                            	0x22
#define	requestSequenceError                            	0x24
#define	requestOutOfRange                               	0x31
#define	securityAccessDenied                            	0x33
#define	invalidKey                                      	0x35
#define	exceedNumberOfAttempts                          	0x36
#define	requiredTimeDelayNotExpired                     	0x37
#define	uploadDownloadNotAccepted                       	0x70
#define	transferDataSuspended                           	0x71
#define	generalProgrammingFailure                       	0x72
#define	wrongBlockSequenceCounter                       	0x73
#define	requestCorrectlyReceivedResponsePending         	0x78
#define	subfunctionNotSupportinActiveSession            	0x7E
#define	serviceNotSupportedInActiveSession              	0x7F
#define	engineIsRunning                                 	0x83
#define	engineIsNotRunning                              	0x84
#define	engineRunTimeTooLow                             	0x85
#define	voltageTooHigh                                  	0x92
#define	voltageTooLow                                   	0x93




#define  noErr   0
#define  SRecRangeError   1
#define  SRecOddError  2       //S-Record Size Must Be Even
#define  FlashProgramError  3  //Flash Programming Error
#define  FlashEraseError  4    //Flash Erase Error
#define  BadHexData 5         //Bad Hex Data
#define  SRecTooLong  6        //S-Record Too Long
#define  CheckSumErr  7        //Checksum Error
#define  UnknownPartID  8       //Unknown Part ID



/******************************************************************************
Bootloader Variable
*******************************************************************************/
typedef struct
{
    uint32_t  GlobalAddress;   //ȫֵַʼַ
    uint32_t  Datalength;      //MemorySize  ¼ݳ(ֽ)
    uint8_t   data[224 + 10];     //Data
} SRecord_t;


typedef struct
{
    // uint8_t F112[8];
    uint8_t F190[17];
    uint8_t F197[10];
    uint8_t F10A[9];
    uint8_t F191[8];
    uint8_t F183[10];
    uint8_t F184[7];
    //uint8_t F199[4];
    //uint8_t F19D[4];
    uint8_t attemptcnt;
    uint8_t Sessiontype;
    uint8_t noused;

} DiagReceiveData;


typedef struct
{

    uint8_t attemptcnt;       //level 1 Դ
    uint8_t RequestSeedCnt;   //level 1 Ӵ
    uint8_t attemptcnt11;     //level 11Դ
    uint8_t RequestSeedCnt11; //level 11Ӵ


} Diag27Data;

typedef struct
{
    uint8_t F110[8];
    uint8_t F101[6];
} DiagReceiveData2;

typedef struct
{
    uint8_t DFEC[64];
    uint8_t DFED[64];
    uint8_t DFEE[64];
    uint8_t DFEF[64];

} DiagReceiveData1;


#define S9S12XHY256 1
#define Bootloader   1
#define OK          			    0x00
#define ERASED      			    0x01
#define NON_ERASED  			    0x02
#define MISALIGNED_ADDRESS  	0x03
#define ACCESS_ERROR        	0x04
#define VERIFICATION_FAILED 	0x05
#define LENGTH_OUT_OF_RANGE 	0x06

#define DFLASH_FirstAddress 	  0x100000                    //0x004400 (HY64)
#define DFLASH_APPvAddress 	    0x100000+256                //=0xA77AʾӦóЧ    
#define DFLASH_DiagAddress 	    0x100000+512                //256ֽ洢Э     2E д  
#define DFLASH_BackupAddress    0x100000+768                //256ֽ洢Э  2E д
#define DFLASH_MOTORAddress     0x100000+1024               //256ֽ洢
#define DFLASH_USERAddress      0X100000+1280               //256ֽF110 F101
#define DFLASH_TripAddress      0X100000+1536               //ֵ,,ֵ
#define DFLASH_LockAddress      0X100000+1792               //27Ϣ

#define EnableInterrupts   {__asm CLI;}
#define DisableInterrupts  {__asm SEI;}
/*-----------------------------------------------------------------------------
Ӧò㷴ö
-----------------------------------------------------------------------------*/
typedef enum
{
    A_OK = 0,
    A_ERR,
} A_Result_Enum;

typedef struct
{
    uint8_t Para;
    uint8_t P2;
    uint8_t P2Ast;
} DiagSendDataRes;

typedef struct
{
    uint8_t Para;
    uint8_t code;
    uint8_t OpCode;
} DiagSendDataNeg;
typedef struct
{
    uint8_t DiagDataLength;
    uint8_t msg[64];
} ConvertData;

typedef union 
{ 
    uint8_t Msg[4]; 
    uint32_t Value;
} DIGKeyValue; 

extern DIGKeyValue      DigKeyValue; 

extern INT8U  ContrlorResumeofSOC;
extern INT8U ContrlorResumeofTEMP;
extern INT8U ContrlorResumeofVspeed;
extern INT8U ContrlorResumeofEspeed;
extern uint8_t DTC_STATUS[cnDTCslen];
extern uint16_t ESpeedValNUM;         //ת
extern uint16_t VspeedValNUM;         //
extern uint16_t ESpeedVal;            //ת
extern uint16_t VspeedVal;            //
extern uint8_t  TempSeg;              //ˮ
extern uint8_t  SocSeg;               //ȼ
extern uint8_t  S3_ServerEN;          //չỰ5sʱʹܿ
extern uint8_t DiagnosticReceived;    //ϲֹȫֱ?
extern uint8_t  ContrlorResumeofLamp;    //бƲ
extern uint8_t LampWarningStatus;        //ƹ״̬

/******************************************************************************

******************************************************************************/

/*** 10# - Diagnostic Session Control ***/
void UDS_Service_19_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_10_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_27_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_28_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_85_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_31_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_34_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_36_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_37_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_11_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_3E_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_2E_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_2F_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_22_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void UDS_Service_14_Indication ( uint32_t A_TA_type, uint16_t A_Length, uint8_t *A_Data );
void S3_ServerCNT ( void );
/*** 11# - Ecu Reset ***/
void Randomcnt ( void );
void CanLoseDetected ( void );
void INIT_DTC_STATUS_IGN_ON ( void );
void Record_DTCStatus_Wait_No_Busoff_xxms ( void );
void ChangeDTCs_ST_PRG ( INT8U xh, INT8U status );
void SaveDTCsToEEPROM ( void );
void CAN_NORMAL_TIME_PRG ( void );
void HandleOf2FServices ( void );

void Write_2E_DATA_TO_FLASH(void);
void Read_2E_DATA_FROM_FLASH(void);
void Write_27_DATA_TO_FLASH(void);
void Read_27_DATA_FROM_FLASH(void);

extern INT16U MYeturnCode;
extern uint32_t DFLASHeep_adr;
INT8U  DFLASH_Erase_Sector ( INT32U  address ) ;
INT8U  DFLASH_Program ( INT32U  address, INT16U *ptr, INT8U number_of_words );

INT8U  DFLASH_Erase_Sector ( INT32U  address );
uint32_t DFLASH_Read_Word ( INT32U  address );
void ReadNbyteFrDFalsh ( INT16U *mP, INT16U mLEN );
void Read_BACKUP_DATA_FROM_FLASH ( void );
void WriteNbyteToDFalsh ( INT16U *mP, INT16U mLEN );
INT8U  DFLASH_N_Program ( INT32U  address, INT16U *ptr, INT8U number_of_words );
#endif