/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.sample.sfview;

import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.sample.sfview.TaggedData;
import com.google.typography.font.sfntly.table.core.PostScriptTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class ViewableTaggedData {
    private List<Marker> markers = new ArrayList<Marker>();
    private final Style style;
    private final Metrics metrics;

    ViewableTaggedData(List<Marker> markers) {
        this(markers, new Style(), new Metrics());
    }

    private ViewableTaggedData(List<Marker> markers, Style style, Metrics metrics) {
        this.markers = markers;
        this.style = style;
        this.metrics = metrics;
    }

    int lineHeight() {
        return this.metrics.lineHeight;
    }

    int totalWidth() {
        return this.metrics.totalWidth;
    }

    void draw(Graphics g, int x, int y) {
        DrawContext context = new DrawContext(this.style, this.metrics, g, x, y);
        for (Marker m : this.markers) {
            m.draw(context);
        }
    }

    Dimension measure(boolean zeroMetrics) {
        if (zeroMetrics) {
            this.metrics.zero();
        }
        DrawContext context = new DrawContext(this.style, this.metrics, null, 0, 0);
        context.measureLineHeight();
        for (Marker m : this.markers) {
            m.draw(context);
        }
        return context.dimension();
    }

    private static class DrawContext {
        private final Style style;
        private final Metrics metrics;
        private final Graphics g;
        private FontRenderContext frc;
        private final int x;
        private int y;
        private int lc;
        private int rangeDepth;
        private int lastMarkedPosition;
        private int lastRenderedPosition;
        private int expectedPosition = -1;
        private static final Color[] REF_COLORS = new Color[]{Color.BLUE, Color.RED, Color.BLACK, Color.GREEN, Color.LIGHT_GRAY, Color.PINK, Color.CYAN, Color.DARK_GRAY, Color.MAGENTA, Color.ORANGE};
        private RefWidthFinder refWidthFinder = new RefWidthFinder();

        private DrawContext(Style style, Metrics metrics, Graphics g, int x, int y) {
            this.style = style;
            this.metrics = metrics;
            this.g = g;
            this.x = x;
            this.y = y;
            this.frc = g != null ? ((Graphics2D)g).getFontRenderContext() : new FontRenderContext(null, true, false);
            this.lc = 0;
        }

        private void measureLineHeight() {
            LineMetrics dataMetrics = this.style.dataFont.getLineMetrics("0123456789abcdef", this.frc);
            LineMetrics labelMetrics = this.style.labelFont.getLineMetrics("ABC", this.frc);
            int lineHeight = (int)Math.ceil(Math.max(dataMetrics.getHeight(), labelMetrics.getHeight()));
            int baseline = (int)Math.ceil(Math.max(dataMetrics.getDescent() + dataMetrics.getLeading(), labelMetrics.getDescent() + labelMetrics.getLeading()));
            int xHeight = (int)Math.ceil((double)Math.max(dataMetrics.getAscent() - dataMetrics.getLeading(), labelMetrics.getAscent() - labelMetrics.getLeading()) / 2.0 - (double)baseline);
            this.metrics.lineHeight = lineHeight;
            this.metrics.baseline = baseline;
            this.metrics.xHeight = xHeight - 3;
        }

        private Dimension dimension() {
            Metrics metrics = this.metrics;
            metrics.marginWidth = metrics.marginWidth + this.style.columnPad;
            Metrics metrics2 = this.metrics;
            metrics2.positionWidth = metrics2.positionWidth + this.style.columnPad;
            Metrics metrics3 = this.metrics;
            metrics3.dataWidth = metrics3.dataWidth + this.style.columnPad;
            Metrics metrics4 = this.metrics;
            metrics4.altWidth = metrics4.altWidth + this.style.columnPad;
            Metrics metrics5 = this.metrics;
            metrics5.labelWidth = metrics5.labelWidth + this.style.columnPad;
            this.metrics.updateTotalWidth();
            int width = this.metrics.totalWidth + this.style.columnPad;
            int height = this.lc * this.metrics.lineHeight + this.style.columnPad;
            return new Dimension(width, height);
        }

        private void newLine() {
            ++this.lc;
            this.y += this.metrics.lineHeight;
        }

        private void srcRef(Reference ref) {
            ref.setSrc(this.x, this.y);
            if (ref.sourcePosition < ref.targetPosition) {
                return;
            }
            this.drawRef(ref);
        }

        private void trgRef(Reference ref) {
            ref.setTrg(this.x, this.y);
            if (ref.sourcePosition > ref.targetPosition) {
                return;
            }
            this.drawRef(ref);
        }

        private boolean measuring() {
            return this.g == null;
        }

        private Color colorForM(int m) {
            return REF_COLORS[m % REF_COLORS.length];
        }

        private void drawRef(Reference ref) {
            int m = this.refWidthFinder.add(ref);
            int srcx = ref.srcx - this.style.marginOffset;
            int srcy = ref.srcy - this.metrics.baseline - this.metrics.xHeight;
            int trgx = ref.trgx - this.style.marginOffset;
            int trgy = ref.trgy - this.metrics.baseline - this.metrics.xHeight;
            int margin = -m * this.style.marginScale;
            int mx = Math.min(srcx, trgx) - this.style.marginPad + margin;
            if (this.measuring()) {
                if (-mx > this.metrics.marginWidth) {
                    this.metrics.marginWidth = -mx;
                }
                return;
            }
            this.g.setColor(this.colorForM(m));
            this.g.drawLine(srcx += this.metrics.marginWidth, srcy, mx += this.metrics.marginWidth, srcy);
            this.g.drawLine(mx, srcy, mx, trgy);
            this.g.drawLine(mx, trgy, trgx += this.metrics.marginWidth, trgy);
            int[] xpts = new int[]{trgx, trgx - 3, trgx - 3};
            int[] ypts = new int[]{trgy, trgy - 2, trgy + 2};
            this.g.fillPolygon(xpts, ypts, 3);
        }

        private int updateWidth(String s, Font f, int w) {
            Rectangle2D bounds = this.style.dataFont.getStringBounds(s, this.frc);
            int width = (int)Math.ceil(bounds.getWidth());
            if (width > w) {
                return width;
            }
            return w;
        }

        private void markPosition(int position) {
            if (position == this.lastMarkedPosition) {
                return;
            }
            this.lastMarkedPosition = position;
            if (position > this.expectedPosition && this.expectedPosition != -1) {
                this.newLine();
                String s = "...";
                if (this.measuring()) {
                    this.metrics.positionWidth = this.updateWidth(s, this.style.dataFont, this.metrics.positionWidth);
                } else {
                    int x = this.x + this.metrics.marginWidth;
                    int y = this.y - this.metrics.baseline;
                    this.g.setFont(this.style.dataFont);
                    this.g.setColor(this.style.positionColor);
                    this.g.drawString(s, x, y);
                }
                this.expectedPosition = position;
            }
            this.newLine();
        }

        private void drawRangeBackground() {
            if (this.measuring()) {
                return;
            }
            Color[] colors = this.style.depthColors;
            int colorIndex = this.rangeDepth % colors.length;
            this.g.setColor(this.rangeDepth == -1 ? Color.WHITE : colors[colorIndex]);
            this.g.fillRect(this.metrics.marginWidth, this.y - this.metrics.lineHeight, this.metrics.totalWidth - this.metrics.marginWidth, this.metrics.lineHeight);
        }

        private void drawLine(int position, int value, int width, String alt, String label) {
            this.markPosition(position);
            if (this.lastRenderedPosition == position) {
                if (alt == null && label == null) {
                    return;
                }
                this.newLine();
            } else {
                this.lastRenderedPosition = position;
            }
            this.drawRangeBackground();
            int x = this.x + this.metrics.marginWidth;
            int y = this.y - this.metrics.baseline;
            String s = String.format("%04x", position);
            if (this.measuring()) {
                this.metrics.positionWidth = this.updateWidth(s, this.style.dataFont, this.metrics.positionWidth);
            } else {
                this.g.setFont(this.style.dataFont);
                this.g.setColor(this.style.positionColor);
                this.g.drawString(s, x, y);
            }
            x += this.metrics.positionWidth;
            if (width > 0) {
                s = String.format("%0" + width * 2 + "x", value);
                if (this.measuring()) {
                    this.metrics.dataWidth = this.updateWidth(s, this.style.dataFont, this.metrics.dataWidth);
                } else {
                    this.g.setColor(this.style.dataColor);
                    this.g.drawString(s, x, y);
                }
            }
            x += this.metrics.dataWidth;
            if (alt != null) {
                if (this.measuring()) {
                    this.metrics.altWidth = this.updateWidth(alt, this.style.labelFont, this.metrics.altWidth);
                } else {
                    this.g.setFont(this.style.labelFont);
                    this.g.setColor(this.style.altColor);
                    this.g.drawString(alt, x, y);
                }
            }
            x += this.metrics.altWidth;
            if (label != null) {
                if (this.measuring()) {
                    this.metrics.labelWidth = this.updateWidth(label, this.style.labelFont, this.metrics.labelWidth);
                } else {
                    this.g.setFont(this.style.labelFont);
                    this.g.setColor(this.style.labelColor);
                    this.g.drawString(label, x, y);
                }
            }
            x += this.metrics.labelWidth;
            this.expectedPosition = position + width;
        }

        private void drawHeader(int position, String header) {
            this.markPosition(position);
            if (this.lastRenderedPosition == position) {
                this.newLine();
            } else {
                this.lastRenderedPosition = position;
            }
            if (this.measuring()) {
                this.metrics.headerWidth = this.updateWidth(header, this.style.labelFont, this.metrics.headerWidth);
            } else {
                this.g.setFont(this.style.labelFont);
                this.g.setColor(this.style.labelColor);
                this.g.drawString(header, this.x + this.metrics.marginWidth, this.y - this.metrics.baseline);
            }
        }

        private void rangeTransition(Range range, boolean start) {
            if (range.length >= 0) {
                this.rangeDepth = start ? range.depth : -1;
            }
        }
    }

    private static class Field
    extends Marker {
        private final int width;
        private final int value;
        private final String alt;
        private final String label;

        private Field(int position, int width, int value, String alt, String label) {
            super(position);
            this.width = width;
            this.value = value;
            this.alt = alt;
            this.label = label;
        }

        @Override
        void draw(DrawContext c) {
            c.drawLine(this.position, this.value, this.width, this.alt, this.label);
        }

        @Override
        int order(Marker rhs) {
            return 0;
        }
    }

    private static abstract class Marker
    implements Comparable<Marker> {
        final int position;
        private static final Object[] classOrder = new Object[]{RangeEnd.class, RangeStart.class, ReferenceTarget.class, Field.class, ReferenceSource.class};

        private Marker(int position) {
            this.position = position;
        }

        abstract int order(Marker var1);

        abstract void draw(DrawContext var1);

        @Override
        public int compareTo(Marker rhs) {
            int result = this.position - rhs.position;
            if (result != 0) {
                return result;
            }
            Class<?> thisClass = this.getClass();
            Class<?> thatClass = rhs.getClass();
            result = Marker.classOrder(thisClass) - Marker.classOrder(thatClass);
            if (result != 0) {
                return result;
            }
            return this.order(rhs);
        }

        private static int classOrder(Class<? extends Marker> clzz) {
            int i = 0;
            while (i < classOrder.length) {
                if (classOrder[i] == clzz) {
                    return i;
                }
                ++i;
            }
            throw new IllegalStateException("No order for class: " + clzz);
        }
    }

    private static class Metrics {
        private int lineHeight = 15;
        private int baseline;
        private int xHeight = 5;
        private int marginWidth = 50;
        private int positionWidth = 50;
        private int dataWidth = 70;
        private int altWidth = 30;
        private int labelWidth = 100;
        private int headerWidth;
        private int totalWidth;

        private Metrics() {
            this.updateTotalWidth();
        }

        private void zero() {
            this.xHeight = 0;
            this.baseline = 0;
            this.lineHeight = 0;
            this.totalWidth = 0;
            this.headerWidth = 0;
            this.labelWidth = 0;
            this.altWidth = 0;
            this.dataWidth = 0;
            this.positionWidth = 0;
            this.marginWidth = 0;
        }

        private void updateTotalWidth() {
            this.totalWidth = this.marginWidth + Math.max(this.positionWidth + this.dataWidth + this.altWidth + this.labelWidth, this.headerWidth);
        }
    }

    private static class Range {
        private final String name;
        private final int start;
        private final int length;
        private int depth;

        private Range(String name, int start, int length, int depth) {
            this.name = name;
            this.start = start;
            this.length = length;
            this.depth = depth;
        }

        private int start() {
            return this.start;
        }

        private int limit() {
            return this.start + this.length;
        }
    }

    private static class RangeEnd
    extends Marker {
        private final Range range;

        private RangeEnd(Range range) {
            super(range.limit());
            this.range = range;
        }

        @Override
        void draw(DrawContext c) {
        }

        @Override
        int order(Marker rhs) {
            return ((RangeEnd)rhs).range.depth - this.range.depth;
        }
    }

    private static class RangeStart
    extends Marker {
        private final Range range;

        private RangeStart(Range range) {
            super(range.start());
            this.range = range;
        }

        @Override
        void draw(DrawContext c) {
            c.rangeTransition(this.range, true);
            c.drawHeader(this.range.start(), this.range.name);
        }

        @Override
        int order(Marker rhs) {
            return this.range.depth - ((RangeStart)rhs).range.depth;
        }
    }

    private static class RefWidthFinder {
        private final TreeMap<Integer, WidthUsageRecord> tgt2widthUsage = new TreeMap();
        private static final int MAX_WIDTH = 600;

        private RefWidthFinder() {
        }

        private int add(Reference ref) {
            WidthUsageRecord lastWidthUsage;
            int src = ref.sourcePosition;
            int trg = ref.targetPosition;
            WidthUsageRecord match = null;
            if (this.tgt2widthUsage.containsKey(trg) && (match = this.tgt2widthUsage.get(trg)).src() <= src) {
                return match.width();
            }
            Map.Entry<Integer, WidthUsageRecord> entry = this.tgt2widthUsage.floorEntry(src);
            WidthUsageRecord srcWidthUsage = entry != null ? entry.getValue() : WidthUsageRecord.EMPTY;
            int width = srcWidthUsage.lowestEquality(lastWidthUsage = (entry = match != null ? this.tgt2widthUsage.floorEntry(trg - 1) : this.tgt2widthUsage.lastEntry()) != null ? entry.getValue() : WidthUsageRecord.EMPTY);
            if (width > 600) {
                width = 600;
            }
            WidthUsageRecord trgWidthUsage = WidthUsageRecord.copyWithWidthAdded(lastWidthUsage, width, src);
            this.tgt2widthUsage.put(trg, trgWidthUsage);
            return width;
        }
    }

    private static class Reference {
        private final int sourcePosition;
        private final int targetPosition;
        private int srcx;
        private int srcy;
        private int trgx;
        private int trgy;

        private Reference(int sourcePosition, int targetPosition) {
            this.sourcePosition = sourcePosition;
            this.targetPosition = targetPosition;
        }

        private void setSrc(int x, int y) {
            this.srcx = x - 1;
            this.srcy = y - 5;
        }

        private void setTrg(int x, int y) {
            this.trgx = x;
            this.trgy = y - 5;
        }
    }

    private static class ReferenceSource
    extends Marker {
        private final Reference ref;
        private final int value;
        private final String label;

        private ReferenceSource(Reference ref, int value, String label) {
            super(ref.sourcePosition);
            this.ref = ref;
            this.value = value;
            this.label = label;
        }

        @Override
        void draw(DrawContext c) {
            c.drawLine(this.position, this.value, 2, null, this.label);
            c.srcRef(this.ref);
        }

        @Override
        int order(Marker rhs) {
            return ((ReferenceSource)rhs).ref.targetPosition - this.ref.targetPosition;
        }
    }

    private static class ReferenceTarget
    extends Marker {
        private final Reference ref;

        private ReferenceTarget(Reference ref) {
            super(ref.targetPosition);
            this.ref = ref;
        }

        @Override
        void draw(DrawContext c) {
            c.markPosition(this.position);
            c.trgRef(this.ref);
        }

        @Override
        int order(Marker rhs) {
            return ((ReferenceTarget)rhs).ref.sourcePosition - this.ref.sourcePosition;
        }
    }

    private static class Style {
        private int marginScale = 4;
        private int marginOffset = 1;
        private int marginPad = 4;
        private int columnPad = 15;
        private Font dataFont;
        private Font labelFont;
        private Color positionColor;
        private Color dataColor;
        private Color altColor;
        private Color labelColor;
        private Color[] depthColors = new Color[]{new Color(10204398), new Color(11781614), new Color(13358830), new Color(0xE3E6EE)};

        private Style() {
            this.dataFont = new Font("monospaced", 0, 13);
            this.labelFont = new Font("serif", 0, 13);
            this.positionColor = Color.BLACK;
            this.dataColor = Color.BLACK;
            this.altColor = new Color(0x8B0000);
            this.labelColor = Color.BLUE;
        }
    }

    public static class TaggedDataImpl
    implements TaggedData {
        private final List<Marker> markers = new ArrayList<Marker>();
        private RangeNode rangeStack;
        private final PostScriptTable post;

        TaggedDataImpl(PostScriptTable post) {
            this.post = post;
        }

        @Override
        public void tagRange(String string, int start, int length, int depth) {
            boolean hasEnd;
            boolean bl = hasEnd = (length & 0xFFFF0000) == 0;
            if (!hasEnd) {
                depth = -1;
            }
            Range range = new Range(string, start, length, depth);
            this.markers.add(new RangeStart(range));
            if (hasEnd) {
                this.markers.add(new RangeEnd(range));
            }
        }

        @Override
        public void tagField(int position, int width, int value, String alt, String label) {
            this.markers.add(new Field(position, width, value, alt, label));
        }

        @Override
        public void tagTarget(int position, int value, int targetPosition, String label) {
            Reference reference = new Reference(position, targetPosition);
            this.markers.add(new ReferenceSource(reference, value, label));
            this.markers.add(new ReferenceTarget(reference));
        }

        List<Marker> getMarkers() {
            Collections.sort(this.markers);
            return this.markers;
        }

        @Override
        public void pushRange(String label, ReadableFontData data) {
            this.rangeStack = new RangeNode(label, data, this.rangeStack, data.dataOffset());
        }

        @Override
        public void pushRangeAtOffset(String label, int base) {
            if (this.rangeStack == null) {
                throw new IllegalStateException("can't push offset range without data");
            }
            this.rangeStack = new RangeNode(label, this.rangeStack.data, this.rangeStack, base);
        }

        @Override
        public void popRange() {
            if (this.rangeStack == null) {
                throw new IllegalStateException("not in a range");
            }
            this.tagRange(this.rangeStack.label, this.rangeStack.base, this.rangeStack.pos, this.rangeStack.depth);
            this.rangeStack = this.rangeStack.next;
        }

        @Override
        public void setRangePosition(int rangePosition) {
            if (this.rangeStack == null) {
                throw new IllegalStateException("not in a range");
            }
            this.rangeStack.pos = rangePosition;
        }

        @Override
        public int tagRangeField(TaggedData.FieldType ft, String label) {
            int width;
            String alt;
            int value;
            if (this.rangeStack == null) {
                throw new IllegalStateException("not in a range");
            }
            ReadableFontData data = this.rangeStack.data;
            int base = this.rangeStack.base;
            int pos = this.rangeStack.pos;
            int position = base + pos;
            switch (ft) {
                case OFFSET_NONZERO: {
                    value = data.readUShort(pos);
                    if (value == 0) {
                        alt = "NULL";
                        width = 2;
                        break;
                    }
                }
                case OFFSET: {
                    value = data.readUShort(pos);
                    alt = String.format("#%04x", base + value);
                    width = 2;
                    this.tagTarget(position, value, base + value, null);
                    break;
                }
                case OFFSET32: {
                    value = data.readULongAsInt(pos);
                    alt = String.format("#%04x", base + value);
                    width = 4;
                    this.tagTarget(position, value, base + value, null);
                    break;
                }
                case SHORT: {
                    value = data.readUShort(pos);
                    alt = String.valueOf(value);
                    width = 2;
                    break;
                }
                case SHORT_IGNORED: {
                    value = data.readUShort(pos);
                    alt = null;
                    width = 2;
                    break;
                }
                case SHORT_IGNORED_FFFF: {
                    value = data.readUShort(pos);
                    alt = value == 65535 ? null : String.valueOf(value);
                    width = 2;
                    break;
                }
                case TAG: {
                    value = data.readULongAsInt(pos);
                    alt = Tag.stringValue(value);
                    width = 4;
                    break;
                }
                case GLYPH: {
                    value = data.readUShort(pos);
                    alt = String.valueOf(value);
                    String glyphName = this.post.glyphName(value);
                    if (glyphName != null) {
                        if (label == null) {
                            label = "glyph name";
                        }
                        label = String.valueOf(label) + ": " + glyphName;
                    }
                    width = 2;
                    break;
                }
                default: {
                    throw new IllegalStateException("unimplemented field type");
                }
            }
            this.tagField(position, width, value, alt, label);
            this.rangeStack.pos += width;
            switch (ft) {
                case OFFSET: 
                case OFFSET32: {
                    value += base;
                    break;
                }
                case OFFSET_NONZERO: {
                    if (value == 0) break;
                    value += base;
                    break;
                }
            }
            return value;
        }

        private static class RangeNode {
            String label;
            ReadableFontData data;
            RangeNode next;
            int depth;
            int base;
            int pos;

            RangeNode(String label, ReadableFontData data, RangeNode next, int base) {
                this.label = label;
                this.data = data;
                this.next = next;
                this.depth = next == null ? 0 : next.depth + 1;
                this.base = base;
            }
        }
    }

    private static class WidthUsageRecord {
        private final Map<Integer, Integer> widthUsage = new HashMap<Integer, Integer>();
        private int width;
        private int src;
        private static final WidthUsageRecord EMPTY = new WidthUsageRecord();

        private WidthUsageRecord() {
        }

        private static WidthUsageRecord copyWithWidthAdded(WidthUsageRecord other, int width, int src) {
            WidthUsageRecord current = new WidthUsageRecord();
            current.width = width;
            current.src = src;
            current.widthUsage.putAll(other.widthUsage);
            int count = 0;
            if (current.widthUsage.containsKey(width)) {
                count = current.widthUsage.get(width);
            }
            current.widthUsage.put(width, count + 1);
            return current;
        }

        private int lowestEquality(WidthUsageRecord other) {
            int i = 0;
            while (this.widthUsage.containsKey(i)) {
                if (other.widthUsage.get(i) == this.widthUsage.get(i)) {
                    return i;
                }
                ++i;
            }
            return other.widthUsage.keySet().size();
        }

        private int width() {
            return this.width;
        }

        private int src() {
            return this.src;
        }

        public String toString() {
            return "{width=" + this.width + " src=" + this.src + this.widthUsage.toString() + "}";
        }
    }
}

