
#ifndef _SOUND_PLAYER_H_
#define _SOUND_PLAYER_H_

#include "Non_volatile_Memorys.h"
#include "Sound_Source.h"
//#include "ISD2360.h"
#include "Buzzer.h"




#define   SND_PLAYER_IDLE                   0x00
#define   SND_PLAYER_PLAY_REQ               0x01
#define   SND_PLAYER_PLAYING                0x02
#define   SND_PLAYER_STOP_REQ               0x03

#define   SND_VOLUME_HI                     0x00
#define   SND_VOLUME_MID                    0x19
#define   SND_VOLUME_LOW                    0x32





typedef struct
{
  uint8_t   Status;
  uint8_t   Playing;
  uint16_t  Timer;
  uint8_t   Cycle;
  uint8_t   VolInit;
}SoundPlayCtrlStruct;




void Sound_Player_Init(void);

uint8_t Sound_Play(uint8_t SoundID);
uint8_t Sound_Stop(uint8_t SoundID);
void Sound_Clear(void);
uint8_t Sound_Priority_Query(uint8_t SoundID);

void Sound_Play_Service(void);

#endif